package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceDeviceStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceCompliancePolicyAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceScheduledActionForRuleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DeviceComplianceUserStatusCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SettingStateDeviceSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceDeviceOverviewRequest;
import odata.msgraph.client.beta.entity.request.DeviceComplianceUserOverviewRequest;


/**
 * <i>“This is the base class for Compliance policy. Compliance policies are platform
 * specific and individual per-platform compliance policies inherit from here.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "lastModifiedDateTime", 
    "roleScopeTagIds", 
    "version", 
    "assignments", 
    "deviceSettingStateSummaries", 
    "deviceStatuses", 
    "deviceStatusOverview", 
    "scheduledActionsForRule", 
    "userStatuses", 
    "userStatusOverview"})
@JsonInclude(Include.NON_NULL)
public class DeviceCompliancePolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceCompliancePolicy";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    @JsonProperty("version")
    protected Integer version;

    @JsonProperty("assignments")
    protected List<DeviceCompliancePolicyAssignment> assignments;

    @JsonProperty("deviceSettingStateSummaries")
    protected List<SettingStateDeviceSummary> deviceSettingStateSummaries;

    @JsonProperty("deviceStatuses")
    protected List<DeviceComplianceDeviceStatus> deviceStatuses;

    @JsonProperty("deviceStatusOverview")
    protected DeviceComplianceDeviceOverview deviceStatusOverview;

    @JsonProperty("scheduledActionsForRule")
    protected List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule;

    @JsonProperty("userStatuses")
    protected List<DeviceComplianceUserStatus> userStatuses;

    @JsonProperty("userStatusOverview")
    protected DeviceComplianceUserOverview userStatusOverview;

    protected DeviceCompliancePolicy() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceCompliancePolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the Device Configuration.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceCompliancePolicy withDescription(String description) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceCompliancePolicy withDisplayName(String displayName) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public DeviceCompliancePolicy withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code roleScopeTagIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param roleScopeTagIds
     *            new value of {@code roleScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code roleScopeTagIds} field changed
     */
    public DeviceCompliancePolicy withRoleScopeTagIds(List<String> roleScopeTagIds) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("roleScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Version of the device configuration.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the device configuration.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DeviceCompliancePolicy withVersion(Integer version) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.version = version;
        return _x;
    }

    public DeviceCompliancePolicy withUnmappedField(String name, Object value) {
        DeviceCompliancePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The collection of assignments for this compliance policy.”</i>
     * 
     * @return navigational property assignments
     */
    @NavigationProperty(name="assignments")
    @JsonIgnore
    public DeviceCompliancePolicyAssignmentCollectionRequest getAssignments() {
        return new DeviceCompliancePolicyAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"), Optional.ofNullable(assignments));
    }

    /**
     * <i>“Compliance Setting State Device Summary”</i>
     * 
     * @return navigational property deviceSettingStateSummaries
     */
    @NavigationProperty(name="deviceSettingStateSummaries")
    @JsonIgnore
    public SettingStateDeviceSummaryCollectionRequest getDeviceSettingStateSummaries() {
        return new SettingStateDeviceSummaryCollectionRequest(
                        contextPath.addSegment("deviceSettingStateSummaries"), Optional.ofNullable(deviceSettingStateSummaries));
    }

    /**
     * <i>“List of DeviceComplianceDeviceStatus.”</i>
     * 
     * @return navigational property deviceStatuses
     */
    @NavigationProperty(name="deviceStatuses")
    @JsonIgnore
    public DeviceComplianceDeviceStatusCollectionRequest getDeviceStatuses() {
        return new DeviceComplianceDeviceStatusCollectionRequest(
                        contextPath.addSegment("deviceStatuses"), Optional.ofNullable(deviceStatuses));
    }

    /**
     * <i>“Device compliance devices status overview”</i>
     * 
     * @return navigational property deviceStatusOverview
     */
    @NavigationProperty(name="deviceStatusOverview")
    @JsonIgnore
    public DeviceComplianceDeviceOverviewRequest getDeviceStatusOverview() {
        return new DeviceComplianceDeviceOverviewRequest(contextPath.addSegment("deviceStatusOverview"), Optional.ofNullable(deviceStatusOverview));
    }

    /**
     * <i>“The list of scheduled action per rule for this compliance policy. This is a
     * required property when creating any individual per-platform compliance policies.”</i>
     * 
     * @return navigational property scheduledActionsForRule
     */
    @NavigationProperty(name="scheduledActionsForRule")
    @JsonIgnore
    public DeviceComplianceScheduledActionForRuleCollectionRequest getScheduledActionsForRule() {
        return new DeviceComplianceScheduledActionForRuleCollectionRequest(
                        contextPath.addSegment("scheduledActionsForRule"), Optional.ofNullable(scheduledActionsForRule));
    }

    /**
     * <i>“List of DeviceComplianceUserStatus.”</i>
     * 
     * @return navigational property userStatuses
     */
    @NavigationProperty(name="userStatuses")
    @JsonIgnore
    public DeviceComplianceUserStatusCollectionRequest getUserStatuses() {
        return new DeviceComplianceUserStatusCollectionRequest(
                        contextPath.addSegment("userStatuses"), Optional.ofNullable(userStatuses));
    }

    /**
     * <i>“Device compliance users status overview”</i>
     * 
     * @return navigational property userStatusOverview
     */
    @NavigationProperty(name="userStatusOverview")
    @JsonIgnore
    public DeviceComplianceUserOverviewRequest getUserStatusOverview() {
        return new DeviceComplianceUserOverviewRequest(contextPath.addSegment("userStatusOverview"), Optional.ofNullable(userStatusOverview));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The collection of assignments for this compliance policy.”</i>
     * 
     * @param assignments
     *            new value of {@code assignments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignments} field changed
     */
    public DeviceCompliancePolicy withAssignments(List<DeviceCompliancePolicyAssignment> assignments) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("assignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.assignments = assignments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceSettingStateSummaries} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Compliance Setting State Device Summary”</i>
     * 
     * @param deviceSettingStateSummaries
     *            new value of {@code deviceSettingStateSummaries} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceSettingStateSummaries} field changed
     */
    public DeviceCompliancePolicy withDeviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceSettingStateSummaries");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of DeviceComplianceDeviceStatus.”</i>
     * 
     * @param deviceStatuses
     *            new value of {@code deviceStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatuses} field changed
     */
    public DeviceCompliancePolicy withDeviceStatuses(List<DeviceComplianceDeviceStatus> deviceStatuses) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.deviceStatuses = deviceStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceStatusOverview} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device compliance devices status overview”</i>
     * 
     * @param deviceStatusOverview
     *            new value of {@code deviceStatusOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceStatusOverview} field changed
     */
    public DeviceCompliancePolicy withDeviceStatusOverview(DeviceComplianceDeviceOverview deviceStatusOverview) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceStatusOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.deviceStatusOverview = deviceStatusOverview;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * scheduledActionsForRule} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The list of scheduled action per rule for this compliance policy. This is a
     * required property when creating any individual per-platform compliance policies.”</i>
     * 
     * @param scheduledActionsForRule
     *            new value of {@code scheduledActionsForRule} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scheduledActionsForRule} field changed
     */
    public DeviceCompliancePolicy withScheduledActionsForRule(List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("scheduledActionsForRule");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.scheduledActionsForRule = scheduledActionsForRule;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code userStatuses}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“List of DeviceComplianceUserStatus.”</i>
     * 
     * @param userStatuses
     *            new value of {@code userStatuses} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatuses} field changed
     */
    public DeviceCompliancePolicy withUserStatuses(List<DeviceComplianceUserStatus> userStatuses) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("userStatuses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.userStatuses = userStatuses;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * userStatusOverview} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Device compliance users status overview”</i>
     * 
     * @param userStatusOverview
     *            new value of {@code userStatusOverview} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code userStatusOverview} field changed
     */
    public DeviceCompliancePolicy withUserStatusOverview(DeviceComplianceUserOverview userStatusOverview) {
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("userStatusOverview");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceCompliancePolicy");
        _x.userStatusOverview = userStatusOverview;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceCompliancePolicy _copy() {
        DeviceCompliancePolicy _x = new DeviceCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.scheduledActionsForRule = scheduledActionsForRule;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        return _x;
    }

    @Action(name = "assign")
    @JsonIgnore
    public CollectionPageNonEntityRequest<DeviceCompliancePolicyAssignment> assign(List<DeviceCompliancePolicyAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("assignments", "Collection(microsoft.graph.deviceCompliancePolicyAssignment)", assignments)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.assign"), DeviceCompliancePolicyAssignment.class, _parameters);
    }

    @Action(name = "scheduleActionsForRules")
    @JsonIgnore
    public ActionRequestNoReturn scheduleActionsForRules(List<DeviceComplianceScheduledActionForRule> deviceComplianceScheduledActionForRules) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("deviceComplianceScheduledActionForRules", "Collection(microsoft.graph.deviceComplianceScheduledActionForRule)", deviceComplianceScheduledActionForRules)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.scheduleActionsForRules"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("scheduledActionsForRule=");
        b.append(this.scheduledActionsForRule);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
