package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceEnrollmentConfigurationType;


/**
 * <i>“Windows 10 Co-Management Authority Page Configuration”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "configurationManagerAgentCommandLineArgument", 
    "installConfigurationManagerAgent", 
    "managedDeviceAuthority"})
@JsonInclude(Include.NON_NULL)
public class DeviceComanagementAuthorityConfiguration extends DeviceEnrollmentConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceComanagementAuthorityConfiguration";
    }

    @JsonProperty("configurationManagerAgentCommandLineArgument")
    protected String configurationManagerAgentCommandLineArgument;

    @JsonProperty("installConfigurationManagerAgent")
    protected Boolean installConfigurationManagerAgent;

    @JsonProperty("managedDeviceAuthority")
    protected Integer managedDeviceAuthority;

    protected DeviceComanagementAuthorityConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceComanagementAuthorityConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceEnrollmentConfigurationType deviceEnrollmentConfigurationType;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer priority;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<EnrollmentConfigurationAssignment> assignments;
        private String configurationManagerAgentCommandLineArgument;
        private Boolean installConfigurationManagerAgent;
        private Integer managedDeviceAuthority;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceEnrollmentConfigurationType(DeviceEnrollmentConfigurationType deviceEnrollmentConfigurationType) {
            this.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
            this.changedFields = changedFields.add("deviceEnrollmentConfigurationType");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<EnrollmentConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(EnrollmentConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        /**
         * <i>“CoManagement Authority configuration
         * ConfigurationManagerAgentCommandLineArgument”</i>
         * 
         * @param configurationManagerAgentCommandLineArgument
         *            value of {@code configurationManagerAgentCommandLineArgument} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder configurationManagerAgentCommandLineArgument(String configurationManagerAgentCommandLineArgument) {
            this.configurationManagerAgentCommandLineArgument = configurationManagerAgentCommandLineArgument;
            this.changedFields = changedFields.add("configurationManagerAgentCommandLineArgument");
            return this;
        }

        /**
         * <i>“CoManagement Authority configuration InstallConfigurationManagerAgent”</i>
         * 
         * @param installConfigurationManagerAgent
         *            value of {@code installConfigurationManagerAgent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder installConfigurationManagerAgent(Boolean installConfigurationManagerAgent) {
            this.installConfigurationManagerAgent = installConfigurationManagerAgent;
            this.changedFields = changedFields.add("installConfigurationManagerAgent");
            return this;
        }

        /**
         * <i>“CoManagement Authority configuration ManagedDeviceAuthority”</i>
         * 
         * @param managedDeviceAuthority
         *            value of {@code managedDeviceAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceAuthority(Integer managedDeviceAuthority) {
            this.managedDeviceAuthority = managedDeviceAuthority;
            this.changedFields = changedFields.add("managedDeviceAuthority");
            return this;
        }

        public DeviceComanagementAuthorityConfiguration build() {
            DeviceComanagementAuthorityConfiguration _x = new DeviceComanagementAuthorityConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceComanagementAuthorityConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.priority = priority;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.configurationManagerAgentCommandLineArgument = configurationManagerAgentCommandLineArgument;
            _x.installConfigurationManagerAgent = installConfigurationManagerAgent;
            _x.managedDeviceAuthority = managedDeviceAuthority;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“CoManagement Authority configuration
     * ConfigurationManagerAgentCommandLineArgument”</i>
     * 
     * @return property configurationManagerAgentCommandLineArgument
     */
    @Property(name="configurationManagerAgentCommandLineArgument")
    @JsonIgnore
    public Optional<String> getConfigurationManagerAgentCommandLineArgument() {
        return Optional.ofNullable(configurationManagerAgentCommandLineArgument);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * configurationManagerAgentCommandLineArgument} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“CoManagement Authority configuration
     * ConfigurationManagerAgentCommandLineArgument”</i>
     * 
     * @param configurationManagerAgentCommandLineArgument
     *            new value of {@code configurationManagerAgentCommandLineArgument} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code configurationManagerAgentCommandLineArgument} field changed
     */
    public DeviceComanagementAuthorityConfiguration withConfigurationManagerAgentCommandLineArgument(String configurationManagerAgentCommandLineArgument) {
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.changedFields = changedFields.add("configurationManagerAgentCommandLineArgument");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComanagementAuthorityConfiguration");
        _x.configurationManagerAgentCommandLineArgument = configurationManagerAgentCommandLineArgument;
        return _x;
    }

    /**
     * <i>“CoManagement Authority configuration InstallConfigurationManagerAgent”</i>
     * 
     * @return property installConfigurationManagerAgent
     */
    @Property(name="installConfigurationManagerAgent")
    @JsonIgnore
    public Optional<Boolean> getInstallConfigurationManagerAgent() {
        return Optional.ofNullable(installConfigurationManagerAgent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * installConfigurationManagerAgent} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“CoManagement Authority configuration InstallConfigurationManagerAgent”</i>
     * 
     * @param installConfigurationManagerAgent
     *            new value of {@code installConfigurationManagerAgent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code installConfigurationManagerAgent} field changed
     */
    public DeviceComanagementAuthorityConfiguration withInstallConfigurationManagerAgent(Boolean installConfigurationManagerAgent) {
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.changedFields = changedFields.add("installConfigurationManagerAgent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComanagementAuthorityConfiguration");
        _x.installConfigurationManagerAgent = installConfigurationManagerAgent;
        return _x;
    }

    /**
     * <i>“CoManagement Authority configuration ManagedDeviceAuthority”</i>
     * 
     * @return property managedDeviceAuthority
     */
    @Property(name="managedDeviceAuthority")
    @JsonIgnore
    public Optional<Integer> getManagedDeviceAuthority() {
        return Optional.ofNullable(managedDeviceAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceAuthority} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“CoManagement Authority configuration ManagedDeviceAuthority”</i>
     * 
     * @param managedDeviceAuthority
     *            new value of {@code managedDeviceAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceAuthority} field changed
     */
    public DeviceComanagementAuthorityConfiguration withManagedDeviceAuthority(Integer managedDeviceAuthority) {
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceComanagementAuthorityConfiguration");
        _x.managedDeviceAuthority = managedDeviceAuthority;
        return _x;
    }

    public DeviceComanagementAuthorityConfiguration withUnmappedField(String name, Object value) {
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComanagementAuthorityConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceComanagementAuthorityConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceComanagementAuthorityConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceComanagementAuthorityConfiguration _copy() {
        DeviceComanagementAuthorityConfiguration _x = new DeviceComanagementAuthorityConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceEnrollmentConfigurationType = deviceEnrollmentConfigurationType;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.priority = priority;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.configurationManagerAgentCommandLineArgument = configurationManagerAgentCommandLineArgument;
        _x.installConfigurationManagerAgent = installConfigurationManagerAgent;
        _x.managedDeviceAuthority = managedDeviceAuthority;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceComanagementAuthorityConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceEnrollmentConfigurationType=");
        b.append(this.deviceEnrollmentConfigurationType);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("configurationManagerAgentCommandLineArgument=");
        b.append(this.configurationManagerAgentCommandLineArgument);
        b.append(", ");
        b.append("installConfigurationManagerAgent=");
        b.append(this.installConfigurationManagerAgent);
        b.append(", ");
        b.append("managedDeviceAuthority=");
        b.append(this.managedDeviceAuthority);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
