package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DeviceAppManagementTaskCategory;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskPriority;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskStatus;


/**
 * <i>“A device app management task.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "assignedTo", 
    "category", 
    "createdDateTime", 
    "creator", 
    "creatorNotes", 
    "description", 
    "displayName", 
    "dueDateTime", 
    "priority", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DeviceAppManagementTask extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.deviceAppManagementTask";
    }

    @JsonProperty("assignedTo")
    protected String assignedTo;

    @JsonProperty("category")
    protected DeviceAppManagementTaskCategory category;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("creator")
    protected String creator;

    @JsonProperty("creatorNotes")
    protected String creatorNotes;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("dueDateTime")
    protected OffsetDateTime dueDateTime;

    @JsonProperty("priority")
    protected DeviceAppManagementTaskPriority priority;

    @JsonProperty("status")
    protected DeviceAppManagementTaskStatus status;

    protected DeviceAppManagementTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDeviceAppManagementTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String assignedTo;
        private DeviceAppManagementTaskCategory category;
        private OffsetDateTime createdDateTime;
        private String creator;
        private String creatorNotes;
        private String description;
        private String displayName;
        private OffsetDateTime dueDateTime;
        private DeviceAppManagementTaskPriority priority;
        private DeviceAppManagementTaskStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The name or email of the admin this task is assigned to.”</i>
         * 
         * @param assignedTo
         *            value of {@code assignedTo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        /**
         * <i>“The category.”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(DeviceAppManagementTaskCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        /**
         * <i>“The created date.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The email address of the creator.”</i>
         * 
         * @param creator
         *            value of {@code creator} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creator(String creator) {
            this.creator = creator;
            this.changedFields = changedFields.add("creator");
            return this;
        }

        /**
         * <i>“Notes from the creator.”</i>
         * 
         * @param creatorNotes
         *            value of {@code creatorNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder creatorNotes(String creatorNotes) {
            this.creatorNotes = creatorNotes;
            this.changedFields = changedFields.add("creatorNotes");
            return this;
        }

        /**
         * <i>“The description.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The due date.”</i>
         * 
         * @param dueDateTime
         *            value of {@code dueDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        /**
         * <i>“The priority.”</i>
         * 
         * @param priority
         *            value of {@code priority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder priority(DeviceAppManagementTaskPriority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        /**
         * <i>“The status.”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(DeviceAppManagementTaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public DeviceAppManagementTask build() {
            DeviceAppManagementTask _x = new DeviceAppManagementTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.deviceAppManagementTask";
            _x.id = id;
            _x.assignedTo = assignedTo;
            _x.category = category;
            _x.createdDateTime = createdDateTime;
            _x.creator = creator;
            _x.creatorNotes = creatorNotes;
            _x.description = description;
            _x.displayName = displayName;
            _x.dueDateTime = dueDateTime;
            _x.priority = priority;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The name or email of the admin this task is assigned to.”</i>
     * 
     * @return property assignedTo
     */
    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<String> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code assignedTo} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The name or email of the admin this task is assigned to.”</i>
     * 
     * @param assignedTo
     *            new value of {@code assignedTo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code assignedTo} field changed
     */
    public DeviceAppManagementTask withAssignedTo(String assignedTo) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("assignedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.assignedTo = assignedTo;
        return _x;
    }

    /**
     * <i>“The category.”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<DeviceAppManagementTaskCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The category.”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public DeviceAppManagementTask withCategory(DeviceAppManagementTaskCategory category) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.category = category;
        return _x;
    }

    /**
     * <i>“The created date.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The created date.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public DeviceAppManagementTask withCreatedDateTime(OffsetDateTime createdDateTime) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The email address of the creator.”</i>
     * 
     * @return property creator
     */
    @Property(name="creator")
    @JsonIgnore
    public Optional<String> getCreator() {
        return Optional.ofNullable(creator);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creator} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The email address of the creator.”</i>
     * 
     * @param creator
     *            new value of {@code creator} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creator} field changed
     */
    public DeviceAppManagementTask withCreator(String creator) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("creator");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.creator = creator;
        return _x;
    }

    /**
     * <i>“Notes from the creator.”</i>
     * 
     * @return property creatorNotes
     */
    @Property(name="creatorNotes")
    @JsonIgnore
    public Optional<String> getCreatorNotes() {
        return Optional.ofNullable(creatorNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code creatorNotes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Notes from the creator.”</i>
     * 
     * @param creatorNotes
     *            new value of {@code creatorNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code creatorNotes} field changed
     */
    public DeviceAppManagementTask withCreatorNotes(String creatorNotes) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("creatorNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.creatorNotes = creatorNotes;
        return _x;
    }

    /**
     * <i>“The description.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The description.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public DeviceAppManagementTask withDescription(String description) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DeviceAppManagementTask withDisplayName(String displayName) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The due date.”</i>
     * 
     * @return property dueDateTime
     */
    @Property(name="dueDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getDueDateTime() {
        return Optional.ofNullable(dueDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code dueDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The due date.”</i>
     * 
     * @param dueDateTime
     *            new value of {@code dueDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dueDateTime} field changed
     */
    public DeviceAppManagementTask withDueDateTime(OffsetDateTime dueDateTime) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("dueDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.dueDateTime = dueDateTime;
        return _x;
    }

    /**
     * <i>“The priority.”</i>
     * 
     * @return property priority
     */
    @Property(name="priority")
    @JsonIgnore
    public Optional<DeviceAppManagementTaskPriority> getPriority() {
        return Optional.ofNullable(priority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code priority} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The priority.”</i>
     * 
     * @param priority
     *            new value of {@code priority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code priority} field changed
     */
    public DeviceAppManagementTask withPriority(DeviceAppManagementTaskPriority priority) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.priority = priority;
        return _x;
    }

    /**
     * <i>“The status.”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<DeviceAppManagementTaskStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The status.”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public DeviceAppManagementTask withStatus(DeviceAppManagementTaskStatus status) {
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.deviceAppManagementTask");
        _x.status = status;
        return _x;
    }

    public DeviceAppManagementTask withUnmappedField(String name, Object value) {
        DeviceAppManagementTask _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagementTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DeviceAppManagementTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DeviceAppManagementTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DeviceAppManagementTask _copy() {
        DeviceAppManagementTask _x = new DeviceAppManagementTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.assignedTo = assignedTo;
        _x.category = category;
        _x.createdDateTime = createdDateTime;
        _x.creator = creator;
        _x.creatorNotes = creatorNotes;
        _x.description = description;
        _x.displayName = displayName;
        _x.dueDateTime = dueDateTime;
        _x.priority = priority;
        _x.status = status;
        return _x;
    }

    @Action(name = "updateStatus")
    @JsonIgnore
    public ActionRequestNoReturn updateStatus(DeviceAppManagementTaskStatus status, String note) {
        Preconditions.checkNotNull(status, "status cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("status", "microsoft.graph.deviceAppManagementTaskStatus", status)
            .put("note", "Edm.String", Checks.checkIsAscii(note))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updateStatus"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DeviceAppManagementTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("creator=");
        b.append(this.creator);
        b.append(", ");
        b.append("creatorNotes=");
        b.append(this.creatorNotes);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
