package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AlternativeSecurityId;
import odata.msgraph.client.beta.complex.OnPremisesExtensionAttributes;
import odata.msgraph.client.beta.entity.collection.request.CommandCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UsageRightCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "accountEnabled", 
    "alternativeSecurityIds", 
    "approximateLastSignInDateTime", 
    "complianceExpirationDateTime", 
    "deviceCategory", 
    "deviceId", 
    "deviceMetadata", 
    "deviceOwnership", 
    "deviceVersion", 
    "displayName", 
    "domainName", 
    "enrollmentProfileName", 
    "enrollmentType", 
    "extensionAttributes", 
    "hostnames", 
    "isCompliant", 
    "isManaged", 
    "isRooted", 
    "managementType", 
    "mdmAppId", 
    "onPremisesLastSyncDateTime", 
    "onPremisesSyncEnabled", 
    "operatingSystem", 
    "operatingSystemVersion", 
    "physicalIds", 
    "profileType", 
    "registrationDateTime", 
    "systemLabels", 
    "trustType", 
    "kind", 
    "manufacturer", 
    "model", 
    "name", 
    "platform", 
    "status", 
    "usageRights", 
    "extensions", 
    "commands"})
@JsonInclude(Include.NON_NULL)
public class Device extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.device";
    }

    @JsonProperty("accountEnabled")
    protected Boolean accountEnabled;

    @JsonProperty("alternativeSecurityIds")
    protected List<AlternativeSecurityId> alternativeSecurityIds;

    @JsonProperty("alternativeSecurityIds@nextLink")
    protected String alternativeSecurityIdsNextLink;

    @JsonProperty("approximateLastSignInDateTime")
    protected OffsetDateTime approximateLastSignInDateTime;

    @JsonProperty("complianceExpirationDateTime")
    protected OffsetDateTime complianceExpirationDateTime;

    @JsonProperty("deviceCategory")
    protected String deviceCategory;

    @JsonProperty("deviceId")
    protected String deviceId;

    @JsonProperty("deviceMetadata")
    protected String deviceMetadata;

    @JsonProperty("deviceOwnership")
    protected String deviceOwnership;

    @JsonProperty("deviceVersion")
    protected Integer deviceVersion;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("domainName")
    protected String domainName;

    @JsonProperty("enrollmentProfileName")
    protected String enrollmentProfileName;

    @JsonProperty("enrollmentType")
    protected String enrollmentType;

    @JsonProperty("extensionAttributes")
    protected OnPremisesExtensionAttributes extensionAttributes;

    @JsonProperty("hostnames")
    protected List<String> hostnames;

    @JsonProperty("hostnames@nextLink")
    protected String hostnamesNextLink;

    @JsonProperty("isCompliant")
    protected Boolean isCompliant;

    @JsonProperty("isManaged")
    protected Boolean isManaged;

    @JsonProperty("isRooted")
    protected Boolean isRooted;

    @JsonProperty("managementType")
    protected String managementType;

    @JsonProperty("mdmAppId")
    protected String mdmAppId;

    @JsonProperty("onPremisesLastSyncDateTime")
    protected OffsetDateTime onPremisesLastSyncDateTime;

    @JsonProperty("onPremisesSyncEnabled")
    protected Boolean onPremisesSyncEnabled;

    @JsonProperty("operatingSystem")
    protected String operatingSystem;

    @JsonProperty("operatingSystemVersion")
    protected String operatingSystemVersion;

    @JsonProperty("physicalIds")
    protected List<String> physicalIds;

    @JsonProperty("physicalIds@nextLink")
    protected String physicalIdsNextLink;

    @JsonProperty("profileType")
    protected String profileType;

    @JsonProperty("registrationDateTime")
    protected OffsetDateTime registrationDateTime;

    @JsonProperty("systemLabels")
    protected List<String> systemLabels;

    @JsonProperty("systemLabels@nextLink")
    protected String systemLabelsNextLink;

    @JsonProperty("trustType")
    protected String trustType;

    @JsonProperty("kind")
    protected String kind;

    @JsonProperty("manufacturer")
    protected String manufacturer;

    @JsonProperty("model")
    protected String model;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("platform")
    protected String platform;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("usageRights")
    protected List<UsageRight> usageRights;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("commands")
    protected List<Command> commands;

    protected Device() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDevice() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private Boolean accountEnabled;
        private List<AlternativeSecurityId> alternativeSecurityIds;
        private String alternativeSecurityIdsNextLink;
        private OffsetDateTime approximateLastSignInDateTime;
        private OffsetDateTime complianceExpirationDateTime;
        private String deviceCategory;
        private String deviceId;
        private String deviceMetadata;
        private String deviceOwnership;
        private Integer deviceVersion;
        private String displayName;
        private String domainName;
        private String enrollmentProfileName;
        private String enrollmentType;
        private OnPremisesExtensionAttributes extensionAttributes;
        private List<String> hostnames;
        private String hostnamesNextLink;
        private Boolean isCompliant;
        private Boolean isManaged;
        private Boolean isRooted;
        private String managementType;
        private String mdmAppId;
        private OffsetDateTime onPremisesLastSyncDateTime;
        private Boolean onPremisesSyncEnabled;
        private String operatingSystem;
        private String operatingSystemVersion;
        private List<String> physicalIds;
        private String physicalIdsNextLink;
        private String profileType;
        private OffsetDateTime registrationDateTime;
        private List<String> systemLabels;
        private String systemLabelsNextLink;
        private String trustType;
        private String kind;
        private String manufacturer;
        private String model;
        private String name;
        private String platform;
        private String status;
        private List<UsageRight> usageRights;
        private List<Extension> extensions;
        private List<Command> commands;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder accountEnabled(Boolean accountEnabled) {
            this.accountEnabled = accountEnabled;
            this.changedFields = changedFields.add("accountEnabled");
            return this;
        }

        public Builder alternativeSecurityIds(List<AlternativeSecurityId> alternativeSecurityIds) {
            this.alternativeSecurityIds = alternativeSecurityIds;
            this.changedFields = changedFields.add("alternativeSecurityIds");
            return this;
        }

        public Builder alternativeSecurityIds(AlternativeSecurityId... alternativeSecurityIds) {
            return alternativeSecurityIds(Arrays.asList(alternativeSecurityIds));
        }

        public Builder alternativeSecurityIdsNextLink(String alternativeSecurityIdsNextLink) {
            this.alternativeSecurityIdsNextLink = alternativeSecurityIdsNextLink;
            this.changedFields = changedFields.add("alternativeSecurityIds");
            return this;
        }

        public Builder approximateLastSignInDateTime(OffsetDateTime approximateLastSignInDateTime) {
            this.approximateLastSignInDateTime = approximateLastSignInDateTime;
            this.changedFields = changedFields.add("approximateLastSignInDateTime");
            return this;
        }

        public Builder complianceExpirationDateTime(OffsetDateTime complianceExpirationDateTime) {
            this.complianceExpirationDateTime = complianceExpirationDateTime;
            this.changedFields = changedFields.add("complianceExpirationDateTime");
            return this;
        }

        public Builder deviceCategory(String deviceCategory) {
            this.deviceCategory = deviceCategory;
            this.changedFields = changedFields.add("deviceCategory");
            return this;
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            this.changedFields = changedFields.add("deviceId");
            return this;
        }

        public Builder deviceMetadata(String deviceMetadata) {
            this.deviceMetadata = deviceMetadata;
            this.changedFields = changedFields.add("deviceMetadata");
            return this;
        }

        public Builder deviceOwnership(String deviceOwnership) {
            this.deviceOwnership = deviceOwnership;
            this.changedFields = changedFields.add("deviceOwnership");
            return this;
        }

        public Builder deviceVersion(Integer deviceVersion) {
            this.deviceVersion = deviceVersion;
            this.changedFields = changedFields.add("deviceVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder domainName(String domainName) {
            this.domainName = domainName;
            this.changedFields = changedFields.add("domainName");
            return this;
        }

        public Builder enrollmentProfileName(String enrollmentProfileName) {
            this.enrollmentProfileName = enrollmentProfileName;
            this.changedFields = changedFields.add("enrollmentProfileName");
            return this;
        }

        public Builder enrollmentType(String enrollmentType) {
            this.enrollmentType = enrollmentType;
            this.changedFields = changedFields.add("enrollmentType");
            return this;
        }

        public Builder extensionAttributes(OnPremisesExtensionAttributes extensionAttributes) {
            this.extensionAttributes = extensionAttributes;
            this.changedFields = changedFields.add("extensionAttributes");
            return this;
        }

        public Builder hostnames(List<String> hostnames) {
            this.hostnames = hostnames;
            this.changedFields = changedFields.add("hostnames");
            return this;
        }

        public Builder hostnames(String... hostnames) {
            return hostnames(Arrays.asList(hostnames));
        }

        public Builder hostnamesNextLink(String hostnamesNextLink) {
            this.hostnamesNextLink = hostnamesNextLink;
            this.changedFields = changedFields.add("hostnames");
            return this;
        }

        public Builder isCompliant(Boolean isCompliant) {
            this.isCompliant = isCompliant;
            this.changedFields = changedFields.add("isCompliant");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("isManaged");
            return this;
        }

        public Builder isRooted(Boolean isRooted) {
            this.isRooted = isRooted;
            this.changedFields = changedFields.add("isRooted");
            return this;
        }

        public Builder managementType(String managementType) {
            this.managementType = managementType;
            this.changedFields = changedFields.add("managementType");
            return this;
        }

        public Builder mdmAppId(String mdmAppId) {
            this.mdmAppId = mdmAppId;
            this.changedFields = changedFields.add("mdmAppId");
            return this;
        }

        public Builder onPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
            this.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            this.changedFields = changedFields.add("onPremisesLastSyncDateTime");
            return this;
        }

        public Builder onPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
            this.onPremisesSyncEnabled = onPremisesSyncEnabled;
            this.changedFields = changedFields.add("onPremisesSyncEnabled");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.changedFields = changedFields.add("operatingSystem");
            return this;
        }

        public Builder operatingSystemVersion(String operatingSystemVersion) {
            this.operatingSystemVersion = operatingSystemVersion;
            this.changedFields = changedFields.add("operatingSystemVersion");
            return this;
        }

        public Builder physicalIds(List<String> physicalIds) {
            this.physicalIds = physicalIds;
            this.changedFields = changedFields.add("physicalIds");
            return this;
        }

        public Builder physicalIds(String... physicalIds) {
            return physicalIds(Arrays.asList(physicalIds));
        }

        public Builder physicalIdsNextLink(String physicalIdsNextLink) {
            this.physicalIdsNextLink = physicalIdsNextLink;
            this.changedFields = changedFields.add("physicalIds");
            return this;
        }

        public Builder profileType(String profileType) {
            this.profileType = profileType;
            this.changedFields = changedFields.add("profileType");
            return this;
        }

        public Builder registrationDateTime(OffsetDateTime registrationDateTime) {
            this.registrationDateTime = registrationDateTime;
            this.changedFields = changedFields.add("registrationDateTime");
            return this;
        }

        public Builder systemLabels(List<String> systemLabels) {
            this.systemLabels = systemLabels;
            this.changedFields = changedFields.add("systemLabels");
            return this;
        }

        public Builder systemLabels(String... systemLabels) {
            return systemLabels(Arrays.asList(systemLabels));
        }

        public Builder systemLabelsNextLink(String systemLabelsNextLink) {
            this.systemLabelsNextLink = systemLabelsNextLink;
            this.changedFields = changedFields.add("systemLabels");
            return this;
        }

        public Builder trustType(String trustType) {
            this.trustType = trustType;
            this.changedFields = changedFields.add("trustType");
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            this.changedFields = changedFields.add("kind");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.changedFields = changedFields.add("manufacturer");
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            this.changedFields = changedFields.add("model");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder platform(String platform) {
            this.platform = platform;
            this.changedFields = changedFields.add("platform");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder usageRights(List<UsageRight> usageRights) {
            this.usageRights = usageRights;
            this.changedFields = changedFields.add("usageRights");
            return this;
        }

        public Builder usageRights(UsageRight... usageRights) {
            return usageRights(Arrays.asList(usageRights));
        }

        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder commands(List<Command> commands) {
            this.commands = commands;
            this.changedFields = changedFields.add("commands");
            return this;
        }

        public Builder commands(Command... commands) {
            return commands(Arrays.asList(commands));
        }

        public Device build() {
            Device _x = new Device();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.device";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.accountEnabled = accountEnabled;
            _x.alternativeSecurityIds = alternativeSecurityIds;
            _x.alternativeSecurityIdsNextLink = alternativeSecurityIdsNextLink;
            _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
            _x.complianceExpirationDateTime = complianceExpirationDateTime;
            _x.deviceCategory = deviceCategory;
            _x.deviceId = deviceId;
            _x.deviceMetadata = deviceMetadata;
            _x.deviceOwnership = deviceOwnership;
            _x.deviceVersion = deviceVersion;
            _x.displayName = displayName;
            _x.domainName = domainName;
            _x.enrollmentProfileName = enrollmentProfileName;
            _x.enrollmentType = enrollmentType;
            _x.extensionAttributes = extensionAttributes;
            _x.hostnames = hostnames;
            _x.hostnamesNextLink = hostnamesNextLink;
            _x.isCompliant = isCompliant;
            _x.isManaged = isManaged;
            _x.isRooted = isRooted;
            _x.managementType = managementType;
            _x.mdmAppId = mdmAppId;
            _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
            _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
            _x.operatingSystem = operatingSystem;
            _x.operatingSystemVersion = operatingSystemVersion;
            _x.physicalIds = physicalIds;
            _x.physicalIdsNextLink = physicalIdsNextLink;
            _x.profileType = profileType;
            _x.registrationDateTime = registrationDateTime;
            _x.systemLabels = systemLabels;
            _x.systemLabelsNextLink = systemLabelsNextLink;
            _x.trustType = trustType;
            _x.kind = kind;
            _x.manufacturer = manufacturer;
            _x.model = model;
            _x.name = name;
            _x.platform = platform;
            _x.status = status;
            _x.usageRights = usageRights;
            _x.extensions = extensions;
            _x.commands = commands;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accountEnabled")
    @JsonIgnore
    public Optional<Boolean> getAccountEnabled() {
        return Optional.ofNullable(accountEnabled);
    }

    public Device withAccountEnabled(Boolean accountEnabled) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("accountEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.accountEnabled = accountEnabled;
        return _x;
    }

    @Property(name="alternativeSecurityIds")
    @JsonIgnore
    public CollectionPage<AlternativeSecurityId> getAlternativeSecurityIds() {
        return new CollectionPage<AlternativeSecurityId>(contextPath, AlternativeSecurityId.class, this.alternativeSecurityIds, Optional.ofNullable(alternativeSecurityIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Device withAlternativeSecurityIds(List<AlternativeSecurityId> alternativeSecurityIds) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("alternativeSecurityIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.alternativeSecurityIds = alternativeSecurityIds;
        return _x;
    }

    @Property(name="alternativeSecurityIds")
    @JsonIgnore
    public CollectionPage<AlternativeSecurityId> getAlternativeSecurityIds(HttpRequestOptions options) {
        return new CollectionPage<AlternativeSecurityId>(contextPath, AlternativeSecurityId.class, this.alternativeSecurityIds, Optional.ofNullable(alternativeSecurityIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="approximateLastSignInDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getApproximateLastSignInDateTime() {
        return Optional.ofNullable(approximateLastSignInDateTime);
    }

    public Device withApproximateLastSignInDateTime(OffsetDateTime approximateLastSignInDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("approximateLastSignInDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
        return _x;
    }

    @Property(name="complianceExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getComplianceExpirationDateTime() {
        return Optional.ofNullable(complianceExpirationDateTime);
    }

    public Device withComplianceExpirationDateTime(OffsetDateTime complianceExpirationDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("complianceExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.complianceExpirationDateTime = complianceExpirationDateTime;
        return _x;
    }

    @Property(name="deviceCategory")
    @JsonIgnore
    public Optional<String> getDeviceCategory() {
        return Optional.ofNullable(deviceCategory);
    }

    public Device withDeviceCategory(String deviceCategory) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceCategory = deviceCategory;
        return _x;
    }

    @Property(name="deviceId")
    @JsonIgnore
    public Optional<String> getDeviceId() {
        return Optional.ofNullable(deviceId);
    }

    public Device withDeviceId(String deviceId) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceId = deviceId;
        return _x;
    }

    @Property(name="deviceMetadata")
    @JsonIgnore
    public Optional<String> getDeviceMetadata() {
        return Optional.ofNullable(deviceMetadata);
    }

    public Device withDeviceMetadata(String deviceMetadata) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceMetadata");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceMetadata = deviceMetadata;
        return _x;
    }

    @Property(name="deviceOwnership")
    @JsonIgnore
    public Optional<String> getDeviceOwnership() {
        return Optional.ofNullable(deviceOwnership);
    }

    public Device withDeviceOwnership(String deviceOwnership) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceOwnership");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceOwnership = deviceOwnership;
        return _x;
    }

    @Property(name="deviceVersion")
    @JsonIgnore
    public Optional<Integer> getDeviceVersion() {
        return Optional.ofNullable(deviceVersion);
    }

    public Device withDeviceVersion(Integer deviceVersion) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("deviceVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.deviceVersion = deviceVersion;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Device withDisplayName(String displayName) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="domainName")
    @JsonIgnore
    public Optional<String> getDomainName() {
        return Optional.ofNullable(domainName);
    }

    public Device withDomainName(String domainName) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("domainName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.domainName = domainName;
        return _x;
    }

    @Property(name="enrollmentProfileName")
    @JsonIgnore
    public Optional<String> getEnrollmentProfileName() {
        return Optional.ofNullable(enrollmentProfileName);
    }

    public Device withEnrollmentProfileName(String enrollmentProfileName) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("enrollmentProfileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.enrollmentProfileName = enrollmentProfileName;
        return _x;
    }

    @Property(name="enrollmentType")
    @JsonIgnore
    public Optional<String> getEnrollmentType() {
        return Optional.ofNullable(enrollmentType);
    }

    public Device withEnrollmentType(String enrollmentType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("enrollmentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.enrollmentType = enrollmentType;
        return _x;
    }

    @Property(name="extensionAttributes")
    @JsonIgnore
    public Optional<OnPremisesExtensionAttributes> getExtensionAttributes() {
        return Optional.ofNullable(extensionAttributes);
    }

    public Device withExtensionAttributes(OnPremisesExtensionAttributes extensionAttributes) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("extensionAttributes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.extensionAttributes = extensionAttributes;
        return _x;
    }

    @Property(name="hostnames")
    @JsonIgnore
    public CollectionPage<String> getHostnames() {
        return new CollectionPage<String>(contextPath, String.class, this.hostnames, Optional.ofNullable(hostnamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Device withHostnames(List<String> hostnames) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("hostnames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.hostnames = hostnames;
        return _x;
    }

    @Property(name="hostnames")
    @JsonIgnore
    public CollectionPage<String> getHostnames(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.hostnames, Optional.ofNullable(hostnamesNextLink), Collections.emptyList(), options);
    }

    @Property(name="isCompliant")
    @JsonIgnore
    public Optional<Boolean> getIsCompliant() {
        return Optional.ofNullable(isCompliant);
    }

    public Device withIsCompliant(Boolean isCompliant) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("isCompliant");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.isCompliant = isCompliant;
        return _x;
    }

    @Property(name="isManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public Device withIsManaged(Boolean isManaged) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("isManaged");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="isRooted")
    @JsonIgnore
    public Optional<Boolean> getIsRooted() {
        return Optional.ofNullable(isRooted);
    }

    public Device withIsRooted(Boolean isRooted) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("isRooted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.isRooted = isRooted;
        return _x;
    }

    @Property(name="managementType")
    @JsonIgnore
    public Optional<String> getManagementType() {
        return Optional.ofNullable(managementType);
    }

    public Device withManagementType(String managementType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("managementType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.managementType = managementType;
        return _x;
    }

    @Property(name="mdmAppId")
    @JsonIgnore
    public Optional<String> getMdmAppId() {
        return Optional.ofNullable(mdmAppId);
    }

    public Device withMdmAppId(String mdmAppId) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("mdmAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.mdmAppId = mdmAppId;
        return _x;
    }

    @Property(name="onPremisesLastSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOnPremisesLastSyncDateTime() {
        return Optional.ofNullable(onPremisesLastSyncDateTime);
    }

    public Device withOnPremisesLastSyncDateTime(OffsetDateTime onPremisesLastSyncDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("onPremisesLastSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        return _x;
    }

    @Property(name="onPremisesSyncEnabled")
    @JsonIgnore
    public Optional<Boolean> getOnPremisesSyncEnabled() {
        return Optional.ofNullable(onPremisesSyncEnabled);
    }

    public Device withOnPremisesSyncEnabled(Boolean onPremisesSyncEnabled) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSyncEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        return _x;
    }

    @Property(name="operatingSystem")
    @JsonIgnore
    public Optional<String> getOperatingSystem() {
        return Optional.ofNullable(operatingSystem);
    }

    public Device withOperatingSystem(String operatingSystem) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("operatingSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.operatingSystem = operatingSystem;
        return _x;
    }

    @Property(name="operatingSystemVersion")
    @JsonIgnore
    public Optional<String> getOperatingSystemVersion() {
        return Optional.ofNullable(operatingSystemVersion);
    }

    public Device withOperatingSystemVersion(String operatingSystemVersion) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("operatingSystemVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.operatingSystemVersion = operatingSystemVersion;
        return _x;
    }

    @Property(name="physicalIds")
    @JsonIgnore
    public CollectionPage<String> getPhysicalIds() {
        return new CollectionPage<String>(contextPath, String.class, this.physicalIds, Optional.ofNullable(physicalIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Device withPhysicalIds(List<String> physicalIds) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("physicalIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.physicalIds = physicalIds;
        return _x;
    }

    @Property(name="physicalIds")
    @JsonIgnore
    public CollectionPage<String> getPhysicalIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.physicalIds, Optional.ofNullable(physicalIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="profileType")
    @JsonIgnore
    public Optional<String> getProfileType() {
        return Optional.ofNullable(profileType);
    }

    public Device withProfileType(String profileType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("profileType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.profileType = profileType;
        return _x;
    }

    @Property(name="registrationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getRegistrationDateTime() {
        return Optional.ofNullable(registrationDateTime);
    }

    public Device withRegistrationDateTime(OffsetDateTime registrationDateTime) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("registrationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.registrationDateTime = registrationDateTime;
        return _x;
    }

    @Property(name="systemLabels")
    @JsonIgnore
    public CollectionPage<String> getSystemLabels() {
        return new CollectionPage<String>(contextPath, String.class, this.systemLabels, Optional.ofNullable(systemLabelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Device withSystemLabels(List<String> systemLabels) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("systemLabels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.systemLabels = systemLabels;
        return _x;
    }

    @Property(name="systemLabels")
    @JsonIgnore
    public CollectionPage<String> getSystemLabels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.systemLabels, Optional.ofNullable(systemLabelsNextLink), Collections.emptyList(), options);
    }

    @Property(name="trustType")
    @JsonIgnore
    public Optional<String> getTrustType() {
        return Optional.ofNullable(trustType);
    }

    public Device withTrustType(String trustType) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("trustType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.trustType = trustType;
        return _x;
    }

    @Property(name="kind")
    @JsonIgnore
    public Optional<String> getKind() {
        return Optional.ofNullable(kind);
    }

    public Device withKind(String kind) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("kind");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.kind = kind;
        return _x;
    }

    @Property(name="manufacturer")
    @JsonIgnore
    public Optional<String> getManufacturer() {
        return Optional.ofNullable(manufacturer);
    }

    public Device withManufacturer(String manufacturer) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("manufacturer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.manufacturer = manufacturer;
        return _x;
    }

    @Property(name="model")
    @JsonIgnore
    public Optional<String> getModel() {
        return Optional.ofNullable(model);
    }

    public Device withModel(String model) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("model");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.model = model;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Device withName(String name) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.name = name;
        return _x;
    }

    @Property(name="platform")
    @JsonIgnore
    public Optional<String> getPlatform() {
        return Optional.ofNullable(platform);
    }

    public Device withPlatform(String platform) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("platform");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.platform = platform;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Device withStatus(String status) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.status = status;
        return _x;
    }

    public Device withUnmappedField(String name, Object value) {
        Device _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="usageRights")
    @JsonIgnore
    public UsageRightCollectionRequest getUsageRights() {
        return new UsageRightCollectionRequest(
                        contextPath.addSegment("usageRights"), Optional.ofNullable(usageRights));
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"), RequestHelper.getValue(unmappedFields, "memberOf"));
    }

    @NavigationProperty(name="registeredOwners")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredOwners"), RequestHelper.getValue(unmappedFields, "registeredOwners"));
    }

    @NavigationProperty(name="registeredUsers")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getRegisteredUsers() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("registeredUsers"), RequestHelper.getValue(unmappedFields, "registeredUsers"));
    }

    @NavigationProperty(name="transitiveMemberOf")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getTransitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"), RequestHelper.getValue(unmappedFields, "transitiveMemberOf"));
    }

    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="commands")
    @JsonIgnore
    public CommandCollectionRequest getCommands() {
        return new CommandCollectionRequest(
                        contextPath.addSegment("commands"), Optional.ofNullable(commands));
    }

    public Device withUsageRights(List<UsageRight> usageRights) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("usageRights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.usageRights = usageRights;
        return _x;
    }

    public Device withExtensions(List<Extension> extensions) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.extensions = extensions;
        return _x;
    }

    public Device withCommands(List<Command> commands) {
        Device _x = _copy();
        _x.changedFields = changedFields.add("commands");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.device");
        _x.commands = commands;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Device patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Device _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Device put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Device _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Device _copy() {
        Device _x = new Device();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.accountEnabled = accountEnabled;
        _x.alternativeSecurityIds = alternativeSecurityIds;
        _x.approximateLastSignInDateTime = approximateLastSignInDateTime;
        _x.complianceExpirationDateTime = complianceExpirationDateTime;
        _x.deviceCategory = deviceCategory;
        _x.deviceId = deviceId;
        _x.deviceMetadata = deviceMetadata;
        _x.deviceOwnership = deviceOwnership;
        _x.deviceVersion = deviceVersion;
        _x.displayName = displayName;
        _x.domainName = domainName;
        _x.enrollmentProfileName = enrollmentProfileName;
        _x.enrollmentType = enrollmentType;
        _x.extensionAttributes = extensionAttributes;
        _x.hostnames = hostnames;
        _x.isCompliant = isCompliant;
        _x.isManaged = isManaged;
        _x.isRooted = isRooted;
        _x.managementType = managementType;
        _x.mdmAppId = mdmAppId;
        _x.onPremisesLastSyncDateTime = onPremisesLastSyncDateTime;
        _x.onPremisesSyncEnabled = onPremisesSyncEnabled;
        _x.operatingSystem = operatingSystem;
        _x.operatingSystemVersion = operatingSystemVersion;
        _x.physicalIds = physicalIds;
        _x.profileType = profileType;
        _x.registrationDateTime = registrationDateTime;
        _x.systemLabels = systemLabels;
        _x.trustType = trustType;
        _x.kind = kind;
        _x.manufacturer = manufacturer;
        _x.model = model;
        _x.name = name;
        _x.platform = platform;
        _x.status = status;
        _x.usageRights = usageRights;
        _x.extensions = extensions;
        _x.commands = commands;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Device[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("accountEnabled=");
        b.append(this.accountEnabled);
        b.append(", ");
        b.append("alternativeSecurityIds=");
        b.append(this.alternativeSecurityIds);
        b.append(", ");
        b.append("approximateLastSignInDateTime=");
        b.append(this.approximateLastSignInDateTime);
        b.append(", ");
        b.append("complianceExpirationDateTime=");
        b.append(this.complianceExpirationDateTime);
        b.append(", ");
        b.append("deviceCategory=");
        b.append(this.deviceCategory);
        b.append(", ");
        b.append("deviceId=");
        b.append(this.deviceId);
        b.append(", ");
        b.append("deviceMetadata=");
        b.append(this.deviceMetadata);
        b.append(", ");
        b.append("deviceOwnership=");
        b.append(this.deviceOwnership);
        b.append(", ");
        b.append("deviceVersion=");
        b.append(this.deviceVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("domainName=");
        b.append(this.domainName);
        b.append(", ");
        b.append("enrollmentProfileName=");
        b.append(this.enrollmentProfileName);
        b.append(", ");
        b.append("enrollmentType=");
        b.append(this.enrollmentType);
        b.append(", ");
        b.append("extensionAttributes=");
        b.append(this.extensionAttributes);
        b.append(", ");
        b.append("hostnames=");
        b.append(this.hostnames);
        b.append(", ");
        b.append("isCompliant=");
        b.append(this.isCompliant);
        b.append(", ");
        b.append("isManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("isRooted=");
        b.append(this.isRooted);
        b.append(", ");
        b.append("managementType=");
        b.append(this.managementType);
        b.append(", ");
        b.append("mdmAppId=");
        b.append(this.mdmAppId);
        b.append(", ");
        b.append("onPremisesLastSyncDateTime=");
        b.append(this.onPremisesLastSyncDateTime);
        b.append(", ");
        b.append("onPremisesSyncEnabled=");
        b.append(this.onPremisesSyncEnabled);
        b.append(", ");
        b.append("operatingSystem=");
        b.append(this.operatingSystem);
        b.append(", ");
        b.append("operatingSystemVersion=");
        b.append(this.operatingSystemVersion);
        b.append(", ");
        b.append("physicalIds=");
        b.append(this.physicalIds);
        b.append(", ");
        b.append("profileType=");
        b.append(this.profileType);
        b.append(", ");
        b.append("registrationDateTime=");
        b.append(this.registrationDateTime);
        b.append(", ");
        b.append("systemLabels=");
        b.append(this.systemLabels);
        b.append(", ");
        b.append("trustType=");
        b.append(this.trustType);
        b.append(", ");
        b.append("kind=");
        b.append(this.kind);
        b.append(", ");
        b.append("manufacturer=");
        b.append(this.manufacturer);
        b.append(", ");
        b.append("model=");
        b.append(this.model);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("platform=");
        b.append(this.platform);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("usageRights=");
        b.append(this.usageRights);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("commands=");
        b.append(this.commands);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
