package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCollectionRequest;


/**
 * <i>“A managed or unmanaged app that is installed on a managed device. Unmanaged apps
 * will only appear for devices marked as corporate owned.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "deviceCount", 
    "displayName", 
    "sizeInByte", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class DetectedApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.detectedApp";
    }

    @JsonProperty("deviceCount")
    protected Integer deviceCount;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("sizeInByte")
    protected Long sizeInByte;

    @JsonProperty("version")
    protected String version;

    protected DetectedApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDetectedApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Integer deviceCount;
        private String displayName;
        private Long sizeInByte;
        private String version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The number of devices that have installed this application”</i>
         * 
         * @param deviceCount
         *            value of {@code deviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCount(Integer deviceCount) {
            this.deviceCount = deviceCount;
            this.changedFields = changedFields.add("deviceCount");
            return this;
        }

        /**
         * <i>“Name of the discovered application. Read-only”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Discovered application size in bytes. Read-only”</i>
         * 
         * @param sizeInByte
         *            value of {@code sizeInByte} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder sizeInByte(Long sizeInByte) {
            this.sizeInByte = sizeInByte;
            this.changedFields = changedFields.add("sizeInByte");
            return this;
        }

        /**
         * <i>“Version of the discovered application. Read-only”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public DetectedApp build() {
            DetectedApp _x = new DetectedApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.detectedApp";
            _x.id = id;
            _x.deviceCount = deviceCount;
            _x.displayName = displayName;
            _x.sizeInByte = sizeInByte;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The number of devices that have installed this application”</i>
     * 
     * @return property deviceCount
     */
    @Property(name="deviceCount")
    @JsonIgnore
    public Optional<Integer> getDeviceCount() {
        return Optional.ofNullable(deviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of devices that have installed this application”</i>
     * 
     * @param deviceCount
     *            new value of {@code deviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCount} field changed
     */
    public DetectedApp withDeviceCount(Integer deviceCount) {
        DetectedApp _x = _copy();
        _x.changedFields = changedFields.add("deviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedApp");
        _x.deviceCount = deviceCount;
        return _x;
    }

    /**
     * <i>“Name of the discovered application. Read-only”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the discovered application. Read-only”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public DetectedApp withDisplayName(String displayName) {
        DetectedApp _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedApp");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Discovered application size in bytes. Read-only”</i>
     * 
     * @return property sizeInByte
     */
    @Property(name="sizeInByte")
    @JsonIgnore
    public Optional<Long> getSizeInByte() {
        return Optional.ofNullable(sizeInByte);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code sizeInByte} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Discovered application size in bytes. Read-only”</i>
     * 
     * @param sizeInByte
     *            new value of {@code sizeInByte} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code sizeInByte} field changed
     */
    public DetectedApp withSizeInByte(Long sizeInByte) {
        DetectedApp _x = _copy();
        _x.changedFields = changedFields.add("sizeInByte");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedApp");
        _x.sizeInByte = sizeInByte;
        return _x;
    }

    /**
     * <i>“Version of the discovered application. Read-only”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the discovered application. Read-only”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public DetectedApp withVersion(String version) {
        DetectedApp _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.detectedApp");
        _x.version = version;
        return _x;
    }

    public DetectedApp withUnmappedField(String name, Object value) {
        DetectedApp _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“The devices that have the discovered application installed”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public ManagedDeviceCollectionRequest getManagedDevices() {
        return new ManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"), RequestHelper.getValue(unmappedFields, "managedDevices"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DetectedApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DetectedApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DetectedApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DetectedApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DetectedApp _copy() {
        DetectedApp _x = new DetectedApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deviceCount = deviceCount;
        _x.displayName = displayName;
        _x.sizeInByte = sizeInByte;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectedApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deviceCount=");
        b.append(this.deviceCount);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("sizeInByte=");
        b.append(this.sizeInByte);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
