package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DelegatedAdminAccessDetails;
import odata.msgraph.client.beta.complex.DelegatedAdminRelationshipCustomerParticipant;
import odata.msgraph.client.beta.complex.DelegatedAdminRelationshipParticipant;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminAccessAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DelegatedAdminRelationshipRequestCollectionRequest;
import odata.msgraph.client.beta.enums.DelegatedAdminRelationshipStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "accessDetails", 
    "activatedDateTime", 
    "createdDateTime", 
    "customer", 
    "displayName", 
    "duration", 
    "endDateTime", 
    "lastModifiedDateTime", 
    "partner", 
    "status", 
    "accessAssignments", 
    "operations", 
    "requests"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminRelationship extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminRelationship";
    }

    @JsonProperty("accessDetails")
    protected DelegatedAdminAccessDetails accessDetails;

    @JsonProperty("activatedDateTime")
    protected OffsetDateTime activatedDateTime;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("customer")
    protected DelegatedAdminRelationshipCustomerParticipant customer;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("duration")
    protected Duration duration;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("partner")
    protected DelegatedAdminRelationshipParticipant partner;

    @JsonProperty("status")
    protected DelegatedAdminRelationshipStatus status;

    @JsonProperty("accessAssignments")
    protected List<DelegatedAdminAccessAssignment> accessAssignments;

    @JsonProperty("operations")
    protected List<DelegatedAdminRelationshipOperation> operations;

    @JsonProperty("requests")
    protected List<DelegatedAdminRelationshipRequest> requests;

    protected DelegatedAdminRelationship() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDelegatedAdminRelationship() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DelegatedAdminAccessDetails accessDetails;
        private OffsetDateTime activatedDateTime;
        private OffsetDateTime createdDateTime;
        private DelegatedAdminRelationshipCustomerParticipant customer;
        private String displayName;
        private Duration duration;
        private OffsetDateTime endDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private DelegatedAdminRelationshipParticipant partner;
        private DelegatedAdminRelationshipStatus status;
        private List<DelegatedAdminAccessAssignment> accessAssignments;
        private List<DelegatedAdminRelationshipOperation> operations;
        private List<DelegatedAdminRelationshipRequest> requests;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessDetails(DelegatedAdminAccessDetails accessDetails) {
            this.accessDetails = accessDetails;
            this.changedFields = changedFields.add("accessDetails");
            return this;
        }

        public Builder activatedDateTime(OffsetDateTime activatedDateTime) {
            this.activatedDateTime = activatedDateTime;
            this.changedFields = changedFields.add("activatedDateTime");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder customer(DelegatedAdminRelationshipCustomerParticipant customer) {
            this.customer = customer;
            this.changedFields = changedFields.add("customer");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder partner(DelegatedAdminRelationshipParticipant partner) {
            this.partner = partner;
            this.changedFields = changedFields.add("partner");
            return this;
        }

        public Builder status(DelegatedAdminRelationshipStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder accessAssignments(List<DelegatedAdminAccessAssignment> accessAssignments) {
            this.accessAssignments = accessAssignments;
            this.changedFields = changedFields.add("accessAssignments");
            return this;
        }

        public Builder accessAssignments(DelegatedAdminAccessAssignment... accessAssignments) {
            return accessAssignments(Arrays.asList(accessAssignments));
        }

        public Builder operations(List<DelegatedAdminRelationshipOperation> operations) {
            this.operations = operations;
            this.changedFields = changedFields.add("operations");
            return this;
        }

        public Builder operations(DelegatedAdminRelationshipOperation... operations) {
            return operations(Arrays.asList(operations));
        }

        public Builder requests(List<DelegatedAdminRelationshipRequest> requests) {
            this.requests = requests;
            this.changedFields = changedFields.add("requests");
            return this;
        }

        public Builder requests(DelegatedAdminRelationshipRequest... requests) {
            return requests(Arrays.asList(requests));
        }

        public DelegatedAdminRelationship build() {
            DelegatedAdminRelationship _x = new DelegatedAdminRelationship();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminRelationship";
            _x.id = id;
            _x.accessDetails = accessDetails;
            _x.activatedDateTime = activatedDateTime;
            _x.createdDateTime = createdDateTime;
            _x.customer = customer;
            _x.displayName = displayName;
            _x.duration = duration;
            _x.endDateTime = endDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.partner = partner;
            _x.status = status;
            _x.accessAssignments = accessAssignments;
            _x.operations = operations;
            _x.requests = requests;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accessDetails")
    @JsonIgnore
    public Optional<DelegatedAdminAccessDetails> getAccessDetails() {
        return Optional.ofNullable(accessDetails);
    }

    public DelegatedAdminRelationship withAccessDetails(DelegatedAdminAccessDetails accessDetails) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("accessDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.accessDetails = accessDetails;
        return _x;
    }

    @Property(name="activatedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivatedDateTime() {
        return Optional.ofNullable(activatedDateTime);
    }

    public DelegatedAdminRelationship withActivatedDateTime(OffsetDateTime activatedDateTime) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("activatedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.activatedDateTime = activatedDateTime;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public DelegatedAdminRelationship withCreatedDateTime(OffsetDateTime createdDateTime) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="customer")
    @JsonIgnore
    public Optional<DelegatedAdminRelationshipCustomerParticipant> getCustomer() {
        return Optional.ofNullable(customer);
    }

    public DelegatedAdminRelationship withCustomer(DelegatedAdminRelationshipCustomerParticipant customer) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("customer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.customer = customer;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public DelegatedAdminRelationship withDisplayName(String displayName) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(duration);
    }

    public DelegatedAdminRelationship withDuration(Duration duration) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.duration = duration;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public DelegatedAdminRelationship withEndDateTime(OffsetDateTime endDateTime) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public DelegatedAdminRelationship withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="partner")
    @JsonIgnore
    public Optional<DelegatedAdminRelationshipParticipant> getPartner() {
        return Optional.ofNullable(partner);
    }

    public DelegatedAdminRelationship withPartner(DelegatedAdminRelationshipParticipant partner) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("partner");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.partner = partner;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<DelegatedAdminRelationshipStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public DelegatedAdminRelationship withStatus(DelegatedAdminRelationshipStatus status) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.status = status;
        return _x;
    }

    public DelegatedAdminRelationship withUnmappedField(String name, Object value) {
        DelegatedAdminRelationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="accessAssignments")
    @JsonIgnore
    public DelegatedAdminAccessAssignmentCollectionRequest getAccessAssignments() {
        return new DelegatedAdminAccessAssignmentCollectionRequest(
                        contextPath.addSegment("accessAssignments"), Optional.ofNullable(accessAssignments));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public DelegatedAdminRelationshipOperationCollectionRequest getOperations() {
        return new DelegatedAdminRelationshipOperationCollectionRequest(
                        contextPath.addSegment("operations"), Optional.ofNullable(operations));
    }

    @NavigationProperty(name="requests")
    @JsonIgnore
    public DelegatedAdminRelationshipRequestCollectionRequest getRequests() {
        return new DelegatedAdminRelationshipRequestCollectionRequest(
                        contextPath.addSegment("requests"), Optional.ofNullable(requests));
    }

    public DelegatedAdminRelationship withAccessAssignments(List<DelegatedAdminAccessAssignment> accessAssignments) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("accessAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.accessAssignments = accessAssignments;
        return _x;
    }

    public DelegatedAdminRelationship withOperations(List<DelegatedAdminRelationshipOperation> operations) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("operations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.operations = operations;
        return _x;
    }

    public DelegatedAdminRelationship withRequests(List<DelegatedAdminRelationshipRequest> requests) {
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = changedFields.add("requests");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminRelationship");
        _x.requests = requests;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminRelationship patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminRelationship put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminRelationship _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DelegatedAdminRelationship _copy() {
        DelegatedAdminRelationship _x = new DelegatedAdminRelationship();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessDetails = accessDetails;
        _x.activatedDateTime = activatedDateTime;
        _x.createdDateTime = createdDateTime;
        _x.customer = customer;
        _x.displayName = displayName;
        _x.duration = duration;
        _x.endDateTime = endDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.partner = partner;
        _x.status = status;
        _x.accessAssignments = accessAssignments;
        _x.operations = operations;
        _x.requests = requests;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminRelationship[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessDetails=");
        b.append(this.accessDetails);
        b.append(", ");
        b.append("activatedDateTime=");
        b.append(this.activatedDateTime);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("customer=");
        b.append(this.customer);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("partner=");
        b.append(this.partner);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("accessAssignments=");
        b.append(this.accessAssignments);
        b.append(", ");
        b.append("operations=");
        b.append(this.operations);
        b.append(", ");
        b.append("requests=");
        b.append(this.requests);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
