package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DelegatedAdminAccessContainer;
import odata.msgraph.client.beta.complex.DelegatedAdminAccessDetails;
import odata.msgraph.client.beta.enums.DelegatedAdminAccessAssignmentStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "accessContainer", 
    "accessDetails", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class DelegatedAdminAccessAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.delegatedAdminAccessAssignment";
    }

    @JsonProperty("accessContainer")
    protected DelegatedAdminAccessContainer accessContainer;

    @JsonProperty("accessDetails")
    protected DelegatedAdminAccessDetails accessDetails;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("status")
    protected DelegatedAdminAccessAssignmentStatus status;

    protected DelegatedAdminAccessAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDelegatedAdminAccessAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private DelegatedAdminAccessContainer accessContainer;
        private DelegatedAdminAccessDetails accessDetails;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private DelegatedAdminAccessAssignmentStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessContainer(DelegatedAdminAccessContainer accessContainer) {
            this.accessContainer = accessContainer;
            this.changedFields = changedFields.add("accessContainer");
            return this;
        }

        public Builder accessDetails(DelegatedAdminAccessDetails accessDetails) {
            this.accessDetails = accessDetails;
            this.changedFields = changedFields.add("accessDetails");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder status(DelegatedAdminAccessAssignmentStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public DelegatedAdminAccessAssignment build() {
            DelegatedAdminAccessAssignment _x = new DelegatedAdminAccessAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.delegatedAdminAccessAssignment";
            _x.id = id;
            _x.accessContainer = accessContainer;
            _x.accessDetails = accessDetails;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="accessContainer")
    @JsonIgnore
    public Optional<DelegatedAdminAccessContainer> getAccessContainer() {
        return Optional.ofNullable(accessContainer);
    }

    public DelegatedAdminAccessAssignment withAccessContainer(DelegatedAdminAccessContainer accessContainer) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = changedFields.add("accessContainer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessAssignment");
        _x.accessContainer = accessContainer;
        return _x;
    }

    @Property(name="accessDetails")
    @JsonIgnore
    public Optional<DelegatedAdminAccessDetails> getAccessDetails() {
        return Optional.ofNullable(accessDetails);
    }

    public DelegatedAdminAccessAssignment withAccessDetails(DelegatedAdminAccessDetails accessDetails) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = changedFields.add("accessDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessAssignment");
        _x.accessDetails = accessDetails;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public DelegatedAdminAccessAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessAssignment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public DelegatedAdminAccessAssignment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessAssignment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<DelegatedAdminAccessAssignmentStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public DelegatedAdminAccessAssignment withStatus(DelegatedAdminAccessAssignmentStatus status) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.delegatedAdminAccessAssignment");
        _x.status = status;
        return _x;
    }

    public DelegatedAdminAccessAssignment withUnmappedField(String name, Object value) {
        DelegatedAdminAccessAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminAccessAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DelegatedAdminAccessAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DelegatedAdminAccessAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DelegatedAdminAccessAssignment _copy() {
        DelegatedAdminAccessAssignment _x = new DelegatedAdminAccessAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.accessContainer = accessContainer;
        _x.accessDetails = accessDetails;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DelegatedAdminAccessAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessContainer=");
        b.append(this.accessContainer);
        b.append(", ");
        b.append("accessDetails=");
        b.append(this.accessDetails);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
