package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyDeploymentSummaryRequest;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetAppsVerificationType;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetDeviceAttestationType;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetEvaluationType;
import odata.msgraph.client.beta.enums.ManagedAppClipboardSharingLevel;
import odata.msgraph.client.beta.enums.ManagedAppDataEncryptionType;
import odata.msgraph.client.beta.enums.ManagedAppDataIngestionLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataStorageLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataTransferLevel;
import odata.msgraph.client.beta.enums.ManagedAppDeviceThreatLevel;
import odata.msgraph.client.beta.enums.ManagedAppNotificationRestriction;
import odata.msgraph.client.beta.enums.ManagedAppPhoneNumberRedirectLevel;
import odata.msgraph.client.beta.enums.ManagedAppPinCharacterSet;
import odata.msgraph.client.beta.enums.ManagedAppRemediationAction;
import odata.msgraph.client.beta.enums.ManagedBrowserType;


/**
 * <i>“Policy used to configure detailed management settings for a specified set of
 * apps for all users not targeted by a TargetedManagedAppProtection Policy”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "allowedAndroidDeviceManufacturers", 
    "allowedAndroidDeviceModels", 
    "allowedIosDeviceModels", 
    "appActionIfAndroidDeviceManufacturerNotAllowed", 
    "appActionIfAndroidDeviceModelNotAllowed", 
    "appActionIfAndroidSafetyNetAppsVerificationFailed", 
    "appActionIfAndroidSafetyNetDeviceAttestationFailed", 
    "appActionIfDeviceLockNotSet", 
    "appActionIfIosDeviceModelNotAllowed", 
    "appDataEncryptionType", 
    "biometricAuthenticationBlocked", 
    "blockAfterCompanyPortalUpdateDeferralInDays", 
    "connectToVpnOnLaunch", 
    "customBrowserDisplayName", 
    "customBrowserPackageId", 
    "customBrowserProtocol", 
    "customDialerAppDisplayName", 
    "customDialerAppPackageId", 
    "customDialerAppProtocol", 
    "customSettings", 
    "deployedAppCount", 
    "deviceLockRequired", 
    "disableAppEncryptionIfDeviceEncryptionIsEnabled", 
    "disableProtectionOfManagedOutboundOpenInData", 
    "encryptAppData", 
    "exemptedAppPackages", 
    "exemptedAppProtocols", 
    "faceIdBlocked", 
    "filterOpenInToOnlyManagedApps", 
    "minimumRequiredCompanyPortalVersion", 
    "minimumRequiredPatchVersion", 
    "minimumRequiredSdkVersion", 
    "minimumWarningCompanyPortalVersion", 
    "minimumWarningPatchVersion", 
    "minimumWipeCompanyPortalVersion", 
    "minimumWipePatchVersion", 
    "minimumWipeSdkVersion", 
    "protectInboundDataFromUnknownSources", 
    "requiredAndroidSafetyNetAppsVerificationType", 
    "requiredAndroidSafetyNetDeviceAttestationType", 
    "requiredAndroidSafetyNetEvaluationType", 
    "screenCaptureBlocked", 
    "thirdPartyKeyboardsBlocked", 
    "warnAfterCompanyPortalUpdateDeferralInDays", 
    "wipeAfterCompanyPortalUpdateDeferralInDays", 
    "apps", 
    "deploymentSummary"})
@JsonInclude(Include.NON_NULL)
public class DefaultManagedAppProtection extends ManagedAppProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.defaultManagedAppProtection";
    }

    @JsonProperty("allowedAndroidDeviceManufacturers")
    protected String allowedAndroidDeviceManufacturers;

    @JsonProperty("allowedAndroidDeviceModels")
    protected List<String> allowedAndroidDeviceModels;

    @JsonProperty("allowedAndroidDeviceModels@nextLink")
    protected String allowedAndroidDeviceModelsNextLink;

    @JsonProperty("allowedIosDeviceModels")
    protected String allowedIosDeviceModels;

    @JsonProperty("appActionIfAndroidDeviceManufacturerNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;

    @JsonProperty("appActionIfAndroidDeviceModelNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;

    @JsonProperty("appActionIfAndroidSafetyNetAppsVerificationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;

    @JsonProperty("appActionIfAndroidSafetyNetDeviceAttestationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;

    @JsonProperty("appActionIfDeviceLockNotSet")
    protected ManagedAppRemediationAction appActionIfDeviceLockNotSet;

    @JsonProperty("appActionIfIosDeviceModelNotAllowed")
    protected ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed;

    @JsonProperty("appDataEncryptionType")
    protected ManagedAppDataEncryptionType appDataEncryptionType;

    @JsonProperty("biometricAuthenticationBlocked")
    protected Boolean biometricAuthenticationBlocked;

    @JsonProperty("blockAfterCompanyPortalUpdateDeferralInDays")
    protected Integer blockAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("connectToVpnOnLaunch")
    protected Boolean connectToVpnOnLaunch;

    @JsonProperty("customBrowserDisplayName")
    protected String customBrowserDisplayName;

    @JsonProperty("customBrowserPackageId")
    protected String customBrowserPackageId;

    @JsonProperty("customBrowserProtocol")
    protected String customBrowserProtocol;

    @JsonProperty("customDialerAppDisplayName")
    protected String customDialerAppDisplayName;

    @JsonProperty("customDialerAppPackageId")
    protected String customDialerAppPackageId;

    @JsonProperty("customDialerAppProtocol")
    protected String customDialerAppProtocol;

    @JsonProperty("customSettings")
    protected List<KeyValuePair> customSettings;

    @JsonProperty("customSettings@nextLink")
    protected String customSettingsNextLink;

    @JsonProperty("deployedAppCount")
    protected Integer deployedAppCount;

    @JsonProperty("deviceLockRequired")
    protected Boolean deviceLockRequired;

    @JsonProperty("disableAppEncryptionIfDeviceEncryptionIsEnabled")
    protected Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;

    @JsonProperty("disableProtectionOfManagedOutboundOpenInData")
    protected Boolean disableProtectionOfManagedOutboundOpenInData;

    @JsonProperty("encryptAppData")
    protected Boolean encryptAppData;

    @JsonProperty("exemptedAppPackages")
    protected List<KeyValuePair> exemptedAppPackages;

    @JsonProperty("exemptedAppPackages@nextLink")
    protected String exemptedAppPackagesNextLink;

    @JsonProperty("exemptedAppProtocols")
    protected List<KeyValuePair> exemptedAppProtocols;

    @JsonProperty("exemptedAppProtocols@nextLink")
    protected String exemptedAppProtocolsNextLink;

    @JsonProperty("faceIdBlocked")
    protected Boolean faceIdBlocked;

    @JsonProperty("filterOpenInToOnlyManagedApps")
    protected Boolean filterOpenInToOnlyManagedApps;

    @JsonProperty("minimumRequiredCompanyPortalVersion")
    protected String minimumRequiredCompanyPortalVersion;

    @JsonProperty("minimumRequiredPatchVersion")
    protected String minimumRequiredPatchVersion;

    @JsonProperty("minimumRequiredSdkVersion")
    protected String minimumRequiredSdkVersion;

    @JsonProperty("minimumWarningCompanyPortalVersion")
    protected String minimumWarningCompanyPortalVersion;

    @JsonProperty("minimumWarningPatchVersion")
    protected String minimumWarningPatchVersion;

    @JsonProperty("minimumWipeCompanyPortalVersion")
    protected String minimumWipeCompanyPortalVersion;

    @JsonProperty("minimumWipePatchVersion")
    protected String minimumWipePatchVersion;

    @JsonProperty("minimumWipeSdkVersion")
    protected String minimumWipeSdkVersion;

    @JsonProperty("protectInboundDataFromUnknownSources")
    protected Boolean protectInboundDataFromUnknownSources;

    @JsonProperty("requiredAndroidSafetyNetAppsVerificationType")
    protected AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;

    @JsonProperty("requiredAndroidSafetyNetDeviceAttestationType")
    protected AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;

    @JsonProperty("requiredAndroidSafetyNetEvaluationType")
    protected AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("thirdPartyKeyboardsBlocked")
    protected Boolean thirdPartyKeyboardsBlocked;

    @JsonProperty("warnAfterCompanyPortalUpdateDeferralInDays")
    protected Integer warnAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("wipeAfterCompanyPortalUpdateDeferralInDays")
    protected Integer wipeAfterCompanyPortalUpdateDeferralInDays;

    @JsonProperty("apps")
    protected List<ManagedMobileApp> apps;

    @JsonProperty("deploymentSummary")
    protected ManagedAppPolicyDeploymentSummary deploymentSummary;

    protected DefaultManagedAppProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDefaultManagedAppProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations;
        private String allowedDataIngestionLocationsNextLink;
        private List<ManagedAppDataStorageLocation> allowedDataStorageLocations;
        private String allowedDataStorageLocationsNextLink;
        private ManagedAppDataTransferLevel allowedInboundDataTransferSources;
        private Integer allowedOutboundClipboardSharingExceptionLength;
        private ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel;
        private ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations;
        private ManagedAppRemediationAction appActionIfDeviceComplianceRequired;
        private ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded;
        private ManagedAppRemediationAction appActionIfUnableToAuthenticateUser;
        private Boolean blockDataIngestionIntoOrganizationDocuments;
        private Boolean contactSyncBlocked;
        private Boolean dataBackupBlocked;
        private Boolean deviceComplianceRequired;
        private ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel;
        private Boolean disableAppPinIfDevicePinIsSet;
        private Boolean fingerprintBlocked;
        private Duration gracePeriodToBlockAppsDuringOffClockHours;
        private ManagedBrowserType managedBrowser;
        private Boolean managedBrowserToOpenLinksRequired;
        private ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel;
        private Integer maximumPinRetries;
        private String maximumRequiredOsVersion;
        private String maximumWarningOsVersion;
        private String maximumWipeOsVersion;
        private Integer minimumPinLength;
        private String minimumRequiredAppVersion;
        private String minimumRequiredOsVersion;
        private String minimumWarningAppVersion;
        private String minimumWarningOsVersion;
        private String minimumWipeAppVersion;
        private String minimumWipeOsVersion;
        private ManagedAppRemediationAction mobileThreatDefenseRemediationAction;
        private ManagedAppNotificationRestriction notificationRestriction;
        private Boolean organizationalCredentialsRequired;
        private Duration periodBeforePinReset;
        private Duration periodOfflineBeforeAccessCheck;
        private Duration periodOfflineBeforeWipeIsEnforced;
        private Duration periodOnlineBeforeAccessCheck;
        private ManagedAppPinCharacterSet pinCharacterSet;
        private Boolean pinRequired;
        private Duration pinRequiredInsteadOfBiometricTimeout;
        private Integer previousPinBlockCount;
        private Boolean printBlocked;
        private Boolean saveAsBlocked;
        private Boolean simplePinBlocked;
        private String allowedAndroidDeviceManufacturers;
        private List<String> allowedAndroidDeviceModels;
        private String allowedAndroidDeviceModelsNextLink;
        private String allowedIosDeviceModels;
        private ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;
        private ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;
        private ManagedAppRemediationAction appActionIfDeviceLockNotSet;
        private ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed;
        private ManagedAppDataEncryptionType appDataEncryptionType;
        private Boolean biometricAuthenticationBlocked;
        private Integer blockAfterCompanyPortalUpdateDeferralInDays;
        private Boolean connectToVpnOnLaunch;
        private String customBrowserDisplayName;
        private String customBrowserPackageId;
        private String customBrowserProtocol;
        private String customDialerAppDisplayName;
        private String customDialerAppPackageId;
        private String customDialerAppProtocol;
        private List<KeyValuePair> customSettings;
        private String customSettingsNextLink;
        private Integer deployedAppCount;
        private Boolean deviceLockRequired;
        private Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;
        private Boolean disableProtectionOfManagedOutboundOpenInData;
        private Boolean encryptAppData;
        private List<KeyValuePair> exemptedAppPackages;
        private String exemptedAppPackagesNextLink;
        private List<KeyValuePair> exemptedAppProtocols;
        private String exemptedAppProtocolsNextLink;
        private Boolean faceIdBlocked;
        private Boolean filterOpenInToOnlyManagedApps;
        private String minimumRequiredCompanyPortalVersion;
        private String minimumRequiredPatchVersion;
        private String minimumRequiredSdkVersion;
        private String minimumWarningCompanyPortalVersion;
        private String minimumWarningPatchVersion;
        private String minimumWipeCompanyPortalVersion;
        private String minimumWipePatchVersion;
        private String minimumWipeSdkVersion;
        private Boolean protectInboundDataFromUnknownSources;
        private AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;
        private AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;
        private AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType;
        private Boolean screenCaptureBlocked;
        private Boolean thirdPartyKeyboardsBlocked;
        private Integer warnAfterCompanyPortalUpdateDeferralInDays;
        private Integer wipeAfterCompanyPortalUpdateDeferralInDays;
        private List<ManagedMobileApp> apps;
        private ManagedAppPolicyDeploymentSummary deploymentSummary;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder allowedDataIngestionLocations(List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations) {
            this.allowedDataIngestionLocations = allowedDataIngestionLocations;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataIngestionLocations(ManagedAppDataIngestionLocation... allowedDataIngestionLocations) {
            return allowedDataIngestionLocations(Arrays.asList(allowedDataIngestionLocations));
        }

        public Builder allowedDataIngestionLocationsNextLink(String allowedDataIngestionLocationsNextLink) {
            this.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(List<ManagedAppDataStorageLocation> allowedDataStorageLocations) {
            this.allowedDataStorageLocations = allowedDataStorageLocations;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(ManagedAppDataStorageLocation... allowedDataStorageLocations) {
            return allowedDataStorageLocations(Arrays.asList(allowedDataStorageLocations));
        }

        public Builder allowedDataStorageLocationsNextLink(String allowedDataStorageLocationsNextLink) {
            this.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedInboundDataTransferSources(ManagedAppDataTransferLevel allowedInboundDataTransferSources) {
            this.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            this.changedFields = changedFields.add("allowedInboundDataTransferSources");
            return this;
        }

        public Builder allowedOutboundClipboardSharingExceptionLength(Integer allowedOutboundClipboardSharingExceptionLength) {
            this.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingExceptionLength");
            return this;
        }

        public Builder allowedOutboundClipboardSharingLevel(ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel) {
            this.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingLevel");
            return this;
        }

        public Builder allowedOutboundDataTransferDestinations(ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations) {
            this.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            this.changedFields = changedFields.add("allowedOutboundDataTransferDestinations");
            return this;
        }

        public Builder appActionIfDeviceComplianceRequired(ManagedAppRemediationAction appActionIfDeviceComplianceRequired) {
            this.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            this.changedFields = changedFields.add("appActionIfDeviceComplianceRequired");
            return this;
        }

        public Builder appActionIfMaximumPinRetriesExceeded(ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded) {
            this.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            this.changedFields = changedFields.add("appActionIfMaximumPinRetriesExceeded");
            return this;
        }

        public Builder appActionIfUnableToAuthenticateUser(ManagedAppRemediationAction appActionIfUnableToAuthenticateUser) {
            this.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            this.changedFields = changedFields.add("appActionIfUnableToAuthenticateUser");
            return this;
        }

        public Builder blockDataIngestionIntoOrganizationDocuments(Boolean blockDataIngestionIntoOrganizationDocuments) {
            this.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            this.changedFields = changedFields.add("blockDataIngestionIntoOrganizationDocuments");
            return this;
        }

        public Builder contactSyncBlocked(Boolean contactSyncBlocked) {
            this.contactSyncBlocked = contactSyncBlocked;
            this.changedFields = changedFields.add("contactSyncBlocked");
            return this;
        }

        public Builder dataBackupBlocked(Boolean dataBackupBlocked) {
            this.dataBackupBlocked = dataBackupBlocked;
            this.changedFields = changedFields.add("dataBackupBlocked");
            return this;
        }

        public Builder deviceComplianceRequired(Boolean deviceComplianceRequired) {
            this.deviceComplianceRequired = deviceComplianceRequired;
            this.changedFields = changedFields.add("deviceComplianceRequired");
            return this;
        }

        public Builder dialerRestrictionLevel(ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel) {
            this.dialerRestrictionLevel = dialerRestrictionLevel;
            this.changedFields = changedFields.add("dialerRestrictionLevel");
            return this;
        }

        public Builder disableAppPinIfDevicePinIsSet(Boolean disableAppPinIfDevicePinIsSet) {
            this.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            this.changedFields = changedFields.add("disableAppPinIfDevicePinIsSet");
            return this;
        }

        public Builder fingerprintBlocked(Boolean fingerprintBlocked) {
            this.fingerprintBlocked = fingerprintBlocked;
            this.changedFields = changedFields.add("fingerprintBlocked");
            return this;
        }

        public Builder gracePeriodToBlockAppsDuringOffClockHours(Duration gracePeriodToBlockAppsDuringOffClockHours) {
            this.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
            this.changedFields = changedFields.add("gracePeriodToBlockAppsDuringOffClockHours");
            return this;
        }

        public Builder managedBrowser(ManagedBrowserType managedBrowser) {
            this.managedBrowser = managedBrowser;
            this.changedFields = changedFields.add("managedBrowser");
            return this;
        }

        public Builder managedBrowserToOpenLinksRequired(Boolean managedBrowserToOpenLinksRequired) {
            this.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            this.changedFields = changedFields.add("managedBrowserToOpenLinksRequired");
            return this;
        }

        public Builder maximumAllowedDeviceThreatLevel(ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel) {
            this.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            this.changedFields = changedFields.add("maximumAllowedDeviceThreatLevel");
            return this;
        }

        public Builder maximumPinRetries(Integer maximumPinRetries) {
            this.maximumPinRetries = maximumPinRetries;
            this.changedFields = changedFields.add("maximumPinRetries");
            return this;
        }

        public Builder maximumRequiredOsVersion(String maximumRequiredOsVersion) {
            this.maximumRequiredOsVersion = maximumRequiredOsVersion;
            this.changedFields = changedFields.add("maximumRequiredOsVersion");
            return this;
        }

        public Builder maximumWarningOsVersion(String maximumWarningOsVersion) {
            this.maximumWarningOsVersion = maximumWarningOsVersion;
            this.changedFields = changedFields.add("maximumWarningOsVersion");
            return this;
        }

        public Builder maximumWipeOsVersion(String maximumWipeOsVersion) {
            this.maximumWipeOsVersion = maximumWipeOsVersion;
            this.changedFields = changedFields.add("maximumWipeOsVersion");
            return this;
        }

        public Builder minimumPinLength(Integer minimumPinLength) {
            this.minimumPinLength = minimumPinLength;
            this.changedFields = changedFields.add("minimumPinLength");
            return this;
        }

        public Builder minimumRequiredAppVersion(String minimumRequiredAppVersion) {
            this.minimumRequiredAppVersion = minimumRequiredAppVersion;
            this.changedFields = changedFields.add("minimumRequiredAppVersion");
            return this;
        }

        public Builder minimumRequiredOsVersion(String minimumRequiredOsVersion) {
            this.minimumRequiredOsVersion = minimumRequiredOsVersion;
            this.changedFields = changedFields.add("minimumRequiredOsVersion");
            return this;
        }

        public Builder minimumWarningAppVersion(String minimumWarningAppVersion) {
            this.minimumWarningAppVersion = minimumWarningAppVersion;
            this.changedFields = changedFields.add("minimumWarningAppVersion");
            return this;
        }

        public Builder minimumWarningOsVersion(String minimumWarningOsVersion) {
            this.minimumWarningOsVersion = minimumWarningOsVersion;
            this.changedFields = changedFields.add("minimumWarningOsVersion");
            return this;
        }

        public Builder minimumWipeAppVersion(String minimumWipeAppVersion) {
            this.minimumWipeAppVersion = minimumWipeAppVersion;
            this.changedFields = changedFields.add("minimumWipeAppVersion");
            return this;
        }

        public Builder minimumWipeOsVersion(String minimumWipeOsVersion) {
            this.minimumWipeOsVersion = minimumWipeOsVersion;
            this.changedFields = changedFields.add("minimumWipeOsVersion");
            return this;
        }

        public Builder mobileThreatDefenseRemediationAction(ManagedAppRemediationAction mobileThreatDefenseRemediationAction) {
            this.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            this.changedFields = changedFields.add("mobileThreatDefenseRemediationAction");
            return this;
        }

        public Builder notificationRestriction(ManagedAppNotificationRestriction notificationRestriction) {
            this.notificationRestriction = notificationRestriction;
            this.changedFields = changedFields.add("notificationRestriction");
            return this;
        }

        public Builder organizationalCredentialsRequired(Boolean organizationalCredentialsRequired) {
            this.organizationalCredentialsRequired = organizationalCredentialsRequired;
            this.changedFields = changedFields.add("organizationalCredentialsRequired");
            return this;
        }

        public Builder periodBeforePinReset(Duration periodBeforePinReset) {
            this.periodBeforePinReset = periodBeforePinReset;
            this.changedFields = changedFields.add("periodBeforePinReset");
            return this;
        }

        public Builder periodOfflineBeforeAccessCheck(Duration periodOfflineBeforeAccessCheck) {
            this.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOfflineBeforeAccessCheck");
            return this;
        }

        public Builder periodOfflineBeforeWipeIsEnforced(Duration periodOfflineBeforeWipeIsEnforced) {
            this.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            this.changedFields = changedFields.add("periodOfflineBeforeWipeIsEnforced");
            return this;
        }

        public Builder periodOnlineBeforeAccessCheck(Duration periodOnlineBeforeAccessCheck) {
            this.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOnlineBeforeAccessCheck");
            return this;
        }

        public Builder pinCharacterSet(ManagedAppPinCharacterSet pinCharacterSet) {
            this.pinCharacterSet = pinCharacterSet;
            this.changedFields = changedFields.add("pinCharacterSet");
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = pinRequired;
            this.changedFields = changedFields.add("pinRequired");
            return this;
        }

        public Builder pinRequiredInsteadOfBiometricTimeout(Duration pinRequiredInsteadOfBiometricTimeout) {
            this.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            this.changedFields = changedFields.add("pinRequiredInsteadOfBiometricTimeout");
            return this;
        }

        public Builder previousPinBlockCount(Integer previousPinBlockCount) {
            this.previousPinBlockCount = previousPinBlockCount;
            this.changedFields = changedFields.add("previousPinBlockCount");
            return this;
        }

        public Builder printBlocked(Boolean printBlocked) {
            this.printBlocked = printBlocked;
            this.changedFields = changedFields.add("printBlocked");
            return this;
        }

        public Builder saveAsBlocked(Boolean saveAsBlocked) {
            this.saveAsBlocked = saveAsBlocked;
            this.changedFields = changedFields.add("saveAsBlocked");
            return this;
        }

        public Builder simplePinBlocked(Boolean simplePinBlocked) {
            this.simplePinBlocked = simplePinBlocked;
            this.changedFields = changedFields.add("simplePinBlocked");
            return this;
        }

        /**
         * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
         * managed app to work. (Android only)”</i>
         * 
         * @param allowedAndroidDeviceManufacturers
         *            value of {@code allowedAndroidDeviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
            this.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            this.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work. (
         * Android Only)”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(List<String> allowedAndroidDeviceModels) {
            this.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work. (
         * Android Only)”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(String... allowedAndroidDeviceModels) {
            return allowedAndroidDeviceModels(Arrays.asList(allowedAndroidDeviceModels));
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work. (
         * Android Only)”</i>
         * 
         * @param allowedAndroidDeviceModelsNextLink
         *            value of {@code allowedAndroidDeviceModels@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModelsNextLink(String allowedAndroidDeviceModelsNextLink) {
            this.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
         * app to work. (iOS Only)”</i>
         * 
         * @param allowedIosDeviceModels
         *            value of {@code allowedIosDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedIosDeviceModels(String allowedIosDeviceModels) {
            this.allowedIosDeviceModels = allowedIosDeviceModels;
            this.changedFields = changedFields.add("allowedIosDeviceModels");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * manufacturer is not allowed. (Android only)”</i>
         * 
         * @param appActionIfAndroidDeviceManufacturerNotAllowed
         *            value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
            this.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * model is not allowed. (Android Only)”</i>
         * 
         * @param appActionIfAndroidDeviceModelNotAllowed
         *            value of {@code appActionIfAndroidDeviceModelNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
            this.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * App Verification requirement fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetAppsVerificationFailed
         *            value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
            this.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * SafetyNet Attestation requirement fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
         *            value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
            this.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
         * is required on device but is not set. (android only)”</i>
         * 
         * @param appActionIfDeviceLockNotSet
         *            value of {@code appActionIfDeviceLockNotSet} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfDeviceLockNotSet(ManagedAppRemediationAction appActionIfDeviceLockNotSet) {
            this.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
            this.changedFields = changedFields.add("appActionIfDeviceLockNotSet");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * model is not allowed. (iOS Only)”</i>
         * 
         * @param appActionIfIosDeviceModelNotAllowed
         *            value of {@code appActionIfIosDeviceModelNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfIosDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed) {
            this.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
            this.changedFields = changedFields.add("appActionIfIosDeviceModelNotAllowed");
            return this;
        }

        /**
         * <i>“Type of encryption which should be used for data in a managed app. (iOS Only)”</i>
         * 
         * @param appDataEncryptionType
         *            value of {@code appDataEncryptionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appDataEncryptionType(ManagedAppDataEncryptionType appDataEncryptionType) {
            this.appDataEncryptionType = appDataEncryptionType;
            this.changedFields = changedFields.add("appDataEncryptionType");
            return this;
        }

        /**
         * <i>“Indicates whether use of the biometric authentication is allowed in place of a
         * pin if PinRequired is set to True. (Android Only)”</i>
         * 
         * @param biometricAuthenticationBlocked
         *            value of {@code biometricAuthenticationBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder biometricAuthenticationBlocked(Boolean biometricAuthenticationBlocked) {
            this.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
            this.changedFields = changedFields.add("biometricAuthenticationBlocked");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * app access will be blocked.”</i>
         * 
         * @param blockAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code blockAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder blockAfterCompanyPortalUpdateDeferralInDays(Integer blockAfterCompanyPortalUpdateDeferralInDays) {
            this.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("blockAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“Whether the app should connect to the configured VPN on launch (Android only).”</i>
         * 
         * @param connectToVpnOnLaunch
         *            value of {@code connectToVpnOnLaunch} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectToVpnOnLaunch(Boolean connectToVpnOnLaunch) {
            this.connectToVpnOnLaunch = connectToVpnOnLaunch;
            this.changedFields = changedFields.add("connectToVpnOnLaunch");
            return this;
        }

        /**
         * <i>“Friendly name of the preferred custom browser to open weblink on Android. (
         * Android only)”</i>
         * 
         * @param customBrowserDisplayName
         *            value of {@code customBrowserDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserDisplayName(String customBrowserDisplayName) {
            this.customBrowserDisplayName = customBrowserDisplayName;
            this.changedFields = changedFields.add("customBrowserDisplayName");
            return this;
        }

        /**
         * <i>“Unique identifier of a custom browser to open weblink on Android. (Android only)”</i>
         * 
         * @param customBrowserPackageId
         *            value of {@code customBrowserPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserPackageId(String customBrowserPackageId) {
            this.customBrowserPackageId = customBrowserPackageId;
            this.changedFields = changedFields.add("customBrowserPackageId");
            return this;
        }

        /**
         * <i>“A custom browser protocol to open weblink on iOS. (iOS only)”</i>
         * 
         * @param customBrowserProtocol
         *            value of {@code customBrowserProtocol} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserProtocol(String customBrowserProtocol) {
            this.customBrowserProtocol = customBrowserProtocol;
            this.changedFields = changedFields.add("customBrowserProtocol");
            return this;
        }

        /**
         * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppDisplayName
         *            value of {@code customDialerAppDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppDisplayName(String customDialerAppDisplayName) {
            this.customDialerAppDisplayName = customDialerAppDisplayName;
            this.changedFields = changedFields.add("customDialerAppDisplayName");
            return this;
        }

        /**
         * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppPackageId
         *            value of {@code customDialerAppPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppPackageId(String customDialerAppPackageId) {
            this.customDialerAppPackageId = customDialerAppPackageId;
            this.changedFields = changedFields.add("customDialerAppPackageId");
            return this;
        }

        /**
         * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
         * example, skype:.”</i>
         * 
         * @param customDialerAppProtocol
         *            value of {@code customDialerAppProtocol} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppProtocol(String customDialerAppProtocol) {
            this.customDialerAppProtocol = customDialerAppProtocol;
            this.changedFields = changedFields.add("customDialerAppProtocol");
            return this;
        }

        /**
         * <i>“A set of string key and string value pairs to be sent to the affected users,
         * unalterned by this service”</i>
         * 
         * @param customSettings
         *            value of {@code customSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSettings(List<KeyValuePair> customSettings) {
            this.customSettings = customSettings;
            this.changedFields = changedFields.add("customSettings");
            return this;
        }

        /**
         * <i>“A set of string key and string value pairs to be sent to the affected users,
         * unalterned by this service”</i>
         * 
         * @param customSettings
         *            value of {@code customSettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSettings(KeyValuePair... customSettings) {
            return customSettings(Arrays.asList(customSettings));
        }

        /**
         * <i>“A set of string key and string value pairs to be sent to the affected users,
         * unalterned by this service”</i>
         * 
         * @param customSettingsNextLink
         *            value of {@code customSettings@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSettingsNextLink(String customSettingsNextLink) {
            this.customSettingsNextLink = customSettingsNextLink;
            this.changedFields = changedFields.add("customSettings");
            return this;
        }

        /**
         * <i>“Count of apps to which the current policy is deployed.”</i>
         * 
         * @param deployedAppCount
         *            value of {@code deployedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedAppCount(Integer deployedAppCount) {
            this.deployedAppCount = deployedAppCount;
            this.changedFields = changedFields.add("deployedAppCount");
            return this;
        }

        /**
         * <i>“Defines if any kind of lock must be required on device. (android only)”</i>
         * 
         * @param deviceLockRequired
         *            value of {@code deviceLockRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceLockRequired(Boolean deviceLockRequired) {
            this.deviceLockRequired = deviceLockRequired;
            this.changedFields = changedFields.add("deviceLockRequired");
            return this;
        }

        /**
         * <i>“When this setting is enabled, app level encryption is disabled if device level
         * encryption is enabled. (Android only)”</i>
         * 
         * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
         *            value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
            this.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            this.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
            return this;
        }

        /**
         * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
         * This setting is only allowed to be True when
         * AllowedOutboundDataTransferDestinations is set to ManagedApps. (iOS Only)”</i>
         * 
         * @param disableProtectionOfManagedOutboundOpenInData
         *            value of {@code disableProtectionOfManagedOutboundOpenInData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableProtectionOfManagedOutboundOpenInData(Boolean disableProtectionOfManagedOutboundOpenInData) {
            this.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
            this.changedFields = changedFields.add("disableProtectionOfManagedOutboundOpenInData");
            return this;
        }

        /**
         * <i>“Indicates whether managed-app data should be encrypted. (Android only)”</i>
         * 
         * @param encryptAppData
         *            value of {@code encryptAppData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptAppData(Boolean encryptAppData) {
            this.encryptAppData = encryptAppData;
            this.changedFields = changedFields.add("encryptAppData");
            return this;
        }

        /**
         * <i>“Android App packages in this list will be exempt from the policy and will be
         * able to receive data from managed apps. (Android only)”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(List<KeyValuePair> exemptedAppPackages) {
            this.exemptedAppPackages = exemptedAppPackages;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“Android App packages in this list will be exempt from the policy and will be
         * able to receive data from managed apps. (Android only)”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(KeyValuePair... exemptedAppPackages) {
            return exemptedAppPackages(Arrays.asList(exemptedAppPackages));
        }

        /**
         * <i>“Android App packages in this list will be exempt from the policy and will be
         * able to receive data from managed apps. (Android only)”</i>
         * 
         * @param exemptedAppPackagesNextLink
         *            value of {@code exemptedAppPackages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackagesNextLink(String exemptedAppPackagesNextLink) {
            this.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps. (iOS Only)”</i>
         * 
         * @param exemptedAppProtocols
         *            value of {@code exemptedAppProtocols} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocols(List<KeyValuePair> exemptedAppProtocols) {
            this.exemptedAppProtocols = exemptedAppProtocols;
            this.changedFields = changedFields.add("exemptedAppProtocols");
            return this;
        }

        /**
         * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps. (iOS Only)”</i>
         * 
         * @param exemptedAppProtocols
         *            value of {@code exemptedAppProtocols} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocols(KeyValuePair... exemptedAppProtocols) {
            return exemptedAppProtocols(Arrays.asList(exemptedAppProtocols));
        }

        /**
         * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
         * data from managed apps. (iOS Only)”</i>
         * 
         * @param exemptedAppProtocolsNextLink
         *            value of {@code exemptedAppProtocols@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppProtocolsNextLink(String exemptedAppProtocolsNextLink) {
            this.exemptedAppProtocolsNextLink = exemptedAppProtocolsNextLink;
            this.changedFields = changedFields.add("exemptedAppProtocols");
            return this;
        }

        /**
         * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
         * is set to True. (iOS Only)”</i>
         * 
         * @param faceIdBlocked
         *            value of {@code faceIdBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder faceIdBlocked(Boolean faceIdBlocked) {
            this.faceIdBlocked = faceIdBlocked;
            this.changedFields = changedFields.add("faceIdBlocked");
            return this;
        }

        /**
         * <i>“Defines if open-in operation is supported from the managed app to the
         * filesharing locations selected. This setting only applies when
         * AllowedOutboundDataTransferDestinations is set to ManagedApps and
         * DisableProtectionOfManagedOutboundOpenInData is set to False. (iOS Only)”</i>
         * 
         * @param filterOpenInToOnlyManagedApps
         *            value of {@code filterOpenInToOnlyManagedApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filterOpenInToOnlyManagedApps(Boolean filterOpenInToOnlyManagedApps) {
            this.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
            this.changedFields = changedFields.add("filterOpenInToOnlyManagedApps");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * app access will be blocked”</i>
         * 
         * @param minimumRequiredCompanyPortalVersion
         *            value of {@code minimumRequiredCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
            this.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Define the oldest required Android security patch level a user can have to gain
         * secure access to the app. (Android only)”</i>
         * 
         * @param minimumRequiredPatchVersion
         *            value of {@code minimumRequiredPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
            this.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            this.changedFields = changedFields.add("minimumRequiredPatchVersion");
            return this;
        }

        /**
         * <i>“Versions less than the specified version will block the managed app from
         * accessing company data. (iOS Only)”</i>
         * 
         * @param minimumRequiredSdkVersion
         *            value of {@code minimumRequiredSdkVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredSdkVersion(String minimumRequiredSdkVersion) {
            this.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
            this.changedFields = changedFields.add("minimumRequiredSdkVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the user will receive a warning”</i>
         * 
         * @param minimumWarningCompanyPortalVersion
         *            value of {@code minimumWarningCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
            this.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Define the oldest recommended Android security patch level a user can have for
         * secure access to the app. (Android only)”</i>
         * 
         * @param minimumWarningPatchVersion
         *            value of {@code minimumWarningPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningPatchVersion(String minimumWarningPatchVersion) {
            this.minimumWarningPatchVersion = minimumWarningPatchVersion;
            this.changedFields = changedFields.add("minimumWarningPatchVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the company data on the app will be wiped”</i>
         * 
         * @param minimumWipeCompanyPortalVersion
         *            value of {@code minimumWipeCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
            this.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Android security patch level  less than or equal to the specified value will
         * wipe the managed app and the associated company data. (Android only)”</i>
         * 
         * @param minimumWipePatchVersion
         *            value of {@code minimumWipePatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipePatchVersion(String minimumWipePatchVersion) {
            this.minimumWipePatchVersion = minimumWipePatchVersion;
            this.changedFields = changedFields.add("minimumWipePatchVersion");
            return this;
        }

        /**
         * <i>“Versions less than the specified version will block the managed app from
         * accessing company data.”</i>
         * 
         * @param minimumWipeSdkVersion
         *            value of {@code minimumWipeSdkVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipeSdkVersion(String minimumWipeSdkVersion) {
            this.minimumWipeSdkVersion = minimumWipeSdkVersion;
            this.changedFields = changedFields.add("minimumWipeSdkVersion");
            return this;
        }

        /**
         * <i>“Protect incoming data from unknown source. This setting is only allowed to be
         * True when AllowedInboundDataTransferSources is set to AllApps. (iOS Only)”</i>
         * 
         * @param protectInboundDataFromUnknownSources
         *            value of {@code protectInboundDataFromUnknownSources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder protectInboundDataFromUnknownSources(Boolean protectInboundDataFromUnknownSources) {
            this.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
            this.changedFields = changedFields.add("protectInboundDataFromUnknownSources");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
         * work.”</i>
         * 
         * @param requiredAndroidSafetyNetAppsVerificationType
         *            value of {@code requiredAndroidSafetyNetAppsVerificationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
            this.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
         * to work.”</i>
         * 
         * @param requiredAndroidSafetyNetDeviceAttestationType
         *            value of {@code requiredAndroidSafetyNetDeviceAttestationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
            this.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
         * work. (Android Only)”</i>
         * 
         * @param requiredAndroidSafetyNetEvaluationType
         *            value of {@code requiredAndroidSafetyNetEvaluationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetEvaluationType(AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType) {
            this.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetEvaluationType");
            return this;
        }

        /**
         * <i>“Indicates whether screen capture is blocked. (Android only)”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Defines if third party keyboards are allowed while accessing a managed app. (iOS
         * Only)”</i>
         * 
         * @param thirdPartyKeyboardsBlocked
         *            value of {@code thirdPartyKeyboardsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder thirdPartyKeyboardsBlocked(Boolean thirdPartyKeyboardsBlocked) {
            this.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
            this.changedFields = changedFields.add("thirdPartyKeyboardsBlocked");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * the user will receive the warning”</i>
         * 
         * @param warnAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code warnAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder warnAfterCompanyPortalUpdateDeferralInDays(Integer warnAfterCompanyPortalUpdateDeferralInDays) {
            this.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("warnAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“Maximum number of days Company Portal update can be deferred on the device or
         * the company data on the app will be wiped”</i>
         * 
         * @param wipeAfterCompanyPortalUpdateDeferralInDays
         *            value of {@code wipeAfterCompanyPortalUpdateDeferralInDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wipeAfterCompanyPortalUpdateDeferralInDays(Integer wipeAfterCompanyPortalUpdateDeferralInDays) {
            this.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
            this.changedFields = changedFields.add("wipeAfterCompanyPortalUpdateDeferralInDays");
            return this;
        }

        /**
         * <i>“List of apps to which the policy is deployed.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(List<ManagedMobileApp> apps) {
            this.apps = apps;
            this.changedFields = changedFields.add("apps");
            return this;
        }

        /**
         * <i>“List of apps to which the policy is deployed.”</i>
         * 
         * @param apps
         *            value of {@code apps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder apps(ManagedMobileApp... apps) {
            return apps(Arrays.asList(apps));
        }

        /**
         * <i>“Navigation property to deployment summary of the configuration.”</i>
         * 
         * @param deploymentSummary
         *            value of {@code deploymentSummary} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deploymentSummary(ManagedAppPolicyDeploymentSummary deploymentSummary) {
            this.deploymentSummary = deploymentSummary;
            this.changedFields = changedFields.add("deploymentSummary");
            return this;
        }

        public DefaultManagedAppProtection build() {
            DefaultManagedAppProtection _x = new DefaultManagedAppProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.defaultManagedAppProtection";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
            _x.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            _x.allowedDataStorageLocations = allowedDataStorageLocations;
            _x.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            _x.contactSyncBlocked = contactSyncBlocked;
            _x.dataBackupBlocked = dataBackupBlocked;
            _x.deviceComplianceRequired = deviceComplianceRequired;
            _x.dialerRestrictionLevel = dialerRestrictionLevel;
            _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            _x.fingerprintBlocked = fingerprintBlocked;
            _x.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
            _x.managedBrowser = managedBrowser;
            _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            _x.maximumPinRetries = maximumPinRetries;
            _x.maximumRequiredOsVersion = maximumRequiredOsVersion;
            _x.maximumWarningOsVersion = maximumWarningOsVersion;
            _x.maximumWipeOsVersion = maximumWipeOsVersion;
            _x.minimumPinLength = minimumPinLength;
            _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
            _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
            _x.minimumWarningAppVersion = minimumWarningAppVersion;
            _x.minimumWarningOsVersion = minimumWarningOsVersion;
            _x.minimumWipeAppVersion = minimumWipeAppVersion;
            _x.minimumWipeOsVersion = minimumWipeOsVersion;
            _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            _x.notificationRestriction = notificationRestriction;
            _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
            _x.periodBeforePinReset = periodBeforePinReset;
            _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            _x.pinCharacterSet = pinCharacterSet;
            _x.pinRequired = pinRequired;
            _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            _x.previousPinBlockCount = previousPinBlockCount;
            _x.printBlocked = printBlocked;
            _x.saveAsBlocked = saveAsBlocked;
            _x.simplePinBlocked = simplePinBlocked;
            _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            _x.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            _x.allowedIosDeviceModels = allowedIosDeviceModels;
            _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
            _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
            _x.appDataEncryptionType = appDataEncryptionType;
            _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
            _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
            _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
            _x.customBrowserDisplayName = customBrowserDisplayName;
            _x.customBrowserPackageId = customBrowserPackageId;
            _x.customBrowserProtocol = customBrowserProtocol;
            _x.customDialerAppDisplayName = customDialerAppDisplayName;
            _x.customDialerAppPackageId = customDialerAppPackageId;
            _x.customDialerAppProtocol = customDialerAppProtocol;
            _x.customSettings = customSettings;
            _x.customSettingsNextLink = customSettingsNextLink;
            _x.deployedAppCount = deployedAppCount;
            _x.deviceLockRequired = deviceLockRequired;
            _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
            _x.encryptAppData = encryptAppData;
            _x.exemptedAppPackages = exemptedAppPackages;
            _x.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            _x.exemptedAppProtocols = exemptedAppProtocols;
            _x.exemptedAppProtocolsNextLink = exemptedAppProtocolsNextLink;
            _x.faceIdBlocked = faceIdBlocked;
            _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
            _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
            _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
            _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            _x.minimumWipePatchVersion = minimumWipePatchVersion;
            _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
            _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
            _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
            _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
            _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
            _x.apps = apps;
            _x.deploymentSummary = deploymentSummary;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work. (Android only)”</i>
     * 
     * @return property allowedAndroidDeviceManufacturers
     */
    @Property(name="allowedAndroidDeviceManufacturers")
    @JsonIgnore
    public Optional<String> getAllowedAndroidDeviceManufacturers() {
        return Optional.ofNullable(allowedAndroidDeviceManufacturers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedAndroidDeviceManufacturers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work. (Android only)”</i>
     * 
     * @param allowedAndroidDeviceManufacturers
     *            new value of {@code allowedAndroidDeviceManufacturers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAndroidDeviceManufacturers} field changed
     */
    public DefaultManagedAppProtection withAllowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        return _x;
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work. (
     * Android Only)”</i>
     * 
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels() {
        return new CollectionPage<String>(contextPath, String.class, this.allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedAndroidDeviceModels} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“List of device models allowed, as a string, for the managed app to work. (
     * Android Only)”</i>
     * 
     * @param allowedAndroidDeviceModels
     *            new value of {@code allowedAndroidDeviceModels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAndroidDeviceModels} field changed
     */
    public DefaultManagedAppProtection withAllowedAndroidDeviceModels(List<String> allowedAndroidDeviceModels) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedAndroidDeviceModels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
        return _x;
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work. (
     * Android Only)”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
     * app to work. (iOS Only)”</i>
     * 
     * @return property allowedIosDeviceModels
     */
    @Property(name="allowedIosDeviceModels")
    @JsonIgnore
    public Optional<String> getAllowedIosDeviceModels() {
        return Optional.ofNullable(allowedIosDeviceModels);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedIosDeviceModels} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Semicolon seperated list of device models allowed, as a string, for the managed
     * app to work. (iOS Only)”</i>
     * 
     * @param allowedIosDeviceModels
     *            new value of {@code allowedIosDeviceModels} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedIosDeviceModels} field changed
     */
    public DefaultManagedAppProtection withAllowedIosDeviceModels(String allowedIosDeviceModels) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedIosDeviceModels");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.allowedIosDeviceModels = allowedIosDeviceModels;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed. (Android only)”</i>
     * 
     * @return property appActionIfAndroidDeviceManufacturerNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceManufacturerNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceManufacturerNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceManufacturerNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceManufacturerNotAllowed} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed. (Android only)”</i>
     * 
     * @param appActionIfAndroidDeviceManufacturerNotAllowed
     *            new value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceManufacturerNotAllowed} field changed
     */
    public DefaultManagedAppProtection withAppActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed. (Android Only)”</i>
     * 
     * @return property appActionIfAndroidDeviceModelNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceModelNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceModelNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceModelNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceModelNotAllowed} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed. (Android Only)”</i>
     * 
     * @param appActionIfAndroidDeviceModelNotAllowed
     *            new value of {@code appActionIfAndroidDeviceModelNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceModelNotAllowed} field changed
     */
    public DefaultManagedAppProtection withAppActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirement fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetAppsVerificationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetAppsVerificationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetAppsVerificationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetAppsVerificationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetAppsVerificationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirement fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetAppsVerificationFailed
     *            new value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field changed
     */
    public DefaultManagedAppProtection withAppActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirement fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetDeviceAttestationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetDeviceAttestationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetDeviceAttestationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetDeviceAttestationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirement fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
     *            new value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed
     */
    public DefaultManagedAppProtection withAppActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
     * is required on device but is not set. (android only)”</i>
     * 
     * @return property appActionIfDeviceLockNotSet
     */
    @Property(name="appActionIfDeviceLockNotSet")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfDeviceLockNotSet() {
        return Optional.ofNullable(appActionIfDeviceLockNotSet);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfDeviceLockNotSet} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn, block or wipe, if the screen lock
     * is required on device but is not set. (android only)”</i>
     * 
     * @param appActionIfDeviceLockNotSet
     *            new value of {@code appActionIfDeviceLockNotSet} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfDeviceLockNotSet} field changed
     */
    public DefaultManagedAppProtection withAppActionIfDeviceLockNotSet(ManagedAppRemediationAction appActionIfDeviceLockNotSet) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfDeviceLockNotSet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed. (iOS Only)”</i>
     * 
     * @return property appActionIfIosDeviceModelNotAllowed
     */
    @Property(name="appActionIfIosDeviceModelNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfIosDeviceModelNotAllowed() {
        return Optional.ofNullable(appActionIfIosDeviceModelNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfIosDeviceModelNotAllowed} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed. (iOS Only)”</i>
     * 
     * @param appActionIfIosDeviceModelNotAllowed
     *            new value of {@code appActionIfIosDeviceModelNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfIosDeviceModelNotAllowed} field changed
     */
    public DefaultManagedAppProtection withAppActionIfIosDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfIosDeviceModelNotAllowed) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfIosDeviceModelNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
        return _x;
    }

    /**
     * <i>“Type of encryption which should be used for data in a managed app. (iOS Only)”</i>
     * 
     * @return property appDataEncryptionType
     */
    @Property(name="appDataEncryptionType")
    @JsonIgnore
    public Optional<ManagedAppDataEncryptionType> getAppDataEncryptionType() {
        return Optional.ofNullable(appDataEncryptionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appDataEncryptionType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of encryption which should be used for data in a managed app. (iOS Only)”</i>
     * 
     * @param appDataEncryptionType
     *            new value of {@code appDataEncryptionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appDataEncryptionType} field changed
     */
    public DefaultManagedAppProtection withAppDataEncryptionType(ManagedAppDataEncryptionType appDataEncryptionType) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appDataEncryptionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.appDataEncryptionType = appDataEncryptionType;
        return _x;
    }

    /**
     * <i>“Indicates whether use of the biometric authentication is allowed in place of a
     * pin if PinRequired is set to True. (Android Only)”</i>
     * 
     * @return property biometricAuthenticationBlocked
     */
    @Property(name="biometricAuthenticationBlocked")
    @JsonIgnore
    public Optional<Boolean> getBiometricAuthenticationBlocked() {
        return Optional.ofNullable(biometricAuthenticationBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * biometricAuthenticationBlocked} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether use of the biometric authentication is allowed in place of a
     * pin if PinRequired is set to True. (Android Only)”</i>
     * 
     * @param biometricAuthenticationBlocked
     *            new value of {@code biometricAuthenticationBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code biometricAuthenticationBlocked} field changed
     */
    public DefaultManagedAppProtection withBiometricAuthenticationBlocked(Boolean biometricAuthenticationBlocked) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("biometricAuthenticationBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * app access will be blocked.”</i>
     * 
     * @return property blockAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="blockAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getBlockAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(blockAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * blockAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * app access will be blocked.”</i>
     * 
     * @param blockAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code blockAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code blockAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public DefaultManagedAppProtection withBlockAfterCompanyPortalUpdateDeferralInDays(Integer blockAfterCompanyPortalUpdateDeferralInDays) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("blockAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    /**
     * <i>“Whether the app should connect to the configured VPN on launch (Android only).”</i>
     * 
     * @return property connectToVpnOnLaunch
     */
    @Property(name="connectToVpnOnLaunch")
    @JsonIgnore
    public Optional<Boolean> getConnectToVpnOnLaunch() {
        return Optional.ofNullable(connectToVpnOnLaunch);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectToVpnOnLaunch} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether the app should connect to the configured VPN on launch (Android only).”</i>
     * 
     * @param connectToVpnOnLaunch
     *            new value of {@code connectToVpnOnLaunch} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectToVpnOnLaunch} field changed
     */
    public DefaultManagedAppProtection withConnectToVpnOnLaunch(Boolean connectToVpnOnLaunch) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("connectToVpnOnLaunch");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
        return _x;
    }

    /**
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. (
     * Android only)”</i>
     * 
     * @return property customBrowserDisplayName
     */
    @Property(name="customBrowserDisplayName")
    @JsonIgnore
    public Optional<String> getCustomBrowserDisplayName() {
        return Optional.ofNullable(customBrowserDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. (
     * Android only)”</i>
     * 
     * @param customBrowserDisplayName
     *            new value of {@code customBrowserDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserDisplayName} field changed
     */
    public DefaultManagedAppProtection withCustomBrowserDisplayName(String customBrowserDisplayName) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customBrowserDisplayName = customBrowserDisplayName;
        return _x;
    }

    /**
     * <i>“Unique identifier of a custom browser to open weblink on Android. (Android only)”</i>
     * 
     * @return property customBrowserPackageId
     */
    @Property(name="customBrowserPackageId")
    @JsonIgnore
    public Optional<String> getCustomBrowserPackageId() {
        return Optional.ofNullable(customBrowserPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Unique identifier of a custom browser to open weblink on Android. (Android only)”</i>
     * 
     * @param customBrowserPackageId
     *            new value of {@code customBrowserPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserPackageId} field changed
     */
    public DefaultManagedAppProtection withCustomBrowserPackageId(String customBrowserPackageId) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customBrowserPackageId = customBrowserPackageId;
        return _x;
    }

    /**
     * <i>“A custom browser protocol to open weblink on iOS. (iOS only)”</i>
     * 
     * @return property customBrowserProtocol
     */
    @Property(name="customBrowserProtocol")
    @JsonIgnore
    public Optional<String> getCustomBrowserProtocol() {
        return Optional.ofNullable(customBrowserProtocol);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserProtocol} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“A custom browser protocol to open weblink on iOS. (iOS only)”</i>
     * 
     * @param customBrowserProtocol
     *            new value of {@code customBrowserProtocol} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserProtocol} field changed
     */
    public DefaultManagedAppProtection withCustomBrowserProtocol(String customBrowserProtocol) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customBrowserProtocol = customBrowserProtocol;
        return _x;
    }

    /**
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppDisplayName
     */
    @Property(name="customDialerAppDisplayName")
    @JsonIgnore
    public Optional<String> getCustomDialerAppDisplayName() {
        return Optional.ofNullable(customDialerAppDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppDisplayName
     *            new value of {@code customDialerAppDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppDisplayName} field changed
     */
    public DefaultManagedAppProtection withCustomDialerAppDisplayName(String customDialerAppDisplayName) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        return _x;
    }

    /**
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppPackageId
     */
    @Property(name="customDialerAppPackageId")
    @JsonIgnore
    public Optional<String> getCustomDialerAppPackageId() {
        return Optional.ofNullable(customDialerAppPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppPackageId
     *            new value of {@code customDialerAppPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppPackageId} field changed
     */
    public DefaultManagedAppProtection withCustomDialerAppPackageId(String customDialerAppPackageId) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customDialerAppPackageId = customDialerAppPackageId;
        return _x;
    }

    /**
     * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
     * example, skype:.”</i>
     * 
     * @return property customDialerAppProtocol
     */
    @Property(name="customDialerAppProtocol")
    @JsonIgnore
    public Optional<String> getCustomDialerAppProtocol() {
        return Optional.ofNullable(customDialerAppProtocol);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppProtocol} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Protocol of a custom dialer app to click-to-open a phone number on iOS, for
     * example, skype:.”</i>
     * 
     * @param customDialerAppProtocol
     *            new value of {@code customDialerAppProtocol} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppProtocol} field changed
     */
    public DefaultManagedAppProtection withCustomDialerAppProtocol(String customDialerAppProtocol) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppProtocol");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customDialerAppProtocol = customDialerAppProtocol;
        return _x;
    }

    /**
     * <i>“A set of string key and string value pairs to be sent to the affected users,
     * unalterned by this service”</i>
     * 
     * @return property customSettings
     */
    @Property(name="customSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomSettings() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.customSettings, Optional.ofNullable(customSettingsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customSettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A set of string key and string value pairs to be sent to the affected users,
     * unalterned by this service”</i>
     * 
     * @param customSettings
     *            new value of {@code customSettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customSettings} field changed
     */
    public DefaultManagedAppProtection withCustomSettings(List<KeyValuePair> customSettings) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.customSettings = customSettings;
        return _x;
    }

    /**
     * <i>“A set of string key and string value pairs to be sent to the affected users,
     * unalterned by this service”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property customSettings
     */
    @Property(name="customSettings")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomSettings(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.customSettings, Optional.ofNullable(customSettingsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @return property deployedAppCount
     */
    @Property(name="deployedAppCount")
    @JsonIgnore
    public Optional<Integer> getDeployedAppCount() {
        return Optional.ofNullable(deployedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @param deployedAppCount
     *            new value of {@code deployedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedAppCount} field changed
     */
    public DefaultManagedAppProtection withDeployedAppCount(Integer deployedAppCount) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deployedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.deployedAppCount = deployedAppCount;
        return _x;
    }

    /**
     * <i>“Defines if any kind of lock must be required on device. (android only)”</i>
     * 
     * @return property deviceLockRequired
     */
    @Property(name="deviceLockRequired")
    @JsonIgnore
    public Optional<Boolean> getDeviceLockRequired() {
        return Optional.ofNullable(deviceLockRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceLockRequired} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Defines if any kind of lock must be required on device. (android only)”</i>
     * 
     * @param deviceLockRequired
     *            new value of {@code deviceLockRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceLockRequired} field changed
     */
    public DefaultManagedAppProtection withDeviceLockRequired(Boolean deviceLockRequired) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deviceLockRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.deviceLockRequired = deviceLockRequired;
        return _x;
    }

    /**
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled. (Android only)”</i>
     * 
     * @return property disableAppEncryptionIfDeviceEncryptionIsEnabled
     */
    @Property(name="disableAppEncryptionIfDeviceEncryptionIsEnabled")
    @JsonIgnore
    public Optional<Boolean> getDisableAppEncryptionIfDeviceEncryptionIsEnabled() {
        return Optional.ofNullable(disableAppEncryptionIfDeviceEncryptionIsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled. (Android only)”</i>
     * 
     * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
     *            new value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed
     */
    public DefaultManagedAppProtection withDisableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        return _x;
    }

    /**
     * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
     * This setting is only allowed to be True when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps. (iOS Only)”</i>
     * 
     * @return property disableProtectionOfManagedOutboundOpenInData
     */
    @Property(name="disableProtectionOfManagedOutboundOpenInData")
    @JsonIgnore
    public Optional<Boolean> getDisableProtectionOfManagedOutboundOpenInData() {
        return Optional.ofNullable(disableProtectionOfManagedOutboundOpenInData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableProtectionOfManagedOutboundOpenInData} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Disable protection of data transferred to other apps through IOS OpenIn option.
     * This setting is only allowed to be True when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps. (iOS Only)”</i>
     * 
     * @param disableProtectionOfManagedOutboundOpenInData
     *            new value of {@code disableProtectionOfManagedOutboundOpenInData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableProtectionOfManagedOutboundOpenInData} field changed
     */
    public DefaultManagedAppProtection withDisableProtectionOfManagedOutboundOpenInData(Boolean disableProtectionOfManagedOutboundOpenInData) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("disableProtectionOfManagedOutboundOpenInData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
        return _x;
    }

    /**
     * <i>“Indicates whether managed-app data should be encrypted. (Android only)”</i>
     * 
     * @return property encryptAppData
     */
    @Property(name="encryptAppData")
    @JsonIgnore
    public Optional<Boolean> getEncryptAppData() {
        return Optional.ofNullable(encryptAppData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptAppData}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether managed-app data should be encrypted. (Android only)”</i>
     * 
     * @param encryptAppData
     *            new value of {@code encryptAppData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptAppData} field changed
     */
    public DefaultManagedAppProtection withEncryptAppData(Boolean encryptAppData) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("encryptAppData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.encryptAppData = encryptAppData;
        return _x;
    }

    /**
     * <i>“Android App packages in this list will be exempt from the policy and will be
     * able to receive data from managed apps. (Android only)”</i>
     * 
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exemptedAppPackages} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Android App packages in this list will be exempt from the policy and will be
     * able to receive data from managed apps. (Android only)”</i>
     * 
     * @param exemptedAppPackages
     *            new value of {@code exemptedAppPackages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exemptedAppPackages} field changed
     */
    public DefaultManagedAppProtection withExemptedAppPackages(List<KeyValuePair> exemptedAppPackages) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("exemptedAppPackages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.exemptedAppPackages = exemptedAppPackages;
        return _x;
    }

    /**
     * <i>“Android App packages in this list will be exempt from the policy and will be
     * able to receive data from managed apps. (Android only)”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
     * data from managed apps. (iOS Only)”</i>
     * 
     * @return property exemptedAppProtocols
     */
    @Property(name="exemptedAppProtocols")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppProtocols() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppProtocols, Optional.ofNullable(exemptedAppProtocolsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * exemptedAppProtocols} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
     * data from managed apps. (iOS Only)”</i>
     * 
     * @param exemptedAppProtocols
     *            new value of {@code exemptedAppProtocols} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exemptedAppProtocols} field changed
     */
    public DefaultManagedAppProtection withExemptedAppProtocols(List<KeyValuePair> exemptedAppProtocols) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("exemptedAppProtocols");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.exemptedAppProtocols = exemptedAppProtocols;
        return _x;
    }

    /**
     * <i>“iOS Apps in this list will be exempt from the policy and will be able to receive
     * data from managed apps. (iOS Only)”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property exemptedAppProtocols
     */
    @Property(name="exemptedAppProtocols")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppProtocols(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.exemptedAppProtocols, Optional.ofNullable(exemptedAppProtocolsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
     * is set to True. (iOS Only)”</i>
     * 
     * @return property faceIdBlocked
     */
    @Property(name="faceIdBlocked")
    @JsonIgnore
    public Optional<Boolean> getFaceIdBlocked() {
        return Optional.ofNullable(faceIdBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code faceIdBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether use of the FaceID is allowed in place of a pin if PinRequired
     * is set to True. (iOS Only)”</i>
     * 
     * @param faceIdBlocked
     *            new value of {@code faceIdBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code faceIdBlocked} field changed
     */
    public DefaultManagedAppProtection withFaceIdBlocked(Boolean faceIdBlocked) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("faceIdBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.faceIdBlocked = faceIdBlocked;
        return _x;
    }

    /**
     * <i>“Defines if open-in operation is supported from the managed app to the
     * filesharing locations selected. This setting only applies when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps and
     * DisableProtectionOfManagedOutboundOpenInData is set to False. (iOS Only)”</i>
     * 
     * @return property filterOpenInToOnlyManagedApps
     */
    @Property(name="filterOpenInToOnlyManagedApps")
    @JsonIgnore
    public Optional<Boolean> getFilterOpenInToOnlyManagedApps() {
        return Optional.ofNullable(filterOpenInToOnlyManagedApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * filterOpenInToOnlyManagedApps} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines if open-in operation is supported from the managed app to the
     * filesharing locations selected. This setting only applies when
     * AllowedOutboundDataTransferDestinations is set to ManagedApps and
     * DisableProtectionOfManagedOutboundOpenInData is set to False. (iOS Only)”</i>
     * 
     * @param filterOpenInToOnlyManagedApps
     *            new value of {@code filterOpenInToOnlyManagedApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filterOpenInToOnlyManagedApps} field changed
     */
    public DefaultManagedAppProtection withFilterOpenInToOnlyManagedApps(Boolean filterOpenInToOnlyManagedApps) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("filterOpenInToOnlyManagedApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @return property minimumRequiredCompanyPortalVersion
     */
    @Property(name="minimumRequiredCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredCompanyPortalVersion() {
        return Optional.ofNullable(minimumRequiredCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @param minimumRequiredCompanyPortalVersion
     *            new value of {@code minimumRequiredCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredCompanyPortalVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app. (Android only)”</i>
     * 
     * @return property minimumRequiredPatchVersion
     */
    @Property(name="minimumRequiredPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredPatchVersion() {
        return Optional.ofNullable(minimumRequiredPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app. (Android only)”</i>
     * 
     * @param minimumRequiredPatchVersion
     *            new value of {@code minimumRequiredPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredPatchVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        return _x;
    }

    /**
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data. (iOS Only)”</i>
     * 
     * @return property minimumRequiredSdkVersion
     */
    @Property(name="minimumRequiredSdkVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredSdkVersion() {
        return Optional.ofNullable(minimumRequiredSdkVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredSdkVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data. (iOS Only)”</i>
     * 
     * @param minimumRequiredSdkVersion
     *            new value of {@code minimumRequiredSdkVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredSdkVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumRequiredSdkVersion(String minimumRequiredSdkVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredSdkVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @return property minimumWarningCompanyPortalVersion
     */
    @Property(name="minimumWarningCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningCompanyPortalVersion() {
        return Optional.ofNullable(minimumWarningCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @param minimumWarningCompanyPortalVersion
     *            new value of {@code minimumWarningCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningCompanyPortalVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app. (Android only)”</i>
     * 
     * @return property minimumWarningPatchVersion
     */
    @Property(name="minimumWarningPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningPatchVersion() {
        return Optional.ofNullable(minimumWarningPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app. (Android only)”</i>
     * 
     * @param minimumWarningPatchVersion
     *            new value of {@code minimumWarningPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningPatchVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumWarningPatchVersion(String minimumWarningPatchVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @return property minimumWipeCompanyPortalVersion
     */
    @Property(name="minimumWipeCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipeCompanyPortalVersion() {
        return Optional.ofNullable(minimumWipeCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipeCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @param minimumWipeCompanyPortalVersion
     *            new value of {@code minimumWipeCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipeCompanyPortalVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data. (Android only)”</i>
     * 
     * @return property minimumWipePatchVersion
     */
    @Property(name="minimumWipePatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipePatchVersion() {
        return Optional.ofNullable(minimumWipePatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipePatchVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data. (Android only)”</i>
     * 
     * @param minimumWipePatchVersion
     *            new value of {@code minimumWipePatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipePatchVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumWipePatchVersion(String minimumWipePatchVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipePatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        return _x;
    }

    /**
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @return property minimumWipeSdkVersion
     */
    @Property(name="minimumWipeSdkVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipeSdkVersion() {
        return Optional.ofNullable(minimumWipeSdkVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipeSdkVersion} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Versions less than the specified version will block the managed app from
     * accessing company data.”</i>
     * 
     * @param minimumWipeSdkVersion
     *            new value of {@code minimumWipeSdkVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipeSdkVersion} field changed
     */
    public DefaultManagedAppProtection withMinimumWipeSdkVersion(String minimumWipeSdkVersion) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipeSdkVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
        return _x;
    }

    /**
     * <i>“Protect incoming data from unknown source. This setting is only allowed to be
     * True when AllowedInboundDataTransferSources is set to AllApps. (iOS Only)”</i>
     * 
     * @return property protectInboundDataFromUnknownSources
     */
    @Property(name="protectInboundDataFromUnknownSources")
    @JsonIgnore
    public Optional<Boolean> getProtectInboundDataFromUnknownSources() {
        return Optional.ofNullable(protectInboundDataFromUnknownSources);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * protectInboundDataFromUnknownSources} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Protect incoming data from unknown source. This setting is only allowed to be
     * True when AllowedInboundDataTransferSources is set to AllApps. (iOS Only)”</i>
     * 
     * @param protectInboundDataFromUnknownSources
     *            new value of {@code protectInboundDataFromUnknownSources} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code protectInboundDataFromUnknownSources} field changed
     */
    public DefaultManagedAppProtection withProtectInboundDataFromUnknownSources(Boolean protectInboundDataFromUnknownSources) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("protectInboundDataFromUnknownSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @return property requiredAndroidSafetyNetAppsVerificationType
     */
    @Property(name="requiredAndroidSafetyNetAppsVerificationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetAppsVerificationType> getRequiredAndroidSafetyNetAppsVerificationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetAppsVerificationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetAppsVerificationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @param requiredAndroidSafetyNetAppsVerificationType
     *            new value of {@code requiredAndroidSafetyNetAppsVerificationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetAppsVerificationType} field changed
     */
    public DefaultManagedAppProtection withRequiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @return property requiredAndroidSafetyNetDeviceAttestationType
     */
    @Property(name="requiredAndroidSafetyNetDeviceAttestationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetDeviceAttestationType> getRequiredAndroidSafetyNetDeviceAttestationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetDeviceAttestationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetDeviceAttestationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @param requiredAndroidSafetyNetDeviceAttestationType
     *            new value of {@code requiredAndroidSafetyNetDeviceAttestationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetDeviceAttestationType} field changed
     */
    public DefaultManagedAppProtection withRequiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
     * work. (Android Only)”</i>
     * 
     * @return property requiredAndroidSafetyNetEvaluationType
     */
    @Property(name="requiredAndroidSafetyNetEvaluationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetEvaluationType> getRequiredAndroidSafetyNetEvaluationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetEvaluationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetEvaluationType} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet evaluation type requirement for a managed app to
     * work. (Android Only)”</i>
     * 
     * @param requiredAndroidSafetyNetEvaluationType
     *            new value of {@code requiredAndroidSafetyNetEvaluationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetEvaluationType} field changed
     */
    public DefaultManagedAppProtection withRequiredAndroidSafetyNetEvaluationType(AndroidManagedAppSafetyNetEvaluationType requiredAndroidSafetyNetEvaluationType) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetEvaluationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
        return _x;
    }

    /**
     * <i>“Indicates whether screen capture is blocked. (Android only)”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether screen capture is blocked. (Android only)”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public DefaultManagedAppProtection withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Defines if third party keyboards are allowed while accessing a managed app. (iOS
     * Only)”</i>
     * 
     * @return property thirdPartyKeyboardsBlocked
     */
    @Property(name="thirdPartyKeyboardsBlocked")
    @JsonIgnore
    public Optional<Boolean> getThirdPartyKeyboardsBlocked() {
        return Optional.ofNullable(thirdPartyKeyboardsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * thirdPartyKeyboardsBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Defines if third party keyboards are allowed while accessing a managed app. (iOS
     * Only)”</i>
     * 
     * @param thirdPartyKeyboardsBlocked
     *            new value of {@code thirdPartyKeyboardsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code thirdPartyKeyboardsBlocked} field changed
     */
    public DefaultManagedAppProtection withThirdPartyKeyboardsBlocked(Boolean thirdPartyKeyboardsBlocked) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("thirdPartyKeyboardsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the user will receive the warning”</i>
     * 
     * @return property warnAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="warnAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getWarnAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(warnAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * warnAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the user will receive the warning”</i>
     * 
     * @param warnAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code warnAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code warnAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public DefaultManagedAppProtection withWarnAfterCompanyPortalUpdateDeferralInDays(Integer warnAfterCompanyPortalUpdateDeferralInDays) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("warnAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    /**
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @return property wipeAfterCompanyPortalUpdateDeferralInDays
     */
    @Property(name="wipeAfterCompanyPortalUpdateDeferralInDays")
    @JsonIgnore
    public Optional<Integer> getWipeAfterCompanyPortalUpdateDeferralInDays() {
        return Optional.ofNullable(wipeAfterCompanyPortalUpdateDeferralInDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wipeAfterCompanyPortalUpdateDeferralInDays} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Maximum number of days Company Portal update can be deferred on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @param wipeAfterCompanyPortalUpdateDeferralInDays
     *            new value of {@code wipeAfterCompanyPortalUpdateDeferralInDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wipeAfterCompanyPortalUpdateDeferralInDays} field changed
     */
    public DefaultManagedAppProtection withWipeAfterCompanyPortalUpdateDeferralInDays(Integer wipeAfterCompanyPortalUpdateDeferralInDays) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("wipeAfterCompanyPortalUpdateDeferralInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
        return _x;
    }

    public DefaultManagedAppProtection withUnmappedField(String name, Object value) {
        DefaultManagedAppProtection _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @return navigational property apps
     */
    @NavigationProperty(name="apps")
    @JsonIgnore
    public ManagedMobileAppCollectionRequest getApps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"), Optional.ofNullable(apps));
    }

    /**
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @return navigational property deploymentSummary
     */
    @NavigationProperty(name="deploymentSummary")
    @JsonIgnore
    public ManagedAppPolicyDeploymentSummaryRequest getDeploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"), Optional.ofNullable(deploymentSummary));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code apps} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @param apps
     *            new value of {@code apps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code apps} field changed
     */
    public DefaultManagedAppProtection withApps(List<ManagedMobileApp> apps) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("apps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.apps = apps;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deploymentSummary
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @param deploymentSummary
     *            new value of {@code deploymentSummary} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deploymentSummary} field changed
     */
    public DefaultManagedAppProtection withDeploymentSummary(ManagedAppPolicyDeploymentSummary deploymentSummary) {
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deploymentSummary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.defaultManagedAppProtection");
        _x.deploymentSummary = deploymentSummary;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DefaultManagedAppProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DefaultManagedAppProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DefaultManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DefaultManagedAppProtection _copy() {
        DefaultManagedAppProtection _x = new DefaultManagedAppProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
        _x.allowedDataStorageLocations = allowedDataStorageLocations;
        _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
        _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
        _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
        _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
        _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
        _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
        _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
        _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
        _x.contactSyncBlocked = contactSyncBlocked;
        _x.dataBackupBlocked = dataBackupBlocked;
        _x.deviceComplianceRequired = deviceComplianceRequired;
        _x.dialerRestrictionLevel = dialerRestrictionLevel;
        _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
        _x.fingerprintBlocked = fingerprintBlocked;
        _x.gracePeriodToBlockAppsDuringOffClockHours = gracePeriodToBlockAppsDuringOffClockHours;
        _x.managedBrowser = managedBrowser;
        _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
        _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
        _x.maximumPinRetries = maximumPinRetries;
        _x.maximumRequiredOsVersion = maximumRequiredOsVersion;
        _x.maximumWarningOsVersion = maximumWarningOsVersion;
        _x.maximumWipeOsVersion = maximumWipeOsVersion;
        _x.minimumPinLength = minimumPinLength;
        _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
        _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
        _x.minimumWarningAppVersion = minimumWarningAppVersion;
        _x.minimumWarningOsVersion = minimumWarningOsVersion;
        _x.minimumWipeAppVersion = minimumWipeAppVersion;
        _x.minimumWipeOsVersion = minimumWipeOsVersion;
        _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
        _x.notificationRestriction = notificationRestriction;
        _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
        _x.periodBeforePinReset = periodBeforePinReset;
        _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
        _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
        _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
        _x.pinCharacterSet = pinCharacterSet;
        _x.pinRequired = pinRequired;
        _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
        _x.previousPinBlockCount = previousPinBlockCount;
        _x.printBlocked = printBlocked;
        _x.saveAsBlocked = saveAsBlocked;
        _x.simplePinBlocked = simplePinBlocked;
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
        _x.allowedIosDeviceModels = allowedIosDeviceModels;
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        _x.appActionIfDeviceLockNotSet = appActionIfDeviceLockNotSet;
        _x.appActionIfIosDeviceModelNotAllowed = appActionIfIosDeviceModelNotAllowed;
        _x.appDataEncryptionType = appDataEncryptionType;
        _x.biometricAuthenticationBlocked = biometricAuthenticationBlocked;
        _x.blockAfterCompanyPortalUpdateDeferralInDays = blockAfterCompanyPortalUpdateDeferralInDays;
        _x.connectToVpnOnLaunch = connectToVpnOnLaunch;
        _x.customBrowserDisplayName = customBrowserDisplayName;
        _x.customBrowserPackageId = customBrowserPackageId;
        _x.customBrowserProtocol = customBrowserProtocol;
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        _x.customDialerAppPackageId = customDialerAppPackageId;
        _x.customDialerAppProtocol = customDialerAppProtocol;
        _x.customSettings = customSettings;
        _x.deployedAppCount = deployedAppCount;
        _x.deviceLockRequired = deviceLockRequired;
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        _x.disableProtectionOfManagedOutboundOpenInData = disableProtectionOfManagedOutboundOpenInData;
        _x.encryptAppData = encryptAppData;
        _x.exemptedAppPackages = exemptedAppPackages;
        _x.exemptedAppProtocols = exemptedAppProtocols;
        _x.faceIdBlocked = faceIdBlocked;
        _x.filterOpenInToOnlyManagedApps = filterOpenInToOnlyManagedApps;
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        _x.minimumRequiredSdkVersion = minimumRequiredSdkVersion;
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        _x.minimumWipeSdkVersion = minimumWipeSdkVersion;
        _x.protectInboundDataFromUnknownSources = protectInboundDataFromUnknownSources;
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        _x.requiredAndroidSafetyNetEvaluationType = requiredAndroidSafetyNetEvaluationType;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.thirdPartyKeyboardsBlocked = thirdPartyKeyboardsBlocked;
        _x.warnAfterCompanyPortalUpdateDeferralInDays = warnAfterCompanyPortalUpdateDeferralInDays;
        _x.wipeAfterCompanyPortalUpdateDeferralInDays = wipeAfterCompanyPortalUpdateDeferralInDays;
        _x.apps = apps;
        _x.deploymentSummary = deploymentSummary;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DefaultManagedAppProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("allowedDataIngestionLocations=");
        b.append(this.allowedDataIngestionLocations);
        b.append(", ");
        b.append("allowedDataStorageLocations=");
        b.append(this.allowedDataStorageLocations);
        b.append(", ");
        b.append("allowedInboundDataTransferSources=");
        b.append(this.allowedInboundDataTransferSources);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingExceptionLength=");
        b.append(this.allowedOutboundClipboardSharingExceptionLength);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingLevel=");
        b.append(this.allowedOutboundClipboardSharingLevel);
        b.append(", ");
        b.append("allowedOutboundDataTransferDestinations=");
        b.append(this.allowedOutboundDataTransferDestinations);
        b.append(", ");
        b.append("appActionIfDeviceComplianceRequired=");
        b.append(this.appActionIfDeviceComplianceRequired);
        b.append(", ");
        b.append("appActionIfMaximumPinRetriesExceeded=");
        b.append(this.appActionIfMaximumPinRetriesExceeded);
        b.append(", ");
        b.append("appActionIfUnableToAuthenticateUser=");
        b.append(this.appActionIfUnableToAuthenticateUser);
        b.append(", ");
        b.append("blockDataIngestionIntoOrganizationDocuments=");
        b.append(this.blockDataIngestionIntoOrganizationDocuments);
        b.append(", ");
        b.append("contactSyncBlocked=");
        b.append(this.contactSyncBlocked);
        b.append(", ");
        b.append("dataBackupBlocked=");
        b.append(this.dataBackupBlocked);
        b.append(", ");
        b.append("deviceComplianceRequired=");
        b.append(this.deviceComplianceRequired);
        b.append(", ");
        b.append("dialerRestrictionLevel=");
        b.append(this.dialerRestrictionLevel);
        b.append(", ");
        b.append("disableAppPinIfDevicePinIsSet=");
        b.append(this.disableAppPinIfDevicePinIsSet);
        b.append(", ");
        b.append("fingerprintBlocked=");
        b.append(this.fingerprintBlocked);
        b.append(", ");
        b.append("gracePeriodToBlockAppsDuringOffClockHours=");
        b.append(this.gracePeriodToBlockAppsDuringOffClockHours);
        b.append(", ");
        b.append("managedBrowser=");
        b.append(this.managedBrowser);
        b.append(", ");
        b.append("managedBrowserToOpenLinksRequired=");
        b.append(this.managedBrowserToOpenLinksRequired);
        b.append(", ");
        b.append("maximumAllowedDeviceThreatLevel=");
        b.append(this.maximumAllowedDeviceThreatLevel);
        b.append(", ");
        b.append("maximumPinRetries=");
        b.append(this.maximumPinRetries);
        b.append(", ");
        b.append("maximumRequiredOsVersion=");
        b.append(this.maximumRequiredOsVersion);
        b.append(", ");
        b.append("maximumWarningOsVersion=");
        b.append(this.maximumWarningOsVersion);
        b.append(", ");
        b.append("maximumWipeOsVersion=");
        b.append(this.maximumWipeOsVersion);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("minimumRequiredAppVersion=");
        b.append(this.minimumRequiredAppVersion);
        b.append(", ");
        b.append("minimumRequiredOsVersion=");
        b.append(this.minimumRequiredOsVersion);
        b.append(", ");
        b.append("minimumWarningAppVersion=");
        b.append(this.minimumWarningAppVersion);
        b.append(", ");
        b.append("minimumWarningOsVersion=");
        b.append(this.minimumWarningOsVersion);
        b.append(", ");
        b.append("minimumWipeAppVersion=");
        b.append(this.minimumWipeAppVersion);
        b.append(", ");
        b.append("minimumWipeOsVersion=");
        b.append(this.minimumWipeOsVersion);
        b.append(", ");
        b.append("mobileThreatDefenseRemediationAction=");
        b.append(this.mobileThreatDefenseRemediationAction);
        b.append(", ");
        b.append("notificationRestriction=");
        b.append(this.notificationRestriction);
        b.append(", ");
        b.append("organizationalCredentialsRequired=");
        b.append(this.organizationalCredentialsRequired);
        b.append(", ");
        b.append("periodBeforePinReset=");
        b.append(this.periodBeforePinReset);
        b.append(", ");
        b.append("periodOfflineBeforeAccessCheck=");
        b.append(this.periodOfflineBeforeAccessCheck);
        b.append(", ");
        b.append("periodOfflineBeforeWipeIsEnforced=");
        b.append(this.periodOfflineBeforeWipeIsEnforced);
        b.append(", ");
        b.append("periodOnlineBeforeAccessCheck=");
        b.append(this.periodOnlineBeforeAccessCheck);
        b.append(", ");
        b.append("pinCharacterSet=");
        b.append(this.pinCharacterSet);
        b.append(", ");
        b.append("pinRequired=");
        b.append(this.pinRequired);
        b.append(", ");
        b.append("pinRequiredInsteadOfBiometricTimeout=");
        b.append(this.pinRequiredInsteadOfBiometricTimeout);
        b.append(", ");
        b.append("previousPinBlockCount=");
        b.append(this.previousPinBlockCount);
        b.append(", ");
        b.append("printBlocked=");
        b.append(this.printBlocked);
        b.append(", ");
        b.append("saveAsBlocked=");
        b.append(this.saveAsBlocked);
        b.append(", ");
        b.append("simplePinBlocked=");
        b.append(this.simplePinBlocked);
        b.append(", ");
        b.append("allowedAndroidDeviceManufacturers=");
        b.append(this.allowedAndroidDeviceManufacturers);
        b.append(", ");
        b.append("allowedAndroidDeviceModels=");
        b.append(this.allowedAndroidDeviceModels);
        b.append(", ");
        b.append("allowedIosDeviceModels=");
        b.append(this.allowedIosDeviceModels);
        b.append(", ");
        b.append("appActionIfAndroidDeviceManufacturerNotAllowed=");
        b.append(this.appActionIfAndroidDeviceManufacturerNotAllowed);
        b.append(", ");
        b.append("appActionIfAndroidDeviceModelNotAllowed=");
        b.append(this.appActionIfAndroidDeviceModelNotAllowed);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetAppsVerificationFailed=");
        b.append(this.appActionIfAndroidSafetyNetAppsVerificationFailed);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetDeviceAttestationFailed=");
        b.append(this.appActionIfAndroidSafetyNetDeviceAttestationFailed);
        b.append(", ");
        b.append("appActionIfDeviceLockNotSet=");
        b.append(this.appActionIfDeviceLockNotSet);
        b.append(", ");
        b.append("appActionIfIosDeviceModelNotAllowed=");
        b.append(this.appActionIfIosDeviceModelNotAllowed);
        b.append(", ");
        b.append("appDataEncryptionType=");
        b.append(this.appDataEncryptionType);
        b.append(", ");
        b.append("biometricAuthenticationBlocked=");
        b.append(this.biometricAuthenticationBlocked);
        b.append(", ");
        b.append("blockAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.blockAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("connectToVpnOnLaunch=");
        b.append(this.connectToVpnOnLaunch);
        b.append(", ");
        b.append("customBrowserDisplayName=");
        b.append(this.customBrowserDisplayName);
        b.append(", ");
        b.append("customBrowserPackageId=");
        b.append(this.customBrowserPackageId);
        b.append(", ");
        b.append("customBrowserProtocol=");
        b.append(this.customBrowserProtocol);
        b.append(", ");
        b.append("customDialerAppDisplayName=");
        b.append(this.customDialerAppDisplayName);
        b.append(", ");
        b.append("customDialerAppPackageId=");
        b.append(this.customDialerAppPackageId);
        b.append(", ");
        b.append("customDialerAppProtocol=");
        b.append(this.customDialerAppProtocol);
        b.append(", ");
        b.append("customSettings=");
        b.append(this.customSettings);
        b.append(", ");
        b.append("deployedAppCount=");
        b.append(this.deployedAppCount);
        b.append(", ");
        b.append("deviceLockRequired=");
        b.append(this.deviceLockRequired);
        b.append(", ");
        b.append("disableAppEncryptionIfDeviceEncryptionIsEnabled=");
        b.append(this.disableAppEncryptionIfDeviceEncryptionIsEnabled);
        b.append(", ");
        b.append("disableProtectionOfManagedOutboundOpenInData=");
        b.append(this.disableProtectionOfManagedOutboundOpenInData);
        b.append(", ");
        b.append("encryptAppData=");
        b.append(this.encryptAppData);
        b.append(", ");
        b.append("exemptedAppPackages=");
        b.append(this.exemptedAppPackages);
        b.append(", ");
        b.append("exemptedAppProtocols=");
        b.append(this.exemptedAppProtocols);
        b.append(", ");
        b.append("faceIdBlocked=");
        b.append(this.faceIdBlocked);
        b.append(", ");
        b.append("filterOpenInToOnlyManagedApps=");
        b.append(this.filterOpenInToOnlyManagedApps);
        b.append(", ");
        b.append("minimumRequiredCompanyPortalVersion=");
        b.append(this.minimumRequiredCompanyPortalVersion);
        b.append(", ");
        b.append("minimumRequiredPatchVersion=");
        b.append(this.minimumRequiredPatchVersion);
        b.append(", ");
        b.append("minimumRequiredSdkVersion=");
        b.append(this.minimumRequiredSdkVersion);
        b.append(", ");
        b.append("minimumWarningCompanyPortalVersion=");
        b.append(this.minimumWarningCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWarningPatchVersion=");
        b.append(this.minimumWarningPatchVersion);
        b.append(", ");
        b.append("minimumWipeCompanyPortalVersion=");
        b.append(this.minimumWipeCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWipePatchVersion=");
        b.append(this.minimumWipePatchVersion);
        b.append(", ");
        b.append("minimumWipeSdkVersion=");
        b.append(this.minimumWipeSdkVersion);
        b.append(", ");
        b.append("protectInboundDataFromUnknownSources=");
        b.append(this.protectInboundDataFromUnknownSources);
        b.append(", ");
        b.append("requiredAndroidSafetyNetAppsVerificationType=");
        b.append(this.requiredAndroidSafetyNetAppsVerificationType);
        b.append(", ");
        b.append("requiredAndroidSafetyNetDeviceAttestationType=");
        b.append(this.requiredAndroidSafetyNetDeviceAttestationType);
        b.append(", ");
        b.append("requiredAndroidSafetyNetEvaluationType=");
        b.append(this.requiredAndroidSafetyNetEvaluationType);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("thirdPartyKeyboardsBlocked=");
        b.append(this.thirdPartyKeyboardsBlocked);
        b.append(", ");
        b.append("warnAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.warnAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("wipeAfterCompanyPortalUpdateDeferralInDays=");
        b.append(this.wipeAfterCompanyPortalUpdateDeferralInDays);
        b.append(", ");
        b.append("apps=");
        b.append(this.apps);
        b.append(", ");
        b.append("deploymentSummary=");
        b.append(this.deploymentSummary);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
