package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DataPolicyOperationStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "completedDateTime", 
    "progress", 
    "status", 
    "storageLocation", 
    "submittedDateTime", 
    "userId"})
@JsonInclude(Include.NON_NULL)
public class DataPolicyOperation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.dataPolicyOperation";
    }

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    @JsonProperty("progress")
    protected Double progress;

    @JsonProperty("status")
    protected DataPolicyOperationStatus status;

    @JsonProperty("storageLocation")
    protected String storageLocation;

    @JsonProperty("submittedDateTime")
    protected OffsetDateTime submittedDateTime;

    @JsonProperty("userId")
    protected String userId;

    protected DataPolicyOperation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDataPolicyOperation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime completedDateTime;
        private Double progress;
        private DataPolicyOperationStatus status;
        private String storageLocation;
        private OffsetDateTime submittedDateTime;
        private String userId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public Builder progress(Double progress) {
            this.progress = progress;
            this.changedFields = changedFields.add("progress");
            return this;
        }

        public Builder status(DataPolicyOperationStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder storageLocation(String storageLocation) {
            this.storageLocation = storageLocation;
            this.changedFields = changedFields.add("storageLocation");
            return this;
        }

        public Builder submittedDateTime(OffsetDateTime submittedDateTime) {
            this.submittedDateTime = submittedDateTime;
            this.changedFields = changedFields.add("submittedDateTime");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public DataPolicyOperation build() {
            DataPolicyOperation _x = new DataPolicyOperation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.dataPolicyOperation";
            _x.id = id;
            _x.completedDateTime = completedDateTime;
            _x.progress = progress;
            _x.status = status;
            _x.storageLocation = storageLocation;
            _x.submittedDateTime = submittedDateTime;
            _x.userId = userId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    public DataPolicyOperation withCompletedDateTime(OffsetDateTime completedDateTime) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Property(name="progress")
    @JsonIgnore
    public Optional<Double> getProgress() {
        return Optional.ofNullable(progress);
    }

    public DataPolicyOperation withProgress(Double progress) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("progress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.progress = progress;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<DataPolicyOperationStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public DataPolicyOperation withStatus(DataPolicyOperationStatus status) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.status = status;
        return _x;
    }

    @Property(name="storageLocation")
    @JsonIgnore
    public Optional<String> getStorageLocation() {
        return Optional.ofNullable(storageLocation);
    }

    public DataPolicyOperation withStorageLocation(String storageLocation) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("storageLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.storageLocation = storageLocation;
        return _x;
    }

    @Property(name="submittedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSubmittedDateTime() {
        return Optional.ofNullable(submittedDateTime);
    }

    public DataPolicyOperation withSubmittedDateTime(OffsetDateTime submittedDateTime) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("submittedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.submittedDateTime = submittedDateTime;
        return _x;
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public DataPolicyOperation withUserId(String userId) {
        DataPolicyOperation _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.dataPolicyOperation");
        _x.userId = userId;
        return _x;
    }

    public DataPolicyOperation withUnmappedField(String name, Object value) {
        DataPolicyOperation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataPolicyOperation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        DataPolicyOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public DataPolicyOperation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        DataPolicyOperation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private DataPolicyOperation _copy() {
        DataPolicyOperation _x = new DataPolicyOperation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.completedDateTime = completedDateTime;
        _x.progress = progress;
        _x.status = status;
        _x.storageLocation = storageLocation;
        _x.submittedDateTime = submittedDateTime;
        _x.userId = userId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DataPolicyOperation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append(", ");
        b.append("progress=");
        b.append(this.progress);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("storageLocation=");
        b.append(this.storageLocation);
        b.append(", ");
        b.append("submittedDateTime=");
        b.append(this.submittedDateTime);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
