package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import odata.msgraph.client.beta.entity.request.CustomerRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "amount", 
    "appliesToInvoiceId", 
    "appliesToInvoiceNumber", 
    "comment", 
    "contactId", 
    "customerId", 
    "customerNumber", 
    "description", 
    "documentNumber", 
    "externalDocumentNumber", 
    "journalDisplayName", 
    "lastModifiedDateTime", 
    "lineNumber", 
    "postingDate", 
    "customer"})
@JsonInclude(Include.NON_NULL)
public class CustomerPayment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customerPayment";
    }

    @JsonProperty("amount")
    protected BigDecimal amount;

    @JsonProperty("appliesToInvoiceId")
    protected UUID appliesToInvoiceId;

    @JsonProperty("appliesToInvoiceNumber")
    protected String appliesToInvoiceNumber;

    @JsonProperty("comment")
    protected String comment;

    @JsonProperty("contactId")
    protected String contactId;

    @JsonProperty("customerId")
    protected UUID customerId;

    @JsonProperty("customerNumber")
    protected String customerNumber;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("documentNumber")
    protected String documentNumber;

    @JsonProperty("externalDocumentNumber")
    protected String externalDocumentNumber;

    @JsonProperty("journalDisplayName")
    protected String journalDisplayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lineNumber")
    protected Integer lineNumber;

    @JsonProperty("postingDate")
    protected LocalDate postingDate;

    @JsonProperty("customer")
    protected Customer customer;

    protected CustomerPayment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomerPayment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private BigDecimal amount;
        private UUID appliesToInvoiceId;
        private String appliesToInvoiceNumber;
        private String comment;
        private String contactId;
        private UUID customerId;
        private String customerNumber;
        private String description;
        private String documentNumber;
        private String externalDocumentNumber;
        private String journalDisplayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer lineNumber;
        private LocalDate postingDate;
        private Customer customer;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder amount(BigDecimal amount) {
            this.amount = amount;
            this.changedFields = changedFields.add("amount");
            return this;
        }

        public Builder appliesToInvoiceId(UUID appliesToInvoiceId) {
            this.appliesToInvoiceId = appliesToInvoiceId;
            this.changedFields = changedFields.add("appliesToInvoiceId");
            return this;
        }

        public Builder appliesToInvoiceNumber(String appliesToInvoiceNumber) {
            this.appliesToInvoiceNumber = appliesToInvoiceNumber;
            this.changedFields = changedFields.add("appliesToInvoiceNumber");
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            this.changedFields = changedFields.add("comment");
            return this;
        }

        public Builder contactId(String contactId) {
            this.contactId = contactId;
            this.changedFields = changedFields.add("contactId");
            return this;
        }

        public Builder customerId(UUID customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerNumber(String customerNumber) {
            this.customerNumber = customerNumber;
            this.changedFields = changedFields.add("customerNumber");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder documentNumber(String documentNumber) {
            this.documentNumber = documentNumber;
            this.changedFields = changedFields.add("documentNumber");
            return this;
        }

        public Builder externalDocumentNumber(String externalDocumentNumber) {
            this.externalDocumentNumber = externalDocumentNumber;
            this.changedFields = changedFields.add("externalDocumentNumber");
            return this;
        }

        public Builder journalDisplayName(String journalDisplayName) {
            this.journalDisplayName = journalDisplayName;
            this.changedFields = changedFields.add("journalDisplayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            this.changedFields = changedFields.add("lineNumber");
            return this;
        }

        public Builder postingDate(LocalDate postingDate) {
            this.postingDate = postingDate;
            this.changedFields = changedFields.add("postingDate");
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            this.changedFields = changedFields.add("customer");
            return this;
        }

        public CustomerPayment build() {
            CustomerPayment _x = new CustomerPayment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.customerPayment";
            _x.id = id;
            _x.amount = amount;
            _x.appliesToInvoiceId = appliesToInvoiceId;
            _x.appliesToInvoiceNumber = appliesToInvoiceNumber;
            _x.comment = comment;
            _x.contactId = contactId;
            _x.customerId = customerId;
            _x.customerNumber = customerNumber;
            _x.description = description;
            _x.documentNumber = documentNumber;
            _x.externalDocumentNumber = externalDocumentNumber;
            _x.journalDisplayName = journalDisplayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lineNumber = lineNumber;
            _x.postingDate = postingDate;
            _x.customer = customer;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="amount")
    @JsonIgnore
    public Optional<BigDecimal> getAmount() {
        return Optional.ofNullable(amount);
    }

    public CustomerPayment withAmount(BigDecimal amount) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("amount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.amount = amount;
        return _x;
    }

    @Property(name="appliesToInvoiceId")
    @JsonIgnore
    public Optional<UUID> getAppliesToInvoiceId() {
        return Optional.ofNullable(appliesToInvoiceId);
    }

    public CustomerPayment withAppliesToInvoiceId(UUID appliesToInvoiceId) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("appliesToInvoiceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.appliesToInvoiceId = appliesToInvoiceId;
        return _x;
    }

    @Property(name="appliesToInvoiceNumber")
    @JsonIgnore
    public Optional<String> getAppliesToInvoiceNumber() {
        return Optional.ofNullable(appliesToInvoiceNumber);
    }

    public CustomerPayment withAppliesToInvoiceNumber(String appliesToInvoiceNumber) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("appliesToInvoiceNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.appliesToInvoiceNumber = appliesToInvoiceNumber;
        return _x;
    }

    @Property(name="comment")
    @JsonIgnore
    public Optional<String> getComment() {
        return Optional.ofNullable(comment);
    }

    public CustomerPayment withComment(String comment) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("comment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.comment = comment;
        return _x;
    }

    @Property(name="contactId")
    @JsonIgnore
    public Optional<String> getContactId() {
        return Optional.ofNullable(contactId);
    }

    public CustomerPayment withContactId(String contactId) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("contactId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.contactId = contactId;
        return _x;
    }

    @Property(name="customerId")
    @JsonIgnore
    public Optional<UUID> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    public CustomerPayment withCustomerId(UUID customerId) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerNumber")
    @JsonIgnore
    public Optional<String> getCustomerNumber() {
        return Optional.ofNullable(customerNumber);
    }

    public CustomerPayment withCustomerNumber(String customerNumber) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("customerNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.customerNumber = customerNumber;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CustomerPayment withDescription(String description) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.description = description;
        return _x;
    }

    @Property(name="documentNumber")
    @JsonIgnore
    public Optional<String> getDocumentNumber() {
        return Optional.ofNullable(documentNumber);
    }

    public CustomerPayment withDocumentNumber(String documentNumber) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("documentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.documentNumber = documentNumber;
        return _x;
    }

    @Property(name="externalDocumentNumber")
    @JsonIgnore
    public Optional<String> getExternalDocumentNumber() {
        return Optional.ofNullable(externalDocumentNumber);
    }

    public CustomerPayment withExternalDocumentNumber(String externalDocumentNumber) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("externalDocumentNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.externalDocumentNumber = externalDocumentNumber;
        return _x;
    }

    @Property(name="journalDisplayName")
    @JsonIgnore
    public Optional<String> getJournalDisplayName() {
        return Optional.ofNullable(journalDisplayName);
    }

    public CustomerPayment withJournalDisplayName(String journalDisplayName) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("journalDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.journalDisplayName = journalDisplayName;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CustomerPayment withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lineNumber")
    @JsonIgnore
    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(lineNumber);
    }

    public CustomerPayment withLineNumber(Integer lineNumber) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("lineNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.lineNumber = lineNumber;
        return _x;
    }

    @Property(name="postingDate")
    @JsonIgnore
    public Optional<LocalDate> getPostingDate() {
        return Optional.ofNullable(postingDate);
    }

    public CustomerPayment withPostingDate(LocalDate postingDate) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("postingDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.postingDate = postingDate;
        return _x;
    }

    public CustomerPayment withUnmappedField(String name, Object value) {
        CustomerPayment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="customer")
    @JsonIgnore
    public CustomerRequest getCustomer() {
        return new CustomerRequest(contextPath.addSegment("customer"), Optional.ofNullable(customer));
    }

    public CustomerPayment withCustomer(Customer customer) {
        CustomerPayment _x = _copy();
        _x.changedFields = changedFields.add("customer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customerPayment");
        _x.customer = customer;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomerPayment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CustomerPayment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomerPayment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CustomerPayment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CustomerPayment _copy() {
        CustomerPayment _x = new CustomerPayment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.amount = amount;
        _x.appliesToInvoiceId = appliesToInvoiceId;
        _x.appliesToInvoiceNumber = appliesToInvoiceNumber;
        _x.comment = comment;
        _x.contactId = contactId;
        _x.customerId = customerId;
        _x.customerNumber = customerNumber;
        _x.description = description;
        _x.documentNumber = documentNumber;
        _x.externalDocumentNumber = externalDocumentNumber;
        _x.journalDisplayName = journalDisplayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lineNumber = lineNumber;
        _x.postingDate = postingDate;
        _x.customer = customer;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomerPayment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("amount=");
        b.append(this.amount);
        b.append(", ");
        b.append("appliesToInvoiceId=");
        b.append(this.appliesToInvoiceId);
        b.append(", ");
        b.append("appliesToInvoiceNumber=");
        b.append(this.appliesToInvoiceNumber);
        b.append(", ");
        b.append("comment=");
        b.append(this.comment);
        b.append(", ");
        b.append("contactId=");
        b.append(this.contactId);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerNumber=");
        b.append(this.customerNumber);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("documentNumber=");
        b.append(this.documentNumber);
        b.append(", ");
        b.append("externalDocumentNumber=");
        b.append(this.externalDocumentNumber);
        b.append(", ");
        b.append("journalDisplayName=");
        b.append(this.journalDisplayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lineNumber=");
        b.append(this.lineNumber);
        b.append(", ");
        b.append("postingDate=");
        b.append(this.postingDate);
        b.append(", ");
        b.append("customer=");
        b.append(this.customer);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
