package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AllowedValueCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "attributeSet", 
    "description", 
    "isCollection", 
    "isSearchable", 
    "name", 
    "status", 
    "type", 
    "usePreDefinedValuesOnly", 
    "allowedValues"})
@JsonInclude(Include.NON_NULL)
public class CustomSecurityAttributeDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.customSecurityAttributeDefinition";
    }

    @JsonProperty("attributeSet")
    protected String attributeSet;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isCollection")
    protected Boolean isCollection;

    @JsonProperty("isSearchable")
    protected Boolean isSearchable;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("usePreDefinedValuesOnly")
    protected Boolean usePreDefinedValuesOnly;

    @JsonProperty("allowedValues")
    protected List<AllowedValue> allowedValues;

    protected CustomSecurityAttributeDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCustomSecurityAttributeDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String attributeSet;
        private String description;
        private Boolean isCollection;
        private Boolean isSearchable;
        private String name;
        private String status;
        private String type;
        private Boolean usePreDefinedValuesOnly;
        private List<AllowedValue> allowedValues;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder attributeSet(String attributeSet) {
            this.attributeSet = attributeSet;
            this.changedFields = changedFields.add("attributeSet");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isCollection(Boolean isCollection) {
            this.isCollection = isCollection;
            this.changedFields = changedFields.add("isCollection");
            return this;
        }

        public Builder isSearchable(Boolean isSearchable) {
            this.isSearchable = isSearchable;
            this.changedFields = changedFields.add("isSearchable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder usePreDefinedValuesOnly(Boolean usePreDefinedValuesOnly) {
            this.usePreDefinedValuesOnly = usePreDefinedValuesOnly;
            this.changedFields = changedFields.add("usePreDefinedValuesOnly");
            return this;
        }

        public Builder allowedValues(List<AllowedValue> allowedValues) {
            this.allowedValues = allowedValues;
            this.changedFields = changedFields.add("allowedValues");
            return this;
        }

        public Builder allowedValues(AllowedValue... allowedValues) {
            return allowedValues(Arrays.asList(allowedValues));
        }

        public CustomSecurityAttributeDefinition build() {
            CustomSecurityAttributeDefinition _x = new CustomSecurityAttributeDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.customSecurityAttributeDefinition";
            _x.id = id;
            _x.attributeSet = attributeSet;
            _x.description = description;
            _x.isCollection = isCollection;
            _x.isSearchable = isSearchable;
            _x.name = name;
            _x.status = status;
            _x.type = type;
            _x.usePreDefinedValuesOnly = usePreDefinedValuesOnly;
            _x.allowedValues = allowedValues;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="attributeSet")
    @JsonIgnore
    public Optional<String> getAttributeSet() {
        return Optional.ofNullable(attributeSet);
    }

    public CustomSecurityAttributeDefinition withAttributeSet(String attributeSet) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("attributeSet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.attributeSet = attributeSet;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public CustomSecurityAttributeDefinition withDescription(String description) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.description = description;
        return _x;
    }

    @Property(name="isCollection")
    @JsonIgnore
    public Optional<Boolean> getIsCollection() {
        return Optional.ofNullable(isCollection);
    }

    public CustomSecurityAttributeDefinition withIsCollection(Boolean isCollection) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("isCollection");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.isCollection = isCollection;
        return _x;
    }

    @Property(name="isSearchable")
    @JsonIgnore
    public Optional<Boolean> getIsSearchable() {
        return Optional.ofNullable(isSearchable);
    }

    public CustomSecurityAttributeDefinition withIsSearchable(Boolean isSearchable) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("isSearchable");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.isSearchable = isSearchable;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public CustomSecurityAttributeDefinition withName(String name) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.name = name;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public CustomSecurityAttributeDefinition withStatus(String status) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.status = status;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public CustomSecurityAttributeDefinition withType(String type) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.type = type;
        return _x;
    }

    @Property(name="usePreDefinedValuesOnly")
    @JsonIgnore
    public Optional<Boolean> getUsePreDefinedValuesOnly() {
        return Optional.ofNullable(usePreDefinedValuesOnly);
    }

    public CustomSecurityAttributeDefinition withUsePreDefinedValuesOnly(Boolean usePreDefinedValuesOnly) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("usePreDefinedValuesOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.usePreDefinedValuesOnly = usePreDefinedValuesOnly;
        return _x;
    }

    public CustomSecurityAttributeDefinition withUnmappedField(String name, Object value) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="allowedValues")
    @JsonIgnore
    public AllowedValueCollectionRequest getAllowedValues() {
        return new AllowedValueCollectionRequest(
                        contextPath.addSegment("allowedValues"), Optional.ofNullable(allowedValues));
    }

    public CustomSecurityAttributeDefinition withAllowedValues(List<AllowedValue> allowedValues) {
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = changedFields.add("allowedValues");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.customSecurityAttributeDefinition");
        _x.allowedValues = allowedValues;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomSecurityAttributeDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CustomSecurityAttributeDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CustomSecurityAttributeDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CustomSecurityAttributeDefinition _copy() {
        CustomSecurityAttributeDefinition _x = new CustomSecurityAttributeDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.attributeSet = attributeSet;
        _x.description = description;
        _x.isCollection = isCollection;
        _x.isSearchable = isSearchable;
        _x.name = name;
        _x.status = status;
        _x.type = type;
        _x.usePreDefinedValuesOnly = usePreDefinedValuesOnly;
        _x.allowedValues = allowedValues;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CustomSecurityAttributeDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("attributeSet=");
        b.append(this.attributeSet);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isCollection=");
        b.append(this.isCollection);
        b.append(", ");
        b.append("isSearchable=");
        b.append(this.isSearchable);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("usePreDefinedValuesOnly=");
        b.append(this.usePreDefinedValuesOnly);
        b.append(", ");
        b.append("allowedValues=");
        b.append(this.allowedValues);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
