package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CrossTenantAccessPolicyB2BSetting;
import odata.msgraph.client.beta.complex.CrossTenantAccessPolicyInboundTrust;

@JsonPropertyOrder({
    "@odata.type", 
    "isServiceProvider", 
    "tenantId"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyConfigurationPartner extends CrossTenantAccessPolicyConfigurationBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyConfigurationPartner";
    }

    @JsonProperty("isServiceProvider")
    protected Boolean isServiceProvider;

    @JsonProperty("tenantId")
    protected String tenantId;

    protected CrossTenantAccessPolicyConfigurationPartner() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCrossTenantAccessPolicyConfigurationPartner() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private CrossTenantAccessPolicyB2BSetting b2bCollaborationInbound;
        private CrossTenantAccessPolicyB2BSetting b2bCollaborationOutbound;
        private CrossTenantAccessPolicyB2BSetting b2bDirectConnectInbound;
        private CrossTenantAccessPolicyB2BSetting b2bDirectConnectOutbound;
        private CrossTenantAccessPolicyInboundTrust inboundTrust;
        private Boolean isServiceProvider;
        private String tenantId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder b2bCollaborationInbound(CrossTenantAccessPolicyB2BSetting b2bCollaborationInbound) {
            this.b2bCollaborationInbound = b2bCollaborationInbound;
            this.changedFields = changedFields.add("b2bCollaborationInbound");
            return this;
        }

        public Builder b2bCollaborationOutbound(CrossTenantAccessPolicyB2BSetting b2bCollaborationOutbound) {
            this.b2bCollaborationOutbound = b2bCollaborationOutbound;
            this.changedFields = changedFields.add("b2bCollaborationOutbound");
            return this;
        }

        public Builder b2bDirectConnectInbound(CrossTenantAccessPolicyB2BSetting b2bDirectConnectInbound) {
            this.b2bDirectConnectInbound = b2bDirectConnectInbound;
            this.changedFields = changedFields.add("b2bDirectConnectInbound");
            return this;
        }

        public Builder b2bDirectConnectOutbound(CrossTenantAccessPolicyB2BSetting b2bDirectConnectOutbound) {
            this.b2bDirectConnectOutbound = b2bDirectConnectOutbound;
            this.changedFields = changedFields.add("b2bDirectConnectOutbound");
            return this;
        }

        public Builder inboundTrust(CrossTenantAccessPolicyInboundTrust inboundTrust) {
            this.inboundTrust = inboundTrust;
            this.changedFields = changedFields.add("inboundTrust");
            return this;
        }

        public Builder isServiceProvider(Boolean isServiceProvider) {
            this.isServiceProvider = isServiceProvider;
            this.changedFields = changedFields.add("isServiceProvider");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = changedFields.add("tenantId");
            return this;
        }

        public CrossTenantAccessPolicyConfigurationPartner build() {
            CrossTenantAccessPolicyConfigurationPartner _x = new CrossTenantAccessPolicyConfigurationPartner();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicyConfigurationPartner";
            _x.id = id;
            _x.b2bCollaborationInbound = b2bCollaborationInbound;
            _x.b2bCollaborationOutbound = b2bCollaborationOutbound;
            _x.b2bDirectConnectInbound = b2bDirectConnectInbound;
            _x.b2bDirectConnectOutbound = b2bDirectConnectOutbound;
            _x.inboundTrust = inboundTrust;
            _x.isServiceProvider = isServiceProvider;
            _x.tenantId = tenantId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="isServiceProvider")
    @JsonIgnore
    public Optional<Boolean> getIsServiceProvider() {
        return Optional.ofNullable(isServiceProvider);
    }

    public CrossTenantAccessPolicyConfigurationPartner withIsServiceProvider(Boolean isServiceProvider) {
        CrossTenantAccessPolicyConfigurationPartner _x = _copy();
        _x.changedFields = changedFields.add("isServiceProvider");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationPartner");
        _x.isServiceProvider = isServiceProvider;
        return _x;
    }

    @Property(name="tenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(tenantId);
    }

    public CrossTenantAccessPolicyConfigurationPartner withTenantId(String tenantId) {
        CrossTenantAccessPolicyConfigurationPartner _x = _copy();
        _x.changedFields = changedFields.add("tenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationPartner");
        _x.tenantId = tenantId;
        return _x;
    }

    public CrossTenantAccessPolicyConfigurationPartner withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyConfigurationPartner _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicyConfigurationPartner patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicyConfigurationPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicyConfigurationPartner put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicyConfigurationPartner _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CrossTenantAccessPolicyConfigurationPartner _copy() {
        CrossTenantAccessPolicyConfigurationPartner _x = new CrossTenantAccessPolicyConfigurationPartner();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.b2bCollaborationInbound = b2bCollaborationInbound;
        _x.b2bCollaborationOutbound = b2bCollaborationOutbound;
        _x.b2bDirectConnectInbound = b2bDirectConnectInbound;
        _x.b2bDirectConnectOutbound = b2bDirectConnectOutbound;
        _x.inboundTrust = inboundTrust;
        _x.isServiceProvider = isServiceProvider;
        _x.tenantId = tenantId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyConfigurationPartner[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("b2bCollaborationInbound=");
        b.append(this.b2bCollaborationInbound);
        b.append(", ");
        b.append("b2bCollaborationOutbound=");
        b.append(this.b2bCollaborationOutbound);
        b.append(", ");
        b.append("b2bDirectConnectInbound=");
        b.append(this.b2bDirectConnectInbound);
        b.append(", ");
        b.append("b2bDirectConnectOutbound=");
        b.append(this.b2bDirectConnectOutbound);
        b.append(", ");
        b.append("inboundTrust=");
        b.append(this.inboundTrust);
        b.append(", ");
        b.append("isServiceProvider=");
        b.append(this.isServiceProvider);
        b.append(", ");
        b.append("tenantId=");
        b.append(this.tenantId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
