package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CrossTenantAccessPolicyB2BSetting;
import odata.msgraph.client.beta.complex.CrossTenantAccessPolicyInboundTrust;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "b2bCollaborationInbound", 
    "b2bCollaborationOutbound", 
    "b2bDirectConnectInbound", 
    "b2bDirectConnectOutbound", 
    "inboundTrust"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicyConfigurationBase extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicyConfigurationBase";
    }

    @JsonProperty("b2bCollaborationInbound")
    protected CrossTenantAccessPolicyB2BSetting b2bCollaborationInbound;

    @JsonProperty("b2bCollaborationOutbound")
    protected CrossTenantAccessPolicyB2BSetting b2bCollaborationOutbound;

    @JsonProperty("b2bDirectConnectInbound")
    protected CrossTenantAccessPolicyB2BSetting b2bDirectConnectInbound;

    @JsonProperty("b2bDirectConnectOutbound")
    protected CrossTenantAccessPolicyB2BSetting b2bDirectConnectOutbound;

    @JsonProperty("inboundTrust")
    protected CrossTenantAccessPolicyInboundTrust inboundTrust;

    protected CrossTenantAccessPolicyConfigurationBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="b2bCollaborationInbound")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyB2BSetting> getB2bCollaborationInbound() {
        return Optional.ofNullable(b2bCollaborationInbound);
    }

    public CrossTenantAccessPolicyConfigurationBase withB2bCollaborationInbound(CrossTenantAccessPolicyB2BSetting b2bCollaborationInbound) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("b2bCollaborationInbound");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationBase");
        _x.b2bCollaborationInbound = b2bCollaborationInbound;
        return _x;
    }

    @Property(name="b2bCollaborationOutbound")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyB2BSetting> getB2bCollaborationOutbound() {
        return Optional.ofNullable(b2bCollaborationOutbound);
    }

    public CrossTenantAccessPolicyConfigurationBase withB2bCollaborationOutbound(CrossTenantAccessPolicyB2BSetting b2bCollaborationOutbound) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("b2bCollaborationOutbound");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationBase");
        _x.b2bCollaborationOutbound = b2bCollaborationOutbound;
        return _x;
    }

    @Property(name="b2bDirectConnectInbound")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyB2BSetting> getB2bDirectConnectInbound() {
        return Optional.ofNullable(b2bDirectConnectInbound);
    }

    public CrossTenantAccessPolicyConfigurationBase withB2bDirectConnectInbound(CrossTenantAccessPolicyB2BSetting b2bDirectConnectInbound) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("b2bDirectConnectInbound");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationBase");
        _x.b2bDirectConnectInbound = b2bDirectConnectInbound;
        return _x;
    }

    @Property(name="b2bDirectConnectOutbound")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyB2BSetting> getB2bDirectConnectOutbound() {
        return Optional.ofNullable(b2bDirectConnectOutbound);
    }

    public CrossTenantAccessPolicyConfigurationBase withB2bDirectConnectOutbound(CrossTenantAccessPolicyB2BSetting b2bDirectConnectOutbound) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("b2bDirectConnectOutbound");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationBase");
        _x.b2bDirectConnectOutbound = b2bDirectConnectOutbound;
        return _x;
    }

    @Property(name="inboundTrust")
    @JsonIgnore
    public Optional<CrossTenantAccessPolicyInboundTrust> getInboundTrust() {
        return Optional.ofNullable(inboundTrust);
    }

    public CrossTenantAccessPolicyConfigurationBase withInboundTrust(CrossTenantAccessPolicyInboundTrust inboundTrust) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("inboundTrust");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicyConfigurationBase");
        _x.inboundTrust = inboundTrust;
        return _x;
    }

    public CrossTenantAccessPolicyConfigurationBase withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicyConfigurationBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicyConfigurationBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicyConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CrossTenantAccessPolicyConfigurationBase _copy() {
        CrossTenantAccessPolicyConfigurationBase _x = new CrossTenantAccessPolicyConfigurationBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.b2bCollaborationInbound = b2bCollaborationInbound;
        _x.b2bCollaborationOutbound = b2bCollaborationOutbound;
        _x.b2bDirectConnectInbound = b2bDirectConnectInbound;
        _x.b2bDirectConnectOutbound = b2bDirectConnectOutbound;
        _x.inboundTrust = inboundTrust;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicyConfigurationBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("b2bCollaborationInbound=");
        b.append(this.b2bCollaborationInbound);
        b.append(", ");
        b.append("b2bCollaborationOutbound=");
        b.append(this.b2bCollaborationOutbound);
        b.append(", ");
        b.append("b2bDirectConnectInbound=");
        b.append(this.b2bDirectConnectInbound);
        b.append(", ");
        b.append("b2bDirectConnectOutbound=");
        b.append(this.b2bDirectConnectOutbound);
        b.append(", ");
        b.append("inboundTrust=");
        b.append(this.inboundTrust);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
