package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.CrossTenantAccessPolicyConfigurationPartnerCollectionRequest;
import odata.msgraph.client.beta.entity.request.CrossTenantAccessPolicyConfigurationDefaultRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "default", 
    "partners"})
@JsonInclude(Include.NON_NULL)
public class CrossTenantAccessPolicy extends TenantRelationshipAccessPolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.crossTenantAccessPolicy";
    }

    @JsonProperty("default")
    protected CrossTenantAccessPolicyConfigurationDefault default_;

    @JsonProperty("partners")
    protected List<CrossTenantAccessPolicyConfigurationPartner> partners;

    protected CrossTenantAccessPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCrossTenantAccessPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private List<String> definition;
        private String definitionNextLink;
        private CrossTenantAccessPolicyConfigurationDefault default_;
        private List<CrossTenantAccessPolicyConfigurationPartner> partners;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder definition(List<String> definition) {
            this.definition = definition;
            this.changedFields = changedFields.add("definition");
            return this;
        }

        public Builder definition(String... definition) {
            return definition(Arrays.asList(definition));
        }

        public Builder definitionNextLink(String definitionNextLink) {
            this.definitionNextLink = definitionNextLink;
            this.changedFields = changedFields.add("definition");
            return this;
        }

        public Builder default_(CrossTenantAccessPolicyConfigurationDefault default_) {
            this.default_ = default_;
            this.changedFields = changedFields.add("default");
            return this;
        }

        public Builder partners(List<CrossTenantAccessPolicyConfigurationPartner> partners) {
            this.partners = partners;
            this.changedFields = changedFields.add("partners");
            return this;
        }

        public Builder partners(CrossTenantAccessPolicyConfigurationPartner... partners) {
            return partners(Arrays.asList(partners));
        }

        public CrossTenantAccessPolicy build() {
            CrossTenantAccessPolicy _x = new CrossTenantAccessPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.crossTenantAccessPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.definition = definition;
            _x.definitionNextLink = definitionNextLink;
            _x.default_ = default_;
            _x.partners = partners;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public CrossTenantAccessPolicy withUnmappedField(String name, Object value) {
        CrossTenantAccessPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="default")
    @JsonIgnore
    public CrossTenantAccessPolicyConfigurationDefaultRequest getDefault() {
        return new CrossTenantAccessPolicyConfigurationDefaultRequest(contextPath.addSegment("default"), Optional.ofNullable(default_));
    }

    @NavigationProperty(name="partners")
    @JsonIgnore
    public CrossTenantAccessPolicyConfigurationPartnerCollectionRequest getPartners() {
        return new CrossTenantAccessPolicyConfigurationPartnerCollectionRequest(
                        contextPath.addSegment("partners"), Optional.ofNullable(partners));
    }

    public CrossTenantAccessPolicy withDefault(CrossTenantAccessPolicyConfigurationDefault default_) {
        CrossTenantAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("default");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicy");
        _x.default_ = default_;
        return _x;
    }

    public CrossTenantAccessPolicy withPartners(List<CrossTenantAccessPolicyConfigurationPartner> partners) {
        CrossTenantAccessPolicy _x = _copy();
        _x.changedFields = changedFields.add("partners");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.crossTenantAccessPolicy");
        _x.partners = partners;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CrossTenantAccessPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CrossTenantAccessPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CrossTenantAccessPolicy _copy() {
        CrossTenantAccessPolicy _x = new CrossTenantAccessPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.definition = definition;
        _x.default_ = default_;
        _x.partners = partners;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CrossTenantAccessPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("definition=");
        b.append(this.definition);
        b.append(", ");
        b.append("default=");
        b.append(this.default_);
        b.append(", ");
        b.append("partners=");
        b.append(this.partners);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
