package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "roles", 
    "visibleHistoryStartDateTime"})
@JsonInclude(Include.NON_NULL)
public class ConversationMember extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.conversationMember";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("roles")
    protected List<String> roles;

    @JsonProperty("roles@nextLink")
    protected String rolesNextLink;

    @JsonProperty("visibleHistoryStartDateTime")
    protected OffsetDateTime visibleHistoryStartDateTime;

    protected ConversationMember() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ConversationMember withDisplayName(String displayName) {
        ConversationMember _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversationMember");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="roles")
    @JsonIgnore
    public CollectionPage<String> getRoles() {
        return new CollectionPage<String>(contextPath, String.class, this.roles, Optional.ofNullable(rolesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ConversationMember withRoles(List<String> roles) {
        ConversationMember _x = _copy();
        _x.changedFields = changedFields.add("roles");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversationMember");
        _x.roles = roles;
        return _x;
    }

    @Property(name="roles")
    @JsonIgnore
    public CollectionPage<String> getRoles(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.roles, Optional.ofNullable(rolesNextLink), Collections.emptyList(), options);
    }

    @Property(name="visibleHistoryStartDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getVisibleHistoryStartDateTime() {
        return Optional.ofNullable(visibleHistoryStartDateTime);
    }

    public ConversationMember withVisibleHistoryStartDateTime(OffsetDateTime visibleHistoryStartDateTime) {
        ConversationMember _x = _copy();
        _x.changedFields = changedFields.add("visibleHistoryStartDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.conversationMember");
        _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
        return _x;
    }

    public ConversationMember withUnmappedField(String name, Object value) {
        ConversationMember _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConversationMember patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConversationMember put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConversationMember _copy() {
        ConversationMember _x = new ConversationMember();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.roles = roles;
        _x.visibleHistoryStartDateTime = visibleHistoryStartDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConversationMember[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("roles=");
        b.append(this.roles);
        b.append(", ");
        b.append("visibleHistoryStartDateTime=");
        b.append(this.visibleHistoryStartDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
