package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "description", 
    "displayName", 
    "groups", 
    "isEnabled", 
    "migrate", 
    "users"})
@JsonInclude(Include.NON_NULL)
public class ContinuousAccessEvaluationPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.continuousAccessEvaluationPolicy";
    }

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("groups")
    protected List<String> groups;

    @JsonProperty("groups@nextLink")
    protected String groupsNextLink;

    @JsonProperty("isEnabled")
    protected Boolean isEnabled;

    @JsonProperty("migrate")
    protected Boolean migrate;

    @JsonProperty("users")
    protected List<String> users;

    @JsonProperty("users@nextLink")
    protected String usersNextLink;

    protected ContinuousAccessEvaluationPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContinuousAccessEvaluationPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String description;
        private String displayName;
        private List<String> groups;
        private String groupsNextLink;
        private Boolean isEnabled;
        private Boolean migrate;
        private List<String> users;
        private String usersNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder groups(List<String> groups) {
            this.groups = groups;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder groups(String... groups) {
            return groups(Arrays.asList(groups));
        }

        public Builder groupsNextLink(String groupsNextLink) {
            this.groupsNextLink = groupsNextLink;
            this.changedFields = changedFields.add("groups");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.changedFields = changedFields.add("isEnabled");
            return this;
        }

        public Builder migrate(Boolean migrate) {
            this.migrate = migrate;
            this.changedFields = changedFields.add("migrate");
            return this;
        }

        public Builder users(List<String> users) {
            this.users = users;
            this.changedFields = changedFields.add("users");
            return this;
        }

        public Builder users(String... users) {
            return users(Arrays.asList(users));
        }

        public Builder usersNextLink(String usersNextLink) {
            this.usersNextLink = usersNextLink;
            this.changedFields = changedFields.add("users");
            return this;
        }

        public ContinuousAccessEvaluationPolicy build() {
            ContinuousAccessEvaluationPolicy _x = new ContinuousAccessEvaluationPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.continuousAccessEvaluationPolicy";
            _x.id = id;
            _x.description = description;
            _x.displayName = displayName;
            _x.groups = groups;
            _x.groupsNextLink = groupsNextLink;
            _x.isEnabled = isEnabled;
            _x.migrate = migrate;
            _x.users = users;
            _x.usersNextLink = usersNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ContinuousAccessEvaluationPolicy withDescription(String description) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ContinuousAccessEvaluationPolicy withDisplayName(String displayName) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="groups")
    @JsonIgnore
    public CollectionPage<String> getGroups() {
        return new CollectionPage<String>(contextPath, String.class, this.groups, Optional.ofNullable(groupsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ContinuousAccessEvaluationPolicy withGroups(List<String> groups) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("groups");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.groups = groups;
        return _x;
    }

    @Property(name="groups")
    @JsonIgnore
    public CollectionPage<String> getGroups(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.groups, Optional.ofNullable(groupsNextLink), Collections.emptyList(), options);
    }

    @Property(name="isEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsEnabled() {
        return Optional.ofNullable(isEnabled);
    }

    public ContinuousAccessEvaluationPolicy withIsEnabled(Boolean isEnabled) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("isEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.isEnabled = isEnabled;
        return _x;
    }

    @Property(name="migrate")
    @JsonIgnore
    public Optional<Boolean> getMigrate() {
        return Optional.ofNullable(migrate);
    }

    public ContinuousAccessEvaluationPolicy withMigrate(Boolean migrate) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("migrate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.migrate = migrate;
        return _x;
    }

    @Property(name="users")
    @JsonIgnore
    public CollectionPage<String> getUsers() {
        return new CollectionPage<String>(contextPath, String.class, this.users, Optional.ofNullable(usersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ContinuousAccessEvaluationPolicy withUsers(List<String> users) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = changedFields.add("users");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.continuousAccessEvaluationPolicy");
        _x.users = users;
        return _x;
    }

    @Property(name="users")
    @JsonIgnore
    public CollectionPage<String> getUsers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.users, Optional.ofNullable(usersNextLink), Collections.emptyList(), options);
    }

    public ContinuousAccessEvaluationPolicy withUnmappedField(String name, Object value) {
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContinuousAccessEvaluationPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContinuousAccessEvaluationPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContinuousAccessEvaluationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContinuousAccessEvaluationPolicy _copy() {
        ContinuousAccessEvaluationPolicy _x = new ContinuousAccessEvaluationPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.description = description;
        _x.displayName = displayName;
        _x.groups = groups;
        _x.isEnabled = isEnabled;
        _x.migrate = migrate;
        _x.users = users;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContinuousAccessEvaluationPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("groups=");
        b.append(this.groups);
        b.append(", ");
        b.append("isEnabled=");
        b.append(this.isEnabled);
        b.append(", ");
        b.append("migrate=");
        b.append(this.migrate);
        b.append(", ");
        b.append("users=");
        b.append(this.users);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
