package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ContentTypeOrder;
import odata.msgraph.client.beta.complex.DocumentSet;
import odata.msgraph.client.beta.complex.DocumentSetContent;
import odata.msgraph.client.beta.complex.ItemReference;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ColumnLinkCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "associatedHubsUrls", 
    "description", 
    "documentSet", 
    "documentTemplate", 
    "group", 
    "hidden", 
    "inheritedFrom", 
    "isBuiltIn", 
    "name", 
    "order", 
    "parentId", 
    "propagateChanges", 
    "readOnly", 
    "sealed", 
    "columnLinks", 
    "columns"})
@JsonInclude(Include.NON_NULL)
public class ContentType extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contentType";
    }

    @JsonProperty("associatedHubsUrls")
    protected List<String> associatedHubsUrls;

    @JsonProperty("associatedHubsUrls@nextLink")
    protected String associatedHubsUrlsNextLink;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("documentSet")
    protected DocumentSet documentSet;

    @JsonProperty("documentTemplate")
    protected DocumentSetContent documentTemplate;

    @JsonProperty("group")
    protected String group;

    @JsonProperty("hidden")
    protected Boolean hidden;

    @JsonProperty("inheritedFrom")
    protected ItemReference inheritedFrom;

    @JsonProperty("isBuiltIn")
    protected Boolean isBuiltIn;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("order")
    protected ContentTypeOrder order;

    @JsonProperty("parentId")
    protected String parentId;

    @JsonProperty("propagateChanges")
    protected Boolean propagateChanges;

    @JsonProperty("readOnly")
    protected Boolean readOnly;

    @JsonProperty("sealed")
    protected Boolean sealed;

    @JsonProperty("columnLinks")
    protected List<ColumnLink> columnLinks;

    @JsonProperty("columns")
    protected List<ColumnDefinition> columns;

    protected ContentType() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContentType() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> associatedHubsUrls;
        private String associatedHubsUrlsNextLink;
        private String description;
        private DocumentSet documentSet;
        private DocumentSetContent documentTemplate;
        private String group;
        private Boolean hidden;
        private ItemReference inheritedFrom;
        private Boolean isBuiltIn;
        private String name;
        private ContentTypeOrder order;
        private String parentId;
        private Boolean propagateChanges;
        private Boolean readOnly;
        private Boolean sealed;
        private List<ColumnLink> columnLinks;
        private List<ColumnDefinition> columns;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder associatedHubsUrls(List<String> associatedHubsUrls) {
            this.associatedHubsUrls = associatedHubsUrls;
            this.changedFields = changedFields.add("associatedHubsUrls");
            return this;
        }

        public Builder associatedHubsUrls(String... associatedHubsUrls) {
            return associatedHubsUrls(Arrays.asList(associatedHubsUrls));
        }

        public Builder associatedHubsUrlsNextLink(String associatedHubsUrlsNextLink) {
            this.associatedHubsUrlsNextLink = associatedHubsUrlsNextLink;
            this.changedFields = changedFields.add("associatedHubsUrls");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder documentSet(DocumentSet documentSet) {
            this.documentSet = documentSet;
            this.changedFields = changedFields.add("documentSet");
            return this;
        }

        public Builder documentTemplate(DocumentSetContent documentTemplate) {
            this.documentTemplate = documentTemplate;
            this.changedFields = changedFields.add("documentTemplate");
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            this.changedFields = changedFields.add("group");
            return this;
        }

        public Builder hidden(Boolean hidden) {
            this.hidden = hidden;
            this.changedFields = changedFields.add("hidden");
            return this;
        }

        public Builder inheritedFrom(ItemReference inheritedFrom) {
            this.inheritedFrom = inheritedFrom;
            this.changedFields = changedFields.add("inheritedFrom");
            return this;
        }

        public Builder isBuiltIn(Boolean isBuiltIn) {
            this.isBuiltIn = isBuiltIn;
            this.changedFields = changedFields.add("isBuiltIn");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder order(ContentTypeOrder order) {
            this.order = order;
            this.changedFields = changedFields.add("order");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.changedFields = changedFields.add("parentId");
            return this;
        }

        public Builder propagateChanges(Boolean propagateChanges) {
            this.propagateChanges = propagateChanges;
            this.changedFields = changedFields.add("propagateChanges");
            return this;
        }

        public Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            this.changedFields = changedFields.add("readOnly");
            return this;
        }

        public Builder sealed(Boolean sealed) {
            this.sealed = sealed;
            this.changedFields = changedFields.add("sealed");
            return this;
        }

        public Builder columnLinks(List<ColumnLink> columnLinks) {
            this.columnLinks = columnLinks;
            this.changedFields = changedFields.add("columnLinks");
            return this;
        }

        public Builder columnLinks(ColumnLink... columnLinks) {
            return columnLinks(Arrays.asList(columnLinks));
        }

        public Builder columns(List<ColumnDefinition> columns) {
            this.columns = columns;
            this.changedFields = changedFields.add("columns");
            return this;
        }

        public Builder columns(ColumnDefinition... columns) {
            return columns(Arrays.asList(columns));
        }

        public ContentType build() {
            ContentType _x = new ContentType();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contentType";
            _x.id = id;
            _x.associatedHubsUrls = associatedHubsUrls;
            _x.associatedHubsUrlsNextLink = associatedHubsUrlsNextLink;
            _x.description = description;
            _x.documentSet = documentSet;
            _x.documentTemplate = documentTemplate;
            _x.group = group;
            _x.hidden = hidden;
            _x.inheritedFrom = inheritedFrom;
            _x.isBuiltIn = isBuiltIn;
            _x.name = name;
            _x.order = order;
            _x.parentId = parentId;
            _x.propagateChanges = propagateChanges;
            _x.readOnly = readOnly;
            _x.sealed = sealed;
            _x.columnLinks = columnLinks;
            _x.columns = columns;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="associatedHubsUrls")
    @JsonIgnore
    public CollectionPage<String> getAssociatedHubsUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.associatedHubsUrls, Optional.ofNullable(associatedHubsUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ContentType withAssociatedHubsUrls(List<String> associatedHubsUrls) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("associatedHubsUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.associatedHubsUrls = associatedHubsUrls;
        return _x;
    }

    @Property(name="associatedHubsUrls")
    @JsonIgnore
    public CollectionPage<String> getAssociatedHubsUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.associatedHubsUrls, Optional.ofNullable(associatedHubsUrlsNextLink), Collections.emptyList(), options);
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ContentType withDescription(String description) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.description = description;
        return _x;
    }

    @Property(name="documentSet")
    @JsonIgnore
    public Optional<DocumentSet> getDocumentSet() {
        return Optional.ofNullable(documentSet);
    }

    public ContentType withDocumentSet(DocumentSet documentSet) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("documentSet");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.documentSet = documentSet;
        return _x;
    }

    @Property(name="documentTemplate")
    @JsonIgnore
    public Optional<DocumentSetContent> getDocumentTemplate() {
        return Optional.ofNullable(documentTemplate);
    }

    public ContentType withDocumentTemplate(DocumentSetContent documentTemplate) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("documentTemplate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.documentTemplate = documentTemplate;
        return _x;
    }

    @Property(name="group")
    @JsonIgnore
    public Optional<String> getGroup() {
        return Optional.ofNullable(group);
    }

    public ContentType withGroup(String group) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("group");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.group = group;
        return _x;
    }

    @Property(name="hidden")
    @JsonIgnore
    public Optional<Boolean> getHidden() {
        return Optional.ofNullable(hidden);
    }

    public ContentType withHidden(Boolean hidden) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("hidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.hidden = hidden;
        return _x;
    }

    @Property(name="inheritedFrom")
    @JsonIgnore
    public Optional<ItemReference> getInheritedFrom() {
        return Optional.ofNullable(inheritedFrom);
    }

    public ContentType withInheritedFrom(ItemReference inheritedFrom) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("inheritedFrom");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.inheritedFrom = inheritedFrom;
        return _x;
    }

    @Property(name="isBuiltIn")
    @JsonIgnore
    public Optional<Boolean> getIsBuiltIn() {
        return Optional.ofNullable(isBuiltIn);
    }

    public ContentType withIsBuiltIn(Boolean isBuiltIn) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("isBuiltIn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.isBuiltIn = isBuiltIn;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ContentType withName(String name) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.name = name;
        return _x;
    }

    @Property(name="order")
    @JsonIgnore
    public Optional<ContentTypeOrder> getOrder() {
        return Optional.ofNullable(order);
    }

    public ContentType withOrder(ContentTypeOrder order) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("order");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.order = order;
        return _x;
    }

    @Property(name="parentId")
    @JsonIgnore
    public Optional<String> getParentId() {
        return Optional.ofNullable(parentId);
    }

    public ContentType withParentId(String parentId) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("parentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.parentId = parentId;
        return _x;
    }

    @Property(name="propagateChanges")
    @JsonIgnore
    public Optional<Boolean> getPropagateChanges() {
        return Optional.ofNullable(propagateChanges);
    }

    public ContentType withPropagateChanges(Boolean propagateChanges) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("propagateChanges");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.propagateChanges = propagateChanges;
        return _x;
    }

    @Property(name="readOnly")
    @JsonIgnore
    public Optional<Boolean> getReadOnly() {
        return Optional.ofNullable(readOnly);
    }

    public ContentType withReadOnly(Boolean readOnly) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("readOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.readOnly = readOnly;
        return _x;
    }

    @Property(name="sealed")
    @JsonIgnore
    public Optional<Boolean> getSealed() {
        return Optional.ofNullable(sealed);
    }

    public ContentType withSealed(Boolean sealed) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("sealed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.sealed = sealed;
        return _x;
    }

    public ContentType withUnmappedField(String name, Object value) {
        ContentType _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="base")
    @JsonIgnore
    public ContentTypeRequest getBase() {
        return new ContentTypeRequest(contextPath.addSegment("base"), RequestHelper.getValue(unmappedFields, "base"));
    }

    @NavigationProperty(name="baseTypes")
    @JsonIgnore
    public ContentTypeCollectionRequest getBaseTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("baseTypes"), RequestHelper.getValue(unmappedFields, "baseTypes"));
    }

    @NavigationProperty(name="columnLinks")
    @JsonIgnore
    public ColumnLinkCollectionRequest getColumnLinks() {
        return new ColumnLinkCollectionRequest(
                        contextPath.addSegment("columnLinks"), Optional.ofNullable(columnLinks));
    }

    @NavigationProperty(name="columnPositions")
    @JsonIgnore
    public ColumnDefinitionCollectionRequest getColumnPositions() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columnPositions"), RequestHelper.getValue(unmappedFields, "columnPositions"));
    }

    @NavigationProperty(name="columns")
    @JsonIgnore
    public ColumnDefinitionCollectionRequest getColumns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"), Optional.ofNullable(columns));
    }

    public ContentType withColumnLinks(List<ColumnLink> columnLinks) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("columnLinks");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.columnLinks = columnLinks;
        return _x;
    }

    public ContentType withColumns(List<ColumnDefinition> columns) {
        ContentType _x = _copy();
        _x.changedFields = changedFields.add("columns");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contentType");
        _x.columns = columns;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentType patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContentType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContentType put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContentType _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContentType _copy() {
        ContentType _x = new ContentType();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.associatedHubsUrls = associatedHubsUrls;
        _x.description = description;
        _x.documentSet = documentSet;
        _x.documentTemplate = documentTemplate;
        _x.group = group;
        _x.hidden = hidden;
        _x.inheritedFrom = inheritedFrom;
        _x.isBuiltIn = isBuiltIn;
        _x.name = name;
        _x.order = order;
        _x.parentId = parentId;
        _x.propagateChanges = propagateChanges;
        _x.readOnly = readOnly;
        _x.sealed = sealed;
        _x.columnLinks = columnLinks;
        _x.columns = columns;
        return _x;
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

    @Action(name = "unpublish")
    @JsonIgnore
    public ActionRequestNoReturn unpublish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unpublish"), _parameters);
    }

    @Action(name = "associateWithHubSites")
    @JsonIgnore
    public ActionRequestNoReturn associateWithHubSites(List<String> hubSiteUrls, Boolean propagateToExistingLists) {
        Preconditions.checkNotNull(hubSiteUrls, "hubSiteUrls cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hubSiteUrls", "Collection(Edm.String)", Checks.checkIsAscii(hubSiteUrls))
            .put("propagateToExistingLists", "Edm.Boolean", propagateToExistingLists)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.associateWithHubSites"), _parameters);
    }

    @Action(name = "copyToDefaultContentLocation")
    @JsonIgnore
    public ActionRequestNoReturn copyToDefaultContentLocation(ItemReference sourceFile, String destinationFileName) {
        Preconditions.checkNotNull(sourceFile, "sourceFile cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("sourceFile", "microsoft.graph.itemReference", sourceFile)
            .put("destinationFileName", "Edm.String", Checks.checkIsAscii(destinationFileName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.copyToDefaultContentLocation"), _parameters);
    }

    @Function(name = "isPublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> isPublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.isPublished"), Boolean.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContentType[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("associatedHubsUrls=");
        b.append(this.associatedHubsUrls);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("documentSet=");
        b.append(this.documentSet);
        b.append(", ");
        b.append("documentTemplate=");
        b.append(this.documentTemplate);
        b.append(", ");
        b.append("group=");
        b.append(this.group);
        b.append(", ");
        b.append("hidden=");
        b.append(this.hidden);
        b.append(", ");
        b.append("inheritedFrom=");
        b.append(this.inheritedFrom);
        b.append(", ");
        b.append("isBuiltIn=");
        b.append(this.isBuiltIn);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("order=");
        b.append(this.order);
        b.append(", ");
        b.append("parentId=");
        b.append(this.parentId);
        b.append(", ");
        b.append("propagateChanges=");
        b.append(this.propagateChanges);
        b.append(", ");
        b.append("readOnly=");
        b.append(this.readOnly);
        b.append(", ");
        b.append("sealed=");
        b.append(this.sealed);
        b.append(", ");
        b.append("columnLinks=");
        b.append(this.columnLinks);
        b.append(", ");
        b.append("columns=");
        b.append(this.columns);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
