package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ContactCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContactFolderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "parentFolderId", 
    "wellKnownName", 
    "childFolders", 
    "contacts", 
    "multiValueExtendedProperties", 
    "singleValueExtendedProperties"})
@JsonInclude(Include.NON_NULL)
public class ContactFolder extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contactFolder";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("wellKnownName")
    protected String wellKnownName;

    @JsonProperty("childFolders")
    protected List<ContactFolder> childFolders;

    @JsonProperty("contacts")
    protected List<Contact> contacts;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    protected ContactFolder() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContactFolder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String parentFolderId;
        private String wellKnownName;
        private List<ContactFolder> childFolders;
        private List<Contact> contacts;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder wellKnownName(String wellKnownName) {
            this.wellKnownName = wellKnownName;
            this.changedFields = changedFields.add("wellKnownName");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param childFolders
         *            value of {@code childFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childFolders(List<ContactFolder> childFolders) {
            this.childFolders = childFolders;
            this.changedFields = changedFields.add("childFolders");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param childFolders
         *            value of {@code childFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder childFolders(ContactFolder... childFolders) {
            return childFolders(Arrays.asList(childFolders));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param contacts
         *            value of {@code contacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contacts(List<Contact> contacts) {
            this.contacts = contacts;
            this.changedFields = changedFields.add("contacts");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param contacts
         *            value of {@code contacts} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder contacts(Contact... contacts) {
            return contacts(Arrays.asList(contacts));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public ContactFolder build() {
            ContactFolder _x = new ContactFolder();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contactFolder";
            _x.id = id;
            _x.displayName = displayName;
            _x.parentFolderId = parentFolderId;
            _x.wellKnownName = wellKnownName;
            _x.childFolders = childFolders;
            _x.contacts = contacts;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ContactFolder withDisplayName(String displayName) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public ContactFolder withParentFolderId(String parentFolderId) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="wellKnownName")
    @JsonIgnore
    public Optional<String> getWellKnownName() {
        return Optional.ofNullable(wellKnownName);
    }

    public ContactFolder withWellKnownName(String wellKnownName) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("wellKnownName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.wellKnownName = wellKnownName;
        return _x;
    }

    public ContactFolder withUnmappedField(String name, Object value) {
        ContactFolder _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property childFolders
     */
    @NavigationProperty(name="childFolders")
    @JsonIgnore
    public ContactFolderCollectionRequest getChildFolders() {
        return new ContactFolderCollectionRequest(
                        contextPath.addSegment("childFolders"), Optional.ofNullable(childFolders));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property contacts
     */
    @NavigationProperty(name="contacts")
    @JsonIgnore
    public ContactCollectionRequest getContacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contacts"), Optional.ofNullable(contacts));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code childFolders}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param childFolders
     *            new value of {@code childFolders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code childFolders} field changed
     */
    public ContactFolder withChildFolders(List<ContactFolder> childFolders) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("childFolders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.childFolders = childFolders;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code contacts} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param contacts
     *            new value of {@code contacts} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code contacts} field changed
     */
    public ContactFolder withContacts(List<Contact> contacts) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("contacts");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.contacts = contacts;
        return _x;
    }

    public ContactFolder withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    public ContactFolder withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        ContactFolder _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contactFolder");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContactFolder patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ContactFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ContactFolder put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ContactFolder _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ContactFolder _copy() {
        ContactFolder _x = new ContactFolder();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.parentFolderId = parentFolderId;
        _x.wellKnownName = wellKnownName;
        _x.childFolders = childFolders;
        _x.contacts = contacts;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ContactFolder[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("wellKnownName=");
        b.append(this.wellKnownName);
        b.append(", ");
        b.append("childFolders=");
        b.append(this.childFolders);
        b.append(", ");
        b.append("contacts=");
        b.append(this.contacts);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
