package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.FollowupFlag;
import odata.msgraph.client.beta.complex.Phone;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.complex.TypedEmailAddress;
import odata.msgraph.client.beta.complex.Website;
import odata.msgraph.client.beta.entity.collection.request.ExtensionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MultiValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SingleValueLegacyExtendedPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "assistantName", 
    "birthday", 
    "children", 
    "companyName", 
    "department", 
    "displayName", 
    "emailAddresses", 
    "fileAs", 
    "flag", 
    "gender", 
    "generation", 
    "givenName", 
    "imAddresses", 
    "initials", 
    "isFavorite", 
    "jobTitle", 
    "manager", 
    "middleName", 
    "nickName", 
    "officeLocation", 
    "parentFolderId", 
    "personalNotes", 
    "phones", 
    "postalAddresses", 
    "profession", 
    "spouseName", 
    "surname", 
    "title", 
    "websites", 
    "weddingAnniversary", 
    "yomiCompanyName", 
    "yomiGivenName", 
    "yomiSurname", 
    "extensions", 
    "multiValueExtendedProperties", 
    "photo", 
    "singleValueExtendedProperties"})
@JsonInclude(Include.NON_NULL)
public class Contact extends OutlookItem implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.contact";
    }

    @JsonProperty("assistantName")
    protected String assistantName;

    @JsonProperty("birthday")
    protected OffsetDateTime birthday;

    @JsonProperty("children")
    protected List<String> children;

    @JsonProperty("children@nextLink")
    protected String childrenNextLink;

    @JsonProperty("companyName")
    protected String companyName;

    @JsonProperty("department")
    protected String department;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("emailAddresses")
    protected List<TypedEmailAddress> emailAddresses;

    @JsonProperty("emailAddresses@nextLink")
    protected String emailAddressesNextLink;

    @JsonProperty("fileAs")
    protected String fileAs;

    @JsonProperty("flag")
    protected FollowupFlag flag;

    @JsonProperty("gender")
    protected String gender;

    @JsonProperty("generation")
    protected String generation;

    @JsonProperty("givenName")
    protected String givenName;

    @JsonProperty("imAddresses")
    protected List<String> imAddresses;

    @JsonProperty("imAddresses@nextLink")
    protected String imAddressesNextLink;

    @JsonProperty("initials")
    protected String initials;

    @JsonProperty("isFavorite")
    protected Boolean isFavorite;

    @JsonProperty("jobTitle")
    protected String jobTitle;

    @JsonProperty("manager")
    protected String manager;

    @JsonProperty("middleName")
    protected String middleName;

    @JsonProperty("nickName")
    protected String nickName;

    @JsonProperty("officeLocation")
    protected String officeLocation;

    @JsonProperty("parentFolderId")
    protected String parentFolderId;

    @JsonProperty("personalNotes")
    protected String personalNotes;

    @JsonProperty("phones")
    protected List<Phone> phones;

    @JsonProperty("phones@nextLink")
    protected String phonesNextLink;

    @JsonProperty("postalAddresses")
    protected List<PhysicalAddress> postalAddresses;

    @JsonProperty("postalAddresses@nextLink")
    protected String postalAddressesNextLink;

    @JsonProperty("profession")
    protected String profession;

    @JsonProperty("spouseName")
    protected String spouseName;

    @JsonProperty("surname")
    protected String surname;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("websites")
    protected List<Website> websites;

    @JsonProperty("websites@nextLink")
    protected String websitesNextLink;

    @JsonProperty("weddingAnniversary")
    protected LocalDate weddingAnniversary;

    @JsonProperty("yomiCompanyName")
    protected String yomiCompanyName;

    @JsonProperty("yomiGivenName")
    protected String yomiGivenName;

    @JsonProperty("yomiSurname")
    protected String yomiSurname;

    @JsonProperty("extensions")
    protected List<Extension> extensions;

    @JsonProperty("multiValueExtendedProperties")
    protected List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;

    @JsonProperty("photo")
    protected ProfilePhoto photo;

    @JsonProperty("singleValueExtendedProperties")
    protected List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;

    protected Contact() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderContact() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> categories;
        private String categoriesNextLink;
        private String changeKey;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String assistantName;
        private OffsetDateTime birthday;
        private List<String> children;
        private String childrenNextLink;
        private String companyName;
        private String department;
        private String displayName;
        private List<TypedEmailAddress> emailAddresses;
        private String emailAddressesNextLink;
        private String fileAs;
        private FollowupFlag flag;
        private String gender;
        private String generation;
        private String givenName;
        private List<String> imAddresses;
        private String imAddressesNextLink;
        private String initials;
        private Boolean isFavorite;
        private String jobTitle;
        private String manager;
        private String middleName;
        private String nickName;
        private String officeLocation;
        private String parentFolderId;
        private String personalNotes;
        private List<Phone> phones;
        private String phonesNextLink;
        private List<PhysicalAddress> postalAddresses;
        private String postalAddressesNextLink;
        private String profession;
        private String spouseName;
        private String surname;
        private String title;
        private List<Website> websites;
        private String websitesNextLink;
        private LocalDate weddingAnniversary;
        private String yomiCompanyName;
        private String yomiGivenName;
        private String yomiSurname;
        private List<Extension> extensions;
        private List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties;
        private ProfilePhoto photo;
        private List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder categories(List<String> categories) {
            this.categories = categories;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder categories(String... categories) {
            return categories(Arrays.asList(categories));
        }

        public Builder categoriesNextLink(String categoriesNextLink) {
            this.categoriesNextLink = categoriesNextLink;
            this.changedFields = changedFields.add("categories");
            return this;
        }

        public Builder changeKey(String changeKey) {
            this.changeKey = changeKey;
            this.changedFields = changedFields.add("changeKey");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder assistantName(String assistantName) {
            this.assistantName = assistantName;
            this.changedFields = changedFields.add("assistantName");
            return this;
        }

        public Builder birthday(OffsetDateTime birthday) {
            this.birthday = birthday;
            this.changedFields = changedFields.add("birthday");
            return this;
        }

        public Builder children(List<String> children) {
            this.children = children;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public Builder children(String... children) {
            return children(Arrays.asList(children));
        }

        public Builder childrenNextLink(String childrenNextLink) {
            this.childrenNextLink = childrenNextLink;
            this.changedFields = changedFields.add("children");
            return this;
        }

        public Builder companyName(String companyName) {
            this.companyName = companyName;
            this.changedFields = changedFields.add("companyName");
            return this;
        }

        public Builder department(String department) {
            this.department = department;
            this.changedFields = changedFields.add("department");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder emailAddresses(List<TypedEmailAddress> emailAddresses) {
            this.emailAddresses = emailAddresses;
            this.changedFields = changedFields.add("emailAddresses");
            return this;
        }

        public Builder emailAddresses(TypedEmailAddress... emailAddresses) {
            return emailAddresses(Arrays.asList(emailAddresses));
        }

        public Builder emailAddressesNextLink(String emailAddressesNextLink) {
            this.emailAddressesNextLink = emailAddressesNextLink;
            this.changedFields = changedFields.add("emailAddresses");
            return this;
        }

        public Builder fileAs(String fileAs) {
            this.fileAs = fileAs;
            this.changedFields = changedFields.add("fileAs");
            return this;
        }

        public Builder flag(FollowupFlag flag) {
            this.flag = flag;
            this.changedFields = changedFields.add("flag");
            return this;
        }

        public Builder gender(String gender) {
            this.gender = gender;
            this.changedFields = changedFields.add("gender");
            return this;
        }

        public Builder generation(String generation) {
            this.generation = generation;
            this.changedFields = changedFields.add("generation");
            return this;
        }

        public Builder givenName(String givenName) {
            this.givenName = givenName;
            this.changedFields = changedFields.add("givenName");
            return this;
        }

        public Builder imAddresses(List<String> imAddresses) {
            this.imAddresses = imAddresses;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder imAddresses(String... imAddresses) {
            return imAddresses(Arrays.asList(imAddresses));
        }

        public Builder imAddressesNextLink(String imAddressesNextLink) {
            this.imAddressesNextLink = imAddressesNextLink;
            this.changedFields = changedFields.add("imAddresses");
            return this;
        }

        public Builder initials(String initials) {
            this.initials = initials;
            this.changedFields = changedFields.add("initials");
            return this;
        }

        public Builder isFavorite(Boolean isFavorite) {
            this.isFavorite = isFavorite;
            this.changedFields = changedFields.add("isFavorite");
            return this;
        }

        public Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.changedFields = changedFields.add("jobTitle");
            return this;
        }

        public Builder manager(String manager) {
            this.manager = manager;
            this.changedFields = changedFields.add("manager");
            return this;
        }

        public Builder middleName(String middleName) {
            this.middleName = middleName;
            this.changedFields = changedFields.add("middleName");
            return this;
        }

        public Builder nickName(String nickName) {
            this.nickName = nickName;
            this.changedFields = changedFields.add("nickName");
            return this;
        }

        public Builder officeLocation(String officeLocation) {
            this.officeLocation = officeLocation;
            this.changedFields = changedFields.add("officeLocation");
            return this;
        }

        public Builder parentFolderId(String parentFolderId) {
            this.parentFolderId = parentFolderId;
            this.changedFields = changedFields.add("parentFolderId");
            return this;
        }

        public Builder personalNotes(String personalNotes) {
            this.personalNotes = personalNotes;
            this.changedFields = changedFields.add("personalNotes");
            return this;
        }

        public Builder phones(List<Phone> phones) {
            this.phones = phones;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder phones(Phone... phones) {
            return phones(Arrays.asList(phones));
        }

        public Builder phonesNextLink(String phonesNextLink) {
            this.phonesNextLink = phonesNextLink;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder postalAddresses(List<PhysicalAddress> postalAddresses) {
            this.postalAddresses = postalAddresses;
            this.changedFields = changedFields.add("postalAddresses");
            return this;
        }

        public Builder postalAddresses(PhysicalAddress... postalAddresses) {
            return postalAddresses(Arrays.asList(postalAddresses));
        }

        public Builder postalAddressesNextLink(String postalAddressesNextLink) {
            this.postalAddressesNextLink = postalAddressesNextLink;
            this.changedFields = changedFields.add("postalAddresses");
            return this;
        }

        public Builder profession(String profession) {
            this.profession = profession;
            this.changedFields = changedFields.add("profession");
            return this;
        }

        public Builder spouseName(String spouseName) {
            this.spouseName = spouseName;
            this.changedFields = changedFields.add("spouseName");
            return this;
        }

        public Builder surname(String surname) {
            this.surname = surname;
            this.changedFields = changedFields.add("surname");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder websites(List<Website> websites) {
            this.websites = websites;
            this.changedFields = changedFields.add("websites");
            return this;
        }

        public Builder websites(Website... websites) {
            return websites(Arrays.asList(websites));
        }

        public Builder websitesNextLink(String websitesNextLink) {
            this.websitesNextLink = websitesNextLink;
            this.changedFields = changedFields.add("websites");
            return this;
        }

        public Builder weddingAnniversary(LocalDate weddingAnniversary) {
            this.weddingAnniversary = weddingAnniversary;
            this.changedFields = changedFields.add("weddingAnniversary");
            return this;
        }

        public Builder yomiCompanyName(String yomiCompanyName) {
            this.yomiCompanyName = yomiCompanyName;
            this.changedFields = changedFields.add("yomiCompanyName");
            return this;
        }

        public Builder yomiGivenName(String yomiGivenName) {
            this.yomiGivenName = yomiGivenName;
            this.changedFields = changedFields.add("yomiGivenName");
            return this;
        }

        public Builder yomiSurname(String yomiSurname) {
            this.yomiSurname = yomiSurname;
            this.changedFields = changedFields.add("yomiSurname");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(List<Extension> extensions) {
            this.extensions = extensions;
            this.changedFields = changedFields.add("extensions");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param extensions
         *            value of {@code extensions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder extensions(Extension... extensions) {
            return extensions(Arrays.asList(extensions));
        }

        public Builder multiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
            this.multiValueExtendedProperties = multiValueExtendedProperties;
            this.changedFields = changedFields.add("multiValueExtendedProperties");
            return this;
        }

        public Builder multiValueExtendedProperties(MultiValueLegacyExtendedProperty... multiValueExtendedProperties) {
            return multiValueExtendedProperties(Arrays.asList(multiValueExtendedProperties));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = false
         * <p>
         * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
         * <p>
         * Deletable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
         * <p>
         * Expandable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
         * <p>
         * Insertable = false
         * <p>
         * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
         * <p>
         * Searchable = false
         * 
         * @param photo
         *            value of {@code photo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder photo(ProfilePhoto photo) {
            this.photo = photo;
            this.changedFields = changedFields.add("photo");
            return this;
        }

        public Builder singleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
            this.singleValueExtendedProperties = singleValueExtendedProperties;
            this.changedFields = changedFields.add("singleValueExtendedProperties");
            return this;
        }

        public Builder singleValueExtendedProperties(SingleValueLegacyExtendedProperty... singleValueExtendedProperties) {
            return singleValueExtendedProperties(Arrays.asList(singleValueExtendedProperties));
        }

        public Contact build() {
            Contact _x = new Contact();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.contact";
            _x.id = id;
            _x.categories = categories;
            _x.categoriesNextLink = categoriesNextLink;
            _x.changeKey = changeKey;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.assistantName = assistantName;
            _x.birthday = birthday;
            _x.children = children;
            _x.childrenNextLink = childrenNextLink;
            _x.companyName = companyName;
            _x.department = department;
            _x.displayName = displayName;
            _x.emailAddresses = emailAddresses;
            _x.emailAddressesNextLink = emailAddressesNextLink;
            _x.fileAs = fileAs;
            _x.flag = flag;
            _x.gender = gender;
            _x.generation = generation;
            _x.givenName = givenName;
            _x.imAddresses = imAddresses;
            _x.imAddressesNextLink = imAddressesNextLink;
            _x.initials = initials;
            _x.isFavorite = isFavorite;
            _x.jobTitle = jobTitle;
            _x.manager = manager;
            _x.middleName = middleName;
            _x.nickName = nickName;
            _x.officeLocation = officeLocation;
            _x.parentFolderId = parentFolderId;
            _x.personalNotes = personalNotes;
            _x.phones = phones;
            _x.phonesNextLink = phonesNextLink;
            _x.postalAddresses = postalAddresses;
            _x.postalAddressesNextLink = postalAddressesNextLink;
            _x.profession = profession;
            _x.spouseName = spouseName;
            _x.surname = surname;
            _x.title = title;
            _x.websites = websites;
            _x.websitesNextLink = websitesNextLink;
            _x.weddingAnniversary = weddingAnniversary;
            _x.yomiCompanyName = yomiCompanyName;
            _x.yomiGivenName = yomiGivenName;
            _x.yomiSurname = yomiSurname;
            _x.extensions = extensions;
            _x.multiValueExtendedProperties = multiValueExtendedProperties;
            _x.photo = photo;
            _x.singleValueExtendedProperties = singleValueExtendedProperties;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="assistantName")
    @JsonIgnore
    public Optional<String> getAssistantName() {
        return Optional.ofNullable(assistantName);
    }

    public Contact withAssistantName(String assistantName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("assistantName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.assistantName = assistantName;
        return _x;
    }

    @Property(name="birthday")
    @JsonIgnore
    public Optional<OffsetDateTime> getBirthday() {
        return Optional.ofNullable(birthday);
    }

    public Contact withBirthday(OffsetDateTime birthday) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("birthday");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.birthday = birthday;
        return _x;
    }

    @Property(name="children")
    @JsonIgnore
    public CollectionPage<String> getChildren() {
        return new CollectionPage<String>(contextPath, String.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withChildren(List<String> children) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("children");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.children = children;
        return _x;
    }

    @Property(name="children")
    @JsonIgnore
    public CollectionPage<String> getChildren(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.children, Optional.ofNullable(childrenNextLink), Collections.emptyList(), options);
    }

    @Property(name="companyName")
    @JsonIgnore
    public Optional<String> getCompanyName() {
        return Optional.ofNullable(companyName);
    }

    public Contact withCompanyName(String companyName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("companyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.companyName = companyName;
        return _x;
    }

    @Property(name="department")
    @JsonIgnore
    public Optional<String> getDepartment() {
        return Optional.ofNullable(department);
    }

    public Contact withDepartment(String department) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("department");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.department = department;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Contact withDisplayName(String displayName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="emailAddresses")
    @JsonIgnore
    public CollectionPage<TypedEmailAddress> getEmailAddresses() {
        return new CollectionPage<TypedEmailAddress>(contextPath, TypedEmailAddress.class, this.emailAddresses, Optional.ofNullable(emailAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withEmailAddresses(List<TypedEmailAddress> emailAddresses) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("emailAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.emailAddresses = emailAddresses;
        return _x;
    }

    @Property(name="emailAddresses")
    @JsonIgnore
    public CollectionPage<TypedEmailAddress> getEmailAddresses(HttpRequestOptions options) {
        return new CollectionPage<TypedEmailAddress>(contextPath, TypedEmailAddress.class, this.emailAddresses, Optional.ofNullable(emailAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="fileAs")
    @JsonIgnore
    public Optional<String> getFileAs() {
        return Optional.ofNullable(fileAs);
    }

    public Contact withFileAs(String fileAs) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("fileAs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.fileAs = fileAs;
        return _x;
    }

    @Property(name="flag")
    @JsonIgnore
    public Optional<FollowupFlag> getFlag() {
        return Optional.ofNullable(flag);
    }

    public Contact withFlag(FollowupFlag flag) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("flag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.flag = flag;
        return _x;
    }

    @Property(name="gender")
    @JsonIgnore
    public Optional<String> getGender() {
        return Optional.ofNullable(gender);
    }

    public Contact withGender(String gender) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("gender");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.gender = gender;
        return _x;
    }

    @Property(name="generation")
    @JsonIgnore
    public Optional<String> getGeneration() {
        return Optional.ofNullable(generation);
    }

    public Contact withGeneration(String generation) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("generation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.generation = generation;
        return _x;
    }

    @Property(name="givenName")
    @JsonIgnore
    public Optional<String> getGivenName() {
        return Optional.ofNullable(givenName);
    }

    public Contact withGivenName(String givenName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("givenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.givenName = givenName;
        return _x;
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses() {
        return new CollectionPage<String>(contextPath, String.class, this.imAddresses, Optional.ofNullable(imAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withImAddresses(List<String> imAddresses) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("imAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.imAddresses = imAddresses;
        return _x;
    }

    @Property(name="imAddresses")
    @JsonIgnore
    public CollectionPage<String> getImAddresses(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.imAddresses, Optional.ofNullable(imAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="initials")
    @JsonIgnore
    public Optional<String> getInitials() {
        return Optional.ofNullable(initials);
    }

    public Contact withInitials(String initials) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("initials");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.initials = initials;
        return _x;
    }

    @Property(name="isFavorite")
    @JsonIgnore
    public Optional<Boolean> getIsFavorite() {
        return Optional.ofNullable(isFavorite);
    }

    public Contact withIsFavorite(Boolean isFavorite) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("isFavorite");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.isFavorite = isFavorite;
        return _x;
    }

    @Property(name="jobTitle")
    @JsonIgnore
    public Optional<String> getJobTitle() {
        return Optional.ofNullable(jobTitle);
    }

    public Contact withJobTitle(String jobTitle) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("jobTitle");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.jobTitle = jobTitle;
        return _x;
    }

    @Property(name="manager")
    @JsonIgnore
    public Optional<String> getManager() {
        return Optional.ofNullable(manager);
    }

    public Contact withManager(String manager) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("manager");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.manager = manager;
        return _x;
    }

    @Property(name="middleName")
    @JsonIgnore
    public Optional<String> getMiddleName() {
        return Optional.ofNullable(middleName);
    }

    public Contact withMiddleName(String middleName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("middleName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.middleName = middleName;
        return _x;
    }

    @Property(name="nickName")
    @JsonIgnore
    public Optional<String> getNickName() {
        return Optional.ofNullable(nickName);
    }

    public Contact withNickName(String nickName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("nickName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.nickName = nickName;
        return _x;
    }

    @Property(name="officeLocation")
    @JsonIgnore
    public Optional<String> getOfficeLocation() {
        return Optional.ofNullable(officeLocation);
    }

    public Contact withOfficeLocation(String officeLocation) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("officeLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.officeLocation = officeLocation;
        return _x;
    }

    @Property(name="parentFolderId")
    @JsonIgnore
    public Optional<String> getParentFolderId() {
        return Optional.ofNullable(parentFolderId);
    }

    public Contact withParentFolderId(String parentFolderId) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("parentFolderId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.parentFolderId = parentFolderId;
        return _x;
    }

    @Property(name="personalNotes")
    @JsonIgnore
    public Optional<String> getPersonalNotes() {
        return Optional.ofNullable(personalNotes);
    }

    public Contact withPersonalNotes(String personalNotes) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("personalNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.personalNotes = personalNotes;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones() {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withPhones(List<Phone> phones) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("phones");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.phones = phones;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones(HttpRequestOptions options) {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), options);
    }

    @Property(name="postalAddresses")
    @JsonIgnore
    public CollectionPage<PhysicalAddress> getPostalAddresses() {
        return new CollectionPage<PhysicalAddress>(contextPath, PhysicalAddress.class, this.postalAddresses, Optional.ofNullable(postalAddressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withPostalAddresses(List<PhysicalAddress> postalAddresses) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("postalAddresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.postalAddresses = postalAddresses;
        return _x;
    }

    @Property(name="postalAddresses")
    @JsonIgnore
    public CollectionPage<PhysicalAddress> getPostalAddresses(HttpRequestOptions options) {
        return new CollectionPage<PhysicalAddress>(contextPath, PhysicalAddress.class, this.postalAddresses, Optional.ofNullable(postalAddressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="profession")
    @JsonIgnore
    public Optional<String> getProfession() {
        return Optional.ofNullable(profession);
    }

    public Contact withProfession(String profession) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("profession");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.profession = profession;
        return _x;
    }

    @Property(name="spouseName")
    @JsonIgnore
    public Optional<String> getSpouseName() {
        return Optional.ofNullable(spouseName);
    }

    public Contact withSpouseName(String spouseName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("spouseName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.spouseName = spouseName;
        return _x;
    }

    @Property(name="surname")
    @JsonIgnore
    public Optional<String> getSurname() {
        return Optional.ofNullable(surname);
    }

    public Contact withSurname(String surname) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("surname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.surname = surname;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Contact withTitle(String title) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.title = title;
        return _x;
    }

    @Property(name="websites")
    @JsonIgnore
    public CollectionPage<Website> getWebsites() {
        return new CollectionPage<Website>(contextPath, Website.class, this.websites, Optional.ofNullable(websitesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public Contact withWebsites(List<Website> websites) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("websites");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.websites = websites;
        return _x;
    }

    @Property(name="websites")
    @JsonIgnore
    public CollectionPage<Website> getWebsites(HttpRequestOptions options) {
        return new CollectionPage<Website>(contextPath, Website.class, this.websites, Optional.ofNullable(websitesNextLink), Collections.emptyList(), options);
    }

    @Property(name="weddingAnniversary")
    @JsonIgnore
    public Optional<LocalDate> getWeddingAnniversary() {
        return Optional.ofNullable(weddingAnniversary);
    }

    public Contact withWeddingAnniversary(LocalDate weddingAnniversary) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("weddingAnniversary");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.weddingAnniversary = weddingAnniversary;
        return _x;
    }

    @Property(name="yomiCompanyName")
    @JsonIgnore
    public Optional<String> getYomiCompanyName() {
        return Optional.ofNullable(yomiCompanyName);
    }

    public Contact withYomiCompanyName(String yomiCompanyName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("yomiCompanyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.yomiCompanyName = yomiCompanyName;
        return _x;
    }

    @Property(name="yomiGivenName")
    @JsonIgnore
    public Optional<String> getYomiGivenName() {
        return Optional.ofNullable(yomiGivenName);
    }

    public Contact withYomiGivenName(String yomiGivenName) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("yomiGivenName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.yomiGivenName = yomiGivenName;
        return _x;
    }

    @Property(name="yomiSurname")
    @JsonIgnore
    public Optional<String> getYomiSurname() {
        return Optional.ofNullable(yomiSurname);
    }

    public Contact withYomiSurname(String yomiSurname) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("yomiSurname");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.yomiSurname = yomiSurname;
        return _x;
    }

    public Contact withUnmappedField(String name, Object value) {
        Contact _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property extensions
     */
    @NavigationProperty(name="extensions")
    @JsonIgnore
    public ExtensionCollectionRequest getExtensions() {
        return new ExtensionCollectionRequest(
                        contextPath.addSegment("extensions"), Optional.ofNullable(extensions));
    }

    @NavigationProperty(name="multiValueExtendedProperties")
    @JsonIgnore
    public MultiValueLegacyExtendedPropertyCollectionRequest getMultiValueExtendedProperties() {
        return new MultiValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("multiValueExtendedProperties"), Optional.ofNullable(multiValueExtendedProperties));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @return navigational property photo
     */
    @NavigationProperty(name="photo")
    @JsonIgnore
    public ProfilePhotoRequest getPhoto() {
        return new ProfilePhotoRequest(contextPath.addSegment("photo"), Optional.ofNullable(photo));
    }

    @NavigationProperty(name="singleValueExtendedProperties")
    @JsonIgnore
    public SingleValueLegacyExtendedPropertyCollectionRequest getSingleValueExtendedProperties() {
        return new SingleValueLegacyExtendedPropertyCollectionRequest(
                        contextPath.addSegment("singleValueExtendedProperties"), Optional.ofNullable(singleValueExtendedProperties));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code extensions} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param extensions
     *            new value of {@code extensions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code extensions} field changed
     */
    public Contact withExtensions(List<Extension> extensions) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("extensions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.extensions = extensions;
        return _x;
    }

    public Contact withMultiValueExtendedProperties(List<MultiValueLegacyExtendedProperty> multiValueExtendedProperties) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("multiValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code photo} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = false
     * <p>
     * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
     * <p>
     * Deletable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
     * <p>
     * Expandable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
     * <p>
     * Insertable = false
     * <p>
     * <b>Org.OData.Capabilities.V1.SearchRestrictions</b>
     * <p>
     * Searchable = false
     * 
     * @param photo
     *            new value of {@code photo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code photo} field changed
     */
    public Contact withPhoto(ProfilePhoto photo) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("photo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.photo = photo;
        return _x;
    }

    public Contact withSingleValueExtendedProperties(List<SingleValueLegacyExtendedProperty> singleValueExtendedProperties) {
        Contact _x = _copy();
        _x.changedFields = changedFields.add("singleValueExtendedProperties");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.contact");
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Contact patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Contact _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Contact put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Contact _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Contact _copy() {
        Contact _x = new Contact();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.categories = categories;
        _x.changeKey = changeKey;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.assistantName = assistantName;
        _x.birthday = birthday;
        _x.children = children;
        _x.companyName = companyName;
        _x.department = department;
        _x.displayName = displayName;
        _x.emailAddresses = emailAddresses;
        _x.fileAs = fileAs;
        _x.flag = flag;
        _x.gender = gender;
        _x.generation = generation;
        _x.givenName = givenName;
        _x.imAddresses = imAddresses;
        _x.initials = initials;
        _x.isFavorite = isFavorite;
        _x.jobTitle = jobTitle;
        _x.manager = manager;
        _x.middleName = middleName;
        _x.nickName = nickName;
        _x.officeLocation = officeLocation;
        _x.parentFolderId = parentFolderId;
        _x.personalNotes = personalNotes;
        _x.phones = phones;
        _x.postalAddresses = postalAddresses;
        _x.profession = profession;
        _x.spouseName = spouseName;
        _x.surname = surname;
        _x.title = title;
        _x.websites = websites;
        _x.weddingAnniversary = weddingAnniversary;
        _x.yomiCompanyName = yomiCompanyName;
        _x.yomiGivenName = yomiGivenName;
        _x.yomiSurname = yomiSurname;
        _x.extensions = extensions;
        _x.multiValueExtendedProperties = multiValueExtendedProperties;
        _x.photo = photo;
        _x.singleValueExtendedProperties = singleValueExtendedProperties;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Contact[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("categories=");
        b.append(this.categories);
        b.append(", ");
        b.append("changeKey=");
        b.append(this.changeKey);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("assistantName=");
        b.append(this.assistantName);
        b.append(", ");
        b.append("birthday=");
        b.append(this.birthday);
        b.append(", ");
        b.append("children=");
        b.append(this.children);
        b.append(", ");
        b.append("companyName=");
        b.append(this.companyName);
        b.append(", ");
        b.append("department=");
        b.append(this.department);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddresses=");
        b.append(this.emailAddresses);
        b.append(", ");
        b.append("fileAs=");
        b.append(this.fileAs);
        b.append(", ");
        b.append("flag=");
        b.append(this.flag);
        b.append(", ");
        b.append("gender=");
        b.append(this.gender);
        b.append(", ");
        b.append("generation=");
        b.append(this.generation);
        b.append(", ");
        b.append("givenName=");
        b.append(this.givenName);
        b.append(", ");
        b.append("imAddresses=");
        b.append(this.imAddresses);
        b.append(", ");
        b.append("initials=");
        b.append(this.initials);
        b.append(", ");
        b.append("isFavorite=");
        b.append(this.isFavorite);
        b.append(", ");
        b.append("jobTitle=");
        b.append(this.jobTitle);
        b.append(", ");
        b.append("manager=");
        b.append(this.manager);
        b.append(", ");
        b.append("middleName=");
        b.append(this.middleName);
        b.append(", ");
        b.append("nickName=");
        b.append(this.nickName);
        b.append(", ");
        b.append("officeLocation=");
        b.append(this.officeLocation);
        b.append(", ");
        b.append("parentFolderId=");
        b.append(this.parentFolderId);
        b.append(", ");
        b.append("personalNotes=");
        b.append(this.personalNotes);
        b.append(", ");
        b.append("phones=");
        b.append(this.phones);
        b.append(", ");
        b.append("postalAddresses=");
        b.append(this.postalAddresses);
        b.append(", ");
        b.append("profession=");
        b.append(this.profession);
        b.append(", ");
        b.append("spouseName=");
        b.append(this.spouseName);
        b.append(", ");
        b.append("surname=");
        b.append(this.surname);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("websites=");
        b.append(this.websites);
        b.append(", ");
        b.append("weddingAnniversary=");
        b.append(this.weddingAnniversary);
        b.append(", ");
        b.append("yomiCompanyName=");
        b.append(this.yomiCompanyName);
        b.append(", ");
        b.append("yomiGivenName=");
        b.append(this.yomiGivenName);
        b.append(", ");
        b.append("yomiSurname=");
        b.append(this.yomiSurname);
        b.append(", ");
        b.append("extensions=");
        b.append(this.extensions);
        b.append(", ");
        b.append("multiValueExtendedProperties=");
        b.append(this.multiValueExtendedProperties);
        b.append(", ");
        b.append("photo=");
        b.append(this.photo);
        b.append(", ");
        b.append("singleValueExtendedProperties=");
        b.append(this.singleValueExtendedProperties);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
