package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.ConnectorGroupCollectionRequest;
import odata.msgraph.client.beta.enums.ConnectorStatus;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.NavigationRestrictions</b>
 * <p>
 * Referenceable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "externalIp", 
    "machineName", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class Connector extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.connector";
    }

    @JsonProperty("externalIp")
    protected String externalIp;

    @JsonProperty("machineName")
    protected String machineName;

    @JsonProperty("status")
    protected ConnectorStatus status;

    protected Connector() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnector() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String externalIp;
        private String machineName;
        private ConnectorStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder externalIp(String externalIp) {
            this.externalIp = externalIp;
            this.changedFields = changedFields.add("externalIp");
            return this;
        }

        public Builder machineName(String machineName) {
            this.machineName = machineName;
            this.changedFields = changedFields.add("machineName");
            return this;
        }

        public Builder status(ConnectorStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Connector build() {
            Connector _x = new Connector();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.connector";
            _x.id = id;
            _x.externalIp = externalIp;
            _x.machineName = machineName;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="externalIp")
    @JsonIgnore
    public Optional<String> getExternalIp() {
        return Optional.ofNullable(externalIp);
    }

    public Connector withExternalIp(String externalIp) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("externalIp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connector");
        _x.externalIp = externalIp;
        return _x;
    }

    @Property(name="machineName")
    @JsonIgnore
    public Optional<String> getMachineName() {
        return Optional.ofNullable(machineName);
    }

    public Connector withMachineName(String machineName) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("machineName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connector");
        _x.machineName = machineName;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<ConnectorStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Connector withStatus(ConnectorStatus status) {
        Connector _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connector");
        _x.status = status;
        return _x;
    }

    public Connector withUnmappedField(String name, Object value) {
        Connector _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="memberOf")
    @JsonIgnore
    public ConnectorGroupCollectionRequest getMemberOf() {
        return new ConnectorGroupCollectionRequest(
                        contextPath.addSegment("memberOf"), RequestHelper.getValue(unmappedFields, "memberOf"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connector patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Connector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Connector put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Connector _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Connector _copy() {
        Connector _x = new Connector();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.externalIp = externalIp;
        _x.machineName = machineName;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Connector[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("externalIp=");
        b.append(this.externalIp);
        b.append(", ");
        b.append("machineName=");
        b.append(this.machineName);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
