package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.IdentitySource;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.enums.ConnectedOrganizationState;

@JsonPropertyOrder({
    "@odata.type", 
    "createdBy", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "identitySources", 
    "modifiedBy", 
    "modifiedDateTime", 
    "state", 
    "externalSponsors", 
    "internalSponsors"})
@JsonInclude(Include.NON_NULL)
public class ConnectedOrganization extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.connectedOrganization";
    }

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("identitySources")
    protected List<IdentitySource> identitySources;

    @JsonProperty("identitySources@nextLink")
    protected String identitySourcesNextLink;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("state")
    protected ConnectedOrganizationState state;

    @JsonProperty("externalSponsors")
    protected List<DirectoryObject> externalSponsors;

    @JsonProperty("internalSponsors")
    protected List<DirectoryObject> internalSponsors;

    protected ConnectedOrganization() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderConnectedOrganization() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private List<IdentitySource> identitySources;
        private String identitySourcesNextLink;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private ConnectedOrganizationState state;
        private List<DirectoryObject> externalSponsors;
        private List<DirectoryObject> internalSponsors;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder identitySources(List<IdentitySource> identitySources) {
            this.identitySources = identitySources;
            this.changedFields = changedFields.add("identitySources");
            return this;
        }

        public Builder identitySources(IdentitySource... identitySources) {
            return identitySources(Arrays.asList(identitySources));
        }

        public Builder identitySourcesNextLink(String identitySourcesNextLink) {
            this.identitySourcesNextLink = identitySourcesNextLink;
            this.changedFields = changedFields.add("identitySources");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder state(ConnectedOrganizationState state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder externalSponsors(List<DirectoryObject> externalSponsors) {
            this.externalSponsors = externalSponsors;
            this.changedFields = changedFields.add("externalSponsors");
            return this;
        }

        public Builder externalSponsors(DirectoryObject... externalSponsors) {
            return externalSponsors(Arrays.asList(externalSponsors));
        }

        public Builder internalSponsors(List<DirectoryObject> internalSponsors) {
            this.internalSponsors = internalSponsors;
            this.changedFields = changedFields.add("internalSponsors");
            return this;
        }

        public Builder internalSponsors(DirectoryObject... internalSponsors) {
            return internalSponsors(Arrays.asList(internalSponsors));
        }

        public ConnectedOrganization build() {
            ConnectedOrganization _x = new ConnectedOrganization();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.connectedOrganization";
            _x.id = id;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.identitySources = identitySources;
            _x.identitySourcesNextLink = identitySourcesNextLink;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.state = state;
            _x.externalSponsors = externalSponsors;
            _x.internalSponsors = internalSponsors;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public ConnectedOrganization withCreatedBy(String createdBy) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ConnectedOrganization withCreatedDateTime(OffsetDateTime createdDateTime) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ConnectedOrganization withDescription(String description) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ConnectedOrganization withDisplayName(String displayName) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="identitySources")
    @JsonIgnore
    public CollectionPage<IdentitySource> getIdentitySources() {
        return new CollectionPage<IdentitySource>(contextPath, IdentitySource.class, this.identitySources, Optional.ofNullable(identitySourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public ConnectedOrganization withIdentitySources(List<IdentitySource> identitySources) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("identitySources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.identitySources = identitySources;
        return _x;
    }

    @Property(name="identitySources")
    @JsonIgnore
    public CollectionPage<IdentitySource> getIdentitySources(HttpRequestOptions options) {
        return new CollectionPage<IdentitySource>(contextPath, IdentitySource.class, this.identitySources, Optional.ofNullable(identitySourcesNextLink), Collections.emptyList(), options);
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public ConnectedOrganization withModifiedBy(String modifiedBy) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public ConnectedOrganization withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<ConnectedOrganizationState> getState() {
        return Optional.ofNullable(state);
    }

    public ConnectedOrganization withState(ConnectedOrganizationState state) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.state = state;
        return _x;
    }

    public ConnectedOrganization withUnmappedField(String name, Object value) {
        ConnectedOrganization _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="externalSponsors")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getExternalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("externalSponsors"), Optional.ofNullable(externalSponsors));
    }

    @NavigationProperty(name="internalSponsors")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getInternalSponsors() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("internalSponsors"), Optional.ofNullable(internalSponsors));
    }

    public ConnectedOrganization withExternalSponsors(List<DirectoryObject> externalSponsors) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("externalSponsors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.externalSponsors = externalSponsors;
        return _x;
    }

    public ConnectedOrganization withInternalSponsors(List<DirectoryObject> internalSponsors) {
        ConnectedOrganization _x = _copy();
        _x.changedFields = changedFields.add("internalSponsors");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.connectedOrganization");
        _x.internalSponsors = internalSponsors;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConnectedOrganization patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ConnectedOrganization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ConnectedOrganization put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ConnectedOrganization _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ConnectedOrganization _copy() {
        ConnectedOrganization _x = new ConnectedOrganization();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.identitySources = identitySources;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.state = state;
        _x.externalSponsors = externalSponsors;
        _x.internalSponsors = internalSponsors;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ConnectedOrganization[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("identitySources=");
        b.append(this.identitySources);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("externalSponsors=");
        b.append(this.externalSponsors);
        b.append(", ");
        b.append("internalSponsors=");
        b.append(this.internalSponsors);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
