package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import odata.msgraph.client.beta.complex.PayloadRequest;
import odata.msgraph.client.beta.entity.request.PayloadResponseRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "appServiceName", 
    "error", 
    "packageFamilyName", 
    "payload", 
    "permissionTicket", 
    "postBackUri", 
    "status", 
    "type"})
@JsonInclude(Include.NON_NULL)
public class Command extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.command";
    }

    @JsonProperty("appServiceName")
    protected String appServiceName;

    @JsonProperty("error")
    protected String error;

    @JsonProperty("packageFamilyName")
    protected String packageFamilyName;

    @JsonProperty("payload")
    protected PayloadRequest payload;

    @JsonProperty("permissionTicket")
    protected String permissionTicket;

    @JsonProperty("postBackUri")
    protected String postBackUri;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("type")
    protected String type;

    protected Command() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCommand() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appServiceName;
        private String error;
        private String packageFamilyName;
        private PayloadRequest payload;
        private String permissionTicket;
        private String postBackUri;
        private String status;
        private String type;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appServiceName(String appServiceName) {
            this.appServiceName = appServiceName;
            this.changedFields = changedFields.add("appServiceName");
            return this;
        }

        public Builder error(String error) {
            this.error = error;
            this.changedFields = changedFields.add("error");
            return this;
        }

        public Builder packageFamilyName(String packageFamilyName) {
            this.packageFamilyName = packageFamilyName;
            this.changedFields = changedFields.add("packageFamilyName");
            return this;
        }

        public Builder payload(PayloadRequest payload) {
            this.payload = payload;
            this.changedFields = changedFields.add("payload");
            return this;
        }

        public Builder permissionTicket(String permissionTicket) {
            this.permissionTicket = permissionTicket;
            this.changedFields = changedFields.add("permissionTicket");
            return this;
        }

        public Builder postBackUri(String postBackUri) {
            this.postBackUri = postBackUri;
            this.changedFields = changedFields.add("postBackUri");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Command build() {
            Command _x = new Command();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.command";
            _x.id = id;
            _x.appServiceName = appServiceName;
            _x.error = error;
            _x.packageFamilyName = packageFamilyName;
            _x.payload = payload;
            _x.permissionTicket = permissionTicket;
            _x.postBackUri = postBackUri;
            _x.status = status;
            _x.type = type;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="appServiceName")
    @JsonIgnore
    public Optional<String> getAppServiceName() {
        return Optional.ofNullable(appServiceName);
    }

    public Command withAppServiceName(String appServiceName) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("appServiceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.appServiceName = appServiceName;
        return _x;
    }

    @Property(name="error")
    @JsonIgnore
    public Optional<String> getError() {
        return Optional.ofNullable(error);
    }

    public Command withError(String error) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("error");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.error = error;
        return _x;
    }

    @Property(name="packageFamilyName")
    @JsonIgnore
    public Optional<String> getPackageFamilyName() {
        return Optional.ofNullable(packageFamilyName);
    }

    public Command withPackageFamilyName(String packageFamilyName) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("packageFamilyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.packageFamilyName = packageFamilyName;
        return _x;
    }

    @Property(name="payload")
    @JsonIgnore
    public Optional<PayloadRequest> getPayload() {
        return Optional.ofNullable(payload);
    }

    public Command withPayload(PayloadRequest payload) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("payload");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.payload = payload;
        return _x;
    }

    @Property(name="permissionTicket")
    @JsonIgnore
    public Optional<String> getPermissionTicket() {
        return Optional.ofNullable(permissionTicket);
    }

    public Command withPermissionTicket(String permissionTicket) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("permissionTicket");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.permissionTicket = permissionTicket;
        return _x;
    }

    @Property(name="postBackUri")
    @JsonIgnore
    public Optional<String> getPostBackUri() {
        return Optional.ofNullable(postBackUri);
    }

    public Command withPostBackUri(String postBackUri) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("postBackUri");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.postBackUri = postBackUri;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public Command withStatus(String status) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.status = status;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public Command withType(String type) {
        Command _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.command");
        _x.type = type;
        return _x;
    }

    public Command withUnmappedField(String name, Object value) {
        Command _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="responsepayload")
    @JsonIgnore
    public PayloadResponseRequest getResponsepayload() {
        return new PayloadResponseRequest(contextPath.addSegment("responsepayload"), RequestHelper.getValue(unmappedFields, "responsepayload"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Command patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Command _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Command put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Command _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Command _copy() {
        Command _x = new Command();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.appServiceName = appServiceName;
        _x.error = error;
        _x.packageFamilyName = packageFamilyName;
        _x.payload = payload;
        _x.permissionTicket = permissionTicket;
        _x.postBackUri = postBackUri;
        _x.status = status;
        _x.type = type;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Command[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appServiceName=");
        b.append(this.appServiceName);
        b.append(", ");
        b.append("error=");
        b.append(this.error);
        b.append(", ");
        b.append("packageFamilyName=");
        b.append(this.packageFamilyName);
        b.append(", ");
        b.append("payload=");
        b.append(this.payload);
        b.append(", ");
        b.append("permissionTicket=");
        b.append(this.permissionTicket);
        b.append(", ");
        b.append("postBackUri=");
        b.append(this.postBackUri);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
