package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcManagementAssignmentTarget;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class CloudPcUserSettingAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcUserSettingAssignment";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("target")
    protected CloudPcManagementAssignmentTarget target;

    protected CloudPcUserSettingAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcUserSettingAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private CloudPcManagementAssignmentTarget target;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder target(CloudPcManagementAssignmentTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public CloudPcUserSettingAssignment build() {
            CloudPcUserSettingAssignment _x = new CloudPcUserSettingAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcUserSettingAssignment";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public CloudPcUserSettingAssignment withCreatedDateTime(OffsetDateTime createdDateTime) {
        CloudPcUserSettingAssignment _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSettingAssignment");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<CloudPcManagementAssignmentTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    public CloudPcUserSettingAssignment withTarget(CloudPcManagementAssignmentTarget target) {
        CloudPcUserSettingAssignment _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcUserSettingAssignment");
        _x.target = target;
        return _x;
    }

    public CloudPcUserSettingAssignment withUnmappedField(String name, Object value) {
        CloudPcUserSettingAssignment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcUserSettingAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcUserSettingAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcUserSettingAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcUserSettingAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcUserSettingAssignment _copy() {
        CloudPcUserSettingAssignment _x = new CloudPcUserSettingAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcUserSettingAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
