package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.CloudPcSnapshotStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "cloudPcId", 
    "createdDateTime", 
    "lastRestoredDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class CloudPcSnapshot extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcSnapshot";
    }

    @JsonProperty("cloudPcId")
    protected String cloudPcId;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastRestoredDateTime")
    protected OffsetDateTime lastRestoredDateTime;

    @JsonProperty("status")
    protected CloudPcSnapshotStatus status;

    protected CloudPcSnapshot() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcSnapshot() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String cloudPcId;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastRestoredDateTime;
        private CloudPcSnapshotStatus status;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder cloudPcId(String cloudPcId) {
            this.cloudPcId = cloudPcId;
            this.changedFields = changedFields.add("cloudPcId");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastRestoredDateTime(OffsetDateTime lastRestoredDateTime) {
            this.lastRestoredDateTime = lastRestoredDateTime;
            this.changedFields = changedFields.add("lastRestoredDateTime");
            return this;
        }

        public Builder status(CloudPcSnapshotStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public CloudPcSnapshot build() {
            CloudPcSnapshot _x = new CloudPcSnapshot();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcSnapshot";
            _x.id = id;
            _x.cloudPcId = cloudPcId;
            _x.createdDateTime = createdDateTime;
            _x.lastRestoredDateTime = lastRestoredDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="cloudPcId")
    @JsonIgnore
    public Optional<String> getCloudPcId() {
        return Optional.ofNullable(cloudPcId);
    }

    public CloudPcSnapshot withCloudPcId(String cloudPcId) {
        CloudPcSnapshot _x = _copy();
        _x.changedFields = changedFields.add("cloudPcId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcSnapshot");
        _x.cloudPcId = cloudPcId;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public CloudPcSnapshot withCreatedDateTime(OffsetDateTime createdDateTime) {
        CloudPcSnapshot _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcSnapshot");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastRestoredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastRestoredDateTime() {
        return Optional.ofNullable(lastRestoredDateTime);
    }

    public CloudPcSnapshot withLastRestoredDateTime(OffsetDateTime lastRestoredDateTime) {
        CloudPcSnapshot _x = _copy();
        _x.changedFields = changedFields.add("lastRestoredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcSnapshot");
        _x.lastRestoredDateTime = lastRestoredDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CloudPcSnapshotStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CloudPcSnapshot withStatus(CloudPcSnapshotStatus status) {
        CloudPcSnapshot _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcSnapshot");
        _x.status = status;
        return _x;
    }

    public CloudPcSnapshot withUnmappedField(String name, Object value) {
        CloudPcSnapshot _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcSnapshot patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcSnapshot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcSnapshot put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcSnapshot _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcSnapshot _copy() {
        CloudPcSnapshot _x = new CloudPcSnapshot();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.cloudPcId = cloudPcId;
        _x.createdDateTime = createdDateTime;
        _x.lastRestoredDateTime = lastRestoredDateTime;
        _x.status = status;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcSnapshot[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("cloudPcId=");
        b.append(this.cloudPcId);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastRestoredDateTime=");
        b.append(this.lastRestoredDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
