package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcAuditActor;
import odata.msgraph.client.beta.complex.CloudPcAuditResource;
import odata.msgraph.client.beta.enums.CloudPcAuditActivityOperationType;
import odata.msgraph.client.beta.enums.CloudPcAuditActivityResult;
import odata.msgraph.client.beta.enums.CloudPcAuditCategory;

@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "activityDateTime", 
    "activityOperationType", 
    "activityResult", 
    "activityType", 
    "actor", 
    "category", 
    "componentName", 
    "correlationId", 
    "displayName", 
    "resources"})
@JsonInclude(Include.NON_NULL)
public class CloudPcAuditEvent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPcAuditEvent";
    }

    @JsonProperty("activity")
    protected String activity;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("activityOperationType")
    protected CloudPcAuditActivityOperationType activityOperationType;

    @JsonProperty("activityResult")
    protected CloudPcAuditActivityResult activityResult;

    @JsonProperty("activityType")
    protected String activityType;

    @JsonProperty("actor")
    protected CloudPcAuditActor actor;

    @JsonProperty("category")
    protected CloudPcAuditCategory category;

    @JsonProperty("componentName")
    protected String componentName;

    @JsonProperty("correlationId")
    protected String correlationId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("resources")
    protected List<CloudPcAuditResource> resources;

    @JsonProperty("resources@nextLink")
    protected String resourcesNextLink;

    protected CloudPcAuditEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPcAuditEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String activity;
        private OffsetDateTime activityDateTime;
        private CloudPcAuditActivityOperationType activityOperationType;
        private CloudPcAuditActivityResult activityResult;
        private String activityType;
        private CloudPcAuditActor actor;
        private CloudPcAuditCategory category;
        private String componentName;
        private String correlationId;
        private String displayName;
        private List<CloudPcAuditResource> resources;
        private String resourcesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activity(String activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        public Builder activityOperationType(CloudPcAuditActivityOperationType activityOperationType) {
            this.activityOperationType = activityOperationType;
            this.changedFields = changedFields.add("activityOperationType");
            return this;
        }

        public Builder activityResult(CloudPcAuditActivityResult activityResult) {
            this.activityResult = activityResult;
            this.changedFields = changedFields.add("activityResult");
            return this;
        }

        public Builder activityType(String activityType) {
            this.activityType = activityType;
            this.changedFields = changedFields.add("activityType");
            return this;
        }

        public Builder actor(CloudPcAuditActor actor) {
            this.actor = actor;
            this.changedFields = changedFields.add("actor");
            return this;
        }

        public Builder category(CloudPcAuditCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.changedFields = changedFields.add("componentName");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder resources(List<CloudPcAuditResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public Builder resources(CloudPcAuditResource... resources) {
            return resources(Arrays.asList(resources));
        }

        public Builder resourcesNextLink(String resourcesNextLink) {
            this.resourcesNextLink = resourcesNextLink;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        public CloudPcAuditEvent build() {
            CloudPcAuditEvent _x = new CloudPcAuditEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPcAuditEvent";
            _x.id = id;
            _x.activity = activity;
            _x.activityDateTime = activityDateTime;
            _x.activityOperationType = activityOperationType;
            _x.activityResult = activityResult;
            _x.activityType = activityType;
            _x.actor = actor;
            _x.category = category;
            _x.componentName = componentName;
            _x.correlationId = correlationId;
            _x.displayName = displayName;
            _x.resources = resources;
            _x.resourcesNextLink = resourcesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<String> getActivity() {
        return Optional.ofNullable(activity);
    }

    public CloudPcAuditEvent withActivity(String activity) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.activity = activity;
        return _x;
    }

    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    public CloudPcAuditEvent withActivityDateTime(OffsetDateTime activityDateTime) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    @Property(name="activityOperationType")
    @JsonIgnore
    public Optional<CloudPcAuditActivityOperationType> getActivityOperationType() {
        return Optional.ofNullable(activityOperationType);
    }

    public CloudPcAuditEvent withActivityOperationType(CloudPcAuditActivityOperationType activityOperationType) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityOperationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.activityOperationType = activityOperationType;
        return _x;
    }

    @Property(name="activityResult")
    @JsonIgnore
    public Optional<CloudPcAuditActivityResult> getActivityResult() {
        return Optional.ofNullable(activityResult);
    }

    public CloudPcAuditEvent withActivityResult(CloudPcAuditActivityResult activityResult) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.activityResult = activityResult;
        return _x;
    }

    @Property(name="activityType")
    @JsonIgnore
    public Optional<String> getActivityType() {
        return Optional.ofNullable(activityType);
    }

    public CloudPcAuditEvent withActivityType(String activityType) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.activityType = activityType;
        return _x;
    }

    @Property(name="actor")
    @JsonIgnore
    public Optional<CloudPcAuditActor> getActor() {
        return Optional.ofNullable(actor);
    }

    public CloudPcAuditEvent withActor(CloudPcAuditActor actor) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("actor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.actor = actor;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<CloudPcAuditCategory> getCategory() {
        return Optional.ofNullable(category);
    }

    public CloudPcAuditEvent withCategory(CloudPcAuditCategory category) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.category = category;
        return _x;
    }

    @Property(name="componentName")
    @JsonIgnore
    public Optional<String> getComponentName() {
        return Optional.ofNullable(componentName);
    }

    public CloudPcAuditEvent withComponentName(String componentName) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("componentName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.componentName = componentName;
        return _x;
    }

    @Property(name="correlationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    public CloudPcAuditEvent withCorrelationId(String correlationId) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("correlationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.correlationId = correlationId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPcAuditEvent withDisplayName(String displayName) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<CloudPcAuditResource> getResources() {
        return new CollectionPage<CloudPcAuditResource>(contextPath, CloudPcAuditResource.class, this.resources, Optional.ofNullable(resourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public CloudPcAuditEvent withResources(List<CloudPcAuditResource> resources) {
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = changedFields.add("resources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPcAuditEvent");
        _x.resources = resources;
        return _x;
    }

    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<CloudPcAuditResource> getResources(HttpRequestOptions options) {
        return new CollectionPage<CloudPcAuditResource>(contextPath, CloudPcAuditResource.class, this.resources, Optional.ofNullable(resourcesNextLink), Collections.emptyList(), options);
    }

    public CloudPcAuditEvent withUnmappedField(String name, Object value) {
        CloudPcAuditEvent _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcAuditEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPcAuditEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPcAuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPcAuditEvent _copy() {
        CloudPcAuditEvent _x = new CloudPcAuditEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.activityDateTime = activityDateTime;
        _x.activityOperationType = activityOperationType;
        _x.activityResult = activityResult;
        _x.activityType = activityType;
        _x.actor = actor;
        _x.category = category;
        _x.componentName = componentName;
        _x.correlationId = correlationId;
        _x.displayName = displayName;
        _x.resources = resources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPcAuditEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("activityOperationType=");
        b.append(this.activityOperationType);
        b.append(", ");
        b.append("activityResult=");
        b.append(this.activityResult);
        b.append(", ");
        b.append("activityType=");
        b.append(this.activityType);
        b.append(", ");
        b.append("actor=");
        b.append(this.actor);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("componentName=");
        b.append(this.componentName);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
