package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CloudPcLoginResult;
import odata.msgraph.client.beta.complex.CloudPcRemoteActionResult;
import odata.msgraph.client.beta.complex.CloudPcStatusDetails;
import odata.msgraph.client.beta.enums.CloudPcOperatingSystem;
import odata.msgraph.client.beta.enums.CloudPcServicePlanType;
import odata.msgraph.client.beta.enums.CloudPcStatus;
import odata.msgraph.client.beta.enums.CloudPcUserAccountType;

@JsonPropertyOrder({
    "@odata.type", 
    "aadDeviceId", 
    "displayName", 
    "gracePeriodEndDateTime", 
    "imageDisplayName", 
    "lastLoginResult", 
    "lastModifiedDateTime", 
    "lastRemoteActionResult", 
    "managedDeviceId", 
    "managedDeviceName", 
    "onPremisesConnectionName", 
    "osVersion", 
    "provisioningPolicyId", 
    "provisioningPolicyName", 
    "servicePlanId", 
    "servicePlanName", 
    "servicePlanType", 
    "status", 
    "statusDetails", 
    "userAccountType", 
    "userPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class CloudPC extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cloudPC";
    }

    @JsonProperty("aadDeviceId")
    protected String aadDeviceId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("gracePeriodEndDateTime")
    protected OffsetDateTime gracePeriodEndDateTime;

    @JsonProperty("imageDisplayName")
    protected String imageDisplayName;

    @JsonProperty("lastLoginResult")
    protected CloudPcLoginResult lastLoginResult;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("lastRemoteActionResult")
    protected CloudPcRemoteActionResult lastRemoteActionResult;

    @JsonProperty("managedDeviceId")
    protected String managedDeviceId;

    @JsonProperty("managedDeviceName")
    protected String managedDeviceName;

    @JsonProperty("onPremisesConnectionName")
    protected String onPremisesConnectionName;

    @JsonProperty("osVersion")
    protected CloudPcOperatingSystem osVersion;

    @JsonProperty("provisioningPolicyId")
    protected String provisioningPolicyId;

    @JsonProperty("provisioningPolicyName")
    protected String provisioningPolicyName;

    @JsonProperty("servicePlanId")
    protected String servicePlanId;

    @JsonProperty("servicePlanName")
    protected String servicePlanName;

    @JsonProperty("servicePlanType")
    protected CloudPcServicePlanType servicePlanType;

    @JsonProperty("status")
    protected CloudPcStatus status;

    @JsonProperty("statusDetails")
    protected CloudPcStatusDetails statusDetails;

    @JsonProperty("userAccountType")
    protected CloudPcUserAccountType userAccountType;

    @JsonProperty("userPrincipalName")
    protected String userPrincipalName;

    protected CloudPC() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCloudPC() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String aadDeviceId;
        private String displayName;
        private OffsetDateTime gracePeriodEndDateTime;
        private String imageDisplayName;
        private CloudPcLoginResult lastLoginResult;
        private OffsetDateTime lastModifiedDateTime;
        private CloudPcRemoteActionResult lastRemoteActionResult;
        private String managedDeviceId;
        private String managedDeviceName;
        private String onPremisesConnectionName;
        private CloudPcOperatingSystem osVersion;
        private String provisioningPolicyId;
        private String provisioningPolicyName;
        private String servicePlanId;
        private String servicePlanName;
        private CloudPcServicePlanType servicePlanType;
        private CloudPcStatus status;
        private CloudPcStatusDetails statusDetails;
        private CloudPcUserAccountType userAccountType;
        private String userPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder aadDeviceId(String aadDeviceId) {
            this.aadDeviceId = aadDeviceId;
            this.changedFields = changedFields.add("aadDeviceId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder gracePeriodEndDateTime(OffsetDateTime gracePeriodEndDateTime) {
            this.gracePeriodEndDateTime = gracePeriodEndDateTime;
            this.changedFields = changedFields.add("gracePeriodEndDateTime");
            return this;
        }

        public Builder imageDisplayName(String imageDisplayName) {
            this.imageDisplayName = imageDisplayName;
            this.changedFields = changedFields.add("imageDisplayName");
            return this;
        }

        public Builder lastLoginResult(CloudPcLoginResult lastLoginResult) {
            this.lastLoginResult = lastLoginResult;
            this.changedFields = changedFields.add("lastLoginResult");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder lastRemoteActionResult(CloudPcRemoteActionResult lastRemoteActionResult) {
            this.lastRemoteActionResult = lastRemoteActionResult;
            this.changedFields = changedFields.add("lastRemoteActionResult");
            return this;
        }

        public Builder managedDeviceId(String managedDeviceId) {
            this.managedDeviceId = managedDeviceId;
            this.changedFields = changedFields.add("managedDeviceId");
            return this;
        }

        public Builder managedDeviceName(String managedDeviceName) {
            this.managedDeviceName = managedDeviceName;
            this.changedFields = changedFields.add("managedDeviceName");
            return this;
        }

        public Builder onPremisesConnectionName(String onPremisesConnectionName) {
            this.onPremisesConnectionName = onPremisesConnectionName;
            this.changedFields = changedFields.add("onPremisesConnectionName");
            return this;
        }

        public Builder osVersion(CloudPcOperatingSystem osVersion) {
            this.osVersion = osVersion;
            this.changedFields = changedFields.add("osVersion");
            return this;
        }

        public Builder provisioningPolicyId(String provisioningPolicyId) {
            this.provisioningPolicyId = provisioningPolicyId;
            this.changedFields = changedFields.add("provisioningPolicyId");
            return this;
        }

        public Builder provisioningPolicyName(String provisioningPolicyName) {
            this.provisioningPolicyName = provisioningPolicyName;
            this.changedFields = changedFields.add("provisioningPolicyName");
            return this;
        }

        public Builder servicePlanId(String servicePlanId) {
            this.servicePlanId = servicePlanId;
            this.changedFields = changedFields.add("servicePlanId");
            return this;
        }

        public Builder servicePlanName(String servicePlanName) {
            this.servicePlanName = servicePlanName;
            this.changedFields = changedFields.add("servicePlanName");
            return this;
        }

        public Builder servicePlanType(CloudPcServicePlanType servicePlanType) {
            this.servicePlanType = servicePlanType;
            this.changedFields = changedFields.add("servicePlanType");
            return this;
        }

        public Builder status(CloudPcStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder statusDetails(CloudPcStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            this.changedFields = changedFields.add("statusDetails");
            return this;
        }

        public Builder userAccountType(CloudPcUserAccountType userAccountType) {
            this.userAccountType = userAccountType;
            this.changedFields = changedFields.add("userAccountType");
            return this;
        }

        public Builder userPrincipalName(String userPrincipalName) {
            this.userPrincipalName = userPrincipalName;
            this.changedFields = changedFields.add("userPrincipalName");
            return this;
        }

        public CloudPC build() {
            CloudPC _x = new CloudPC();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cloudPC";
            _x.id = id;
            _x.aadDeviceId = aadDeviceId;
            _x.displayName = displayName;
            _x.gracePeriodEndDateTime = gracePeriodEndDateTime;
            _x.imageDisplayName = imageDisplayName;
            _x.lastLoginResult = lastLoginResult;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.lastRemoteActionResult = lastRemoteActionResult;
            _x.managedDeviceId = managedDeviceId;
            _x.managedDeviceName = managedDeviceName;
            _x.onPremisesConnectionName = onPremisesConnectionName;
            _x.osVersion = osVersion;
            _x.provisioningPolicyId = provisioningPolicyId;
            _x.provisioningPolicyName = provisioningPolicyName;
            _x.servicePlanId = servicePlanId;
            _x.servicePlanName = servicePlanName;
            _x.servicePlanType = servicePlanType;
            _x.status = status;
            _x.statusDetails = statusDetails;
            _x.userAccountType = userAccountType;
            _x.userPrincipalName = userPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="aadDeviceId")
    @JsonIgnore
    public Optional<String> getAadDeviceId() {
        return Optional.ofNullable(aadDeviceId);
    }

    public CloudPC withAadDeviceId(String aadDeviceId) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("aadDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.aadDeviceId = aadDeviceId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public CloudPC withDisplayName(String displayName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="gracePeriodEndDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getGracePeriodEndDateTime() {
        return Optional.ofNullable(gracePeriodEndDateTime);
    }

    public CloudPC withGracePeriodEndDateTime(OffsetDateTime gracePeriodEndDateTime) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("gracePeriodEndDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.gracePeriodEndDateTime = gracePeriodEndDateTime;
        return _x;
    }

    @Property(name="imageDisplayName")
    @JsonIgnore
    public Optional<String> getImageDisplayName() {
        return Optional.ofNullable(imageDisplayName);
    }

    public CloudPC withImageDisplayName(String imageDisplayName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("imageDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.imageDisplayName = imageDisplayName;
        return _x;
    }

    @Property(name="lastLoginResult")
    @JsonIgnore
    public Optional<CloudPcLoginResult> getLastLoginResult() {
        return Optional.ofNullable(lastLoginResult);
    }

    public CloudPC withLastLoginResult(CloudPcLoginResult lastLoginResult) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("lastLoginResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.lastLoginResult = lastLoginResult;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public CloudPC withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="lastRemoteActionResult")
    @JsonIgnore
    public Optional<CloudPcRemoteActionResult> getLastRemoteActionResult() {
        return Optional.ofNullable(lastRemoteActionResult);
    }

    public CloudPC withLastRemoteActionResult(CloudPcRemoteActionResult lastRemoteActionResult) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("lastRemoteActionResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.lastRemoteActionResult = lastRemoteActionResult;
        return _x;
    }

    @Property(name="managedDeviceId")
    @JsonIgnore
    public Optional<String> getManagedDeviceId() {
        return Optional.ofNullable(managedDeviceId);
    }

    public CloudPC withManagedDeviceId(String managedDeviceId) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.managedDeviceId = managedDeviceId;
        return _x;
    }

    @Property(name="managedDeviceName")
    @JsonIgnore
    public Optional<String> getManagedDeviceName() {
        return Optional.ofNullable(managedDeviceName);
    }

    public CloudPC withManagedDeviceName(String managedDeviceName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.managedDeviceName = managedDeviceName;
        return _x;
    }

    @Property(name="onPremisesConnectionName")
    @JsonIgnore
    public Optional<String> getOnPremisesConnectionName() {
        return Optional.ofNullable(onPremisesConnectionName);
    }

    public CloudPC withOnPremisesConnectionName(String onPremisesConnectionName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("onPremisesConnectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.onPremisesConnectionName = onPremisesConnectionName;
        return _x;
    }

    @Property(name="osVersion")
    @JsonIgnore
    public Optional<CloudPcOperatingSystem> getOsVersion() {
        return Optional.ofNullable(osVersion);
    }

    public CloudPC withOsVersion(CloudPcOperatingSystem osVersion) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("osVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.osVersion = osVersion;
        return _x;
    }

    @Property(name="provisioningPolicyId")
    @JsonIgnore
    public Optional<String> getProvisioningPolicyId() {
        return Optional.ofNullable(provisioningPolicyId);
    }

    public CloudPC withProvisioningPolicyId(String provisioningPolicyId) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("provisioningPolicyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.provisioningPolicyId = provisioningPolicyId;
        return _x;
    }

    @Property(name="provisioningPolicyName")
    @JsonIgnore
    public Optional<String> getProvisioningPolicyName() {
        return Optional.ofNullable(provisioningPolicyName);
    }

    public CloudPC withProvisioningPolicyName(String provisioningPolicyName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("provisioningPolicyName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.provisioningPolicyName = provisioningPolicyName;
        return _x;
    }

    @Property(name="servicePlanId")
    @JsonIgnore
    public Optional<String> getServicePlanId() {
        return Optional.ofNullable(servicePlanId);
    }

    public CloudPC withServicePlanId(String servicePlanId) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("servicePlanId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.servicePlanId = servicePlanId;
        return _x;
    }

    @Property(name="servicePlanName")
    @JsonIgnore
    public Optional<String> getServicePlanName() {
        return Optional.ofNullable(servicePlanName);
    }

    public CloudPC withServicePlanName(String servicePlanName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("servicePlanName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.servicePlanName = servicePlanName;
        return _x;
    }

    @Property(name="servicePlanType")
    @JsonIgnore
    public Optional<CloudPcServicePlanType> getServicePlanType() {
        return Optional.ofNullable(servicePlanType);
    }

    public CloudPC withServicePlanType(CloudPcServicePlanType servicePlanType) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("servicePlanType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.servicePlanType = servicePlanType;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<CloudPcStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public CloudPC withStatus(CloudPcStatus status) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.status = status;
        return _x;
    }

    @Property(name="statusDetails")
    @JsonIgnore
    public Optional<CloudPcStatusDetails> getStatusDetails() {
        return Optional.ofNullable(statusDetails);
    }

    public CloudPC withStatusDetails(CloudPcStatusDetails statusDetails) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("statusDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.statusDetails = statusDetails;
        return _x;
    }

    @Property(name="userAccountType")
    @JsonIgnore
    public Optional<CloudPcUserAccountType> getUserAccountType() {
        return Optional.ofNullable(userAccountType);
    }

    public CloudPC withUserAccountType(CloudPcUserAccountType userAccountType) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("userAccountType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.userAccountType = userAccountType;
        return _x;
    }

    @Property(name="userPrincipalName")
    @JsonIgnore
    public Optional<String> getUserPrincipalName() {
        return Optional.ofNullable(userPrincipalName);
    }

    public CloudPC withUserPrincipalName(String userPrincipalName) {
        CloudPC _x = _copy();
        _x.changedFields = changedFields.add("userPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cloudPC");
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    public CloudPC withUnmappedField(String name, Object value) {
        CloudPC _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPC patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CloudPC _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CloudPC put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CloudPC _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CloudPC _copy() {
        CloudPC _x = new CloudPC();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.aadDeviceId = aadDeviceId;
        _x.displayName = displayName;
        _x.gracePeriodEndDateTime = gracePeriodEndDateTime;
        _x.imageDisplayName = imageDisplayName;
        _x.lastLoginResult = lastLoginResult;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.lastRemoteActionResult = lastRemoteActionResult;
        _x.managedDeviceId = managedDeviceId;
        _x.managedDeviceName = managedDeviceName;
        _x.onPremisesConnectionName = onPremisesConnectionName;
        _x.osVersion = osVersion;
        _x.provisioningPolicyId = provisioningPolicyId;
        _x.provisioningPolicyName = provisioningPolicyName;
        _x.servicePlanId = servicePlanId;
        _x.servicePlanName = servicePlanName;
        _x.servicePlanType = servicePlanType;
        _x.status = status;
        _x.statusDetails = statusDetails;
        _x.userAccountType = userAccountType;
        _x.userPrincipalName = userPrincipalName;
        return _x;
    }

    @Action(name = "changeUserAccountType")
    @JsonIgnore
    public ActionRequestNoReturn changeUserAccountType(CloudPcUserAccountType userAccountType) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userAccountType", "microsoft.graph.cloudPcUserAccountType", userAccountType)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.changeUserAccountType"), _parameters);
    }

    @Action(name = "endGracePeriod")
    @JsonIgnore
    public ActionRequestNoReturn endGracePeriod() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.endGracePeriod"), _parameters);
    }

    @Action(name = "reboot")
    @JsonIgnore
    public ActionRequestNoReturn reboot() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reboot"), _parameters);
    }

    @Action(name = "rename")
    @JsonIgnore
    public ActionRequestNoReturn rename(String displayName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("displayName", "Edm.String", Checks.checkIsAscii(displayName))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.rename"), _parameters);
    }

    @Action(name = "reprovision")
    @JsonIgnore
    public ActionRequestNoReturn reprovision(CloudPcUserAccountType userAccountType, CloudPcOperatingSystem osVersion) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userAccountType", "microsoft.graph.cloudPcUserAccountType", userAccountType)
            .put("osVersion", "microsoft.graph.cloudPcOperatingSystem", osVersion)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.reprovision"), _parameters);
    }

    @Action(name = "troubleshoot")
    @JsonIgnore
    public ActionRequestNoReturn troubleshoot() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.troubleshoot"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CloudPC[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("aadDeviceId=");
        b.append(this.aadDeviceId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("gracePeriodEndDateTime=");
        b.append(this.gracePeriodEndDateTime);
        b.append(", ");
        b.append("imageDisplayName=");
        b.append(this.imageDisplayName);
        b.append(", ");
        b.append("lastLoginResult=");
        b.append(this.lastLoginResult);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("lastRemoteActionResult=");
        b.append(this.lastRemoteActionResult);
        b.append(", ");
        b.append("managedDeviceId=");
        b.append(this.managedDeviceId);
        b.append(", ");
        b.append("managedDeviceName=");
        b.append(this.managedDeviceName);
        b.append(", ");
        b.append("onPremisesConnectionName=");
        b.append(this.onPremisesConnectionName);
        b.append(", ");
        b.append("osVersion=");
        b.append(this.osVersion);
        b.append(", ");
        b.append("provisioningPolicyId=");
        b.append(this.provisioningPolicyId);
        b.append(", ");
        b.append("provisioningPolicyName=");
        b.append(this.provisioningPolicyName);
        b.append(", ");
        b.append("servicePlanId=");
        b.append(this.servicePlanId);
        b.append(", ");
        b.append("servicePlanName=");
        b.append(this.servicePlanName);
        b.append(", ");
        b.append("servicePlanType=");
        b.append(this.servicePlanType);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("statusDetails=");
        b.append(this.statusDetails);
        b.append(", ");
        b.append("userAccountType=");
        b.append(this.userAccountType);
        b.append(", ");
        b.append("userPrincipalName=");
        b.append(this.userPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
