package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Double;
import java.lang.Float;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.DevicePlatformType;


/**
 * <i>“Contains the information to define a circular geo-fence management condition, an
 * area of interest, to monitor.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "latitude", 
    "longitude", 
    "radiusInMeters"})
@JsonInclude(Include.NON_NULL)
public class CircularGeofenceManagementCondition extends LocationManagementCondition implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.circularGeofenceManagementCondition";
    }

    @JsonProperty("latitude")
    protected Double latitude;

    @JsonProperty("longitude")
    protected Double longitude;

    @JsonProperty("radiusInMeters")
    protected Float radiusInMeters;

    protected CircularGeofenceManagementCondition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCircularGeofenceManagementCondition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<DevicePlatformType> applicablePlatforms;
        private String applicablePlatformsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String eTag;
        private OffsetDateTime modifiedDateTime;
        private String uniqueName;
        private Double latitude;
        private Double longitude;
        private Float radiusInMeters;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder applicablePlatforms(List<DevicePlatformType> applicablePlatforms) {
            this.applicablePlatforms = applicablePlatforms;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        public Builder applicablePlatforms(DevicePlatformType... applicablePlatforms) {
            return applicablePlatforms(Arrays.asList(applicablePlatforms));
        }

        public Builder applicablePlatformsNextLink(String applicablePlatformsNextLink) {
            this.applicablePlatformsNextLink = applicablePlatformsNextLink;
            this.changedFields = changedFields.add("applicablePlatforms");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder eTag(String eTag) {
            this.eTag = eTag;
            this.changedFields = changedFields.add("eTag");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = changedFields.add("uniqueName");
            return this;
        }

        /**
         * <i>“Latitude in degrees, between -90 and +90 inclusive.”</i>
         * 
         * @param latitude
         *            value of {@code latitude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder latitude(Double latitude) {
            this.latitude = latitude;
            this.changedFields = changedFields.add("latitude");
            return this;
        }

        /**
         * <i>“Longitude in degrees, between -180 and +180 inclusive.”</i>
         * 
         * @param longitude
         *            value of {@code longitude} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder longitude(Double longitude) {
            this.longitude = longitude;
            this.changedFields = changedFields.add("longitude");
            return this;
        }

        /**
         * <i>“Radius in meters.”</i>
         * 
         * @param radiusInMeters
         *            value of {@code radiusInMeters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder radiusInMeters(Float radiusInMeters) {
            this.radiusInMeters = radiusInMeters;
            this.changedFields = changedFields.add("radiusInMeters");
            return this;
        }

        public CircularGeofenceManagementCondition build() {
            CircularGeofenceManagementCondition _x = new CircularGeofenceManagementCondition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.circularGeofenceManagementCondition";
            _x.id = id;
            _x.applicablePlatforms = applicablePlatforms;
            _x.applicablePlatformsNextLink = applicablePlatformsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.eTag = eTag;
            _x.modifiedDateTime = modifiedDateTime;
            _x.uniqueName = uniqueName;
            _x.latitude = latitude;
            _x.longitude = longitude;
            _x.radiusInMeters = radiusInMeters;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Latitude in degrees, between -90 and +90 inclusive.”</i>
     * 
     * @return property latitude
     */
    @Property(name="latitude")
    @JsonIgnore
    public Optional<Double> getLatitude() {
        return Optional.ofNullable(latitude);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code latitude} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Latitude in degrees, between -90 and +90 inclusive.”</i>
     * 
     * @param latitude
     *            new value of {@code latitude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code latitude} field changed
     */
    public CircularGeofenceManagementCondition withLatitude(Double latitude) {
        CircularGeofenceManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("latitude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.circularGeofenceManagementCondition");
        _x.latitude = latitude;
        return _x;
    }

    /**
     * <i>“Longitude in degrees, between -180 and +180 inclusive.”</i>
     * 
     * @return property longitude
     */
    @Property(name="longitude")
    @JsonIgnore
    public Optional<Double> getLongitude() {
        return Optional.ofNullable(longitude);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code longitude} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Longitude in degrees, between -180 and +180 inclusive.”</i>
     * 
     * @param longitude
     *            new value of {@code longitude} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code longitude} field changed
     */
    public CircularGeofenceManagementCondition withLongitude(Double longitude) {
        CircularGeofenceManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("longitude");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.circularGeofenceManagementCondition");
        _x.longitude = longitude;
        return _x;
    }

    /**
     * <i>“Radius in meters.”</i>
     * 
     * @return property radiusInMeters
     */
    @Property(name="radiusInMeters")
    @JsonIgnore
    public Optional<Float> getRadiusInMeters() {
        return Optional.ofNullable(radiusInMeters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code radiusInMeters}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Radius in meters.”</i>
     * 
     * @param radiusInMeters
     *            new value of {@code radiusInMeters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code radiusInMeters} field changed
     */
    public CircularGeofenceManagementCondition withRadiusInMeters(Float radiusInMeters) {
        CircularGeofenceManagementCondition _x = _copy();
        _x.changedFields = changedFields.add("radiusInMeters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.circularGeofenceManagementCondition");
        _x.radiusInMeters = radiusInMeters;
        return _x;
    }

    public CircularGeofenceManagementCondition withUnmappedField(String name, Object value) {
        CircularGeofenceManagementCondition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CircularGeofenceManagementCondition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CircularGeofenceManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CircularGeofenceManagementCondition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CircularGeofenceManagementCondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CircularGeofenceManagementCondition _copy() {
        CircularGeofenceManagementCondition _x = new CircularGeofenceManagementCondition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.applicablePlatforms = applicablePlatforms;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.eTag = eTag;
        _x.modifiedDateTime = modifiedDateTime;
        _x.uniqueName = uniqueName;
        _x.latitude = latitude;
        _x.longitude = longitude;
        _x.radiusInMeters = radiusInMeters;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CircularGeofenceManagementCondition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("applicablePlatforms=");
        b.append(this.applicablePlatforms);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("eTag=");
        b.append(this.eTag);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("uniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("latitude=");
        b.append(this.latitude);
        b.append(", ");
        b.append("longitude=");
        b.append(this.longitude);
        b.append(", ");
        b.append("radiusInMeters=");
        b.append(this.radiusInMeters);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
