package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.enums.OnboardingStatus;


/**
 * <i>“Entity that represents a Chromebook tenant settings”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "lastDirectorySyncDateTime", 
    "lastModifiedDateTime", 
    "onboardingStatus", 
    "ownerUserPrincipalName"})
@JsonInclude(Include.NON_NULL)
public class ChromeOSOnboardingSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.chromeOSOnboardingSettings";
    }

    @JsonProperty("lastDirectorySyncDateTime")
    protected OffsetDateTime lastDirectorySyncDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("onboardingStatus")
    protected OnboardingStatus onboardingStatus;

    @JsonProperty("ownerUserPrincipalName")
    protected String ownerUserPrincipalName;

    protected ChromeOSOnboardingSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChromeOSOnboardingSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastDirectorySyncDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OnboardingStatus onboardingStatus;
        private String ownerUserPrincipalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The ChromebookTenant's LastDirectorySyncDateTime”</i>
         * 
         * @param lastDirectorySyncDateTime
         *            value of {@code lastDirectorySyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastDirectorySyncDateTime(OffsetDateTime lastDirectorySyncDateTime) {
            this.lastDirectorySyncDateTime = lastDirectorySyncDateTime;
            this.changedFields = changedFields.add("lastDirectorySyncDateTime");
            return this;
        }

        /**
         * <i>“The ChromebookTenant's LastModifiedDateTime”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The ChromebookTenant's OnboardingStatus”</i>
         * 
         * @param onboardingStatus
         *            value of {@code onboardingStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onboardingStatus(OnboardingStatus onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            this.changedFields = changedFields.add("onboardingStatus");
            return this;
        }

        /**
         * <i>“The ChromebookTenant's OwnerUserPrincipalName”</i>
         * 
         * @param ownerUserPrincipalName
         *            value of {@code ownerUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerUserPrincipalName(String ownerUserPrincipalName) {
            this.ownerUserPrincipalName = ownerUserPrincipalName;
            this.changedFields = changedFields.add("ownerUserPrincipalName");
            return this;
        }

        public ChromeOSOnboardingSettings build() {
            ChromeOSOnboardingSettings _x = new ChromeOSOnboardingSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.chromeOSOnboardingSettings";
            _x.id = id;
            _x.lastDirectorySyncDateTime = lastDirectorySyncDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.onboardingStatus = onboardingStatus;
            _x.ownerUserPrincipalName = ownerUserPrincipalName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“The ChromebookTenant's LastDirectorySyncDateTime”</i>
     * 
     * @return property lastDirectorySyncDateTime
     */
    @Property(name="lastDirectorySyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastDirectorySyncDateTime() {
        return Optional.ofNullable(lastDirectorySyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastDirectorySyncDateTime} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The ChromebookTenant's LastDirectorySyncDateTime”</i>
     * 
     * @param lastDirectorySyncDateTime
     *            new value of {@code lastDirectorySyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastDirectorySyncDateTime} field changed
     */
    public ChromeOSOnboardingSettings withLastDirectorySyncDateTime(OffsetDateTime lastDirectorySyncDateTime) {
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = changedFields.add("lastDirectorySyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSOnboardingSettings");
        _x.lastDirectorySyncDateTime = lastDirectorySyncDateTime;
        return _x;
    }

    /**
     * <i>“The ChromebookTenant's LastModifiedDateTime”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The ChromebookTenant's LastModifiedDateTime”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ChromeOSOnboardingSettings withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSOnboardingSettings");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The ChromebookTenant's OnboardingStatus”</i>
     * 
     * @return property onboardingStatus
     */
    @Property(name="onboardingStatus")
    @JsonIgnore
    public Optional<OnboardingStatus> getOnboardingStatus() {
        return Optional.ofNullable(onboardingStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code onboardingStatus}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The ChromebookTenant's OnboardingStatus”</i>
     * 
     * @param onboardingStatus
     *            new value of {@code onboardingStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onboardingStatus} field changed
     */
    public ChromeOSOnboardingSettings withOnboardingStatus(OnboardingStatus onboardingStatus) {
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = changedFields.add("onboardingStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSOnboardingSettings");
        _x.onboardingStatus = onboardingStatus;
        return _x;
    }

    /**
     * <i>“The ChromebookTenant's OwnerUserPrincipalName”</i>
     * 
     * @return property ownerUserPrincipalName
     */
    @Property(name="ownerUserPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerUserPrincipalName() {
        return Optional.ofNullable(ownerUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ownerUserPrincipalName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The ChromebookTenant's OwnerUserPrincipalName”</i>
     * 
     * @param ownerUserPrincipalName
     *            new value of {@code ownerUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerUserPrincipalName} field changed
     */
    public ChromeOSOnboardingSettings withOwnerUserPrincipalName(String ownerUserPrincipalName) {
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = changedFields.add("ownerUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.chromeOSOnboardingSettings");
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        return _x;
    }

    public ChromeOSOnboardingSettings withUnmappedField(String name, Object value) {
        ChromeOSOnboardingSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChromeOSOnboardingSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ChromeOSOnboardingSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ChromeOSOnboardingSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ChromeOSOnboardingSettings _copy() {
        ChromeOSOnboardingSettings _x = new ChromeOSOnboardingSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.lastDirectorySyncDateTime = lastDirectorySyncDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.onboardingStatus = onboardingStatus;
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChromeOSOnboardingSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastDirectorySyncDateTime=");
        b.append(this.lastDirectorySyncDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("onboardingStatus=");
        b.append(this.onboardingStatus);
        b.append(", ");
        b.append("ownerUserPrincipalName=");
        b.append(this.ownerUserPrincipalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
