package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ChannelModerationSettings;
import odata.msgraph.client.beta.complex.ProvisionChannelEmailResult;
import odata.msgraph.client.beta.entity.collection.request.ChatMessageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ConversationMemberCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TeamsTabCollectionRequest;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.enums.ChannelMembershipType;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "description", 
    "displayName", 
    "email", 
    "isFavoriteByDefault", 
    "membershipType", 
    "moderationSettings", 
    "webUrl", 
    "filesFolder", 
    "members", 
    "messages", 
    "tabs"})
@JsonInclude(Include.NON_NULL)
public class Channel extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.channel";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("isFavoriteByDefault")
    protected Boolean isFavoriteByDefault;

    @JsonProperty("membershipType")
    protected ChannelMembershipType membershipType;

    @JsonProperty("moderationSettings")
    protected ChannelModerationSettings moderationSettings;

    @JsonProperty("webUrl")
    protected String webUrl;

    @JsonProperty("filesFolder")
    protected DriveItem filesFolder;

    @JsonProperty("members")
    protected List<ConversationMember> members;

    @JsonProperty("messages")
    protected List<ChatMessage> messages;

    @JsonProperty("tabs")
    protected List<TeamsTab> tabs;

    protected Channel() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderChannel() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private String email;
        private Boolean isFavoriteByDefault;
        private ChannelMembershipType membershipType;
        private ChannelModerationSettings moderationSettings;
        private String webUrl;
        private DriveItem filesFolder;
        private List<ConversationMember> members;
        private List<ChatMessage> messages;
        private List<TeamsTab> tabs;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder isFavoriteByDefault(Boolean isFavoriteByDefault) {
            this.isFavoriteByDefault = isFavoriteByDefault;
            this.changedFields = changedFields.add("isFavoriteByDefault");
            return this;
        }

        public Builder membershipType(ChannelMembershipType membershipType) {
            this.membershipType = membershipType;
            this.changedFields = changedFields.add("membershipType");
            return this;
        }

        public Builder moderationSettings(ChannelModerationSettings moderationSettings) {
            this.moderationSettings = moderationSettings;
            this.changedFields = changedFields.add("moderationSettings");
            return this;
        }

        public Builder webUrl(String webUrl) {
            this.webUrl = webUrl;
            this.changedFields = changedFields.add("webUrl");
            return this;
        }

        public Builder filesFolder(DriveItem filesFolder) {
            this.filesFolder = filesFolder;
            this.changedFields = changedFields.add("filesFolder");
            return this;
        }

        public Builder members(List<ConversationMember> members) {
            this.members = members;
            this.changedFields = changedFields.add("members");
            return this;
        }

        public Builder members(ConversationMember... members) {
            return members(Arrays.asList(members));
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(List<ChatMessage> messages) {
            this.messages = messages;
            this.changedFields = changedFields.add("messages");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
         * <p>
         * Supported = true
         * 
         * @param messages
         *            value of {@code messages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder messages(ChatMessage... messages) {
            return messages(Arrays.asList(messages));
        }

        public Builder tabs(List<TeamsTab> tabs) {
            this.tabs = tabs;
            this.changedFields = changedFields.add("tabs");
            return this;
        }

        public Builder tabs(TeamsTab... tabs) {
            return tabs(Arrays.asList(tabs));
        }

        public Channel build() {
            Channel _x = new Channel();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.channel";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.email = email;
            _x.isFavoriteByDefault = isFavoriteByDefault;
            _x.membershipType = membershipType;
            _x.moderationSettings = moderationSettings;
            _x.webUrl = webUrl;
            _x.filesFolder = filesFolder;
            _x.members = members;
            _x.messages = messages;
            _x.tabs = tabs;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Channel withCreatedDateTime(OffsetDateTime createdDateTime) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Channel withDescription(String description) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.description = description;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Channel withDisplayName(String displayName) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public Channel withEmail(String email) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.email = email;
        return _x;
    }

    @Property(name="isFavoriteByDefault")
    @JsonIgnore
    public Optional<Boolean> getIsFavoriteByDefault() {
        return Optional.ofNullable(isFavoriteByDefault);
    }

    public Channel withIsFavoriteByDefault(Boolean isFavoriteByDefault) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("isFavoriteByDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.isFavoriteByDefault = isFavoriteByDefault;
        return _x;
    }

    @Property(name="membershipType")
    @JsonIgnore
    public Optional<ChannelMembershipType> getMembershipType() {
        return Optional.ofNullable(membershipType);
    }

    public Channel withMembershipType(ChannelMembershipType membershipType) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("membershipType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.membershipType = membershipType;
        return _x;
    }

    @Property(name="moderationSettings")
    @JsonIgnore
    public Optional<ChannelModerationSettings> getModerationSettings() {
        return Optional.ofNullable(moderationSettings);
    }

    public Channel withModerationSettings(ChannelModerationSettings moderationSettings) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("moderationSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.moderationSettings = moderationSettings;
        return _x;
    }

    @Property(name="webUrl")
    @JsonIgnore
    public Optional<String> getWebUrl() {
        return Optional.ofNullable(webUrl);
    }

    public Channel withWebUrl(String webUrl) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("webUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.webUrl = webUrl;
        return _x;
    }

    public Channel withUnmappedField(String name, Object value) {
        Channel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="filesFolder")
    @JsonIgnore
    public DriveItemRequest getFilesFolder() {
        return new DriveItemRequest(contextPath.addSegment("filesFolder"), Optional.ofNullable(filesFolder));
    }

    @NavigationProperty(name="members")
    @JsonIgnore
    public ConversationMemberCollectionRequest getMembers() {
        return new ConversationMemberCollectionRequest(
                        contextPath.addSegment("members"), Optional.ofNullable(members));
    }

    /**
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @return navigational property messages
     */
    @NavigationProperty(name="messages")
    @JsonIgnore
    public ChatMessageCollectionRequest getMessages() {
        return new ChatMessageCollectionRequest(
                        contextPath.addSegment("messages"), Optional.ofNullable(messages));
    }

    @NavigationProperty(name="tabs")
    @JsonIgnore
    public TeamsTabCollectionRequest getTabs() {
        return new TeamsTabCollectionRequest(
                        contextPath.addSegment("tabs"), Optional.ofNullable(tabs));
    }

    public Channel withFilesFolder(DriveItem filesFolder) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("filesFolder");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.filesFolder = filesFolder;
        return _x;
    }

    public Channel withMembers(List<ConversationMember> members) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("members");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.members = members;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code messages} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
     * <p>
     * Supported = true
     * 
     * @param messages
     *            new value of {@code messages} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code messages} field changed
     */
    public Channel withMessages(List<ChatMessage> messages) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("messages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.messages = messages;
        return _x;
    }

    public Channel withTabs(List<TeamsTab> tabs) {
        Channel _x = _copy();
        _x.changedFields = changedFields.add("tabs");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.channel");
        _x.tabs = tabs;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channel patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Channel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Channel put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Channel _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Channel _copy() {
        Channel _x = new Channel();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.email = email;
        _x.isFavoriteByDefault = isFavoriteByDefault;
        _x.membershipType = membershipType;
        _x.moderationSettings = moderationSettings;
        _x.webUrl = webUrl;
        _x.filesFolder = filesFolder;
        _x.members = members;
        _x.messages = messages;
        _x.tabs = tabs;
        return _x;
    }

    @Action(name = "completeMigration")
    @JsonIgnore
    public ActionRequestNoReturn completeMigration() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeMigration"), _parameters);
    }

    @Action(name = "provisionEmail")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<ProvisionChannelEmailResult> provisionEmail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<ProvisionChannelEmailResult>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.provisionEmail"), ProvisionChannelEmailResult.class, _parameters);
    }

    @Action(name = "removeEmail")
    @JsonIgnore
    public ActionRequestNoReturn removeEmail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeEmail"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Channel[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("isFavoriteByDefault=");
        b.append(this.isFavoriteByDefault);
        b.append(", ");
        b.append("membershipType=");
        b.append(this.membershipType);
        b.append(", ");
        b.append("moderationSettings=");
        b.append(this.moderationSettings);
        b.append(", ");
        b.append("webUrl=");
        b.append(this.webUrl);
        b.append(", ");
        b.append("filesFolder=");
        b.append(this.filesFolder);
        b.append(", ");
        b.append("members=");
        b.append(this.members);
        b.append(", ");
        b.append("messages=");
        b.append(this.messages);
        b.append(", ");
        b.append("tabs=");
        b.append(this.tabs);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
