package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CertificateConnectorHealthMetricValue;
import odata.msgraph.client.beta.complex.KeyLongValuePair;
import odata.msgraph.client.beta.complex.TimeSeriesParameter;


/**
 * <i>“Entity used to retrieve information about Intune Certificate Connectors.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectorName", 
    "enrollmentDateTime", 
    "lastCheckinDateTime", 
    "machineName"})
@JsonInclude(Include.NON_NULL)
public class CertificateConnectorDetails extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.certificateConnectorDetails";
    }

    @JsonProperty("connectorName")
    protected String connectorName;

    @JsonProperty("enrollmentDateTime")
    protected OffsetDateTime enrollmentDateTime;

    @JsonProperty("lastCheckinDateTime")
    protected OffsetDateTime lastCheckinDateTime;

    @JsonProperty("machineName")
    protected String machineName;

    protected CertificateConnectorDetails() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCertificateConnectorDetails() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String connectorName;
        private OffsetDateTime enrollmentDateTime;
        private OffsetDateTime lastCheckinDateTime;
        private String machineName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Connector name (set during enrollment).”</i>
         * 
         * @param connectorName
         *            value of {@code connectorName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectorName(String connectorName) {
            this.connectorName = connectorName;
            this.changedFields = changedFields.add("connectorName");
            return this;
        }

        /**
         * <i>“Date/time when this connector was enrolled.”</i>
         * 
         * @param enrollmentDateTime
         *            value of {@code enrollmentDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentDateTime(OffsetDateTime enrollmentDateTime) {
            this.enrollmentDateTime = enrollmentDateTime;
            this.changedFields = changedFields.add("enrollmentDateTime");
            return this;
        }

        /**
         * <i>“Date/time when this connector last connected to the service.”</i>
         * 
         * @param lastCheckinDateTime
         *            value of {@code lastCheckinDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
            this.lastCheckinDateTime = lastCheckinDateTime;
            this.changedFields = changedFields.add("lastCheckinDateTime");
            return this;
        }

        /**
         * <i>“Name of the machine hosting this connector service.”</i>
         * 
         * @param machineName
         *            value of {@code machineName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder machineName(String machineName) {
            this.machineName = machineName;
            this.changedFields = changedFields.add("machineName");
            return this;
        }

        public CertificateConnectorDetails build() {
            CertificateConnectorDetails _x = new CertificateConnectorDetails();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.certificateConnectorDetails";
            _x.id = id;
            _x.connectorName = connectorName;
            _x.enrollmentDateTime = enrollmentDateTime;
            _x.lastCheckinDateTime = lastCheckinDateTime;
            _x.machineName = machineName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Connector name (set during enrollment).”</i>
     * 
     * @return property connectorName
     */
    @Property(name="connectorName")
    @JsonIgnore
    public Optional<String> getConnectorName() {
        return Optional.ofNullable(connectorName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectorName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connector name (set during enrollment).”</i>
     * 
     * @param connectorName
     *            new value of {@code connectorName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectorName} field changed
     */
    public CertificateConnectorDetails withConnectorName(String connectorName) {
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = changedFields.add("connectorName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorDetails");
        _x.connectorName = connectorName;
        return _x;
    }

    /**
     * <i>“Date/time when this connector was enrolled.”</i>
     * 
     * @return property enrollmentDateTime
     */
    @Property(name="enrollmentDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnrollmentDateTime() {
        return Optional.ofNullable(enrollmentDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrollmentDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Date/time when this connector was enrolled.”</i>
     * 
     * @param enrollmentDateTime
     *            new value of {@code enrollmentDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentDateTime} field changed
     */
    public CertificateConnectorDetails withEnrollmentDateTime(OffsetDateTime enrollmentDateTime) {
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = changedFields.add("enrollmentDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorDetails");
        _x.enrollmentDateTime = enrollmentDateTime;
        return _x;
    }

    /**
     * <i>“Date/time when this connector last connected to the service.”</i>
     * 
     * @return property lastCheckinDateTime
     */
    @Property(name="lastCheckinDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastCheckinDateTime() {
        return Optional.ofNullable(lastCheckinDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastCheckinDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Date/time when this connector last connected to the service.”</i>
     * 
     * @param lastCheckinDateTime
     *            new value of {@code lastCheckinDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastCheckinDateTime} field changed
     */
    public CertificateConnectorDetails withLastCheckinDateTime(OffsetDateTime lastCheckinDateTime) {
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = changedFields.add("lastCheckinDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorDetails");
        _x.lastCheckinDateTime = lastCheckinDateTime;
        return _x;
    }

    /**
     * <i>“Name of the machine hosting this connector service.”</i>
     * 
     * @return property machineName
     */
    @Property(name="machineName")
    @JsonIgnore
    public Optional<String> getMachineName() {
        return Optional.ofNullable(machineName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code machineName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Name of the machine hosting this connector service.”</i>
     * 
     * @param machineName
     *            new value of {@code machineName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code machineName} field changed
     */
    public CertificateConnectorDetails withMachineName(String machineName) {
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = changedFields.add("machineName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.certificateConnectorDetails");
        _x.machineName = machineName;
        return _x;
    }

    public CertificateConnectorDetails withUnmappedField(String name, Object value) {
        CertificateConnectorDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CertificateConnectorDetails patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CertificateConnectorDetails put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CertificateConnectorDetails _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CertificateConnectorDetails _copy() {
        CertificateConnectorDetails _x = new CertificateConnectorDetails();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.connectorName = connectorName;
        _x.enrollmentDateTime = enrollmentDateTime;
        _x.lastCheckinDateTime = lastCheckinDateTime;
        _x.machineName = machineName;
        return _x;
    }

    @Action(name = "getHealthMetrics")
    @JsonIgnore
    public CollectionPageNonEntityRequest<KeyLongValuePair> getHealthMetrics(List<String> metricNames) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("metricNames", "Collection(Edm.String)", Checks.checkIsAscii(metricNames))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetrics"), KeyLongValuePair.class, _parameters);
    }

    @Action(name = "getHealthMetricTimeSeries")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CertificateConnectorHealthMetricValue> getHealthMetricTimeSeries(TimeSeriesParameter timeSeries) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("timeSeries", "microsoft.graph.timeSeriesParameter", timeSeries)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getHealthMetricTimeSeries"), CertificateConnectorHealthMetricValue.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CertificateConnectorDetails[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("connectorName=");
        b.append(this.connectorName);
        b.append(", ");
        b.append("enrollmentDateTime=");
        b.append(this.enrollmentDateTime);
        b.append(", ");
        b.append("lastCheckinDateTime=");
        b.append(this.lastCheckinDateTime);
        b.append(", ");
        b.append("machineName=");
        b.append(this.machineName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
