package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;


/**
 * <i>“CartToClassAssociation for associating device carts with classrooms.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "classroomIds", 
    "createdDateTime", 
    "description", 
    "deviceCartIds", 
    "displayName", 
    "lastModifiedDateTime", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class CartToClassAssociation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.cartToClassAssociation";
    }

    @JsonProperty("classroomIds")
    protected List<String> classroomIds;

    @JsonProperty("classroomIds@nextLink")
    protected String classroomIdsNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("deviceCartIds")
    protected List<String> deviceCartIds;

    @JsonProperty("deviceCartIds@nextLink")
    protected String deviceCartIdsNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("version")
    protected Integer version;

    protected CartToClassAssociation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderCartToClassAssociation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> classroomIds;
        private String classroomIdsNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private List<String> deviceCartIds;
        private String deviceCartIdsNextLink;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private Integer version;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Identifiers of classrooms to be associated with device carts.”</i>
         * 
         * @param classroomIds
         *            value of {@code classroomIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomIds(List<String> classroomIds) {
            this.classroomIds = classroomIds;
            this.changedFields = changedFields.add("classroomIds");
            return this;
        }

        /**
         * <i>“Identifiers of classrooms to be associated with device carts.”</i>
         * 
         * @param classroomIds
         *            value of {@code classroomIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomIds(String... classroomIds) {
            return classroomIds(Arrays.asList(classroomIds));
        }

        /**
         * <i>“Identifiers of classrooms to be associated with device carts.”</i>
         * 
         * @param classroomIdsNextLink
         *            value of {@code classroomIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder classroomIdsNextLink(String classroomIdsNextLink) {
            this.classroomIdsNextLink = classroomIdsNextLink;
            this.changedFields = changedFields.add("classroomIds");
            return this;
        }

        /**
         * <i>“DateTime the object was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Admin provided description of the CartToClassAssociation.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“Identifiers of device carts to be associated with classes.”</i>
         * 
         * @param deviceCartIds
         *            value of {@code deviceCartIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCartIds(List<String> deviceCartIds) {
            this.deviceCartIds = deviceCartIds;
            this.changedFields = changedFields.add("deviceCartIds");
            return this;
        }

        /**
         * <i>“Identifiers of device carts to be associated with classes.”</i>
         * 
         * @param deviceCartIds
         *            value of {@code deviceCartIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCartIds(String... deviceCartIds) {
            return deviceCartIds(Arrays.asList(deviceCartIds));
        }

        /**
         * <i>“Identifiers of device carts to be associated with classes.”</i>
         * 
         * @param deviceCartIdsNextLink
         *            value of {@code deviceCartIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceCartIdsNextLink(String deviceCartIdsNextLink) {
            this.deviceCartIdsNextLink = deviceCartIdsNextLink;
            this.changedFields = changedFields.add("deviceCartIds");
            return this;
        }

        /**
         * <i>“Admin provided name of the device configuration.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“DateTime the object was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Version of the CartToClassAssociation.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public CartToClassAssociation build() {
            CartToClassAssociation _x = new CartToClassAssociation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.cartToClassAssociation";
            _x.id = id;
            _x.classroomIds = classroomIds;
            _x.classroomIdsNextLink = classroomIdsNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceCartIds = deviceCartIds;
            _x.deviceCartIdsNextLink = deviceCartIdsNextLink;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Identifiers of classrooms to be associated with device carts.”</i>
     * 
     * @return property classroomIds
     */
    @Property(name="classroomIds")
    @JsonIgnore
    public CollectionPage<String> getClassroomIds() {
        return new CollectionPage<String>(contextPath, String.class, this.classroomIds, Optional.ofNullable(classroomIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code classroomIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Identifiers of classrooms to be associated with device carts.”</i>
     * 
     * @param classroomIds
     *            new value of {@code classroomIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code classroomIds} field changed
     */
    public CartToClassAssociation withClassroomIds(List<String> classroomIds) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("classroomIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.classroomIds = classroomIds;
        return _x;
    }

    /**
     * <i>“Identifiers of classrooms to be associated with device carts.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property classroomIds
     */
    @Property(name="classroomIds")
    @JsonIgnore
    public CollectionPage<String> getClassroomIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.classroomIds, Optional.ofNullable(classroomIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“DateTime the object was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“DateTime the object was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public CartToClassAssociation withCreatedDateTime(OffsetDateTime createdDateTime) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Admin provided description of the CartToClassAssociation.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided description of the CartToClassAssociation.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public CartToClassAssociation withDescription(String description) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“Identifiers of device carts to be associated with classes.”</i>
     * 
     * @return property deviceCartIds
     */
    @Property(name="deviceCartIds")
    @JsonIgnore
    public CollectionPage<String> getDeviceCartIds() {
        return new CollectionPage<String>(contextPath, String.class, this.deviceCartIds, Optional.ofNullable(deviceCartIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deviceCartIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Identifiers of device carts to be associated with classes.”</i>
     * 
     * @param deviceCartIds
     *            new value of {@code deviceCartIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceCartIds} field changed
     */
    public CartToClassAssociation withDeviceCartIds(List<String> deviceCartIds) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("deviceCartIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.deviceCartIds = deviceCartIds;
        return _x;
    }

    /**
     * <i>“Identifiers of device carts to be associated with classes.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property deviceCartIds
     */
    @Property(name="deviceCartIds")
    @JsonIgnore
    public CollectionPage<String> getDeviceCartIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.deviceCartIds, Optional.ofNullable(deviceCartIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Admin provided name of the device configuration.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public CartToClassAssociation withDisplayName(String displayName) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“DateTime the object was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public CartToClassAssociation withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Version of the CartToClassAssociation.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<Integer> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Version of the CartToClassAssociation.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public CartToClassAssociation withVersion(Integer version) {
        CartToClassAssociation _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.cartToClassAssociation");
        _x.version = version;
        return _x;
    }

    public CartToClassAssociation withUnmappedField(String name, Object value) {
        CartToClassAssociation _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CartToClassAssociation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        CartToClassAssociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public CartToClassAssociation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        CartToClassAssociation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private CartToClassAssociation _copy() {
        CartToClassAssociation _x = new CartToClassAssociation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.classroomIds = classroomIds;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceCartIds = deviceCartIds;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CartToClassAssociation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("classroomIds=");
        b.append(this.classroomIds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceCartIds=");
        b.append(this.deviceCartIds);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
