package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "identityProviderType"})
@JsonInclude(Include.NON_NULL)
public class BuiltInIdentityProvider extends IdentityProviderBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.builtInIdentityProvider";
    }

    @JsonProperty("identityProviderType")
    protected String identityProviderType;

    protected BuiltInIdentityProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBuiltInIdentityProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String identityProviderType;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            this.changedFields = changedFields.add("identityProviderType");
            return this;
        }

        public BuiltInIdentityProvider build() {
            BuiltInIdentityProvider _x = new BuiltInIdentityProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.builtInIdentityProvider";
            _x.id = id;
            _x.displayName = displayName;
            _x.identityProviderType = identityProviderType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="identityProviderType")
    @JsonIgnore
    public Optional<String> getIdentityProviderType() {
        return Optional.ofNullable(identityProviderType);
    }

    public BuiltInIdentityProvider withIdentityProviderType(String identityProviderType) {
        BuiltInIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("identityProviderType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.builtInIdentityProvider");
        _x.identityProviderType = identityProviderType;
        return _x;
    }

    public BuiltInIdentityProvider withUnmappedField(String name, Object value) {
        BuiltInIdentityProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BuiltInIdentityProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BuiltInIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BuiltInIdentityProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BuiltInIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BuiltInIdentityProvider _copy() {
        BuiltInIdentityProvider _x = new BuiltInIdentityProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.identityProviderType = identityProviderType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BuiltInIdentityProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("identityProviderType=");
        b.append(this.identityProviderType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
