package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BookingWorkHours;
import odata.msgraph.client.beta.enums.BookingStaffRole;


/**
 * <i>“Represents a staff member who provides services in a business.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "availabilityIsAffectedByPersonalCalendar", 
    "colorIndex", 
    "role", 
    "timeZone", 
    "useBusinessHours", 
    "workingHours"})
@JsonInclude(Include.NON_NULL)
public class BookingStaffMember extends BookingPerson implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingStaffMember";
    }

    @JsonProperty("availabilityIsAffectedByPersonalCalendar")
    protected Boolean availabilityIsAffectedByPersonalCalendar;

    @JsonProperty("colorIndex")
    protected Integer colorIndex;

    @JsonProperty("role")
    protected BookingStaffRole role;

    @JsonProperty("timeZone")
    protected String timeZone;

    @JsonProperty("useBusinessHours")
    protected Boolean useBusinessHours;

    @JsonProperty("workingHours")
    protected List<BookingWorkHours> workingHours;

    @JsonProperty("workingHours@nextLink")
    protected String workingHoursNextLink;

    protected BookingStaffMember() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingStaffMember() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String emailAddress;
        private Boolean availabilityIsAffectedByPersonalCalendar;
        private Integer colorIndex;
        private BookingStaffRole role;
        private String timeZone;
        private Boolean useBusinessHours;
        private List<BookingWorkHours> workingHours;
        private String workingHoursNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder availabilityIsAffectedByPersonalCalendar(Boolean availabilityIsAffectedByPersonalCalendar) {
            this.availabilityIsAffectedByPersonalCalendar = availabilityIsAffectedByPersonalCalendar;
            this.changedFields = changedFields.add("availabilityIsAffectedByPersonalCalendar");
            return this;
        }

        public Builder colorIndex(Integer colorIndex) {
            this.colorIndex = colorIndex;
            this.changedFields = changedFields.add("colorIndex");
            return this;
        }

        public Builder role(BookingStaffRole role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            this.changedFields = changedFields.add("timeZone");
            return this;
        }

        public Builder useBusinessHours(Boolean useBusinessHours) {
            this.useBusinessHours = useBusinessHours;
            this.changedFields = changedFields.add("useBusinessHours");
            return this;
        }

        public Builder workingHours(List<BookingWorkHours> workingHours) {
            this.workingHours = workingHours;
            this.changedFields = changedFields.add("workingHours");
            return this;
        }

        public Builder workingHours(BookingWorkHours... workingHours) {
            return workingHours(Arrays.asList(workingHours));
        }

        public Builder workingHoursNextLink(String workingHoursNextLink) {
            this.workingHoursNextLink = workingHoursNextLink;
            this.changedFields = changedFields.add("workingHours");
            return this;
        }

        public BookingStaffMember build() {
            BookingStaffMember _x = new BookingStaffMember();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingStaffMember";
            _x.id = id;
            _x.displayName = displayName;
            _x.emailAddress = emailAddress;
            _x.availabilityIsAffectedByPersonalCalendar = availabilityIsAffectedByPersonalCalendar;
            _x.colorIndex = colorIndex;
            _x.role = role;
            _x.timeZone = timeZone;
            _x.useBusinessHours = useBusinessHours;
            _x.workingHours = workingHours;
            _x.workingHoursNextLink = workingHoursNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="availabilityIsAffectedByPersonalCalendar")
    @JsonIgnore
    public Optional<Boolean> getAvailabilityIsAffectedByPersonalCalendar() {
        return Optional.ofNullable(availabilityIsAffectedByPersonalCalendar);
    }

    public BookingStaffMember withAvailabilityIsAffectedByPersonalCalendar(Boolean availabilityIsAffectedByPersonalCalendar) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("availabilityIsAffectedByPersonalCalendar");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.availabilityIsAffectedByPersonalCalendar = availabilityIsAffectedByPersonalCalendar;
        return _x;
    }

    @Property(name="colorIndex")
    @JsonIgnore
    public Optional<Integer> getColorIndex() {
        return Optional.ofNullable(colorIndex);
    }

    public BookingStaffMember withColorIndex(Integer colorIndex) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("colorIndex");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.colorIndex = colorIndex;
        return _x;
    }

    @Property(name="role")
    @JsonIgnore
    public Optional<BookingStaffRole> getRole() {
        return Optional.ofNullable(role);
    }

    public BookingStaffMember withRole(BookingStaffRole role) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.role = role;
        return _x;
    }

    @Property(name="timeZone")
    @JsonIgnore
    public Optional<String> getTimeZone() {
        return Optional.ofNullable(timeZone);
    }

    public BookingStaffMember withTimeZone(String timeZone) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("timeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.timeZone = timeZone;
        return _x;
    }

    @Property(name="useBusinessHours")
    @JsonIgnore
    public Optional<Boolean> getUseBusinessHours() {
        return Optional.ofNullable(useBusinessHours);
    }

    public BookingStaffMember withUseBusinessHours(Boolean useBusinessHours) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("useBusinessHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.useBusinessHours = useBusinessHours;
        return _x;
    }

    @Property(name="workingHours")
    @JsonIgnore
    public CollectionPage<BookingWorkHours> getWorkingHours() {
        return new CollectionPage<BookingWorkHours>(contextPath, BookingWorkHours.class, this.workingHours, Optional.ofNullable(workingHoursNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingStaffMember withWorkingHours(List<BookingWorkHours> workingHours) {
        BookingStaffMember _x = _copy();
        _x.changedFields = changedFields.add("workingHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingStaffMember");
        _x.workingHours = workingHours;
        return _x;
    }

    @Property(name="workingHours")
    @JsonIgnore
    public CollectionPage<BookingWorkHours> getWorkingHours(HttpRequestOptions options) {
        return new CollectionPage<BookingWorkHours>(contextPath, BookingWorkHours.class, this.workingHours, Optional.ofNullable(workingHoursNextLink), Collections.emptyList(), options);
    }

    public BookingStaffMember withUnmappedField(String name, Object value) {
        BookingStaffMember _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingStaffMember patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingStaffMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingStaffMember put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingStaffMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingStaffMember _copy() {
        BookingStaffMember _x = new BookingStaffMember();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.emailAddress = emailAddress;
        _x.availabilityIsAffectedByPersonalCalendar = availabilityIsAffectedByPersonalCalendar;
        _x.colorIndex = colorIndex;
        _x.role = role;
        _x.timeZone = timeZone;
        _x.useBusinessHours = useBusinessHours;
        _x.workingHours = workingHours;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingStaffMember[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("availabilityIsAffectedByPersonalCalendar=");
        b.append(this.availabilityIsAffectedByPersonalCalendar);
        b.append(", ");
        b.append("colorIndex=");
        b.append(this.colorIndex);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("timeZone=");
        b.append(this.timeZone);
        b.append(", ");
        b.append("useBusinessHours=");
        b.append(this.useBusinessHours);
        b.append(", ");
        b.append("workingHours=");
        b.append(this.workingHours);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
