package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Phone;
import odata.msgraph.client.beta.complex.PhysicalAddress;


/**
 * <i>“Represents a customer of the business.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "addresses", 
    "phones"})
@JsonInclude(Include.NON_NULL)
public class BookingCustomer extends BookingPerson implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingCustomer";
    }

    @JsonProperty("addresses")
    protected List<PhysicalAddress> addresses;

    @JsonProperty("addresses@nextLink")
    protected String addressesNextLink;

    @JsonProperty("phones")
    protected List<Phone> phones;

    @JsonProperty("phones@nextLink")
    protected String phonesNextLink;

    protected BookingCustomer() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingCustomer() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String emailAddress;
        private List<PhysicalAddress> addresses;
        private String addressesNextLink;
        private List<Phone> phones;
        private String phonesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            this.changedFields = changedFields.add("emailAddress");
            return this;
        }

        public Builder addresses(List<PhysicalAddress> addresses) {
            this.addresses = addresses;
            this.changedFields = changedFields.add("addresses");
            return this;
        }

        public Builder addresses(PhysicalAddress... addresses) {
            return addresses(Arrays.asList(addresses));
        }

        public Builder addressesNextLink(String addressesNextLink) {
            this.addressesNextLink = addressesNextLink;
            this.changedFields = changedFields.add("addresses");
            return this;
        }

        public Builder phones(List<Phone> phones) {
            this.phones = phones;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public Builder phones(Phone... phones) {
            return phones(Arrays.asList(phones));
        }

        public Builder phonesNextLink(String phonesNextLink) {
            this.phonesNextLink = phonesNextLink;
            this.changedFields = changedFields.add("phones");
            return this;
        }

        public BookingCustomer build() {
            BookingCustomer _x = new BookingCustomer();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingCustomer";
            _x.id = id;
            _x.displayName = displayName;
            _x.emailAddress = emailAddress;
            _x.addresses = addresses;
            _x.addressesNextLink = addressesNextLink;
            _x.phones = phones;
            _x.phonesNextLink = phonesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="addresses")
    @JsonIgnore
    public CollectionPage<PhysicalAddress> getAddresses() {
        return new CollectionPage<PhysicalAddress>(contextPath, PhysicalAddress.class, this.addresses, Optional.ofNullable(addressesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingCustomer withAddresses(List<PhysicalAddress> addresses) {
        BookingCustomer _x = _copy();
        _x.changedFields = changedFields.add("addresses");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomer");
        _x.addresses = addresses;
        return _x;
    }

    @Property(name="addresses")
    @JsonIgnore
    public CollectionPage<PhysicalAddress> getAddresses(HttpRequestOptions options) {
        return new CollectionPage<PhysicalAddress>(contextPath, PhysicalAddress.class, this.addresses, Optional.ofNullable(addressesNextLink), Collections.emptyList(), options);
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones() {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingCustomer withPhones(List<Phone> phones) {
        BookingCustomer _x = _copy();
        _x.changedFields = changedFields.add("phones");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingCustomer");
        _x.phones = phones;
        return _x;
    }

    @Property(name="phones")
    @JsonIgnore
    public CollectionPage<Phone> getPhones(HttpRequestOptions options) {
        return new CollectionPage<Phone>(contextPath, Phone.class, this.phones, Optional.ofNullable(phonesNextLink), Collections.emptyList(), options);
    }

    public BookingCustomer withUnmappedField(String name, Object value) {
        BookingCustomer _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingCustomer patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingCustomer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingCustomer put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingCustomer _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingCustomer _copy() {
        BookingCustomer _x = new BookingCustomer();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.emailAddress = emailAddress;
        _x.addresses = addresses;
        _x.phones = phones;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingCustomer[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("emailAddress=");
        b.append(this.emailAddress);
        b.append(", ");
        b.append("addresses=");
        b.append(this.addresses);
        b.append(", ");
        b.append("phones=");
        b.append(this.phones);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
