package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BookingSchedulingPolicy;
import odata.msgraph.client.beta.complex.BookingWorkHours;
import odata.msgraph.client.beta.complex.PhysicalAddress;
import odata.msgraph.client.beta.entity.collection.request.BookingAppointmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingCustomQuestionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingCustomerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.BookingStaffMemberCollectionRequest;


/**
 * <i>“The bookingBusiness is the top level object which contains business information
 * and related business objects such as appointments, customers, services and staff
 * members.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "address", 
    "businessHours", 
    "businessType", 
    "defaultCurrencyIso", 
    "email", 
    "isPublished", 
    "phone", 
    "publicUrl", 
    "schedulingPolicy", 
    "webSiteUrl", 
    "appointments", 
    "calendarView", 
    "customers", 
    "customQuestions", 
    "services", 
    "staffMembers"})
@JsonInclude(Include.NON_NULL)
public class BookingBusiness extends BookingNamedEntity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingBusiness";
    }

    @JsonProperty("address")
    protected PhysicalAddress address;

    @JsonProperty("businessHours")
    protected List<BookingWorkHours> businessHours;

    @JsonProperty("businessHours@nextLink")
    protected String businessHoursNextLink;

    @JsonProperty("businessType")
    protected String businessType;

    @JsonProperty("defaultCurrencyIso")
    protected String defaultCurrencyIso;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("isPublished")
    protected Boolean isPublished;

    @JsonProperty("phone")
    protected String phone;

    @JsonProperty("publicUrl")
    protected String publicUrl;

    @JsonProperty("schedulingPolicy")
    protected BookingSchedulingPolicy schedulingPolicy;

    @JsonProperty("webSiteUrl")
    protected String webSiteUrl;

    @JsonProperty("appointments")
    protected List<BookingAppointment> appointments;

    @JsonProperty("calendarView")
    protected List<BookingAppointment> calendarView;

    @JsonProperty("customers")
    protected List<BookingCustomer> customers;

    @JsonProperty("customQuestions")
    protected List<BookingCustomQuestion> customQuestions;

    @JsonProperty("services")
    protected List<BookingService> services;

    @JsonProperty("staffMembers")
    protected List<BookingStaffMember> staffMembers;

    protected BookingBusiness() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingBusiness() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private PhysicalAddress address;
        private List<BookingWorkHours> businessHours;
        private String businessHoursNextLink;
        private String businessType;
        private String defaultCurrencyIso;
        private String email;
        private Boolean isPublished;
        private String phone;
        private String publicUrl;
        private BookingSchedulingPolicy schedulingPolicy;
        private String webSiteUrl;
        private List<BookingAppointment> appointments;
        private List<BookingAppointment> calendarView;
        private List<BookingCustomer> customers;
        private List<BookingCustomQuestion> customQuestions;
        private List<BookingService> services;
        private List<BookingStaffMember> staffMembers;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder address(PhysicalAddress address) {
            this.address = address;
            this.changedFields = changedFields.add("address");
            return this;
        }

        public Builder businessHours(List<BookingWorkHours> businessHours) {
            this.businessHours = businessHours;
            this.changedFields = changedFields.add("businessHours");
            return this;
        }

        public Builder businessHours(BookingWorkHours... businessHours) {
            return businessHours(Arrays.asList(businessHours));
        }

        public Builder businessHoursNextLink(String businessHoursNextLink) {
            this.businessHoursNextLink = businessHoursNextLink;
            this.changedFields = changedFields.add("businessHours");
            return this;
        }

        public Builder businessType(String businessType) {
            this.businessType = businessType;
            this.changedFields = changedFields.add("businessType");
            return this;
        }

        public Builder defaultCurrencyIso(String defaultCurrencyIso) {
            this.defaultCurrencyIso = defaultCurrencyIso;
            this.changedFields = changedFields.add("defaultCurrencyIso");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param isPublished
         *            value of {@code isPublished} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder isPublished(Boolean isPublished) {
            this.isPublished = isPublished;
            this.changedFields = changedFields.add("isPublished");
            return this;
        }

        public Builder phone(String phone) {
            this.phone = phone;
            this.changedFields = changedFields.add("phone");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param publicUrl
         *            value of {@code publicUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder publicUrl(String publicUrl) {
            this.publicUrl = publicUrl;
            this.changedFields = changedFields.add("publicUrl");
            return this;
        }

        public Builder schedulingPolicy(BookingSchedulingPolicy schedulingPolicy) {
            this.schedulingPolicy = schedulingPolicy;
            this.changedFields = changedFields.add("schedulingPolicy");
            return this;
        }

        /**
         * <i>“Example: https://www.contoso.com”</i>
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param webSiteUrl
         *            value of {@code webSiteUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder webSiteUrl(String webSiteUrl) {
            this.webSiteUrl = webSiteUrl;
            this.changedFields = changedFields.add("webSiteUrl");
            return this;
        }

        /**
         * <i>“All appointments in this business.”</i>
         * 
         * @param appointments
         *            value of {@code appointments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appointments(List<BookingAppointment> appointments) {
            this.appointments = appointments;
            this.changedFields = changedFields.add("appointments");
            return this;
        }

        /**
         * <i>“All appointments in this business.”</i>
         * 
         * @param appointments
         *            value of {@code appointments} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appointments(BookingAppointment... appointments) {
            return appointments(Arrays.asList(appointments));
        }

        /**
         * <i>“A calendar view of appointments in this business.”</i>
         * 
         * @param calendarView
         *            value of {@code calendarView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarView(List<BookingAppointment> calendarView) {
            this.calendarView = calendarView;
            this.changedFields = changedFields.add("calendarView");
            return this;
        }

        /**
         * <i>“A calendar view of appointments in this business.”</i>
         * 
         * @param calendarView
         *            value of {@code calendarView} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder calendarView(BookingAppointment... calendarView) {
            return calendarView(Arrays.asList(calendarView));
        }

        /**
         * <i>“All customers of this business.”</i>
         * 
         * @param customers
         *            value of {@code customers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customers(List<BookingCustomer> customers) {
            this.customers = customers;
            this.changedFields = changedFields.add("customers");
            return this;
        }

        /**
         * <i>“All customers of this business.”</i>
         * 
         * @param customers
         *            value of {@code customers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customers(BookingCustomer... customers) {
            return customers(Arrays.asList(customers));
        }

        /**
         * <i>“All custom questions of this business.”</i>
         * 
         * @param customQuestions
         *            value of {@code customQuestions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customQuestions(List<BookingCustomQuestion> customQuestions) {
            this.customQuestions = customQuestions;
            this.changedFields = changedFields.add("customQuestions");
            return this;
        }

        /**
         * <i>“All custom questions of this business.”</i>
         * 
         * @param customQuestions
         *            value of {@code customQuestions} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customQuestions(BookingCustomQuestion... customQuestions) {
            return customQuestions(Arrays.asList(customQuestions));
        }

        /**
         * <i>“All services offered by this business.”</i>
         * 
         * @param services
         *            value of {@code services} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder services(List<BookingService> services) {
            this.services = services;
            this.changedFields = changedFields.add("services");
            return this;
        }

        /**
         * <i>“All services offered by this business.”</i>
         * 
         * @param services
         *            value of {@code services} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder services(BookingService... services) {
            return services(Arrays.asList(services));
        }

        /**
         * <i>“All staff members that provides services in this business.”</i>
         * 
         * @param staffMembers
         *            value of {@code staffMembers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder staffMembers(List<BookingStaffMember> staffMembers) {
            this.staffMembers = staffMembers;
            this.changedFields = changedFields.add("staffMembers");
            return this;
        }

        /**
         * <i>“All staff members that provides services in this business.”</i>
         * 
         * @param staffMembers
         *            value of {@code staffMembers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder staffMembers(BookingStaffMember... staffMembers) {
            return staffMembers(Arrays.asList(staffMembers));
        }

        public BookingBusiness build() {
            BookingBusiness _x = new BookingBusiness();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingBusiness";
            _x.id = id;
            _x.displayName = displayName;
            _x.address = address;
            _x.businessHours = businessHours;
            _x.businessHoursNextLink = businessHoursNextLink;
            _x.businessType = businessType;
            _x.defaultCurrencyIso = defaultCurrencyIso;
            _x.email = email;
            _x.isPublished = isPublished;
            _x.phone = phone;
            _x.publicUrl = publicUrl;
            _x.schedulingPolicy = schedulingPolicy;
            _x.webSiteUrl = webSiteUrl;
            _x.appointments = appointments;
            _x.calendarView = calendarView;
            _x.customers = customers;
            _x.customQuestions = customQuestions;
            _x.services = services;
            _x.staffMembers = staffMembers;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="address")
    @JsonIgnore
    public Optional<PhysicalAddress> getAddress() {
        return Optional.ofNullable(address);
    }

    public BookingBusiness withAddress(PhysicalAddress address) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("address");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.address = address;
        return _x;
    }

    @Property(name="businessHours")
    @JsonIgnore
    public CollectionPage<BookingWorkHours> getBusinessHours() {
        return new CollectionPage<BookingWorkHours>(contextPath, BookingWorkHours.class, this.businessHours, Optional.ofNullable(businessHoursNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingBusiness withBusinessHours(List<BookingWorkHours> businessHours) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("businessHours");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.businessHours = businessHours;
        return _x;
    }

    @Property(name="businessHours")
    @JsonIgnore
    public CollectionPage<BookingWorkHours> getBusinessHours(HttpRequestOptions options) {
        return new CollectionPage<BookingWorkHours>(contextPath, BookingWorkHours.class, this.businessHours, Optional.ofNullable(businessHoursNextLink), Collections.emptyList(), options);
    }

    @Property(name="businessType")
    @JsonIgnore
    public Optional<String> getBusinessType() {
        return Optional.ofNullable(businessType);
    }

    public BookingBusiness withBusinessType(String businessType) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("businessType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.businessType = businessType;
        return _x;
    }

    @Property(name="defaultCurrencyIso")
    @JsonIgnore
    public Optional<String> getDefaultCurrencyIso() {
        return Optional.ofNullable(defaultCurrencyIso);
    }

    public BookingBusiness withDefaultCurrencyIso(String defaultCurrencyIso) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("defaultCurrencyIso");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.defaultCurrencyIso = defaultCurrencyIso;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public BookingBusiness withEmail(String email) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.email = email;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property isPublished
     */
    @Property(name="isPublished")
    @JsonIgnore
    public Optional<Boolean> getIsPublished() {
        return Optional.ofNullable(isPublished);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code isPublished}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param isPublished
     *            new value of {@code isPublished} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code isPublished} field changed
     */
    public BookingBusiness withIsPublished(Boolean isPublished) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("isPublished");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.isPublished = isPublished;
        return _x;
    }

    @Property(name="phone")
    @JsonIgnore
    public Optional<String> getPhone() {
        return Optional.ofNullable(phone);
    }

    public BookingBusiness withPhone(String phone) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("phone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.phone = phone;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property publicUrl
     */
    @Property(name="publicUrl")
    @JsonIgnore
    public Optional<String> getPublicUrl() {
        return Optional.ofNullable(publicUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code publicUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param publicUrl
     *            new value of {@code publicUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code publicUrl} field changed
     */
    public BookingBusiness withPublicUrl(String publicUrl) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("publicUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.publicUrl = publicUrl;
        return _x;
    }

    @Property(name="schedulingPolicy")
    @JsonIgnore
    public Optional<BookingSchedulingPolicy> getSchedulingPolicy() {
        return Optional.ofNullable(schedulingPolicy);
    }

    public BookingBusiness withSchedulingPolicy(BookingSchedulingPolicy schedulingPolicy) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("schedulingPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.schedulingPolicy = schedulingPolicy;
        return _x;
    }

    /**
     * <i>“Example: https://www.contoso.com”</i>
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property webSiteUrl
     */
    @Property(name="webSiteUrl")
    @JsonIgnore
    public Optional<String> getWebSiteUrl() {
        return Optional.ofNullable(webSiteUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code webSiteUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Example: https://www.contoso.com”</i>
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param webSiteUrl
     *            new value of {@code webSiteUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code webSiteUrl} field changed
     */
    public BookingBusiness withWebSiteUrl(String webSiteUrl) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("webSiteUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.webSiteUrl = webSiteUrl;
        return _x;
    }

    public BookingBusiness withUnmappedField(String name, Object value) {
        BookingBusiness _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“All appointments in this business.”</i>
     * 
     * @return navigational property appointments
     */
    @NavigationProperty(name="appointments")
    @JsonIgnore
    public BookingAppointmentCollectionRequest getAppointments() {
        return new BookingAppointmentCollectionRequest(
                        contextPath.addSegment("appointments"), Optional.ofNullable(appointments));
    }

    /**
     * <i>“A calendar view of appointments in this business.”</i>
     * 
     * @return navigational property calendarView
     */
    @NavigationProperty(name="calendarView")
    @JsonIgnore
    public BookingAppointmentCollectionRequest getCalendarView() {
        return new BookingAppointmentCollectionRequest(
                        contextPath.addSegment("calendarView"), Optional.ofNullable(calendarView));
    }

    /**
     * <i>“All customers of this business.”</i>
     * 
     * @return navigational property customers
     */
    @NavigationProperty(name="customers")
    @JsonIgnore
    public BookingCustomerCollectionRequest getCustomers() {
        return new BookingCustomerCollectionRequest(
                        contextPath.addSegment("customers"), Optional.ofNullable(customers));
    }

    /**
     * <i>“All custom questions of this business.”</i>
     * 
     * @return navigational property customQuestions
     */
    @NavigationProperty(name="customQuestions")
    @JsonIgnore
    public BookingCustomQuestionCollectionRequest getCustomQuestions() {
        return new BookingCustomQuestionCollectionRequest(
                        contextPath.addSegment("customQuestions"), Optional.ofNullable(customQuestions));
    }

    /**
     * <i>“All services offered by this business.”</i>
     * 
     * @return navigational property services
     */
    @NavigationProperty(name="services")
    @JsonIgnore
    public BookingServiceCollectionRequest getServices() {
        return new BookingServiceCollectionRequest(
                        contextPath.addSegment("services"), Optional.ofNullable(services));
    }

    /**
     * <i>“All staff members that provides services in this business.”</i>
     * 
     * @return navigational property staffMembers
     */
    @NavigationProperty(name="staffMembers")
    @JsonIgnore
    public BookingStaffMemberCollectionRequest getStaffMembers() {
        return new BookingStaffMemberCollectionRequest(
                        contextPath.addSegment("staffMembers"), Optional.ofNullable(staffMembers));
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appointments}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“All appointments in this business.”</i>
     * 
     * @param appointments
     *            new value of {@code appointments} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appointments} field changed
     */
    public BookingBusiness withAppointments(List<BookingAppointment> appointments) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("appointments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.appointments = appointments;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code calendarView}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“A calendar view of appointments in this business.”</i>
     * 
     * @param calendarView
     *            new value of {@code calendarView} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code calendarView} field changed
     */
    public BookingBusiness withCalendarView(List<BookingAppointment> calendarView) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("calendarView");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.calendarView = calendarView;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customers} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“All customers of this business.”</i>
     * 
     * @param customers
     *            new value of {@code customers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customers} field changed
     */
    public BookingBusiness withCustomers(List<BookingCustomer> customers) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("customers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.customers = customers;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customQuestions}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“All custom questions of this business.”</i>
     * 
     * @param customQuestions
     *            new value of {@code customQuestions} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customQuestions} field changed
     */
    public BookingBusiness withCustomQuestions(List<BookingCustomQuestion> customQuestions) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("customQuestions");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.customQuestions = customQuestions;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code services} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“All services offered by this business.”</i>
     * 
     * @param services
     *            new value of {@code services} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code services} field changed
     */
    public BookingBusiness withServices(List<BookingService> services) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("services");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.services = services;
        return _x;
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code staffMembers}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“All staff members that provides services in this business.”</i>
     * 
     * @param staffMembers
     *            new value of {@code staffMembers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code staffMembers} field changed
     */
    public BookingBusiness withStaffMembers(List<BookingStaffMember> staffMembers) {
        BookingBusiness _x = _copy();
        _x.changedFields = changedFields.add("staffMembers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingBusiness");
        _x.staffMembers = staffMembers;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingBusiness patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingBusiness _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingBusiness put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingBusiness _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingBusiness _copy() {
        BookingBusiness _x = new BookingBusiness();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.address = address;
        _x.businessHours = businessHours;
        _x.businessType = businessType;
        _x.defaultCurrencyIso = defaultCurrencyIso;
        _x.email = email;
        _x.isPublished = isPublished;
        _x.phone = phone;
        _x.publicUrl = publicUrl;
        _x.schedulingPolicy = schedulingPolicy;
        _x.webSiteUrl = webSiteUrl;
        _x.appointments = appointments;
        _x.calendarView = calendarView;
        _x.customers = customers;
        _x.customQuestions = customQuestions;
        _x.services = services;
        _x.staffMembers = staffMembers;
        return _x;
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

    @Action(name = "unpublish")
    @JsonIgnore
    public ActionRequestNoReturn unpublish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unpublish"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingBusiness[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("address=");
        b.append(this.address);
        b.append(", ");
        b.append("businessHours=");
        b.append(this.businessHours);
        b.append(", ");
        b.append("businessType=");
        b.append(this.businessType);
        b.append(", ");
        b.append("defaultCurrencyIso=");
        b.append(this.defaultCurrencyIso);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("isPublished=");
        b.append(this.isPublished);
        b.append(", ");
        b.append("phone=");
        b.append(this.phone);
        b.append(", ");
        b.append("publicUrl=");
        b.append(this.publicUrl);
        b.append(", ");
        b.append("schedulingPolicy=");
        b.append(this.schedulingPolicy);
        b.append(", ");
        b.append("webSiteUrl=");
        b.append(this.webSiteUrl);
        b.append(", ");
        b.append("appointments=");
        b.append(this.appointments);
        b.append(", ");
        b.append("calendarView=");
        b.append(this.calendarView);
        b.append(", ");
        b.append("customers=");
        b.append(this.customers);
        b.append(", ");
        b.append("customQuestions=");
        b.append(this.customQuestions);
        b.append(", ");
        b.append("services=");
        b.append(this.services);
        b.append(", ");
        b.append("staffMembers=");
        b.append(this.staffMembers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
