package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.BookingCustomerInformationBase;
import odata.msgraph.client.beta.complex.BookingReminder;
import odata.msgraph.client.beta.complex.DateTimeTimeZone;
import odata.msgraph.client.beta.complex.Location;
import odata.msgraph.client.beta.enums.BookingInvoiceStatus;
import odata.msgraph.client.beta.enums.BookingPriceType;


/**
 * <i>“Represents a booked appointment of a service by a customer in a business.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "additionalInformation", 
    "customerEmailAddress", 
    "customerId", 
    "customerLocation", 
    "customerName", 
    "customerNotes", 
    "customerPhone", 
    "customers", 
    "customerTimeZone", 
    "duration", 
    "end", 
    "filledAttendeesCount", 
    "invoiceAmount", 
    "invoiceDate", 
    "invoiceId", 
    "invoiceStatus", 
    "invoiceUrl", 
    "isLocationOnline", 
    "joinWebUrl", 
    "maximumAttendeesCount", 
    "onlineMeetingUrl", 
    "optOutOfCustomerEmail", 
    "postBuffer", 
    "preBuffer", 
    "price", 
    "priceType", 
    "reminders", 
    "selfServiceAppointmentId", 
    "serviceId", 
    "serviceLocation", 
    "serviceName", 
    "serviceNotes", 
    "smsNotificationsEnabled", 
    "staffMemberIds", 
    "start"})
@JsonInclude(Include.NON_NULL)
public class BookingAppointment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bookingAppointment";
    }

    @JsonProperty("additionalInformation")
    protected String additionalInformation;

    @JsonProperty("customerEmailAddress")
    protected String customerEmailAddress;

    @JsonProperty("customerId")
    protected String customerId;

    @JsonProperty("customerLocation")
    protected Location customerLocation;

    @JsonProperty("customerName")
    protected String customerName;

    @JsonProperty("customerNotes")
    protected String customerNotes;

    @JsonProperty("customerPhone")
    protected String customerPhone;

    @JsonProperty("customers")
    protected List<BookingCustomerInformationBase> customers;

    @JsonProperty("customers@nextLink")
    protected String customersNextLink;

    @JsonProperty("customerTimeZone")
    protected String customerTimeZone;

    @JsonProperty("duration")
    protected Duration duration;

    @JsonProperty("end")
    protected DateTimeTimeZone end;

    @JsonProperty("filledAttendeesCount")
    protected Integer filledAttendeesCount;

    @JsonProperty("invoiceAmount")
    protected Double invoiceAmount;

    @JsonProperty("invoiceDate")
    protected DateTimeTimeZone invoiceDate;

    @JsonProperty("invoiceId")
    protected String invoiceId;

    @JsonProperty("invoiceStatus")
    protected BookingInvoiceStatus invoiceStatus;

    @JsonProperty("invoiceUrl")
    protected String invoiceUrl;

    @JsonProperty("isLocationOnline")
    protected Boolean isLocationOnline;

    @JsonProperty("joinWebUrl")
    protected String joinWebUrl;

    @JsonProperty("maximumAttendeesCount")
    protected Integer maximumAttendeesCount;

    @JsonProperty("onlineMeetingUrl")
    protected String onlineMeetingUrl;

    @JsonProperty("optOutOfCustomerEmail")
    protected Boolean optOutOfCustomerEmail;

    @JsonProperty("postBuffer")
    protected Duration postBuffer;

    @JsonProperty("preBuffer")
    protected Duration preBuffer;

    @JsonProperty("price")
    protected Double price;

    @JsonProperty("priceType")
    protected BookingPriceType priceType;

    @JsonProperty("reminders")
    protected List<BookingReminder> reminders;

    @JsonProperty("reminders@nextLink")
    protected String remindersNextLink;

    @JsonProperty("selfServiceAppointmentId")
    protected String selfServiceAppointmentId;

    @JsonProperty("serviceId")
    protected String serviceId;

    @JsonProperty("serviceLocation")
    protected Location serviceLocation;

    @JsonProperty("serviceName")
    protected String serviceName;

    @JsonProperty("serviceNotes")
    protected String serviceNotes;

    @JsonProperty("smsNotificationsEnabled")
    protected Boolean smsNotificationsEnabled;

    @JsonProperty("staffMemberIds")
    protected List<String> staffMemberIds;

    @JsonProperty("staffMemberIds@nextLink")
    protected String staffMemberIdsNextLink;

    @JsonProperty("start")
    protected DateTimeTimeZone start;

    protected BookingAppointment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBookingAppointment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String additionalInformation;
        private String customerEmailAddress;
        private String customerId;
        private Location customerLocation;
        private String customerName;
        private String customerNotes;
        private String customerPhone;
        private List<BookingCustomerInformationBase> customers;
        private String customersNextLink;
        private String customerTimeZone;
        private Duration duration;
        private DateTimeTimeZone end;
        private Integer filledAttendeesCount;
        private Double invoiceAmount;
        private DateTimeTimeZone invoiceDate;
        private String invoiceId;
        private BookingInvoiceStatus invoiceStatus;
        private String invoiceUrl;
        private Boolean isLocationOnline;
        private String joinWebUrl;
        private Integer maximumAttendeesCount;
        private String onlineMeetingUrl;
        private Boolean optOutOfCustomerEmail;
        private Duration postBuffer;
        private Duration preBuffer;
        private Double price;
        private BookingPriceType priceType;
        private List<BookingReminder> reminders;
        private String remindersNextLink;
        private String selfServiceAppointmentId;
        private String serviceId;
        private Location serviceLocation;
        private String serviceName;
        private String serviceNotes;
        private Boolean smsNotificationsEnabled;
        private List<String> staffMemberIds;
        private String staffMemberIdsNextLink;
        private DateTimeTimeZone start;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder customerEmailAddress(String customerEmailAddress) {
            this.customerEmailAddress = customerEmailAddress;
            this.changedFields = changedFields.add("customerEmailAddress");
            return this;
        }

        /**
         * <i>“If CustomerId is not specified when an appointment is created then a new
         * customer is created based on the appointment customer information. Once set, the
         * customerId should be considered immutable.”</i>
         * 
         * @param customerId
         *            value of {@code customerId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customerId(String customerId) {
            this.customerId = customerId;
            this.changedFields = changedFields.add("customerId");
            return this;
        }

        public Builder customerLocation(Location customerLocation) {
            this.customerLocation = customerLocation;
            this.changedFields = changedFields.add("customerLocation");
            return this;
        }

        public Builder customerName(String customerName) {
            this.customerName = customerName;
            this.changedFields = changedFields.add("customerName");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * appointment by id. Its value can only be set when creating a new appointment
         * with a new customer, ie, without specifying a CustomerId. After that, the
         * property is computed from the customer represented by CustomerId.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Immutable</b>
         * <p>
         * true
         * 
         * @param customerNotes
         *            value of {@code customerNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customerNotes(String customerNotes) {
            this.customerNotes = customerNotes;
            this.changedFields = changedFields.add("customerNotes");
            return this;
        }

        public Builder customerPhone(String customerPhone) {
            this.customerPhone = customerPhone;
            this.changedFields = changedFields.add("customerPhone");
            return this;
        }

        public Builder customers(List<BookingCustomerInformationBase> customers) {
            this.customers = customers;
            this.changedFields = changedFields.add("customers");
            return this;
        }

        public Builder customers(BookingCustomerInformationBase... customers) {
            return customers(Arrays.asList(customers));
        }

        public Builder customersNextLink(String customersNextLink) {
            this.customersNextLink = customersNextLink;
            this.changedFields = changedFields.add("customers");
            return this;
        }

        public Builder customerTimeZone(String customerTimeZone) {
            this.customerTimeZone = customerTimeZone;
            this.changedFields = changedFields.add("customerTimeZone");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param duration
         *            value of {@code duration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder duration(Duration duration) {
            this.duration = duration;
            this.changedFields = changedFields.add("duration");
            return this;
        }

        public Builder end(DateTimeTimeZone end) {
            this.end = end;
            this.changedFields = changedFields.add("end");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * 
         * @param filledAttendeesCount
         *            value of {@code filledAttendeesCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder filledAttendeesCount(Integer filledAttendeesCount) {
            this.filledAttendeesCount = filledAttendeesCount;
            this.changedFields = changedFields.add("filledAttendeesCount");
            return this;
        }

        public Builder invoiceAmount(Double invoiceAmount) {
            this.invoiceAmount = invoiceAmount;
            this.changedFields = changedFields.add("invoiceAmount");
            return this;
        }

        public Builder invoiceDate(DateTimeTimeZone invoiceDate) {
            this.invoiceDate = invoiceDate;
            this.changedFields = changedFields.add("invoiceDate");
            return this;
        }

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            this.changedFields = changedFields.add("invoiceId");
            return this;
        }

        public Builder invoiceStatus(BookingInvoiceStatus invoiceStatus) {
            this.invoiceStatus = invoiceStatus;
            this.changedFields = changedFields.add("invoiceStatus");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param invoiceUrl
         *            value of {@code invoiceUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder invoiceUrl(String invoiceUrl) {
            this.invoiceUrl = invoiceUrl;
            this.changedFields = changedFields.add("invoiceUrl");
            return this;
        }

        public Builder isLocationOnline(Boolean isLocationOnline) {
            this.isLocationOnline = isLocationOnline;
            this.changedFields = changedFields.add("isLocationOnline");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param joinWebUrl
         *            value of {@code joinWebUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder joinWebUrl(String joinWebUrl) {
            this.joinWebUrl = joinWebUrl;
            this.changedFields = changedFields.add("joinWebUrl");
            return this;
        }

        public Builder maximumAttendeesCount(Integer maximumAttendeesCount) {
            this.maximumAttendeesCount = maximumAttendeesCount;
            this.changedFields = changedFields.add("maximumAttendeesCount");
            return this;
        }

        /**
         * <p>
         * <b>Org.OData.Core.V1.IsURL</b>
         * <p>
         * true
         * 
         * @param onlineMeetingUrl
         *            value of {@code onlineMeetingUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder onlineMeetingUrl(String onlineMeetingUrl) {
            this.onlineMeetingUrl = onlineMeetingUrl;
            this.changedFields = changedFields.add("onlineMeetingUrl");
            return this;
        }

        public Builder optOutOfCustomerEmail(Boolean optOutOfCustomerEmail) {
            this.optOutOfCustomerEmail = optOutOfCustomerEmail;
            this.changedFields = changedFields.add("optOutOfCustomerEmail");
            return this;
        }

        public Builder postBuffer(Duration postBuffer) {
            this.postBuffer = postBuffer;
            this.changedFields = changedFields.add("postBuffer");
            return this;
        }

        public Builder preBuffer(Duration preBuffer) {
            this.preBuffer = preBuffer;
            this.changedFields = changedFields.add("preBuffer");
            return this;
        }

        public Builder price(Double price) {
            this.price = price;
            this.changedFields = changedFields.add("price");
            return this;
        }

        public Builder priceType(BookingPriceType priceType) {
            this.priceType = priceType;
            this.changedFields = changedFields.add("priceType");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * appointment by id.”</i>
         * 
         * @param reminders
         *            value of {@code reminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reminders(List<BookingReminder> reminders) {
            this.reminders = reminders;
            this.changedFields = changedFields.add("reminders");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * appointment by id.”</i>
         * 
         * @param reminders
         *            value of {@code reminders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder reminders(BookingReminder... reminders) {
            return reminders(Arrays.asList(reminders));
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * appointment by id.”</i>
         * 
         * @param remindersNextLink
         *            value of {@code reminders@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remindersNextLink(String remindersNextLink) {
            this.remindersNextLink = remindersNextLink;
            this.changedFields = changedFields.add("reminders");
            return this;
        }

        public Builder selfServiceAppointmentId(String selfServiceAppointmentId) {
            this.selfServiceAppointmentId = selfServiceAppointmentId;
            this.changedFields = changedFields.add("selfServiceAppointmentId");
            return this;
        }

        /**
         * <i>“The id of the booking service associated with this appointment.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Immutable</b>
         * <p>
         * true
         * 
         * @param serviceId
         *            value of {@code serviceId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            this.changedFields = changedFields.add("serviceId");
            return this;
        }

        public Builder serviceLocation(Location serviceLocation) {
            this.serviceLocation = serviceLocation;
            this.changedFields = changedFields.add("serviceLocation");
            return this;
        }

        /**
         * <i>“This property is optional when creating a new appointment. If not specified, it
         * is computed from the service associated with the appointment by the service id.”</i>
         * 
         * @param serviceName
         *            value of {@code serviceName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            this.changedFields = changedFields.add("serviceName");
            return this;
        }

        /**
         * <i>“The value of this property is only available when reading an individual booking
         * appointment by id.”</i>
         * 
         * @param serviceNotes
         *            value of {@code serviceNotes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serviceNotes(String serviceNotes) {
            this.serviceNotes = serviceNotes;
            this.changedFields = changedFields.add("serviceNotes");
            return this;
        }

        public Builder smsNotificationsEnabled(Boolean smsNotificationsEnabled) {
            this.smsNotificationsEnabled = smsNotificationsEnabled;
            this.changedFields = changedFields.add("smsNotificationsEnabled");
            return this;
        }

        public Builder staffMemberIds(List<String> staffMemberIds) {
            this.staffMemberIds = staffMemberIds;
            this.changedFields = changedFields.add("staffMemberIds");
            return this;
        }

        public Builder staffMemberIds(String... staffMemberIds) {
            return staffMemberIds(Arrays.asList(staffMemberIds));
        }

        public Builder staffMemberIdsNextLink(String staffMemberIdsNextLink) {
            this.staffMemberIdsNextLink = staffMemberIdsNextLink;
            this.changedFields = changedFields.add("staffMemberIds");
            return this;
        }

        public Builder start(DateTimeTimeZone start) {
            this.start = start;
            this.changedFields = changedFields.add("start");
            return this;
        }

        public BookingAppointment build() {
            BookingAppointment _x = new BookingAppointment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bookingAppointment";
            _x.id = id;
            _x.additionalInformation = additionalInformation;
            _x.customerEmailAddress = customerEmailAddress;
            _x.customerId = customerId;
            _x.customerLocation = customerLocation;
            _x.customerName = customerName;
            _x.customerNotes = customerNotes;
            _x.customerPhone = customerPhone;
            _x.customers = customers;
            _x.customersNextLink = customersNextLink;
            _x.customerTimeZone = customerTimeZone;
            _x.duration = duration;
            _x.end = end;
            _x.filledAttendeesCount = filledAttendeesCount;
            _x.invoiceAmount = invoiceAmount;
            _x.invoiceDate = invoiceDate;
            _x.invoiceId = invoiceId;
            _x.invoiceStatus = invoiceStatus;
            _x.invoiceUrl = invoiceUrl;
            _x.isLocationOnline = isLocationOnline;
            _x.joinWebUrl = joinWebUrl;
            _x.maximumAttendeesCount = maximumAttendeesCount;
            _x.onlineMeetingUrl = onlineMeetingUrl;
            _x.optOutOfCustomerEmail = optOutOfCustomerEmail;
            _x.postBuffer = postBuffer;
            _x.preBuffer = preBuffer;
            _x.price = price;
            _x.priceType = priceType;
            _x.reminders = reminders;
            _x.remindersNextLink = remindersNextLink;
            _x.selfServiceAppointmentId = selfServiceAppointmentId;
            _x.serviceId = serviceId;
            _x.serviceLocation = serviceLocation;
            _x.serviceName = serviceName;
            _x.serviceNotes = serviceNotes;
            _x.smsNotificationsEnabled = smsNotificationsEnabled;
            _x.staffMemberIds = staffMemberIds;
            _x.staffMemberIdsNextLink = staffMemberIdsNextLink;
            _x.start = start;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="additionalInformation")
    @JsonIgnore
    public Optional<String> getAdditionalInformation() {
        return Optional.ofNullable(additionalInformation);
    }

    public BookingAppointment withAdditionalInformation(String additionalInformation) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("additionalInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.additionalInformation = additionalInformation;
        return _x;
    }

    @Property(name="customerEmailAddress")
    @JsonIgnore
    public Optional<String> getCustomerEmailAddress() {
        return Optional.ofNullable(customerEmailAddress);
    }

    public BookingAppointment withCustomerEmailAddress(String customerEmailAddress) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerEmailAddress");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerEmailAddress = customerEmailAddress;
        return _x;
    }

    /**
     * <i>“If CustomerId is not specified when an appointment is created then a new
     * customer is created based on the appointment customer information. Once set, the
     * customerId should be considered immutable.”</i>
     * 
     * @return property customerId
     */
    @Property(name="customerId")
    @JsonIgnore
    public Optional<String> getCustomerId() {
        return Optional.ofNullable(customerId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customerId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“If CustomerId is not specified when an appointment is created then a new
     * customer is created based on the appointment customer information. Once set, the
     * customerId should be considered immutable.”</i>
     * 
     * @param customerId
     *            new value of {@code customerId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customerId} field changed
     */
    public BookingAppointment withCustomerId(String customerId) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerId = customerId;
        return _x;
    }

    @Property(name="customerLocation")
    @JsonIgnore
    public Optional<Location> getCustomerLocation() {
        return Optional.ofNullable(customerLocation);
    }

    public BookingAppointment withCustomerLocation(Location customerLocation) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerLocation = customerLocation;
        return _x;
    }

    @Property(name="customerName")
    @JsonIgnore
    public Optional<String> getCustomerName() {
        return Optional.ofNullable(customerName);
    }

    public BookingAppointment withCustomerName(String customerName) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerName = customerName;
        return _x;
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id. Its value can only be set when creating a new appointment
     * with a new customer, ie, without specifying a CustomerId. After that, the
     * property is computed from the customer represented by CustomerId.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Immutable</b>
     * <p>
     * true
     * 
     * @return property customerNotes
     */
    @Property(name="customerNotes")
    @JsonIgnore
    public Optional<String> getCustomerNotes() {
        return Optional.ofNullable(customerNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customerNotes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id. Its value can only be set when creating a new appointment
     * with a new customer, ie, without specifying a CustomerId. After that, the
     * property is computed from the customer represented by CustomerId.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Immutable</b>
     * <p>
     * true
     * 
     * @param customerNotes
     *            new value of {@code customerNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customerNotes} field changed
     */
    public BookingAppointment withCustomerNotes(String customerNotes) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerNotes = customerNotes;
        return _x;
    }

    @Property(name="customerPhone")
    @JsonIgnore
    public Optional<String> getCustomerPhone() {
        return Optional.ofNullable(customerPhone);
    }

    public BookingAppointment withCustomerPhone(String customerPhone) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerPhone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerPhone = customerPhone;
        return _x;
    }

    @Property(name="customers")
    @JsonIgnore
    public CollectionPage<BookingCustomerInformationBase> getCustomers() {
        return new CollectionPage<BookingCustomerInformationBase>(contextPath, BookingCustomerInformationBase.class, this.customers, Optional.ofNullable(customersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingAppointment withCustomers(List<BookingCustomerInformationBase> customers) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customers = customers;
        return _x;
    }

    @Property(name="customers")
    @JsonIgnore
    public CollectionPage<BookingCustomerInformationBase> getCustomers(HttpRequestOptions options) {
        return new CollectionPage<BookingCustomerInformationBase>(contextPath, BookingCustomerInformationBase.class, this.customers, Optional.ofNullable(customersNextLink), Collections.emptyList(), options);
    }

    @Property(name="customerTimeZone")
    @JsonIgnore
    public Optional<String> getCustomerTimeZone() {
        return Optional.ofNullable(customerTimeZone);
    }

    public BookingAppointment withCustomerTimeZone(String customerTimeZone) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("customerTimeZone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.customerTimeZone = customerTimeZone;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property duration
     */
    @Property(name="duration")
    @JsonIgnore
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(duration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code duration} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param duration
     *            new value of {@code duration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code duration} field changed
     */
    public BookingAppointment withDuration(Duration duration) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.duration = duration;
        return _x;
    }

    @Property(name="end")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getEnd() {
        return Optional.ofNullable(end);
    }

    public BookingAppointment withEnd(DateTimeTimeZone end) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("end");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.end = end;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @return property filledAttendeesCount
     */
    @Property(name="filledAttendeesCount")
    @JsonIgnore
    public Optional<Integer> getFilledAttendeesCount() {
        return Optional.ofNullable(filledAttendeesCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * filledAttendeesCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * 
     * @param filledAttendeesCount
     *            new value of {@code filledAttendeesCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code filledAttendeesCount} field changed
     */
    public BookingAppointment withFilledAttendeesCount(Integer filledAttendeesCount) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("filledAttendeesCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.filledAttendeesCount = filledAttendeesCount;
        return _x;
    }

    @Property(name="invoiceAmount")
    @JsonIgnore
    public Optional<Double> getInvoiceAmount() {
        return Optional.ofNullable(invoiceAmount);
    }

    public BookingAppointment withInvoiceAmount(Double invoiceAmount) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("invoiceAmount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.invoiceAmount = invoiceAmount;
        return _x;
    }

    @Property(name="invoiceDate")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getInvoiceDate() {
        return Optional.ofNullable(invoiceDate);
    }

    public BookingAppointment withInvoiceDate(DateTimeTimeZone invoiceDate) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("invoiceDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.invoiceDate = invoiceDate;
        return _x;
    }

    @Property(name="invoiceId")
    @JsonIgnore
    public Optional<String> getInvoiceId() {
        return Optional.ofNullable(invoiceId);
    }

    public BookingAppointment withInvoiceId(String invoiceId) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("invoiceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.invoiceId = invoiceId;
        return _x;
    }

    @Property(name="invoiceStatus")
    @JsonIgnore
    public Optional<BookingInvoiceStatus> getInvoiceStatus() {
        return Optional.ofNullable(invoiceStatus);
    }

    public BookingAppointment withInvoiceStatus(BookingInvoiceStatus invoiceStatus) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("invoiceStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.invoiceStatus = invoiceStatus;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property invoiceUrl
     */
    @Property(name="invoiceUrl")
    @JsonIgnore
    public Optional<String> getInvoiceUrl() {
        return Optional.ofNullable(invoiceUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code invoiceUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param invoiceUrl
     *            new value of {@code invoiceUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code invoiceUrl} field changed
     */
    public BookingAppointment withInvoiceUrl(String invoiceUrl) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("invoiceUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.invoiceUrl = invoiceUrl;
        return _x;
    }

    @Property(name="isLocationOnline")
    @JsonIgnore
    public Optional<Boolean> getIsLocationOnline() {
        return Optional.ofNullable(isLocationOnline);
    }

    public BookingAppointment withIsLocationOnline(Boolean isLocationOnline) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("isLocationOnline");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.isLocationOnline = isLocationOnline;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property joinWebUrl
     */
    @Property(name="joinWebUrl")
    @JsonIgnore
    public Optional<String> getJoinWebUrl() {
        return Optional.ofNullable(joinWebUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code joinWebUrl} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param joinWebUrl
     *            new value of {@code joinWebUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code joinWebUrl} field changed
     */
    public BookingAppointment withJoinWebUrl(String joinWebUrl) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("joinWebUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.joinWebUrl = joinWebUrl;
        return _x;
    }

    @Property(name="maximumAttendeesCount")
    @JsonIgnore
    public Optional<Integer> getMaximumAttendeesCount() {
        return Optional.ofNullable(maximumAttendeesCount);
    }

    public BookingAppointment withMaximumAttendeesCount(Integer maximumAttendeesCount) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("maximumAttendeesCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.maximumAttendeesCount = maximumAttendeesCount;
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @return property onlineMeetingUrl
     */
    @Property(name="onlineMeetingUrl")
    @JsonIgnore
    public Optional<String> getOnlineMeetingUrl() {
        return Optional.ofNullable(onlineMeetingUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code onlineMeetingUrl}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <b>Org.OData.Core.V1.IsURL</b>
     * <p>
     * true
     * 
     * @param onlineMeetingUrl
     *            new value of {@code onlineMeetingUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code onlineMeetingUrl} field changed
     */
    public BookingAppointment withOnlineMeetingUrl(String onlineMeetingUrl) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("onlineMeetingUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.onlineMeetingUrl = onlineMeetingUrl;
        return _x;
    }

    @Property(name="optOutOfCustomerEmail")
    @JsonIgnore
    public Optional<Boolean> getOptOutOfCustomerEmail() {
        return Optional.ofNullable(optOutOfCustomerEmail);
    }

    public BookingAppointment withOptOutOfCustomerEmail(Boolean optOutOfCustomerEmail) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("optOutOfCustomerEmail");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.optOutOfCustomerEmail = optOutOfCustomerEmail;
        return _x;
    }

    @Property(name="postBuffer")
    @JsonIgnore
    public Optional<Duration> getPostBuffer() {
        return Optional.ofNullable(postBuffer);
    }

    public BookingAppointment withPostBuffer(Duration postBuffer) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("postBuffer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.postBuffer = postBuffer;
        return _x;
    }

    @Property(name="preBuffer")
    @JsonIgnore
    public Optional<Duration> getPreBuffer() {
        return Optional.ofNullable(preBuffer);
    }

    public BookingAppointment withPreBuffer(Duration preBuffer) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("preBuffer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.preBuffer = preBuffer;
        return _x;
    }

    @Property(name="price")
    @JsonIgnore
    public Optional<Double> getPrice() {
        return Optional.ofNullable(price);
    }

    public BookingAppointment withPrice(Double price) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("price");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.price = price;
        return _x;
    }

    @Property(name="priceType")
    @JsonIgnore
    public Optional<BookingPriceType> getPriceType() {
        return Optional.ofNullable(priceType);
    }

    public BookingAppointment withPriceType(BookingPriceType priceType) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("priceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.priceType = priceType;
        return _x;
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id.”</i>
     * 
     * @return property reminders
     */
    @Property(name="reminders")
    @JsonIgnore
    public CollectionPage<BookingReminder> getReminders() {
        return new CollectionPage<BookingReminder>(contextPath, BookingReminder.class, this.reminders, Optional.ofNullable(remindersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code reminders} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id.”</i>
     * 
     * @param reminders
     *            new value of {@code reminders} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code reminders} field changed
     */
    public BookingAppointment withReminders(List<BookingReminder> reminders) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("reminders");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.reminders = reminders;
        return _x;
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property reminders
     */
    @Property(name="reminders")
    @JsonIgnore
    public CollectionPage<BookingReminder> getReminders(HttpRequestOptions options) {
        return new CollectionPage<BookingReminder>(contextPath, BookingReminder.class, this.reminders, Optional.ofNullable(remindersNextLink), Collections.emptyList(), options);
    }

    @Property(name="selfServiceAppointmentId")
    @JsonIgnore
    public Optional<String> getSelfServiceAppointmentId() {
        return Optional.ofNullable(selfServiceAppointmentId);
    }

    public BookingAppointment withSelfServiceAppointmentId(String selfServiceAppointmentId) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("selfServiceAppointmentId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.selfServiceAppointmentId = selfServiceAppointmentId;
        return _x;
    }

    /**
     * <i>“The id of the booking service associated with this appointment.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Immutable</b>
     * <p>
     * true
     * 
     * @return property serviceId
     */
    @Property(name="serviceId")
    @JsonIgnore
    public Optional<String> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serviceId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The id of the booking service associated with this appointment.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Immutable</b>
     * <p>
     * true
     * 
     * @param serviceId
     *            new value of {@code serviceId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serviceId} field changed
     */
    public BookingAppointment withServiceId(String serviceId) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("serviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.serviceId = serviceId;
        return _x;
    }

    @Property(name="serviceLocation")
    @JsonIgnore
    public Optional<Location> getServiceLocation() {
        return Optional.ofNullable(serviceLocation);
    }

    public BookingAppointment withServiceLocation(Location serviceLocation) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("serviceLocation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.serviceLocation = serviceLocation;
        return _x;
    }

    /**
     * <i>“This property is optional when creating a new appointment. If not specified, it
     * is computed from the service associated with the appointment by the service id.”</i>
     * 
     * @return property serviceName
     */
    @Property(name="serviceName")
    @JsonIgnore
    public Optional<String> getServiceName() {
        return Optional.ofNullable(serviceName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serviceName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“This property is optional when creating a new appointment. If not specified, it
     * is computed from the service associated with the appointment by the service id.”</i>
     * 
     * @param serviceName
     *            new value of {@code serviceName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serviceName} field changed
     */
    public BookingAppointment withServiceName(String serviceName) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("serviceName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.serviceName = serviceName;
        return _x;
    }

    /**
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id.”</i>
     * 
     * @return property serviceNotes
     */
    @Property(name="serviceNotes")
    @JsonIgnore
    public Optional<String> getServiceNotes() {
        return Optional.ofNullable(serviceNotes);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code serviceNotes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The value of this property is only available when reading an individual booking
     * appointment by id.”</i>
     * 
     * @param serviceNotes
     *            new value of {@code serviceNotes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code serviceNotes} field changed
     */
    public BookingAppointment withServiceNotes(String serviceNotes) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("serviceNotes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.serviceNotes = serviceNotes;
        return _x;
    }

    @Property(name="smsNotificationsEnabled")
    @JsonIgnore
    public Optional<Boolean> getSmsNotificationsEnabled() {
        return Optional.ofNullable(smsNotificationsEnabled);
    }

    public BookingAppointment withSmsNotificationsEnabled(Boolean smsNotificationsEnabled) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("smsNotificationsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.smsNotificationsEnabled = smsNotificationsEnabled;
        return _x;
    }

    @Property(name="staffMemberIds")
    @JsonIgnore
    public CollectionPage<String> getStaffMemberIds() {
        return new CollectionPage<String>(contextPath, String.class, this.staffMemberIds, Optional.ofNullable(staffMemberIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public BookingAppointment withStaffMemberIds(List<String> staffMemberIds) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("staffMemberIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.staffMemberIds = staffMemberIds;
        return _x;
    }

    @Property(name="staffMemberIds")
    @JsonIgnore
    public CollectionPage<String> getStaffMemberIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.staffMemberIds, Optional.ofNullable(staffMemberIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="start")
    @JsonIgnore
    public Optional<DateTimeTimeZone> getStart() {
        return Optional.ofNullable(start);
    }

    public BookingAppointment withStart(DateTimeTimeZone start) {
        BookingAppointment _x = _copy();
        _x.changedFields = changedFields.add("start");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bookingAppointment");
        _x.start = start;
        return _x;
    }

    public BookingAppointment withUnmappedField(String name, Object value) {
        BookingAppointment _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingAppointment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        BookingAppointment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public BookingAppointment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        BookingAppointment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private BookingAppointment _copy() {
        BookingAppointment _x = new BookingAppointment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.additionalInformation = additionalInformation;
        _x.customerEmailAddress = customerEmailAddress;
        _x.customerId = customerId;
        _x.customerLocation = customerLocation;
        _x.customerName = customerName;
        _x.customerNotes = customerNotes;
        _x.customerPhone = customerPhone;
        _x.customers = customers;
        _x.customerTimeZone = customerTimeZone;
        _x.duration = duration;
        _x.end = end;
        _x.filledAttendeesCount = filledAttendeesCount;
        _x.invoiceAmount = invoiceAmount;
        _x.invoiceDate = invoiceDate;
        _x.invoiceId = invoiceId;
        _x.invoiceStatus = invoiceStatus;
        _x.invoiceUrl = invoiceUrl;
        _x.isLocationOnline = isLocationOnline;
        _x.joinWebUrl = joinWebUrl;
        _x.maximumAttendeesCount = maximumAttendeesCount;
        _x.onlineMeetingUrl = onlineMeetingUrl;
        _x.optOutOfCustomerEmail = optOutOfCustomerEmail;
        _x.postBuffer = postBuffer;
        _x.preBuffer = preBuffer;
        _x.price = price;
        _x.priceType = priceType;
        _x.reminders = reminders;
        _x.selfServiceAppointmentId = selfServiceAppointmentId;
        _x.serviceId = serviceId;
        _x.serviceLocation = serviceLocation;
        _x.serviceName = serviceName;
        _x.serviceNotes = serviceNotes;
        _x.smsNotificationsEnabled = smsNotificationsEnabled;
        _x.staffMemberIds = staffMemberIds;
        _x.start = start;
        return _x;
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel(String cancellationMessage) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("cancellationMessage", "Edm.String", Checks.checkIsAscii(cancellationMessage))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookingAppointment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("customerEmailAddress=");
        b.append(this.customerEmailAddress);
        b.append(", ");
        b.append("customerId=");
        b.append(this.customerId);
        b.append(", ");
        b.append("customerLocation=");
        b.append(this.customerLocation);
        b.append(", ");
        b.append("customerName=");
        b.append(this.customerName);
        b.append(", ");
        b.append("customerNotes=");
        b.append(this.customerNotes);
        b.append(", ");
        b.append("customerPhone=");
        b.append(this.customerPhone);
        b.append(", ");
        b.append("customers=");
        b.append(this.customers);
        b.append(", ");
        b.append("customerTimeZone=");
        b.append(this.customerTimeZone);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("end=");
        b.append(this.end);
        b.append(", ");
        b.append("filledAttendeesCount=");
        b.append(this.filledAttendeesCount);
        b.append(", ");
        b.append("invoiceAmount=");
        b.append(this.invoiceAmount);
        b.append(", ");
        b.append("invoiceDate=");
        b.append(this.invoiceDate);
        b.append(", ");
        b.append("invoiceId=");
        b.append(this.invoiceId);
        b.append(", ");
        b.append("invoiceStatus=");
        b.append(this.invoiceStatus);
        b.append(", ");
        b.append("invoiceUrl=");
        b.append(this.invoiceUrl);
        b.append(", ");
        b.append("isLocationOnline=");
        b.append(this.isLocationOnline);
        b.append(", ");
        b.append("joinWebUrl=");
        b.append(this.joinWebUrl);
        b.append(", ");
        b.append("maximumAttendeesCount=");
        b.append(this.maximumAttendeesCount);
        b.append(", ");
        b.append("onlineMeetingUrl=");
        b.append(this.onlineMeetingUrl);
        b.append(", ");
        b.append("optOutOfCustomerEmail=");
        b.append(this.optOutOfCustomerEmail);
        b.append(", ");
        b.append("postBuffer=");
        b.append(this.postBuffer);
        b.append(", ");
        b.append("preBuffer=");
        b.append(this.preBuffer);
        b.append(", ");
        b.append("price=");
        b.append(this.price);
        b.append(", ");
        b.append("priceType=");
        b.append(this.priceType);
        b.append(", ");
        b.append("reminders=");
        b.append(this.reminders);
        b.append(", ");
        b.append("selfServiceAppointmentId=");
        b.append(this.selfServiceAppointmentId);
        b.append(", ");
        b.append("serviceId=");
        b.append(this.serviceId);
        b.append(", ");
        b.append("serviceLocation=");
        b.append(this.serviceLocation);
        b.append(", ");
        b.append("serviceName=");
        b.append(this.serviceName);
        b.append(", ");
        b.append("serviceNotes=");
        b.append(this.serviceNotes);
        b.append(", ");
        b.append("smsNotificationsEnabled=");
        b.append(this.smsNotificationsEnabled);
        b.append(", ");
        b.append("staffMemberIds=");
        b.append(this.staffMemberIds);
        b.append(", ");
        b.append("start=");
        b.append(this.start);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
