package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.BitlockerRecoveryKeyCollectionRequest;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "recoveryKeys"})
@JsonInclude(Include.NON_NULL)
public class Bitlocker extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.bitlocker";
    }

    @JsonProperty("recoveryKeys")
    protected List<BitlockerRecoveryKey> recoveryKeys;

    protected Bitlocker() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderBitlocker() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<BitlockerRecoveryKey> recoveryKeys;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder recoveryKeys(List<BitlockerRecoveryKey> recoveryKeys) {
            this.recoveryKeys = recoveryKeys;
            this.changedFields = changedFields.add("recoveryKeys");
            return this;
        }

        public Builder recoveryKeys(BitlockerRecoveryKey... recoveryKeys) {
            return recoveryKeys(Arrays.asList(recoveryKeys));
        }

        public Bitlocker build() {
            Bitlocker _x = new Bitlocker();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.bitlocker";
            _x.id = id;
            _x.recoveryKeys = recoveryKeys;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    public Bitlocker withUnmappedField(String name, Object value) {
        Bitlocker _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="recoveryKeys")
    @JsonIgnore
    public BitlockerRecoveryKeyCollectionRequest getRecoveryKeys() {
        return new BitlockerRecoveryKeyCollectionRequest(
                        contextPath.addSegment("recoveryKeys"), Optional.ofNullable(recoveryKeys));
    }

    public Bitlocker withRecoveryKeys(List<BitlockerRecoveryKey> recoveryKeys) {
        Bitlocker _x = _copy();
        _x.changedFields = changedFields.add("recoveryKeys");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.bitlocker");
        _x.recoveryKeys = recoveryKeys;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bitlocker patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Bitlocker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Bitlocker put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Bitlocker _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Bitlocker _copy() {
        Bitlocker _x = new Bitlocker();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.recoveryKeys = recoveryKeys;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Bitlocker[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("recoveryKeys=");
        b.append(this.recoveryKeys);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
