package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Float;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserFlowApiConnectorConfiguration;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderBaseCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityProviderCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IdentityUserFlowAttributeAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserFlowLanguageConfigurationCollectionRequest;
import odata.msgraph.client.beta.enums.UserFlowType;

@JsonPropertyOrder({
    "@odata.type", 
    "apiConnectorConfiguration", 
    "defaultLanguageTag", 
    "isLanguageCustomizationEnabled", 
    "languages", 
    "userAttributeAssignments"})
@JsonInclude(Include.NON_NULL)
public class B2cIdentityUserFlow extends IdentityUserFlow implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.b2cIdentityUserFlow";
    }

    @JsonProperty("apiConnectorConfiguration")
    protected UserFlowApiConnectorConfiguration apiConnectorConfiguration;

    @JsonProperty("defaultLanguageTag")
    protected String defaultLanguageTag;

    @JsonProperty("isLanguageCustomizationEnabled")
    protected Boolean isLanguageCustomizationEnabled;

    @JsonProperty("languages")
    protected List<UserFlowLanguageConfiguration> languages;

    @JsonProperty("userAttributeAssignments")
    protected List<IdentityUserFlowAttributeAssignment> userAttributeAssignments;

    protected B2cIdentityUserFlow() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderB2cIdentityUserFlow() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private UserFlowType userFlowType;
        private Float userFlowTypeVersion;
        private UserFlowApiConnectorConfiguration apiConnectorConfiguration;
        private String defaultLanguageTag;
        private Boolean isLanguageCustomizationEnabled;
        private List<UserFlowLanguageConfiguration> languages;
        private List<IdentityUserFlowAttributeAssignment> userAttributeAssignments;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder userFlowType(UserFlowType userFlowType) {
            this.userFlowType = userFlowType;
            this.changedFields = changedFields.add("userFlowType");
            return this;
        }

        public Builder userFlowTypeVersion(Float userFlowTypeVersion) {
            this.userFlowTypeVersion = userFlowTypeVersion;
            this.changedFields = changedFields.add("userFlowTypeVersion");
            return this;
        }

        public Builder apiConnectorConfiguration(UserFlowApiConnectorConfiguration apiConnectorConfiguration) {
            this.apiConnectorConfiguration = apiConnectorConfiguration;
            this.changedFields = changedFields.add("apiConnectorConfiguration");
            return this;
        }

        public Builder defaultLanguageTag(String defaultLanguageTag) {
            this.defaultLanguageTag = defaultLanguageTag;
            this.changedFields = changedFields.add("defaultLanguageTag");
            return this;
        }

        public Builder isLanguageCustomizationEnabled(Boolean isLanguageCustomizationEnabled) {
            this.isLanguageCustomizationEnabled = isLanguageCustomizationEnabled;
            this.changedFields = changedFields.add("isLanguageCustomizationEnabled");
            return this;
        }

        public Builder languages(List<UserFlowLanguageConfiguration> languages) {
            this.languages = languages;
            this.changedFields = changedFields.add("languages");
            return this;
        }

        public Builder languages(UserFlowLanguageConfiguration... languages) {
            return languages(Arrays.asList(languages));
        }

        public Builder userAttributeAssignments(List<IdentityUserFlowAttributeAssignment> userAttributeAssignments) {
            this.userAttributeAssignments = userAttributeAssignments;
            this.changedFields = changedFields.add("userAttributeAssignments");
            return this;
        }

        public Builder userAttributeAssignments(IdentityUserFlowAttributeAssignment... userAttributeAssignments) {
            return userAttributeAssignments(Arrays.asList(userAttributeAssignments));
        }

        public B2cIdentityUserFlow build() {
            B2cIdentityUserFlow _x = new B2cIdentityUserFlow();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.b2cIdentityUserFlow";
            _x.id = id;
            _x.userFlowType = userFlowType;
            _x.userFlowTypeVersion = userFlowTypeVersion;
            _x.apiConnectorConfiguration = apiConnectorConfiguration;
            _x.defaultLanguageTag = defaultLanguageTag;
            _x.isLanguageCustomizationEnabled = isLanguageCustomizationEnabled;
            _x.languages = languages;
            _x.userAttributeAssignments = userAttributeAssignments;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="apiConnectorConfiguration")
    @JsonIgnore
    public Optional<UserFlowApiConnectorConfiguration> getApiConnectorConfiguration() {
        return Optional.ofNullable(apiConnectorConfiguration);
    }

    public B2cIdentityUserFlow withApiConnectorConfiguration(UserFlowApiConnectorConfiguration apiConnectorConfiguration) {
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = changedFields.add("apiConnectorConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cIdentityUserFlow");
        _x.apiConnectorConfiguration = apiConnectorConfiguration;
        return _x;
    }

    @Property(name="defaultLanguageTag")
    @JsonIgnore
    public Optional<String> getDefaultLanguageTag() {
        return Optional.ofNullable(defaultLanguageTag);
    }

    public B2cIdentityUserFlow withDefaultLanguageTag(String defaultLanguageTag) {
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = changedFields.add("defaultLanguageTag");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cIdentityUserFlow");
        _x.defaultLanguageTag = defaultLanguageTag;
        return _x;
    }

    @Property(name="isLanguageCustomizationEnabled")
    @JsonIgnore
    public Optional<Boolean> getIsLanguageCustomizationEnabled() {
        return Optional.ofNullable(isLanguageCustomizationEnabled);
    }

    public B2cIdentityUserFlow withIsLanguageCustomizationEnabled(Boolean isLanguageCustomizationEnabled) {
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = changedFields.add("isLanguageCustomizationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cIdentityUserFlow");
        _x.isLanguageCustomizationEnabled = isLanguageCustomizationEnabled;
        return _x;
    }

    public B2cIdentityUserFlow withUnmappedField(String name, Object value) {
        B2cIdentityUserFlow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <p>
     * <b>Org.OData.Core.V1.Revisions</b>
     * 
     * @return navigational property identityProviders
     */
    @NavigationProperty(name="identityProviders")
    @JsonIgnore
    public IdentityProviderCollectionRequest getIdentityProviders() {
        return new IdentityProviderCollectionRequest(
                        contextPath.addSegment("identityProviders"), RequestHelper.getValue(unmappedFields, "identityProviders"));
    }

    @NavigationProperty(name="languages")
    @JsonIgnore
    public UserFlowLanguageConfigurationCollectionRequest getLanguages() {
        return new UserFlowLanguageConfigurationCollectionRequest(
                        contextPath.addSegment("languages"), Optional.ofNullable(languages));
    }

    @NavigationProperty(name="userAttributeAssignments")
    @JsonIgnore
    public IdentityUserFlowAttributeAssignmentCollectionRequest getUserAttributeAssignments() {
        return new IdentityUserFlowAttributeAssignmentCollectionRequest(
                        contextPath.addSegment("userAttributeAssignments"), Optional.ofNullable(userAttributeAssignments));
    }

    @NavigationProperty(name="userFlowIdentityProviders")
    @JsonIgnore
    public IdentityProviderBaseCollectionRequest getUserFlowIdentityProviders() {
        return new IdentityProviderBaseCollectionRequest(
                        contextPath.addSegment("userFlowIdentityProviders"), RequestHelper.getValue(unmappedFields, "userFlowIdentityProviders"));
    }

    public B2cIdentityUserFlow withLanguages(List<UserFlowLanguageConfiguration> languages) {
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = changedFields.add("languages");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cIdentityUserFlow");
        _x.languages = languages;
        return _x;
    }

    public B2cIdentityUserFlow withUserAttributeAssignments(List<IdentityUserFlowAttributeAssignment> userAttributeAssignments) {
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = changedFields.add("userAttributeAssignments");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.b2cIdentityUserFlow");
        _x.userAttributeAssignments = userAttributeAssignments;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public B2cIdentityUserFlow patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public B2cIdentityUserFlow put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        B2cIdentityUserFlow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private B2cIdentityUserFlow _copy() {
        B2cIdentityUserFlow _x = new B2cIdentityUserFlow();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.userFlowType = userFlowType;
        _x.userFlowTypeVersion = userFlowTypeVersion;
        _x.apiConnectorConfiguration = apiConnectorConfiguration;
        _x.defaultLanguageTag = defaultLanguageTag;
        _x.isLanguageCustomizationEnabled = isLanguageCustomizationEnabled;
        _x.languages = languages;
        _x.userAttributeAssignments = userAttributeAssignments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("B2cIdentityUserFlow[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("userFlowType=");
        b.append(this.userFlowType);
        b.append(", ");
        b.append("userFlowTypeVersion=");
        b.append(this.userFlowTypeVersion);
        b.append(", ");
        b.append("apiConnectorConfiguration=");
        b.append(this.apiConnectorConfiguration);
        b.append(", ");
        b.append("defaultLanguageTag=");
        b.append(this.defaultLanguageTag);
        b.append(", ");
        b.append("isLanguageCustomizationEnabled=");
        b.append(this.isLanguageCustomizationEnabled);
        b.append(", ");
        b.append("languages=");
        b.append(this.languages);
        b.append(", ");
        b.append("userAttributeAssignments=");
        b.append(this.userAttributeAssignments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
