package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.LicenseInfoDetail;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "licenseInfoDetails", 
    "snapshotDateTime"})
@JsonInclude(Include.NON_NULL)
public class AzureADLicenseUsage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.azureADLicenseUsage";
    }

    @JsonProperty("licenseInfoDetails")
    protected List<LicenseInfoDetail> licenseInfoDetails;

    @JsonProperty("licenseInfoDetails@nextLink")
    protected String licenseInfoDetailsNextLink;

    @JsonProperty("snapshotDateTime")
    protected OffsetDateTime snapshotDateTime;

    protected AzureADLicenseUsage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAzureADLicenseUsage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<LicenseInfoDetail> licenseInfoDetails;
        private String licenseInfoDetailsNextLink;
        private OffsetDateTime snapshotDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder licenseInfoDetails(List<LicenseInfoDetail> licenseInfoDetails) {
            this.licenseInfoDetails = licenseInfoDetails;
            this.changedFields = changedFields.add("licenseInfoDetails");
            return this;
        }

        public Builder licenseInfoDetails(LicenseInfoDetail... licenseInfoDetails) {
            return licenseInfoDetails(Arrays.asList(licenseInfoDetails));
        }

        public Builder licenseInfoDetailsNextLink(String licenseInfoDetailsNextLink) {
            this.licenseInfoDetailsNextLink = licenseInfoDetailsNextLink;
            this.changedFields = changedFields.add("licenseInfoDetails");
            return this;
        }

        public Builder snapshotDateTime(OffsetDateTime snapshotDateTime) {
            this.snapshotDateTime = snapshotDateTime;
            this.changedFields = changedFields.add("snapshotDateTime");
            return this;
        }

        public AzureADLicenseUsage build() {
            AzureADLicenseUsage _x = new AzureADLicenseUsage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.azureADLicenseUsage";
            _x.id = id;
            _x.licenseInfoDetails = licenseInfoDetails;
            _x.licenseInfoDetailsNextLink = licenseInfoDetailsNextLink;
            _x.snapshotDateTime = snapshotDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="licenseInfoDetails")
    @JsonIgnore
    public CollectionPage<LicenseInfoDetail> getLicenseInfoDetails() {
        return new CollectionPage<LicenseInfoDetail>(contextPath, LicenseInfoDetail.class, this.licenseInfoDetails, Optional.ofNullable(licenseInfoDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AzureADLicenseUsage withLicenseInfoDetails(List<LicenseInfoDetail> licenseInfoDetails) {
        AzureADLicenseUsage _x = _copy();
        _x.changedFields = changedFields.add("licenseInfoDetails");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADLicenseUsage");
        _x.licenseInfoDetails = licenseInfoDetails;
        return _x;
    }

    @Property(name="licenseInfoDetails")
    @JsonIgnore
    public CollectionPage<LicenseInfoDetail> getLicenseInfoDetails(HttpRequestOptions options) {
        return new CollectionPage<LicenseInfoDetail>(contextPath, LicenseInfoDetail.class, this.licenseInfoDetails, Optional.ofNullable(licenseInfoDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="snapshotDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getSnapshotDateTime() {
        return Optional.ofNullable(snapshotDateTime);
    }

    public AzureADLicenseUsage withSnapshotDateTime(OffsetDateTime snapshotDateTime) {
        AzureADLicenseUsage _x = _copy();
        _x.changedFields = changedFields.add("snapshotDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.azureADLicenseUsage");
        _x.snapshotDateTime = snapshotDateTime;
        return _x;
    }

    public AzureADLicenseUsage withUnmappedField(String name, Object value) {
        AzureADLicenseUsage _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADLicenseUsage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AzureADLicenseUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AzureADLicenseUsage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AzureADLicenseUsage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AzureADLicenseUsage _copy() {
        AzureADLicenseUsage _x = new AzureADLicenseUsage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.licenseInfoDetails = licenseInfoDetails;
        _x.snapshotDateTime = snapshotDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AzureADLicenseUsage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("licenseInfoDetails=");
        b.append(this.licenseInfoDetails);
        b.append(", ");
        b.append("snapshotDateTime=");
        b.append(this.snapshotDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
