package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.complex.ItemBody;

@JsonPropertyOrder({
    "@odata.type", 
    "author", 
    "content", 
    "createdDateTime"})
@JsonInclude(Include.NON_NULL)
public class AuthoredNote extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authoredNote";
    }

    @JsonProperty("author")
    protected Identity author;

    @JsonProperty("content")
    protected ItemBody content;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    protected AuthoredNote() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthoredNote() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Identity author;
        private ItemBody content;
        private OffsetDateTime createdDateTime;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder author(Identity author) {
            this.author = author;
            this.changedFields = changedFields.add("author");
            return this;
        }

        public Builder content(ItemBody content) {
            this.content = content;
            this.changedFields = changedFields.add("content");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public AuthoredNote build() {
            AuthoredNote _x = new AuthoredNote();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.authoredNote";
            _x.id = id;
            _x.author = author;
            _x.content = content;
            _x.createdDateTime = createdDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="author")
    @JsonIgnore
    public Optional<Identity> getAuthor() {
        return Optional.ofNullable(author);
    }

    public AuthoredNote withAuthor(Identity author) {
        AuthoredNote _x = _copy();
        _x.changedFields = changedFields.add("author");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authoredNote");
        _x.author = author;
        return _x;
    }

    @Property(name="content")
    @JsonIgnore
    public Optional<ItemBody> getContent() {
        return Optional.ofNullable(content);
    }

    public AuthoredNote withContent(ItemBody content) {
        AuthoredNote _x = _copy();
        _x.changedFields = changedFields.add("content");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authoredNote");
        _x.content = content;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AuthoredNote withCreatedDateTime(OffsetDateTime createdDateTime) {
        AuthoredNote _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authoredNote");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    public AuthoredNote withUnmappedField(String name, Object value) {
        AuthoredNote _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthoredNote patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuthoredNote _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthoredNote put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuthoredNote _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuthoredNote _copy() {
        AuthoredNote _x = new AuthoredNote();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.author = author;
        _x.content = content;
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthoredNote[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("author=");
        b.append(this.author);
        b.append(", ");
        b.append("content=");
        b.append(this.content);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
