package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RoutingMode;

@JsonPropertyOrder({
    "@odata.type", 
    "receivers", 
    "routingMode", 
    "sources"})
@JsonInclude(Include.NON_NULL)
public class AudioRoutingGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.audioRoutingGroup";
    }

    @JsonProperty("receivers")
    protected List<String> receivers;

    @JsonProperty("receivers@nextLink")
    protected String receiversNextLink;

    @JsonProperty("routingMode")
    protected RoutingMode routingMode;

    @JsonProperty("sources")
    protected List<String> sources;

    @JsonProperty("sources@nextLink")
    protected String sourcesNextLink;

    protected AudioRoutingGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAudioRoutingGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> receivers;
        private String receiversNextLink;
        private RoutingMode routingMode;
        private List<String> sources;
        private String sourcesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder receivers(List<String> receivers) {
            this.receivers = receivers;
            this.changedFields = changedFields.add("receivers");
            return this;
        }

        public Builder receivers(String... receivers) {
            return receivers(Arrays.asList(receivers));
        }

        public Builder receiversNextLink(String receiversNextLink) {
            this.receiversNextLink = receiversNextLink;
            this.changedFields = changedFields.add("receivers");
            return this;
        }

        public Builder routingMode(RoutingMode routingMode) {
            this.routingMode = routingMode;
            this.changedFields = changedFields.add("routingMode");
            return this;
        }

        public Builder sources(List<String> sources) {
            this.sources = sources;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public Builder sources(String... sources) {
            return sources(Arrays.asList(sources));
        }

        public Builder sourcesNextLink(String sourcesNextLink) {
            this.sourcesNextLink = sourcesNextLink;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public AudioRoutingGroup build() {
            AudioRoutingGroup _x = new AudioRoutingGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.audioRoutingGroup";
            _x.id = id;
            _x.receivers = receivers;
            _x.receiversNextLink = receiversNextLink;
            _x.routingMode = routingMode;
            _x.sources = sources;
            _x.sourcesNextLink = sourcesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="receivers")
    @JsonIgnore
    public CollectionPage<String> getReceivers() {
        return new CollectionPage<String>(contextPath, String.class, this.receivers, Optional.ofNullable(receiversNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AudioRoutingGroup withReceivers(List<String> receivers) {
        AudioRoutingGroup _x = _copy();
        _x.changedFields = changedFields.add("receivers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioRoutingGroup");
        _x.receivers = receivers;
        return _x;
    }

    @Property(name="receivers")
    @JsonIgnore
    public CollectionPage<String> getReceivers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.receivers, Optional.ofNullable(receiversNextLink), Collections.emptyList(), options);
    }

    @Property(name="routingMode")
    @JsonIgnore
    public Optional<RoutingMode> getRoutingMode() {
        return Optional.ofNullable(routingMode);
    }

    public AudioRoutingGroup withRoutingMode(RoutingMode routingMode) {
        AudioRoutingGroup _x = _copy();
        _x.changedFields = changedFields.add("routingMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioRoutingGroup");
        _x.routingMode = routingMode;
        return _x;
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<String> getSources() {
        return new CollectionPage<String>(contextPath, String.class, this.sources, Optional.ofNullable(sourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public AudioRoutingGroup withSources(List<String> sources) {
        AudioRoutingGroup _x = _copy();
        _x.changedFields = changedFields.add("sources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioRoutingGroup");
        _x.sources = sources;
        return _x;
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<String> getSources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.sources, Optional.ofNullable(sourcesNextLink), Collections.emptyList(), options);
    }

    public AudioRoutingGroup withUnmappedField(String name, Object value) {
        AudioRoutingGroup _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AudioRoutingGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AudioRoutingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AudioRoutingGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AudioRoutingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AudioRoutingGroup _copy() {
        AudioRoutingGroup _x = new AudioRoutingGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.receivers = receivers;
        _x.routingMode = routingMode;
        _x.sources = sources;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AudioRoutingGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("receivers=");
        b.append(this.receivers);
        b.append(", ");
        b.append("routingMode=");
        b.append(this.routingMode);
        b.append(", ");
        b.append("sources=");
        b.append(this.sources);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
