package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.BusinessFlowCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernancePolicyTemplateCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "businessFlows", 
    "businessFlowsWithRequestsAwaitingMyDecision", 
    "policyTemplates"})
@JsonInclude(Include.NON_NULL)
public class ApprovalWorkflowProvider extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.approvalWorkflowProvider";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("businessFlows")
    protected List<BusinessFlow> businessFlows;

    @JsonProperty("businessFlowsWithRequestsAwaitingMyDecision")
    protected List<BusinessFlow> businessFlowsWithRequestsAwaitingMyDecision;

    @JsonProperty("policyTemplates")
    protected List<GovernancePolicyTemplate> policyTemplates;

    protected ApprovalWorkflowProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApprovalWorkflowProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private List<BusinessFlow> businessFlows;
        private List<BusinessFlow> businessFlowsWithRequestsAwaitingMyDecision;
        private List<GovernancePolicyTemplate> policyTemplates;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder businessFlows(List<BusinessFlow> businessFlows) {
            this.businessFlows = businessFlows;
            this.changedFields = changedFields.add("businessFlows");
            return this;
        }

        public Builder businessFlows(BusinessFlow... businessFlows) {
            return businessFlows(Arrays.asList(businessFlows));
        }

        public Builder businessFlowsWithRequestsAwaitingMyDecision(List<BusinessFlow> businessFlowsWithRequestsAwaitingMyDecision) {
            this.businessFlowsWithRequestsAwaitingMyDecision = businessFlowsWithRequestsAwaitingMyDecision;
            this.changedFields = changedFields.add("businessFlowsWithRequestsAwaitingMyDecision");
            return this;
        }

        public Builder businessFlowsWithRequestsAwaitingMyDecision(BusinessFlow... businessFlowsWithRequestsAwaitingMyDecision) {
            return businessFlowsWithRequestsAwaitingMyDecision(Arrays.asList(businessFlowsWithRequestsAwaitingMyDecision));
        }

        public Builder policyTemplates(List<GovernancePolicyTemplate> policyTemplates) {
            this.policyTemplates = policyTemplates;
            this.changedFields = changedFields.add("policyTemplates");
            return this;
        }

        public Builder policyTemplates(GovernancePolicyTemplate... policyTemplates) {
            return policyTemplates(Arrays.asList(policyTemplates));
        }

        public ApprovalWorkflowProvider build() {
            ApprovalWorkflowProvider _x = new ApprovalWorkflowProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.approvalWorkflowProvider";
            _x.id = id;
            _x.displayName = displayName;
            _x.businessFlows = businessFlows;
            _x.businessFlowsWithRequestsAwaitingMyDecision = businessFlowsWithRequestsAwaitingMyDecision;
            _x.policyTemplates = policyTemplates;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ApprovalWorkflowProvider withDisplayName(String displayName) {
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalWorkflowProvider");
        _x.displayName = displayName;
        return _x;
    }

    public ApprovalWorkflowProvider withUnmappedField(String name, Object value) {
        ApprovalWorkflowProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="businessFlows")
    @JsonIgnore
    public BusinessFlowCollectionRequest getBusinessFlows() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlows"), Optional.ofNullable(businessFlows));
    }

    @NavigationProperty(name="businessFlowsWithRequestsAwaitingMyDecision")
    @JsonIgnore
    public BusinessFlowCollectionRequest getBusinessFlowsWithRequestsAwaitingMyDecision() {
        return new BusinessFlowCollectionRequest(
                        contextPath.addSegment("businessFlowsWithRequestsAwaitingMyDecision"), Optional.ofNullable(businessFlowsWithRequestsAwaitingMyDecision));
    }

    @NavigationProperty(name="policyTemplates")
    @JsonIgnore
    public GovernancePolicyTemplateCollectionRequest getPolicyTemplates() {
        return new GovernancePolicyTemplateCollectionRequest(
                        contextPath.addSegment("policyTemplates"), Optional.ofNullable(policyTemplates));
    }

    public ApprovalWorkflowProvider withBusinessFlows(List<BusinessFlow> businessFlows) {
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = changedFields.add("businessFlows");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalWorkflowProvider");
        _x.businessFlows = businessFlows;
        return _x;
    }

    public ApprovalWorkflowProvider withBusinessFlowsWithRequestsAwaitingMyDecision(List<BusinessFlow> businessFlowsWithRequestsAwaitingMyDecision) {
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = changedFields.add("businessFlowsWithRequestsAwaitingMyDecision");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalWorkflowProvider");
        _x.businessFlowsWithRequestsAwaitingMyDecision = businessFlowsWithRequestsAwaitingMyDecision;
        return _x;
    }

    public ApprovalWorkflowProvider withPolicyTemplates(List<GovernancePolicyTemplate> policyTemplates) {
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = changedFields.add("policyTemplates");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalWorkflowProvider");
        _x.policyTemplates = policyTemplates;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApprovalWorkflowProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApprovalWorkflowProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApprovalWorkflowProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApprovalWorkflowProvider _copy() {
        ApprovalWorkflowProvider _x = new ApprovalWorkflowProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.businessFlows = businessFlows;
        _x.businessFlowsWithRequestsAwaitingMyDecision = businessFlowsWithRequestsAwaitingMyDecision;
        _x.policyTemplates = policyTemplates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApprovalWorkflowProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("businessFlows=");
        b.append(this.businessFlows);
        b.append(", ");
        b.append("businessFlowsWithRequestsAwaitingMyDecision=");
        b.append(this.businessFlowsWithRequestsAwaitingMyDecision);
        b.append(", ");
        b.append("policyTemplates=");
        b.append(this.policyTemplates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
