package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "certificateData", 
    "developerId", 
    "keyId", 
    "serviceId"})
@JsonInclude(Include.NON_NULL)
public class AppleManagedIdentityProvider extends IdentityProviderBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleManagedIdentityProvider";
    }

    @JsonProperty("certificateData")
    protected String certificateData;

    @JsonProperty("developerId")
    protected String developerId;

    @JsonProperty("keyId")
    protected String keyId;

    @JsonProperty("serviceId")
    protected String serviceId;

    protected AppleManagedIdentityProvider() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppleManagedIdentityProvider() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String certificateData;
        private String developerId;
        private String keyId;
        private String serviceId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder certificateData(String certificateData) {
            this.certificateData = certificateData;
            this.changedFields = changedFields.add("certificateData");
            return this;
        }

        public Builder developerId(String developerId) {
            this.developerId = developerId;
            this.changedFields = changedFields.add("developerId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.changedFields = changedFields.add("keyId");
            return this;
        }

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            this.changedFields = changedFields.add("serviceId");
            return this;
        }

        public AppleManagedIdentityProvider build() {
            AppleManagedIdentityProvider _x = new AppleManagedIdentityProvider();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.appleManagedIdentityProvider";
            _x.id = id;
            _x.displayName = displayName;
            _x.certificateData = certificateData;
            _x.developerId = developerId;
            _x.keyId = keyId;
            _x.serviceId = serviceId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="certificateData")
    @JsonIgnore
    public Optional<String> getCertificateData() {
        return Optional.ofNullable(certificateData);
    }

    public AppleManagedIdentityProvider withCertificateData(String certificateData) {
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("certificateData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleManagedIdentityProvider");
        _x.certificateData = certificateData;
        return _x;
    }

    @Property(name="developerId")
    @JsonIgnore
    public Optional<String> getDeveloperId() {
        return Optional.ofNullable(developerId);
    }

    public AppleManagedIdentityProvider withDeveloperId(String developerId) {
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("developerId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleManagedIdentityProvider");
        _x.developerId = developerId;
        return _x;
    }

    @Property(name="keyId")
    @JsonIgnore
    public Optional<String> getKeyId() {
        return Optional.ofNullable(keyId);
    }

    public AppleManagedIdentityProvider withKeyId(String keyId) {
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("keyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleManagedIdentityProvider");
        _x.keyId = keyId;
        return _x;
    }

    @Property(name="serviceId")
    @JsonIgnore
    public Optional<String> getServiceId() {
        return Optional.ofNullable(serviceId);
    }

    public AppleManagedIdentityProvider withServiceId(String serviceId) {
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = changedFields.add("serviceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleManagedIdentityProvider");
        _x.serviceId = serviceId;
        return _x;
    }

    public AppleManagedIdentityProvider withUnmappedField(String name, Object value) {
        AppleManagedIdentityProvider _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleManagedIdentityProvider patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleManagedIdentityProvider put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleManagedIdentityProvider _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleManagedIdentityProvider _copy() {
        AppleManagedIdentityProvider _x = new AppleManagedIdentityProvider();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.certificateData = certificateData;
        _x.developerId = developerId;
        _x.keyId = keyId;
        _x.serviceId = serviceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleManagedIdentityProvider[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("certificateData=");
        b.append(this.certificateData);
        b.append(", ");
        b.append("developerId=");
        b.append(this.developerId);
        b.append(", ");
        b.append("keyId=");
        b.append(this.keyId);
        b.append(", ");
        b.append("serviceId=");
        b.append(this.serviceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
