package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AirPrintDestination;


/**
 * <i>“Apple device features configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "airPrintDestinations"})
@JsonInclude(Include.NON_NULL)
public class AppleDeviceFeaturesConfigurationBase extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleDeviceFeaturesConfigurationBase";
    }

    @JsonProperty("airPrintDestinations")
    protected List<AirPrintDestination> airPrintDestinations;

    @JsonProperty("airPrintDestinations@nextLink")
    protected String airPrintDestinationsNextLink;

    protected AppleDeviceFeaturesConfigurationBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“An array of AirPrint printers that should always be shown. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @return property airPrintDestinations
     */
    @Property(name="airPrintDestinations")
    @JsonIgnore
    public CollectionPage<AirPrintDestination> getAirPrintDestinations() {
        return new CollectionPage<AirPrintDestination>(contextPath, AirPrintDestination.class, this.airPrintDestinations, Optional.ofNullable(airPrintDestinationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * airPrintDestinations} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“An array of AirPrint printers that should always be shown. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param airPrintDestinations
     *            new value of {@code airPrintDestinations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code airPrintDestinations} field changed
     */
    public AppleDeviceFeaturesConfigurationBase withAirPrintDestinations(List<AirPrintDestination> airPrintDestinations) {
        AppleDeviceFeaturesConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("airPrintDestinations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleDeviceFeaturesConfigurationBase");
        _x.airPrintDestinations = airPrintDestinations;
        return _x;
    }

    /**
     * <i>“An array of AirPrint printers that should always be shown. This collection can
     * contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property airPrintDestinations
     */
    @Property(name="airPrintDestinations")
    @JsonIgnore
    public CollectionPage<AirPrintDestination> getAirPrintDestinations(HttpRequestOptions options) {
        return new CollectionPage<AirPrintDestination>(contextPath, AirPrintDestination.class, this.airPrintDestinations, Optional.ofNullable(airPrintDestinationsNextLink), Collections.emptyList(), options);
    }

    public AppleDeviceFeaturesConfigurationBase withUnmappedField(String name, Object value) {
        AppleDeviceFeaturesConfigurationBase _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleDeviceFeaturesConfigurationBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleDeviceFeaturesConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleDeviceFeaturesConfigurationBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleDeviceFeaturesConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleDeviceFeaturesConfigurationBase _copy() {
        AppleDeviceFeaturesConfigurationBase _x = new AppleDeviceFeaturesConfigurationBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.airPrintDestinations = airPrintDestinations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleDeviceFeaturesConfigurationBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("airPrintDestinations=");
        b.append(this.airPrintDestinations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
