package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidDeviceOwnerRequiredPasswordType;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the AndroidDeviceOwnerAOSPCompliancePolicy resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "minAndroidSecurityPatchLevel", 
    "osMaximumVersion", 
    "osMinimumVersion", 
    "passwordMinimumLength", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordRequired", 
    "passwordRequiredType", 
    "securityBlockJailbrokenDevices", 
    "storageRequireEncryption"})
@JsonInclude(Include.NON_NULL)
public class AospDeviceOwnerCompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.aospDeviceOwnerCompliancePolicy";
    }

    @JsonProperty("minAndroidSecurityPatchLevel")
    protected String minAndroidSecurityPatchLevel;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordRequiredType")
    protected AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;

    @JsonProperty("securityBlockJailbrokenDevices")
    protected Boolean securityBlockJailbrokenDevices;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    protected AospDeviceOwnerCompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAospDeviceOwnerCompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<DeviceCompliancePolicyAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceComplianceDeviceStatus> deviceStatuses;
        private DeviceComplianceDeviceOverview deviceStatusOverview;
        private List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule;
        private List<DeviceComplianceUserStatus> userStatuses;
        private DeviceComplianceUserOverview userStatusOverview;
        private String minAndroidSecurityPatchLevel;
        private String osMaximumVersion;
        private String osMinimumVersion;
        private Integer passwordMinimumLength;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Boolean passwordRequired;
        private AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;
        private Boolean securityBlockJailbrokenDevices;
        private Boolean storageRequireEncryption;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceCompliancePolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceCompliancePolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceComplianceDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceComplianceDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceComplianceDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder scheduledActionsForRule(List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule) {
            this.scheduledActionsForRule = scheduledActionsForRule;
            this.changedFields = changedFields.add("scheduledActionsForRule");
            return this;
        }

        public Builder scheduledActionsForRule(DeviceComplianceScheduledActionForRule... scheduledActionsForRule) {
            return scheduledActionsForRule(Arrays.asList(scheduledActionsForRule));
        }

        public Builder userStatuses(List<DeviceComplianceUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceComplianceUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceComplianceUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Minimum Android security patch level.”</i>
         * 
         * @param minAndroidSecurityPatchLevel
         *            value of {@code minAndroidSecurityPatchLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minAndroidSecurityPatchLevel(String minAndroidSecurityPatchLevel) {
            this.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
            this.changedFields = changedFields.add("minAndroidSecurityPatchLevel");
            return this;
        }

        /**
         * <i>“Maximum Android version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Minimum Android version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Minimum password length. Valid values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a password is required. Valid values 1 to 8640”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Require a password to unlock device.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Type of characters in password”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Devices must not be jailbroken or rooted.”</i>
         * 
         * @param securityBlockJailbrokenDevices
         *            value of {@code securityBlockJailbrokenDevices} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityBlockJailbrokenDevices(Boolean securityBlockJailbrokenDevices) {
            this.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
            this.changedFields = changedFields.add("securityBlockJailbrokenDevices");
            return this;
        }

        /**
         * <i>“Require encryption on Android devices.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        public AospDeviceOwnerCompliancePolicy build() {
            AospDeviceOwnerCompliancePolicy _x = new AospDeviceOwnerCompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.aospDeviceOwnerCompliancePolicy";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.scheduledActionsForRule = scheduledActionsForRule;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
            _x.osMaximumVersion = osMaximumVersion;
            _x.osMinimumVersion = osMinimumVersion;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordRequired = passwordRequired;
            _x.passwordRequiredType = passwordRequiredType;
            _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
            _x.storageRequireEncryption = storageRequireEncryption;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Minimum Android security patch level.”</i>
     * 
     * @return property minAndroidSecurityPatchLevel
     */
    @Property(name="minAndroidSecurityPatchLevel")
    @JsonIgnore
    public Optional<String> getMinAndroidSecurityPatchLevel() {
        return Optional.ofNullable(minAndroidSecurityPatchLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minAndroidSecurityPatchLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Minimum Android security patch level.”</i>
     * 
     * @param minAndroidSecurityPatchLevel
     *            new value of {@code minAndroidSecurityPatchLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minAndroidSecurityPatchLevel} field changed
     */
    public AospDeviceOwnerCompliancePolicy withMinAndroidSecurityPatchLevel(String minAndroidSecurityPatchLevel) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("minAndroidSecurityPatchLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
        return _x;
    }

    /**
     * <i>“Maximum Android version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum Android version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public AospDeviceOwnerCompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Minimum Android version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum Android version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public AospDeviceOwnerCompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public AospDeviceOwnerCompliancePolicy withPasswordMinimumLength(Integer passwordMinimumLength) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a password is required. Valid values 1 to 8640”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a password is required. Valid values 1 to 8640”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public AospDeviceOwnerCompliancePolicy withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Require a password to unlock device.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require a password to unlock device.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public AospDeviceOwnerCompliancePolicy withPasswordRequired(Boolean passwordRequired) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Type of characters in password”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerRequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of characters in password”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public AospDeviceOwnerCompliancePolicy withPasswordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Devices must not be jailbroken or rooted.”</i>
     * 
     * @return property securityBlockJailbrokenDevices
     */
    @Property(name="securityBlockJailbrokenDevices")
    @JsonIgnore
    public Optional<Boolean> getSecurityBlockJailbrokenDevices() {
        return Optional.ofNullable(securityBlockJailbrokenDevices);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityBlockJailbrokenDevices} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Devices must not be jailbroken or rooted.”</i>
     * 
     * @param securityBlockJailbrokenDevices
     *            new value of {@code securityBlockJailbrokenDevices} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityBlockJailbrokenDevices} field changed
     */
    public AospDeviceOwnerCompliancePolicy withSecurityBlockJailbrokenDevices(Boolean securityBlockJailbrokenDevices) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("securityBlockJailbrokenDevices");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
        return _x;
    }

    /**
     * <i>“Require encryption on Android devices.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require encryption on Android devices.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public AospDeviceOwnerCompliancePolicy withStorageRequireEncryption(Boolean storageRequireEncryption) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aospDeviceOwnerCompliancePolicy");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    public AospDeviceOwnerCompliancePolicy withUnmappedField(String name, Object value) {
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AospDeviceOwnerCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AospDeviceOwnerCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AospDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AospDeviceOwnerCompliancePolicy _copy() {
        AospDeviceOwnerCompliancePolicy _x = new AospDeviceOwnerCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.scheduledActionsForRule = scheduledActionsForRule;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
        _x.osMaximumVersion = osMaximumVersion;
        _x.osMinimumVersion = osMinimumVersion;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordRequired = passwordRequired;
        _x.passwordRequiredType = passwordRequiredType;
        _x.securityBlockJailbrokenDevices = securityBlockJailbrokenDevices;
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AospDeviceOwnerCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("scheduledActionsForRule=");
        b.append(this.scheduledActionsForRule);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("minAndroidSecurityPatchLevel=");
        b.append(this.minAndroidSecurityPatchLevel);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("securityBlockJailbrokenDevices=");
        b.append(this.securityBlockJailbrokenDevices);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
