package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.VpnProxyServer;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.entity.request.AndroidWorkProfileCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.AndroidWorkProfileVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android
 * Work Profile device to connect to desired VPN endpoint. By specifying the
 * authentication method and security types expected by VPN endpoint you can make
 * the VPN connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "alwaysOn", 
    "alwaysOnLockdown", 
    "authenticationMethod", 
    "connectionName", 
    "connectionType", 
    "customData", 
    "customKeyValueData", 
    "fingerprint", 
    "microsoftTunnelSiteId", 
    "proxyServer", 
    "realm", 
    "role", 
    "servers", 
    "targetedMobileApps", 
    "targetedPackageIds"})
@JsonInclude(Include.NON_NULL)
public class AndroidWorkProfileVpnConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidWorkProfileVpnConfiguration";
    }

    @JsonProperty("alwaysOn")
    protected Boolean alwaysOn;

    @JsonProperty("alwaysOnLockdown")
    protected Boolean alwaysOnLockdown;

    @JsonProperty("authenticationMethod")
    protected VpnAuthenticationMethod authenticationMethod;

    @JsonProperty("connectionName")
    protected String connectionName;

    @JsonProperty("connectionType")
    protected AndroidWorkProfileVpnConnectionType connectionType;

    @JsonProperty("customData")
    protected List<KeyValue> customData;

    @JsonProperty("customData@nextLink")
    protected String customDataNextLink;

    @JsonProperty("customKeyValueData")
    protected List<KeyValuePair> customKeyValueData;

    @JsonProperty("customKeyValueData@nextLink")
    protected String customKeyValueDataNextLink;

    @JsonProperty("fingerprint")
    protected String fingerprint;

    @JsonProperty("microsoftTunnelSiteId")
    protected String microsoftTunnelSiteId;

    @JsonProperty("proxyServer")
    protected VpnProxyServer proxyServer;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("servers")
    protected List<VpnServer> servers;

    @JsonProperty("servers@nextLink")
    protected String serversNextLink;

    @JsonProperty("targetedMobileApps")
    protected List<AppListItem> targetedMobileApps;

    @JsonProperty("targetedMobileApps@nextLink")
    protected String targetedMobileAppsNextLink;

    @JsonProperty("targetedPackageIds")
    protected List<String> targetedPackageIds;

    @JsonProperty("targetedPackageIds@nextLink")
    protected String targetedPackageIdsNextLink;

    protected AndroidWorkProfileVpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidWorkProfileVpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private Boolean alwaysOn;
        private Boolean alwaysOnLockdown;
        private VpnAuthenticationMethod authenticationMethod;
        private String connectionName;
        private AndroidWorkProfileVpnConnectionType connectionType;
        private List<KeyValue> customData;
        private String customDataNextLink;
        private List<KeyValuePair> customKeyValueData;
        private String customKeyValueDataNextLink;
        private String fingerprint;
        private String microsoftTunnelSiteId;
        private VpnProxyServer proxyServer;
        private String realm;
        private String role;
        private List<VpnServer> servers;
        private String serversNextLink;
        private List<AppListItem> targetedMobileApps;
        private String targetedMobileAppsNextLink;
        private List<String> targetedPackageIds;
        private String targetedPackageIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“Whether or not to enable always-on VPN connection.”</i>
         * 
         * @param alwaysOn
         *            value of {@code alwaysOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alwaysOn(Boolean alwaysOn) {
            this.alwaysOn = alwaysOn;
            this.changedFields = changedFields.add("alwaysOn");
            return this;
        }

        /**
         * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
         * when that VPN is disconnected.”</i>
         * 
         * @param alwaysOnLockdown
         *            value of {@code alwaysOnLockdown} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alwaysOnLockdown(Boolean alwaysOnLockdown) {
            this.alwaysOnLockdown = alwaysOnLockdown;
            this.changedFields = changedFields.add("alwaysOnLockdown");
            return this;
        }

        /**
         * <i>“Authentication method.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Connection name displayed to the user.”</i>
         * 
         * @param connectionName
         *            value of {@code connectionName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        /**
         * <i>“Connection type.”</i>
         * 
         * @param connectionType
         *            value of {@code connectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionType(AndroidWorkProfileVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customData
         *            value of {@code customData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customData(List<KeyValue> customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customData
         *            value of {@code customData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customData(KeyValue... customData) {
            return customData(Arrays.asList(customData));
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customDataNextLink
         *            value of {@code customData@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDataNextLink(String customDataNextLink) {
            this.customDataNextLink = customDataNextLink;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueData
         *            value of {@code customKeyValueData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueData(List<KeyValuePair> customKeyValueData) {
            this.customKeyValueData = customKeyValueData;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueData
         *            value of {@code customKeyValueData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueData(KeyValuePair... customKeyValueData) {
            return customKeyValueData(Arrays.asList(customKeyValueData));
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueDataNextLink
         *            value of {@code customKeyValueData@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueDataNextLink(String customKeyValueDataNextLink) {
            this.customKeyValueDataNextLink = customKeyValueDataNextLink;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        /**
         * <i>“Fingerprint is a string that will be used to verify the VPN server can be
         * trusted, which is only applicable when connection type is Check Point Capsule
         * VPN.”</i>
         * 
         * @param fingerprint
         *            value of {@code fingerprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            this.changedFields = changedFields.add("fingerprint");
            return this;
        }

        /**
         * <i>“Microsoft Tunnel site ID.”</i>
         * 
         * @param microsoftTunnelSiteId
         *            value of {@code microsoftTunnelSiteId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftTunnelSiteId(String microsoftTunnelSiteId) {
            this.microsoftTunnelSiteId = microsoftTunnelSiteId;
            this.changedFields = changedFields.add("microsoftTunnelSiteId");
            return this;
        }

        /**
         * <i>“Proxy server.”</i>
         * 
         * @param proxyServer
         *            value of {@code proxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyServer(VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        /**
         * <i>“Realm when connection type is set to Pulse Secure.”</i>
         * 
         * @param realm
         *            value of {@code realm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        /**
         * <i>“Role when connection type is set to Pulse Secure.”</i>
         * 
         * @param role
         *            value of {@code role} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param serversNextLink
         *            value of {@code servers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param targetedMobileApps
         *            value of {@code targetedMobileApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedMobileApps(List<AppListItem> targetedMobileApps) {
            this.targetedMobileApps = targetedMobileApps;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        /**
         * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param targetedMobileApps
         *            value of {@code targetedMobileApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedMobileApps(AppListItem... targetedMobileApps) {
            return targetedMobileApps(Arrays.asList(targetedMobileApps));
        }

        /**
         * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param targetedMobileAppsNextLink
         *            value of {@code targetedMobileApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedMobileAppsNextLink(String targetedMobileAppsNextLink) {
            this.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            this.changedFields = changedFields.add("targetedMobileApps");
            return this;
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIds
         *            value of {@code targetedPackageIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIds(List<String> targetedPackageIds) {
            this.targetedPackageIds = targetedPackageIds;
            this.changedFields = changedFields.add("targetedPackageIds");
            return this;
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIds
         *            value of {@code targetedPackageIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIds(String... targetedPackageIds) {
            return targetedPackageIds(Arrays.asList(targetedPackageIds));
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIdsNextLink
         *            value of {@code targetedPackageIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIdsNextLink(String targetedPackageIdsNextLink) {
            this.targetedPackageIdsNextLink = targetedPackageIdsNextLink;
            this.changedFields = changedFields.add("targetedPackageIds");
            return this;
        }

        public AndroidWorkProfileVpnConfiguration build() {
            AndroidWorkProfileVpnConfiguration _x = new AndroidWorkProfileVpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidWorkProfileVpnConfiguration";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.alwaysOn = alwaysOn;
            _x.alwaysOnLockdown = alwaysOnLockdown;
            _x.authenticationMethod = authenticationMethod;
            _x.connectionName = connectionName;
            _x.connectionType = connectionType;
            _x.customData = customData;
            _x.customDataNextLink = customDataNextLink;
            _x.customKeyValueData = customKeyValueData;
            _x.customKeyValueDataNextLink = customKeyValueDataNextLink;
            _x.fingerprint = fingerprint;
            _x.microsoftTunnelSiteId = microsoftTunnelSiteId;
            _x.proxyServer = proxyServer;
            _x.realm = realm;
            _x.role = role;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.targetedMobileApps = targetedMobileApps;
            _x.targetedMobileAppsNextLink = targetedMobileAppsNextLink;
            _x.targetedPackageIds = targetedPackageIds;
            _x.targetedPackageIdsNextLink = targetedPackageIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Whether or not to enable always-on VPN connection.”</i>
     * 
     * @return property alwaysOn
     */
    @Property(name="alwaysOn")
    @JsonIgnore
    public Optional<Boolean> getAlwaysOn() {
        return Optional.ofNullable(alwaysOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code alwaysOn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether or not to enable always-on VPN connection.”</i>
     * 
     * @param alwaysOn
     *            new value of {@code alwaysOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alwaysOn} field changed
     */
    public AndroidWorkProfileVpnConfiguration withAlwaysOn(Boolean alwaysOn) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("alwaysOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.alwaysOn = alwaysOn;
        return _x;
    }

    /**
     * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
     * when that VPN is disconnected.”</i>
     * 
     * @return property alwaysOnLockdown
     */
    @Property(name="alwaysOnLockdown")
    @JsonIgnore
    public Optional<Boolean> getAlwaysOnLockdown() {
        return Optional.ofNullable(alwaysOnLockdown);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code alwaysOnLockdown}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
     * when that VPN is disconnected.”</i>
     * 
     * @param alwaysOnLockdown
     *            new value of {@code alwaysOnLockdown} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alwaysOnLockdown} field changed
     */
    public AndroidWorkProfileVpnConfiguration withAlwaysOnLockdown(Boolean alwaysOnLockdown) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("alwaysOnLockdown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.alwaysOnLockdown = alwaysOnLockdown;
        return _x;
    }

    /**
     * <i>“Authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidWorkProfileVpnConfiguration withAuthenticationMethod(VpnAuthenticationMethod authenticationMethod) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @return property connectionName
     */
    @Property(name="connectionName")
    @JsonIgnore
    public Optional<String> getConnectionName() {
        return Optional.ofNullable(connectionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @param connectionName
     *            new value of {@code connectionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionName} field changed
     */
    public AndroidWorkProfileVpnConfiguration withConnectionName(String connectionName) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.connectionName = connectionName;
        return _x;
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<AndroidWorkProfileVpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public AndroidWorkProfileVpnConfiguration withConnectionType(AndroidWorkProfileVpnConnectionType connectionType) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.customData, Optional.ofNullable(customDataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code customData} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @param customData
     *            new value of {@code customData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customData} field changed
     */
    public AndroidWorkProfileVpnConfiguration withCustomData(List<KeyValue> customData) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.customData = customData;
        return _x;
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, this.customData, Optional.ofNullable(customDataNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customKeyValueData} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @param customKeyValueData
     *            new value of {@code customKeyValueData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customKeyValueData} field changed
     */
    public AndroidWorkProfileVpnConfiguration withCustomKeyValueData(List<KeyValuePair> customKeyValueData) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("customKeyValueData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.customKeyValueData = customKeyValueData;
        return _x;
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, this.customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Fingerprint is a string that will be used to verify the VPN server can be
     * trusted, which is only applicable when connection type is Check Point Capsule
     * VPN.”</i>
     * 
     * @return property fingerprint
     */
    @Property(name="fingerprint")
    @JsonIgnore
    public Optional<String> getFingerprint() {
        return Optional.ofNullable(fingerprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fingerprint}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Fingerprint is a string that will be used to verify the VPN server can be
     * trusted, which is only applicable when connection type is Check Point Capsule
     * VPN.”</i>
     * 
     * @param fingerprint
     *            new value of {@code fingerprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fingerprint} field changed
     */
    public AndroidWorkProfileVpnConfiguration withFingerprint(String fingerprint) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("fingerprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.fingerprint = fingerprint;
        return _x;
    }

    /**
     * <i>“Microsoft Tunnel site ID.”</i>
     * 
     * @return property microsoftTunnelSiteId
     */
    @Property(name="microsoftTunnelSiteId")
    @JsonIgnore
    public Optional<String> getMicrosoftTunnelSiteId() {
        return Optional.ofNullable(microsoftTunnelSiteId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftTunnelSiteId} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Microsoft Tunnel site ID.”</i>
     * 
     * @param microsoftTunnelSiteId
     *            new value of {@code microsoftTunnelSiteId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftTunnelSiteId} field changed
     */
    public AndroidWorkProfileVpnConfiguration withMicrosoftTunnelSiteId(String microsoftTunnelSiteId) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftTunnelSiteId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.microsoftTunnelSiteId = microsoftTunnelSiteId;
        return _x;
    }

    /**
     * <i>“Proxy server.”</i>
     * 
     * @return property proxyServer
     */
    @Property(name="proxyServer")
    @JsonIgnore
    public Optional<VpnProxyServer> getProxyServer() {
        return Optional.ofNullable(proxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy server.”</i>
     * 
     * @param proxyServer
     *            new value of {@code proxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServer} field changed
     */
    public AndroidWorkProfileVpnConfiguration withProxyServer(VpnProxyServer proxyServer) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.proxyServer = proxyServer;
        return _x;
    }

    /**
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public AndroidWorkProfileVpnConfiguration withRealm(String realm) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("realm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @return property role
     */
    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code role} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @param role
     *            new value of {@code role} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code role} field changed
     */
    public AndroidWorkProfileVpnConfiguration withRole(String role) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.role = role;
        return _x;
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers() {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, this.servers, Optional.ofNullable(serversNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code servers} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param servers
     *            new value of {@code servers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code servers} field changed
     */
    public AndroidWorkProfileVpnConfiguration withServers(List<VpnServer> servers) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("servers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.servers = servers;
        return _x;
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers(HttpRequestOptions options) {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, this.servers, Optional.ofNullable(serversNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getTargetedMobileApps() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedMobileApps} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param targetedMobileApps
     *            new value of {@code targetedMobileApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedMobileApps} field changed
     */
    public AndroidWorkProfileVpnConfiguration withTargetedMobileApps(List<AppListItem> targetedMobileApps) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("targetedMobileApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.targetedMobileApps = targetedMobileApps;
        return _x;
    }

    /**
     * <i>“Targeted mobile apps. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property targetedMobileApps
     */
    @Property(name="targetedMobileApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getTargetedMobileApps(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, this.targetedMobileApps, Optional.ofNullable(targetedMobileAppsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Targeted App package IDs.”</i>
     * 
     * @return property targetedPackageIds
     */
    @Property(name="targetedPackageIds")
    @JsonIgnore
    public CollectionPage<String> getTargetedPackageIds() {
        return new CollectionPage<String>(contextPath, String.class, this.targetedPackageIds, Optional.ofNullable(targetedPackageIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * targetedPackageIds} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Targeted App package IDs.”</i>
     * 
     * @param targetedPackageIds
     *            new value of {@code targetedPackageIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetedPackageIds} field changed
     */
    public AndroidWorkProfileVpnConfiguration withTargetedPackageIds(List<String> targetedPackageIds) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("targetedPackageIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileVpnConfiguration");
        _x.targetedPackageIds = targetedPackageIds;
        return _x;
    }

    /**
     * <i>“Targeted App package IDs.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property targetedPackageIds
     */
    @Property(name="targetedPackageIds")
    @JsonIgnore
    public CollectionPage<String> getTargetedPackageIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.targetedPackageIds, Optional.ofNullable(targetedPackageIdsNextLink), Collections.emptyList(), options);
    }

    public AndroidWorkProfileVpnConfiguration withUnmappedField(String name, Object value) {
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public AndroidWorkProfileCertificateProfileBaseRequest getIdentityCertificate() {
        return new AndroidWorkProfileCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"), RequestHelper.getValue(unmappedFields, "identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidWorkProfileVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidWorkProfileVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidWorkProfileVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidWorkProfileVpnConfiguration _copy() {
        AndroidWorkProfileVpnConfiguration _x = new AndroidWorkProfileVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.alwaysOn = alwaysOn;
        _x.alwaysOnLockdown = alwaysOnLockdown;
        _x.authenticationMethod = authenticationMethod;
        _x.connectionName = connectionName;
        _x.connectionType = connectionType;
        _x.customData = customData;
        _x.customKeyValueData = customKeyValueData;
        _x.fingerprint = fingerprint;
        _x.microsoftTunnelSiteId = microsoftTunnelSiteId;
        _x.proxyServer = proxyServer;
        _x.realm = realm;
        _x.role = role;
        _x.servers = servers;
        _x.targetedMobileApps = targetedMobileApps;
        _x.targetedPackageIds = targetedPackageIds;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidWorkProfileVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("alwaysOn=");
        b.append(this.alwaysOn);
        b.append(", ");
        b.append("alwaysOnLockdown=");
        b.append(this.alwaysOnLockdown);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("customKeyValueData=");
        b.append(this.customKeyValueData);
        b.append(", ");
        b.append("fingerprint=");
        b.append(this.fingerprint);
        b.append(", ");
        b.append("microsoftTunnelSiteId=");
        b.append(this.microsoftTunnelSiteId);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("targetedMobileApps=");
        b.append(this.targetedMobileApps);
        b.append(", ");
        b.append("targetedPackageIds=");
        b.append(this.targetedPackageIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
