package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidEnrollmentCompanyCode;
import odata.msgraph.client.beta.enums.AndroidManagedStoreAccountAppSyncStatus;
import odata.msgraph.client.beta.enums.AndroidManagedStoreAccountBindStatus;
import odata.msgraph.client.beta.enums.AndroidManagedStoreAccountEnrollmentTarget;


/**
 * <i>“Enterprise settings for an Android managed store account.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "androidDeviceOwnerFullyManagedEnrollmentEnabled", 
    "bindStatus", 
    "companyCodes", 
    "deviceOwnerManagementEnabled", 
    "enrollmentTarget", 
    "lastAppSyncDateTime", 
    "lastAppSyncStatus", 
    "lastModifiedDateTime", 
    "managedGooglePlayInitialScopeTagIds", 
    "ownerOrganizationName", 
    "ownerUserPrincipalName", 
    "targetGroupIds"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreAccountEnterpriseSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreAccountEnterpriseSettings";
    }

    @JsonProperty("androidDeviceOwnerFullyManagedEnrollmentEnabled")
    protected Boolean androidDeviceOwnerFullyManagedEnrollmentEnabled;

    @JsonProperty("bindStatus")
    protected AndroidManagedStoreAccountBindStatus bindStatus;

    @JsonProperty("companyCodes")
    protected List<AndroidEnrollmentCompanyCode> companyCodes;

    @JsonProperty("companyCodes@nextLink")
    protected String companyCodesNextLink;

    @JsonProperty("deviceOwnerManagementEnabled")
    protected Boolean deviceOwnerManagementEnabled;

    @JsonProperty("enrollmentTarget")
    protected AndroidManagedStoreAccountEnrollmentTarget enrollmentTarget;

    @JsonProperty("lastAppSyncDateTime")
    protected OffsetDateTime lastAppSyncDateTime;

    @JsonProperty("lastAppSyncStatus")
    protected AndroidManagedStoreAccountAppSyncStatus lastAppSyncStatus;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("managedGooglePlayInitialScopeTagIds")
    protected List<String> managedGooglePlayInitialScopeTagIds;

    @JsonProperty("managedGooglePlayInitialScopeTagIds@nextLink")
    protected String managedGooglePlayInitialScopeTagIdsNextLink;

    @JsonProperty("ownerOrganizationName")
    protected String ownerOrganizationName;

    @JsonProperty("ownerUserPrincipalName")
    protected String ownerUserPrincipalName;

    @JsonProperty("targetGroupIds")
    protected List<String> targetGroupIds;

    @JsonProperty("targetGroupIds@nextLink")
    protected String targetGroupIdsNextLink;

    protected AndroidManagedStoreAccountEnterpriseSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreAccountEnterpriseSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Boolean androidDeviceOwnerFullyManagedEnrollmentEnabled;
        private AndroidManagedStoreAccountBindStatus bindStatus;
        private List<AndroidEnrollmentCompanyCode> companyCodes;
        private String companyCodesNextLink;
        private Boolean deviceOwnerManagementEnabled;
        private AndroidManagedStoreAccountEnrollmentTarget enrollmentTarget;
        private OffsetDateTime lastAppSyncDateTime;
        private AndroidManagedStoreAccountAppSyncStatus lastAppSyncStatus;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> managedGooglePlayInitialScopeTagIds;
        private String managedGooglePlayInitialScopeTagIdsNextLink;
        private String ownerOrganizationName;
        private String ownerUserPrincipalName;
        private List<String> targetGroupIds;
        private String targetGroupIdsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
         * 
         * @param androidDeviceOwnerFullyManagedEnrollmentEnabled
         *            value of {@code androidDeviceOwnerFullyManagedEnrollmentEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder androidDeviceOwnerFullyManagedEnrollmentEnabled(Boolean androidDeviceOwnerFullyManagedEnrollmentEnabled) {
            this.androidDeviceOwnerFullyManagedEnrollmentEnabled = androidDeviceOwnerFullyManagedEnrollmentEnabled;
            this.changedFields = changedFields.add("androidDeviceOwnerFullyManagedEnrollmentEnabled");
            return this;
        }

        /**
         * <i>“Bind status of the tenant with the Google EMM API”</i>
         * 
         * @param bindStatus
         *            value of {@code bindStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bindStatus(AndroidManagedStoreAccountBindStatus bindStatus) {
            this.bindStatus = bindStatus;
            this.changedFields = changedFields.add("bindStatus");
            return this;
        }

        /**
         * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
         * 
         * @param companyCodes
         *            value of {@code companyCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyCodes(List<AndroidEnrollmentCompanyCode> companyCodes) {
            this.companyCodes = companyCodes;
            this.changedFields = changedFields.add("companyCodes");
            return this;
        }

        /**
         * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
         * 
         * @param companyCodes
         *            value of {@code companyCodes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyCodes(AndroidEnrollmentCompanyCode... companyCodes) {
            return companyCodes(Arrays.asList(companyCodes));
        }

        /**
         * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
         * 
         * @param companyCodesNextLink
         *            value of {@code companyCodes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder companyCodesNextLink(String companyCodesNextLink) {
            this.companyCodesNextLink = companyCodesNextLink;
            this.changedFields = changedFields.add("companyCodes");
            return this;
        }

        /**
         * <i>“Indicates if this account is flighting for Android Device Owner Management with
         * CloudDPC.”</i>
         * 
         * @param deviceOwnerManagementEnabled
         *            value of {@code deviceOwnerManagementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceOwnerManagementEnabled(Boolean deviceOwnerManagementEnabled) {
            this.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
            this.changedFields = changedFields.add("deviceOwnerManagementEnabled");
            return this;
        }

        /**
         * <i>“Indicates which users can enroll devices in Android Enterprise device management”</i>
         * 
         * @param enrollmentTarget
         *            value of {@code enrollmentTarget} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentTarget(AndroidManagedStoreAccountEnrollmentTarget enrollmentTarget) {
            this.enrollmentTarget = enrollmentTarget;
            this.changedFields = changedFields.add("enrollmentTarget");
            return this;
        }

        /**
         * <i>“Last completion time for app sync”</i>
         * 
         * @param lastAppSyncDateTime
         *            value of {@code lastAppSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastAppSyncDateTime(OffsetDateTime lastAppSyncDateTime) {
            this.lastAppSyncDateTime = lastAppSyncDateTime;
            this.changedFields = changedFields.add("lastAppSyncDateTime");
            return this;
        }

        /**
         * <i>“Last application sync result”</i>
         * 
         * @param lastAppSyncStatus
         *            value of {@code lastAppSyncStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastAppSyncStatus(AndroidManagedStoreAccountAppSyncStatus lastAppSyncStatus) {
            this.lastAppSyncStatus = lastAppSyncStatus;
            this.changedFields = changedFields.add("lastAppSyncStatus");
            return this;
        }

        /**
         * <i>“Last modification time for Android enterprise settings”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Initial scope tags for MGP apps”</i>
         * 
         * @param managedGooglePlayInitialScopeTagIds
         *            value of {@code managedGooglePlayInitialScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedGooglePlayInitialScopeTagIds(List<String> managedGooglePlayInitialScopeTagIds) {
            this.managedGooglePlayInitialScopeTagIds = managedGooglePlayInitialScopeTagIds;
            this.changedFields = changedFields.add("managedGooglePlayInitialScopeTagIds");
            return this;
        }

        /**
         * <i>“Initial scope tags for MGP apps”</i>
         * 
         * @param managedGooglePlayInitialScopeTagIds
         *            value of {@code managedGooglePlayInitialScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedGooglePlayInitialScopeTagIds(String... managedGooglePlayInitialScopeTagIds) {
            return managedGooglePlayInitialScopeTagIds(Arrays.asList(managedGooglePlayInitialScopeTagIds));
        }

        /**
         * <i>“Initial scope tags for MGP apps”</i>
         * 
         * @param managedGooglePlayInitialScopeTagIdsNextLink
         *            value of {@code managedGooglePlayInitialScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedGooglePlayInitialScopeTagIdsNextLink(String managedGooglePlayInitialScopeTagIdsNextLink) {
            this.managedGooglePlayInitialScopeTagIdsNextLink = managedGooglePlayInitialScopeTagIdsNextLink;
            this.changedFields = changedFields.add("managedGooglePlayInitialScopeTagIds");
            return this;
        }

        /**
         * <i>“Organization name used when onboarding Android Enterprise”</i>
         * 
         * @param ownerOrganizationName
         *            value of {@code ownerOrganizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerOrganizationName(String ownerOrganizationName) {
            this.ownerOrganizationName = ownerOrganizationName;
            this.changedFields = changedFields.add("ownerOrganizationName");
            return this;
        }

        /**
         * <i>“Owner UPN that created the enterprise”</i>
         * 
         * @param ownerUserPrincipalName
         *            value of {@code ownerUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerUserPrincipalName(String ownerUserPrincipalName) {
            this.ownerUserPrincipalName = ownerUserPrincipalName;
            this.changedFields = changedFields.add("ownerUserPrincipalName");
            return this;
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIds
         *            value of {@code targetGroupIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIds(List<String> targetGroupIds) {
            this.targetGroupIds = targetGroupIds;
            this.changedFields = changedFields.add("targetGroupIds");
            return this;
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIds
         *            value of {@code targetGroupIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIds(String... targetGroupIds) {
            return targetGroupIds(Arrays.asList(targetGroupIds));
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIdsNextLink
         *            value of {@code targetGroupIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIdsNextLink(String targetGroupIdsNextLink) {
            this.targetGroupIdsNextLink = targetGroupIdsNextLink;
            this.changedFields = changedFields.add("targetGroupIds");
            return this;
        }

        public AndroidManagedStoreAccountEnterpriseSettings build() {
            AndroidManagedStoreAccountEnterpriseSettings _x = new AndroidManagedStoreAccountEnterpriseSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidManagedStoreAccountEnterpriseSettings";
            _x.id = id;
            _x.androidDeviceOwnerFullyManagedEnrollmentEnabled = androidDeviceOwnerFullyManagedEnrollmentEnabled;
            _x.bindStatus = bindStatus;
            _x.companyCodes = companyCodes;
            _x.companyCodesNextLink = companyCodesNextLink;
            _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
            _x.enrollmentTarget = enrollmentTarget;
            _x.lastAppSyncDateTime = lastAppSyncDateTime;
            _x.lastAppSyncStatus = lastAppSyncStatus;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.managedGooglePlayInitialScopeTagIds = managedGooglePlayInitialScopeTagIds;
            _x.managedGooglePlayInitialScopeTagIdsNextLink = managedGooglePlayInitialScopeTagIdsNextLink;
            _x.ownerOrganizationName = ownerOrganizationName;
            _x.ownerUserPrincipalName = ownerUserPrincipalName;
            _x.targetGroupIds = targetGroupIds;
            _x.targetGroupIdsNextLink = targetGroupIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
     * 
     * @return property androidDeviceOwnerFullyManagedEnrollmentEnabled
     */
    @Property(name="androidDeviceOwnerFullyManagedEnrollmentEnabled")
    @JsonIgnore
    public Optional<Boolean> getAndroidDeviceOwnerFullyManagedEnrollmentEnabled() {
        return Optional.ofNullable(androidDeviceOwnerFullyManagedEnrollmentEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * androidDeviceOwnerFullyManagedEnrollmentEnabled} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
     * 
     * @param androidDeviceOwnerFullyManagedEnrollmentEnabled
     *            new value of {@code androidDeviceOwnerFullyManagedEnrollmentEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code androidDeviceOwnerFullyManagedEnrollmentEnabled} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withAndroidDeviceOwnerFullyManagedEnrollmentEnabled(Boolean androidDeviceOwnerFullyManagedEnrollmentEnabled) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("androidDeviceOwnerFullyManagedEnrollmentEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.androidDeviceOwnerFullyManagedEnrollmentEnabled = androidDeviceOwnerFullyManagedEnrollmentEnabled;
        return _x;
    }

    /**
     * <i>“Bind status of the tenant with the Google EMM API”</i>
     * 
     * @return property bindStatus
     */
    @Property(name="bindStatus")
    @JsonIgnore
    public Optional<AndroidManagedStoreAccountBindStatus> getBindStatus() {
        return Optional.ofNullable(bindStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bindStatus} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Bind status of the tenant with the Google EMM API”</i>
     * 
     * @param bindStatus
     *            new value of {@code bindStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bindStatus} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withBindStatus(AndroidManagedStoreAccountBindStatus bindStatus) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("bindStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.bindStatus = bindStatus;
        return _x;
    }

    /**
     * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
     * 
     * @return property companyCodes
     */
    @Property(name="companyCodes")
    @JsonIgnore
    public CollectionPage<AndroidEnrollmentCompanyCode> getCompanyCodes() {
        return new CollectionPage<AndroidEnrollmentCompanyCode>(contextPath, AndroidEnrollmentCompanyCode.class, this.companyCodes, Optional.ofNullable(companyCodesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code companyCodes}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
     * 
     * @param companyCodes
     *            new value of {@code companyCodes} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code companyCodes} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withCompanyCodes(List<AndroidEnrollmentCompanyCode> companyCodes) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("companyCodes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.companyCodes = companyCodes;
        return _x;
    }

    /**
     * <i>“Company codes for AndroidManagedStoreAccountEnterpriseSettings”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property companyCodes
     */
    @Property(name="companyCodes")
    @JsonIgnore
    public CollectionPage<AndroidEnrollmentCompanyCode> getCompanyCodes(HttpRequestOptions options) {
        return new CollectionPage<AndroidEnrollmentCompanyCode>(contextPath, AndroidEnrollmentCompanyCode.class, this.companyCodes, Optional.ofNullable(companyCodesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if this account is flighting for Android Device Owner Management with
     * CloudDPC.”</i>
     * 
     * @return property deviceOwnerManagementEnabled
     */
    @Property(name="deviceOwnerManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceOwnerManagementEnabled() {
        return Optional.ofNullable(deviceOwnerManagementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceOwnerManagementEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if this account is flighting for Android Device Owner Management with
     * CloudDPC.”</i>
     * 
     * @param deviceOwnerManagementEnabled
     *            new value of {@code deviceOwnerManagementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceOwnerManagementEnabled} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withDeviceOwnerManagementEnabled(Boolean deviceOwnerManagementEnabled) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("deviceOwnerManagementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
        return _x;
    }

    /**
     * <i>“Indicates which users can enroll devices in Android Enterprise device management”</i>
     * 
     * @return property enrollmentTarget
     */
    @Property(name="enrollmentTarget")
    @JsonIgnore
    public Optional<AndroidManagedStoreAccountEnrollmentTarget> getEnrollmentTarget() {
        return Optional.ofNullable(enrollmentTarget);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentTarget}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates which users can enroll devices in Android Enterprise device management”</i>
     * 
     * @param enrollmentTarget
     *            new value of {@code enrollmentTarget} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentTarget} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withEnrollmentTarget(AndroidManagedStoreAccountEnrollmentTarget enrollmentTarget) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("enrollmentTarget");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.enrollmentTarget = enrollmentTarget;
        return _x;
    }

    /**
     * <i>“Last completion time for app sync”</i>
     * 
     * @return property lastAppSyncDateTime
     */
    @Property(name="lastAppSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAppSyncDateTime() {
        return Optional.ofNullable(lastAppSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastAppSyncDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last completion time for app sync”</i>
     * 
     * @param lastAppSyncDateTime
     *            new value of {@code lastAppSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastAppSyncDateTime} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withLastAppSyncDateTime(OffsetDateTime lastAppSyncDateTime) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("lastAppSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.lastAppSyncDateTime = lastAppSyncDateTime;
        return _x;
    }

    /**
     * <i>“Last application sync result”</i>
     * 
     * @return property lastAppSyncStatus
     */
    @Property(name="lastAppSyncStatus")
    @JsonIgnore
    public Optional<AndroidManagedStoreAccountAppSyncStatus> getLastAppSyncStatus() {
        return Optional.ofNullable(lastAppSyncStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastAppSyncStatus
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last application sync result”</i>
     * 
     * @param lastAppSyncStatus
     *            new value of {@code lastAppSyncStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastAppSyncStatus} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withLastAppSyncStatus(AndroidManagedStoreAccountAppSyncStatus lastAppSyncStatus) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("lastAppSyncStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.lastAppSyncStatus = lastAppSyncStatus;
        return _x;
    }

    /**
     * <i>“Last modification time for Android enterprise settings”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modification time for Android enterprise settings”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Initial scope tags for MGP apps”</i>
     * 
     * @return property managedGooglePlayInitialScopeTagIds
     */
    @Property(name="managedGooglePlayInitialScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getManagedGooglePlayInitialScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, this.managedGooglePlayInitialScopeTagIds, Optional.ofNullable(managedGooglePlayInitialScopeTagIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedGooglePlayInitialScopeTagIds} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Initial scope tags for MGP apps”</i>
     * 
     * @param managedGooglePlayInitialScopeTagIds
     *            new value of {@code managedGooglePlayInitialScopeTagIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedGooglePlayInitialScopeTagIds} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withManagedGooglePlayInitialScopeTagIds(List<String> managedGooglePlayInitialScopeTagIds) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("managedGooglePlayInitialScopeTagIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.managedGooglePlayInitialScopeTagIds = managedGooglePlayInitialScopeTagIds;
        return _x;
    }

    /**
     * <i>“Initial scope tags for MGP apps”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property managedGooglePlayInitialScopeTagIds
     */
    @Property(name="managedGooglePlayInitialScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getManagedGooglePlayInitialScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.managedGooglePlayInitialScopeTagIds, Optional.ofNullable(managedGooglePlayInitialScopeTagIdsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Organization name used when onboarding Android Enterprise”</i>
     * 
     * @return property ownerOrganizationName
     */
    @Property(name="ownerOrganizationName")
    @JsonIgnore
    public Optional<String> getOwnerOrganizationName() {
        return Optional.ofNullable(ownerOrganizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ownerOrganizationName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Organization name used when onboarding Android Enterprise”</i>
     * 
     * @param ownerOrganizationName
     *            new value of {@code ownerOrganizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerOrganizationName} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withOwnerOrganizationName(String ownerOrganizationName) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("ownerOrganizationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.ownerOrganizationName = ownerOrganizationName;
        return _x;
    }

    /**
     * <i>“Owner UPN that created the enterprise”</i>
     * 
     * @return property ownerUserPrincipalName
     */
    @Property(name="ownerUserPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerUserPrincipalName() {
        return Optional.ofNullable(ownerUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ownerUserPrincipalName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Owner UPN that created the enterprise”</i>
     * 
     * @param ownerUserPrincipalName
     *            new value of {@code ownerUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerUserPrincipalName} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withOwnerUserPrincipalName(String ownerUserPrincipalName) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("ownerUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        return _x;
    }

    /**
     * <i>“Specifies which AAD groups can enroll devices in Android for Work device
     * management if enrollmentTarget is set to 'Targeted'”</i>
     * 
     * @return property targetGroupIds
     */
    @Property(name="targetGroupIds")
    @JsonIgnore
    public CollectionPage<String> getTargetGroupIds() {
        return new CollectionPage<String>(contextPath, String.class, this.targetGroupIds, Optional.ofNullable(targetGroupIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code targetGroupIds}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Specifies which AAD groups can enroll devices in Android for Work device
     * management if enrollmentTarget is set to 'Targeted'”</i>
     * 
     * @param targetGroupIds
     *            new value of {@code targetGroupIds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code targetGroupIds} field changed
     */
    public AndroidManagedStoreAccountEnterpriseSettings withTargetGroupIds(List<String> targetGroupIds) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = changedFields.add("targetGroupIds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAccountEnterpriseSettings");
        _x.targetGroupIds = targetGroupIds;
        return _x;
    }

    /**
     * <i>“Specifies which AAD groups can enroll devices in Android for Work device
     * management if enrollmentTarget is set to 'Targeted'”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property targetGroupIds
     */
    @Property(name="targetGroupIds")
    @JsonIgnore
    public CollectionPage<String> getTargetGroupIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.targetGroupIds, Optional.ofNullable(targetGroupIdsNextLink), Collections.emptyList(), options);
    }

    public AndroidManagedStoreAccountEnterpriseSettings withUnmappedField(String name, Object value) {
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreAccountEnterpriseSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreAccountEnterpriseSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreAccountEnterpriseSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedStoreAccountEnterpriseSettings _copy() {
        AndroidManagedStoreAccountEnterpriseSettings _x = new AndroidManagedStoreAccountEnterpriseSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.androidDeviceOwnerFullyManagedEnrollmentEnabled = androidDeviceOwnerFullyManagedEnrollmentEnabled;
        _x.bindStatus = bindStatus;
        _x.companyCodes = companyCodes;
        _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
        _x.enrollmentTarget = enrollmentTarget;
        _x.lastAppSyncDateTime = lastAppSyncDateTime;
        _x.lastAppSyncStatus = lastAppSyncStatus;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.managedGooglePlayInitialScopeTagIds = managedGooglePlayInitialScopeTagIds;
        _x.ownerOrganizationName = ownerOrganizationName;
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        _x.targetGroupIds = targetGroupIds;
        return _x;
    }

    @Action(name = "approveApps")
    @JsonIgnore
    public ActionRequestNoReturn approveApps(List<String> packageIds, Boolean approveAllPermissions) {
        Preconditions.checkNotNull(approveAllPermissions, "approveAllPermissions cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("packageIds", "Collection(Edm.String)", Checks.checkIsAscii(packageIds))
            .put("approveAllPermissions", "Edm.Boolean", approveAllPermissions)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.approveApps"), _parameters);
    }

    @Action(name = "completeSignup")
    @JsonIgnore
    public ActionRequestNoReturn completeSignup(String enterpriseToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enterpriseToken", "Edm.String", Checks.checkIsAscii(enterpriseToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeSignup"), _parameters);
    }

    @Action(name = "createGooglePlayWebToken")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> createGooglePlayWebToken(String parentUri) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parentUri", "Edm.String", Checks.checkIsAscii(parentUri))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createGooglePlayWebToken"), String.class, _parameters);
    }

    @Action(name = "requestSignupUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> requestSignupUrl(String hostName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hostName", "Edm.String", Checks.checkIsAscii(hostName))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestSignupUrl"), String.class, _parameters);
    }

    @Action(name = "setAndroidDeviceOwnerFullyManagedEnrollmentState")
    @JsonIgnore
    public ActionRequestNoReturn setAndroidDeviceOwnerFullyManagedEnrollmentState(Boolean enabled) {
        Preconditions.checkNotNull(enabled, "enabled cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enabled", "Edm.Boolean", enabled)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.setAndroidDeviceOwnerFullyManagedEnrollmentState"), _parameters);
    }

    @Action(name = "syncApps")
    @JsonIgnore
    public ActionRequestNoReturn syncApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncApps"), _parameters);
    }

    @Action(name = "unbind")
    @JsonIgnore
    public ActionRequestNoReturn unbind() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unbind"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreAccountEnterpriseSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("androidDeviceOwnerFullyManagedEnrollmentEnabled=");
        b.append(this.androidDeviceOwnerFullyManagedEnrollmentEnabled);
        b.append(", ");
        b.append("bindStatus=");
        b.append(this.bindStatus);
        b.append(", ");
        b.append("companyCodes=");
        b.append(this.companyCodes);
        b.append(", ");
        b.append("deviceOwnerManagementEnabled=");
        b.append(this.deviceOwnerManagementEnabled);
        b.append(", ");
        b.append("enrollmentTarget=");
        b.append(this.enrollmentTarget);
        b.append(", ");
        b.append("lastAppSyncDateTime=");
        b.append(this.lastAppSyncDateTime);
        b.append(", ");
        b.append("lastAppSyncStatus=");
        b.append(this.lastAppSyncStatus);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("managedGooglePlayInitialScopeTagIds=");
        b.append(this.managedGooglePlayInitialScopeTagIds);
        b.append(", ");
        b.append("ownerOrganizationName=");
        b.append(this.ownerOrganizationName);
        b.append(", ");
        b.append("ownerUserPrincipalName=");
        b.append(this.ownerUserPrincipalName);
        b.append(", ");
        b.append("targetGroupIds=");
        b.append(this.targetGroupIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
