package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomSubjectAlternativeName;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.enums.CertificateStore;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.HashAlgorithms;
import odata.msgraph.client.beta.enums.KeySize;
import odata.msgraph.client.beta.enums.KeyUsages;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;


/**
 * <i>“Android For Work SCEP certificate profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certificateStore", 
    "customSubjectAlternativeNames", 
    "hashAlgorithm", 
    "keySize", 
    "keyUsage", 
    "scepServerUrls", 
    "subjectAlternativeNameFormatString", 
    "subjectNameFormatString"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkScepCertificateProfile extends AndroidForWorkCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkScepCertificateProfile";
    }

    @JsonProperty("certificateStore")
    protected CertificateStore certificateStore;

    @JsonProperty("customSubjectAlternativeNames")
    protected List<CustomSubjectAlternativeName> customSubjectAlternativeNames;

    @JsonProperty("customSubjectAlternativeNames@nextLink")
    protected String customSubjectAlternativeNamesNextLink;

    @JsonProperty("hashAlgorithm")
    protected HashAlgorithms hashAlgorithm;

    @JsonProperty("keySize")
    protected KeySize keySize;

    @JsonProperty("keyUsage")
    protected KeyUsages keyUsage;

    @JsonProperty("scepServerUrls")
    protected List<String> scepServerUrls;

    @JsonProperty("scepServerUrls@nextLink")
    protected String scepServerUrlsNextLink;

    @JsonProperty("subjectAlternativeNameFormatString")
    protected String subjectAlternativeNameFormatString;

    @JsonProperty("subjectNameFormatString")
    protected String subjectNameFormatString;

    protected AndroidForWorkScepCertificateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkScepCertificateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private Integer version;
        private List<DeviceConfigurationAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceConfigurationDeviceStatus> deviceStatuses;
        private DeviceConfigurationDeviceOverview deviceStatusOverview;
        private List<DeviceConfigurationGroupAssignment> groupAssignments;
        private List<DeviceConfigurationUserStatus> userStatuses;
        private DeviceConfigurationUserOverview userStatusOverview;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private Integer certificateValidityPeriodValue;
        private List<ExtendedKeyUsage> extendedKeyUsages;
        private String extendedKeyUsagesNextLink;
        private Integer renewalThresholdPercentage;
        private SubjectAlternativeNameType subjectAlternativeNameType;
        private SubjectNameFormat subjectNameFormat;
        private CertificateStore certificateStore;
        private List<CustomSubjectAlternativeName> customSubjectAlternativeNames;
        private String customSubjectAlternativeNamesNextLink;
        private HashAlgorithms hashAlgorithm;
        private KeySize keySize;
        private KeyUsages keyUsage;
        private List<String> scepServerUrls;
        private String scepServerUrlsNextLink;
        private String subjectAlternativeNameFormatString;
        private String subjectNameFormatString;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceConfigurationAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceConfigurationAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceConfigurationDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceConfigurationDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceConfigurationDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder groupAssignments(List<DeviceConfigurationGroupAssignment> groupAssignments) {
            this.groupAssignments = groupAssignments;
            this.changedFields = changedFields.add("groupAssignments");
            return this;
        }

        public Builder groupAssignments(DeviceConfigurationGroupAssignment... groupAssignments) {
            return groupAssignments(Arrays.asList(groupAssignments));
        }

        public Builder userStatuses(List<DeviceConfigurationUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceConfigurationUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceConfigurationUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        public Builder extendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = extendedKeyUsages;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder extendedKeyUsages(ExtendedKeyUsage... extendedKeyUsages) {
            return extendedKeyUsages(Arrays.asList(extendedKeyUsages));
        }

        public Builder extendedKeyUsagesNextLink(String extendedKeyUsagesNextLink) {
            this.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        public Builder subjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
            this.subjectAlternativeNameType = subjectAlternativeNameType;
            this.changedFields = changedFields.add("subjectAlternativeNameType");
            return this;
        }

        public Builder subjectNameFormat(SubjectNameFormat subjectNameFormat) {
            this.subjectNameFormat = subjectNameFormat;
            this.changedFields = changedFields.add("subjectNameFormat");
            return this;
        }

        /**
         * <i>“Target store certificate”</i>
         * 
         * @param certificateStore
         *            value of {@code certificateStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateStore(CertificateStore certificateStore) {
            this.certificateStore = certificateStore;
            this.changedFields = changedFields.add("certificateStore");
            return this;
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNames
         *            value of {@code customSubjectAlternativeNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNames(List<CustomSubjectAlternativeName> customSubjectAlternativeNames) {
            this.customSubjectAlternativeNames = customSubjectAlternativeNames;
            this.changedFields = changedFields.add("customSubjectAlternativeNames");
            return this;
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNames
         *            value of {@code customSubjectAlternativeNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNames(CustomSubjectAlternativeName... customSubjectAlternativeNames) {
            return customSubjectAlternativeNames(Arrays.asList(customSubjectAlternativeNames));
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNamesNextLink
         *            value of {@code customSubjectAlternativeNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNamesNextLink(String customSubjectAlternativeNamesNextLink) {
            this.customSubjectAlternativeNamesNextLink = customSubjectAlternativeNamesNextLink;
            this.changedFields = changedFields.add("customSubjectAlternativeNames");
            return this;
        }

        /**
         * <i>“SCEP Hash Algorithm”</i>
         * 
         * @param hashAlgorithm
         *            value of {@code hashAlgorithm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder hashAlgorithm(HashAlgorithms hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            this.changedFields = changedFields.add("hashAlgorithm");
            return this;
        }

        /**
         * <i>“SCEP Key Size”</i>
         * 
         * @param keySize
         *            value of {@code keySize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keySize(KeySize keySize) {
            this.keySize = keySize;
            this.changedFields = changedFields.add("keySize");
            return this;
        }

        /**
         * <i>“SCEP Key Usage”</i>
         * 
         * @param keyUsage
         *            value of {@code keyUsage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyUsage(KeyUsages keyUsage) {
            this.keyUsage = keyUsage;
            this.changedFields = changedFields.add("keyUsage");
            return this;
        }

        /**
         * <i>“SCEP Server Url(s)”</i>
         * 
         * @param scepServerUrls
         *            value of {@code scepServerUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrls(List<String> scepServerUrls) {
            this.scepServerUrls = scepServerUrls;
            this.changedFields = changedFields.add("scepServerUrls");
            return this;
        }

        /**
         * <i>“SCEP Server Url(s)”</i>
         * 
         * @param scepServerUrls
         *            value of {@code scepServerUrls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrls(String... scepServerUrls) {
            return scepServerUrls(Arrays.asList(scepServerUrls));
        }

        /**
         * <i>“SCEP Server Url(s)”</i>
         * 
         * @param scepServerUrlsNextLink
         *            value of {@code scepServerUrls@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder scepServerUrlsNextLink(String scepServerUrlsNextLink) {
            this.scepServerUrlsNextLink = scepServerUrlsNextLink;
            this.changedFields = changedFields.add("scepServerUrls");
            return this;
        }

        /**
         * <i>“Custom String that defines the AAD Attribute.”</i>
         * 
         * @param subjectAlternativeNameFormatString
         *            value of {@code subjectAlternativeNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
            this.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            this.changedFields = changedFields.add("subjectAlternativeNameFormatString");
            return this;
        }

        /**
         * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
         * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
         * C=US”</i>
         * 
         * @param subjectNameFormatString
         *            value of {@code subjectNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectNameFormatString(String subjectNameFormatString) {
            this.subjectNameFormatString = subjectNameFormatString;
            this.changedFields = changedFields.add("subjectNameFormatString");
            return this;
        }

        public AndroidForWorkScepCertificateProfile build() {
            AndroidForWorkScepCertificateProfile _x = new AndroidForWorkScepCertificateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidForWorkScepCertificateProfile";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.groupAssignments = groupAssignments;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.extendedKeyUsages = extendedKeyUsages;
            _x.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.subjectAlternativeNameType = subjectAlternativeNameType;
            _x.subjectNameFormat = subjectNameFormat;
            _x.certificateStore = certificateStore;
            _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
            _x.customSubjectAlternativeNamesNextLink = customSubjectAlternativeNamesNextLink;
            _x.hashAlgorithm = hashAlgorithm;
            _x.keySize = keySize;
            _x.keyUsage = keyUsage;
            _x.scepServerUrls = scepServerUrls;
            _x.scepServerUrlsNextLink = scepServerUrlsNextLink;
            _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            _x.subjectNameFormatString = subjectNameFormatString;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“Target store certificate”</i>
     * 
     * @return property certificateStore
     */
    @Property(name="certificateStore")
    @JsonIgnore
    public Optional<CertificateStore> getCertificateStore() {
        return Optional.ofNullable(certificateStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificateStore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Target store certificate”</i>
     * 
     * @param certificateStore
     *            new value of {@code certificateStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateStore} field changed
     */
    public AndroidForWorkScepCertificateProfile withCertificateStore(CertificateStore certificateStore) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateStore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.certificateStore = certificateStore;
        return _x;
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames() {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, this.customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customSubjectAlternativeNames} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @param customSubjectAlternativeNames
     *            new value of {@code customSubjectAlternativeNames} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customSubjectAlternativeNames} field changed
     */
    public AndroidForWorkScepCertificateProfile withCustomSubjectAlternativeNames(List<CustomSubjectAlternativeName> customSubjectAlternativeNames) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("customSubjectAlternativeNames");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        return _x;
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames(HttpRequestOptions options) {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, this.customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“SCEP Hash Algorithm”</i>
     * 
     * @return property hashAlgorithm
     */
    @Property(name="hashAlgorithm")
    @JsonIgnore
    public Optional<HashAlgorithms> getHashAlgorithm() {
        return Optional.ofNullable(hashAlgorithm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code hashAlgorithm}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SCEP Hash Algorithm”</i>
     * 
     * @param hashAlgorithm
     *            new value of {@code hashAlgorithm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code hashAlgorithm} field changed
     */
    public AndroidForWorkScepCertificateProfile withHashAlgorithm(HashAlgorithms hashAlgorithm) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("hashAlgorithm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.hashAlgorithm = hashAlgorithm;
        return _x;
    }

    /**
     * <i>“SCEP Key Size”</i>
     * 
     * @return property keySize
     */
    @Property(name="keySize")
    @JsonIgnore
    public Optional<KeySize> getKeySize() {
        return Optional.ofNullable(keySize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keySize} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SCEP Key Size”</i>
     * 
     * @param keySize
     *            new value of {@code keySize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keySize} field changed
     */
    public AndroidForWorkScepCertificateProfile withKeySize(KeySize keySize) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("keySize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.keySize = keySize;
        return _x;
    }

    /**
     * <i>“SCEP Key Usage”</i>
     * 
     * @return property keyUsage
     */
    @Property(name="keyUsage")
    @JsonIgnore
    public Optional<KeyUsages> getKeyUsage() {
        return Optional.ofNullable(keyUsage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code keyUsage} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“SCEP Key Usage”</i>
     * 
     * @param keyUsage
     *            new value of {@code keyUsage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyUsage} field changed
     */
    public AndroidForWorkScepCertificateProfile withKeyUsage(KeyUsages keyUsage) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("keyUsage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.keyUsage = keyUsage;
        return _x;
    }

    /**
     * <i>“SCEP Server Url(s)”</i>
     * 
     * @return property scepServerUrls
     */
    @Property(name="scepServerUrls")
    @JsonIgnore
    public CollectionPage<String> getScepServerUrls() {
        return new CollectionPage<String>(contextPath, String.class, this.scepServerUrls, Optional.ofNullable(scepServerUrlsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code scepServerUrls}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“SCEP Server Url(s)”</i>
     * 
     * @param scepServerUrls
     *            new value of {@code scepServerUrls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code scepServerUrls} field changed
     */
    public AndroidForWorkScepCertificateProfile withScepServerUrls(List<String> scepServerUrls) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("scepServerUrls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.scepServerUrls = scepServerUrls;
        return _x;
    }

    /**
     * <i>“SCEP Server Url(s)”</i>
     * 
     * @param options
     *            specify connect and read timeouts
     * @return property scepServerUrls
     */
    @Property(name="scepServerUrls")
    @JsonIgnore
    public CollectionPage<String> getScepServerUrls(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.scepServerUrls, Optional.ofNullable(scepServerUrlsNextLink), Collections.emptyList(), options);
    }

    /**
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @return property subjectAlternativeNameFormatString
     */
    @Property(name="subjectAlternativeNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectAlternativeNameFormatString() {
        return Optional.ofNullable(subjectAlternativeNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameFormatString} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @param subjectAlternativeNameFormatString
     *            new value of {@code subjectAlternativeNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameFormatString} field changed
     */
    public AndroidForWorkScepCertificateProfile withSubjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        return _x;
    }

    /**
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @return property subjectNameFormatString
     */
    @Property(name="subjectNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectNameFormatString() {
        return Optional.ofNullable(subjectNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectNameFormatString} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @param subjectNameFormatString
     *            new value of {@code subjectNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectNameFormatString} field changed
     */
    public AndroidForWorkScepCertificateProfile withSubjectNameFormatString(String subjectNameFormatString) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkScepCertificateProfile");
        _x.subjectNameFormatString = subjectNameFormatString;
        return _x;
    }

    public AndroidForWorkScepCertificateProfile withUnmappedField(String name, Object value) {
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    /**
     * <i>“Certificate state for devices. This collection can contain a maximum of
     * 2147483647 elements.”</i>
     * 
     * @return navigational property managedDeviceCertificateStates
     */
    @NavigationProperty(name="managedDeviceCertificateStates")
    @JsonIgnore
    public ManagedDeviceCertificateStateCollectionRequest getManagedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"), RequestHelper.getValue(unmappedFields, "managedDeviceCertificateStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkScepCertificateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkScepCertificateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkScepCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkScepCertificateProfile _copy() {
        AndroidForWorkScepCertificateProfile _x = new AndroidForWorkScepCertificateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.groupAssignments = groupAssignments;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.subjectNameFormat = subjectNameFormat;
        _x.certificateStore = certificateStore;
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        _x.hashAlgorithm = hashAlgorithm;
        _x.keySize = keySize;
        _x.keyUsage = keyUsage;
        _x.scepServerUrls = scepServerUrls;
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        _x.subjectNameFormatString = subjectNameFormatString;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkScepCertificateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("groupAssignments=");
        b.append(this.groupAssignments);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("certificateStore=");
        b.append(this.certificateStore);
        b.append(", ");
        b.append("customSubjectAlternativeNames=");
        b.append(this.customSubjectAlternativeNames);
        b.append(", ");
        b.append("hashAlgorithm=");
        b.append(this.hashAlgorithm);
        b.append(", ");
        b.append("keySize=");
        b.append(this.keySize);
        b.append(", ");
        b.append("keyUsage=");
        b.append(this.keyUsage);
        b.append(", ");
        b.append("scepServerUrls=");
        b.append(this.scepServerUrls);
        b.append(", ");
        b.append("subjectAlternativeNameFormatString=");
        b.append(this.subjectAlternativeNameFormatString);
        b.append(", ");
        b.append("subjectNameFormatString=");
        b.append(this.subjectNameFormatString);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
