package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidDeviceOwnerRequiredPasswordType;
import odata.msgraph.client.beta.enums.DeviceThreatProtectionLevel;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the AndroidDeviceOwnerCompliancePolicy resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "advancedThreatProtectionRequiredSecurityLevel", 
    "deviceThreatProtectionEnabled", 
    "deviceThreatProtectionRequiredSecurityLevel", 
    "minAndroidSecurityPatchLevel", 
    "osMaximumVersion", 
    "osMinimumVersion", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinimumLetterCharacters", 
    "passwordMinimumLowerCaseCharacters", 
    "passwordMinimumNonLetterCharacters", 
    "passwordMinimumNumericCharacters", 
    "passwordMinimumSymbolCharacters", 
    "passwordMinimumUpperCaseCharacters", 
    "passwordMinutesOfInactivityBeforeLock", 
    "passwordPreviousPasswordCountToBlock", 
    "passwordRequired", 
    "passwordRequiredType", 
    "securityRequireIntuneAppIntegrity", 
    "securityRequireSafetyNetAttestationBasicIntegrity", 
    "securityRequireSafetyNetAttestationCertifiedDevice", 
    "storageRequireEncryption"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerCompliancePolicy extends DeviceCompliancePolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerCompliancePolicy";
    }

    @JsonProperty("advancedThreatProtectionRequiredSecurityLevel")
    protected DeviceThreatProtectionLevel advancedThreatProtectionRequiredSecurityLevel;

    @JsonProperty("deviceThreatProtectionEnabled")
    protected Boolean deviceThreatProtectionEnabled;

    @JsonProperty("deviceThreatProtectionRequiredSecurityLevel")
    protected DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;

    @JsonProperty("minAndroidSecurityPatchLevel")
    protected String minAndroidSecurityPatchLevel;

    @JsonProperty("osMaximumVersion")
    protected String osMaximumVersion;

    @JsonProperty("osMinimumVersion")
    protected String osMinimumVersion;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinimumLetterCharacters")
    protected Integer passwordMinimumLetterCharacters;

    @JsonProperty("passwordMinimumLowerCaseCharacters")
    protected Integer passwordMinimumLowerCaseCharacters;

    @JsonProperty("passwordMinimumNonLetterCharacters")
    protected Integer passwordMinimumNonLetterCharacters;

    @JsonProperty("passwordMinimumNumericCharacters")
    protected Integer passwordMinimumNumericCharacters;

    @JsonProperty("passwordMinimumSymbolCharacters")
    protected Integer passwordMinimumSymbolCharacters;

    @JsonProperty("passwordMinimumUpperCaseCharacters")
    protected Integer passwordMinimumUpperCaseCharacters;

    @JsonProperty("passwordMinutesOfInactivityBeforeLock")
    protected Integer passwordMinutesOfInactivityBeforeLock;

    @JsonProperty("passwordPreviousPasswordCountToBlock")
    protected Integer passwordPreviousPasswordCountToBlock;

    @JsonProperty("passwordRequired")
    protected Boolean passwordRequired;

    @JsonProperty("passwordRequiredType")
    protected AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;

    @JsonProperty("securityRequireIntuneAppIntegrity")
    protected Boolean securityRequireIntuneAppIntegrity;

    @JsonProperty("securityRequireSafetyNetAttestationBasicIntegrity")
    protected Boolean securityRequireSafetyNetAttestationBasicIntegrity;

    @JsonProperty("securityRequireSafetyNetAttestationCertifiedDevice")
    protected Boolean securityRequireSafetyNetAttestationCertifiedDevice;

    @JsonProperty("storageRequireEncryption")
    protected Boolean storageRequireEncryption;

    protected AndroidDeviceOwnerCompliancePolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerCompliancePolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer version;
        private List<DeviceCompliancePolicyAssignment> assignments;
        private List<SettingStateDeviceSummary> deviceSettingStateSummaries;
        private List<DeviceComplianceDeviceStatus> deviceStatuses;
        private DeviceComplianceDeviceOverview deviceStatusOverview;
        private List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule;
        private List<DeviceComplianceUserStatus> userStatuses;
        private DeviceComplianceUserOverview userStatusOverview;
        private DeviceThreatProtectionLevel advancedThreatProtectionRequiredSecurityLevel;
        private Boolean deviceThreatProtectionEnabled;
        private DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel;
        private String minAndroidSecurityPatchLevel;
        private String osMaximumVersion;
        private String osMinimumVersion;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinimumLetterCharacters;
        private Integer passwordMinimumLowerCaseCharacters;
        private Integer passwordMinimumNonLetterCharacters;
        private Integer passwordMinimumNumericCharacters;
        private Integer passwordMinimumSymbolCharacters;
        private Integer passwordMinimumUpperCaseCharacters;
        private Integer passwordMinutesOfInactivityBeforeLock;
        private Integer passwordPreviousPasswordCountToBlock;
        private Boolean passwordRequired;
        private AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;
        private Boolean securityRequireIntuneAppIntegrity;
        private Boolean securityRequireSafetyNetAttestationBasicIntegrity;
        private Boolean securityRequireSafetyNetAttestationCertifiedDevice;
        private Boolean storageRequireEncryption;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder assignments(List<DeviceCompliancePolicyAssignment> assignments) {
            this.assignments = assignments;
            this.changedFields = changedFields.add("assignments");
            return this;
        }

        public Builder assignments(DeviceCompliancePolicyAssignment... assignments) {
            return assignments(Arrays.asList(assignments));
        }

        public Builder deviceSettingStateSummaries(List<SettingStateDeviceSummary> deviceSettingStateSummaries) {
            this.deviceSettingStateSummaries = deviceSettingStateSummaries;
            this.changedFields = changedFields.add("deviceSettingStateSummaries");
            return this;
        }

        public Builder deviceSettingStateSummaries(SettingStateDeviceSummary... deviceSettingStateSummaries) {
            return deviceSettingStateSummaries(Arrays.asList(deviceSettingStateSummaries));
        }

        public Builder deviceStatuses(List<DeviceComplianceDeviceStatus> deviceStatuses) {
            this.deviceStatuses = deviceStatuses;
            this.changedFields = changedFields.add("deviceStatuses");
            return this;
        }

        public Builder deviceStatuses(DeviceComplianceDeviceStatus... deviceStatuses) {
            return deviceStatuses(Arrays.asList(deviceStatuses));
        }

        public Builder deviceStatusOverview(DeviceComplianceDeviceOverview deviceStatusOverview) {
            this.deviceStatusOverview = deviceStatusOverview;
            this.changedFields = changedFields.add("deviceStatusOverview");
            return this;
        }

        public Builder scheduledActionsForRule(List<DeviceComplianceScheduledActionForRule> scheduledActionsForRule) {
            this.scheduledActionsForRule = scheduledActionsForRule;
            this.changedFields = changedFields.add("scheduledActionsForRule");
            return this;
        }

        public Builder scheduledActionsForRule(DeviceComplianceScheduledActionForRule... scheduledActionsForRule) {
            return scheduledActionsForRule(Arrays.asList(scheduledActionsForRule));
        }

        public Builder userStatuses(List<DeviceComplianceUserStatus> userStatuses) {
            this.userStatuses = userStatuses;
            this.changedFields = changedFields.add("userStatuses");
            return this;
        }

        public Builder userStatuses(DeviceComplianceUserStatus... userStatuses) {
            return userStatuses(Arrays.asList(userStatuses));
        }

        public Builder userStatusOverview(DeviceComplianceUserOverview userStatusOverview) {
            this.userStatusOverview = userStatusOverview;
            this.changedFields = changedFields.add("userStatusOverview");
            return this;
        }

        /**
         * <i>“MDATP Require Mobile Threat Protection minimum risk level to report
         * noncompliance.”</i>
         * 
         * @param advancedThreatProtectionRequiredSecurityLevel
         *            value of {@code advancedThreatProtectionRequiredSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder advancedThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel advancedThreatProtectionRequiredSecurityLevel) {
            this.advancedThreatProtectionRequiredSecurityLevel = advancedThreatProtectionRequiredSecurityLevel;
            this.changedFields = changedFields.add("advancedThreatProtectionRequiredSecurityLevel");
            return this;
        }

        /**
         * <i>“Require that devices have enabled device threat protection.”</i>
         * 
         * @param deviceThreatProtectionEnabled
         *            value of {@code deviceThreatProtectionEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
            this.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            this.changedFields = changedFields.add("deviceThreatProtectionEnabled");
            return this;
        }

        /**
         * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
         * 
         * @param deviceThreatProtectionRequiredSecurityLevel
         *            value of {@code deviceThreatProtectionRequiredSecurityLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
            this.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            this.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
            return this;
        }

        /**
         * <i>“Minimum Android security patch level.”</i>
         * 
         * @param minAndroidSecurityPatchLevel
         *            value of {@code minAndroidSecurityPatchLevel} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minAndroidSecurityPatchLevel(String minAndroidSecurityPatchLevel) {
            this.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
            this.changedFields = changedFields.add("minAndroidSecurityPatchLevel");
            return this;
        }

        /**
         * <i>“Maximum Android version.”</i>
         * 
         * @param osMaximumVersion
         *            value of {@code osMaximumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMaximumVersion(String osMaximumVersion) {
            this.osMaximumVersion = osMaximumVersion;
            this.changedFields = changedFields.add("osMaximumVersion");
            return this;
        }

        /**
         * <i>“Minimum Android version.”</i>
         * 
         * @param osMinimumVersion
         *            value of {@code osMinimumVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder osMinimumVersion(String osMinimumVersion) {
            this.osMinimumVersion = osMinimumVersion;
            this.changedFields = changedFields.add("osMinimumVersion");
            return this;
        }

        /**
         * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Minimum password length. Valid values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of letter characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumLetterCharacters
         *            value of {@code passwordMinimumLetterCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLetterCharacters(Integer passwordMinimumLetterCharacters) {
            this.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
            this.changedFields = changedFields.add("passwordMinimumLetterCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of lower case characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumLowerCaseCharacters
         *            value of {@code passwordMinimumLowerCaseCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLowerCaseCharacters(Integer passwordMinimumLowerCaseCharacters) {
            this.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
            this.changedFields = changedFields.add("passwordMinimumLowerCaseCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of non-letter characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumNonLetterCharacters
         *            value of {@code passwordMinimumNonLetterCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumNonLetterCharacters(Integer passwordMinimumNonLetterCharacters) {
            this.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
            this.changedFields = changedFields.add("passwordMinimumNonLetterCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of numeric characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumNumericCharacters
         *            value of {@code passwordMinimumNumericCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumNumericCharacters(Integer passwordMinimumNumericCharacters) {
            this.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
            this.changedFields = changedFields.add("passwordMinimumNumericCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of symbol characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumSymbolCharacters
         *            value of {@code passwordMinimumSymbolCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumSymbolCharacters(Integer passwordMinimumSymbolCharacters) {
            this.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
            this.changedFields = changedFields.add("passwordMinimumSymbolCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of upper case letter characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumUpperCaseCharacters
         *            value of {@code passwordMinimumUpperCaseCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumUpperCaseCharacters(Integer passwordMinimumUpperCaseCharacters) {
            this.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
            this.changedFields = changedFields.add("passwordMinimumUpperCaseCharacters");
            return this;
        }

        /**
         * <i>“Minutes of inactivity before a password is required.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeLock
         *            value of {@code passwordMinutesOfInactivityBeforeLock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
            this.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
            return this;
        }

        /**
         * <i>“Number of previous passwords to block. Valid values 1 to 24”</i>
         * 
         * @param passwordPreviousPasswordCountToBlock
         *            value of {@code passwordPreviousPasswordCountToBlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordCountToBlock(Integer passwordPreviousPasswordCountToBlock) {
            this.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
            this.changedFields = changedFields.add("passwordPreviousPasswordCountToBlock");
            return this;
        }

        /**
         * <i>“Require a password to unlock device.”</i>
         * 
         * @param passwordRequired
         *            value of {@code passwordRequired} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequired(Boolean passwordRequired) {
            this.passwordRequired = passwordRequired;
            this.changedFields = changedFields.add("passwordRequired");
            return this;
        }

        /**
         * <i>“Type of characters in password”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“If setting is set to true, checks that the Intune app installed on fully managed
         * , dedicated, or corporate-owned work profile Android Enterprise enrolled devices
         * , is the one provided by Microsoft from the Managed Google Playstore. If the
         * check fails, the device will be reported as non-compliant.”</i>
         * 
         * @param securityRequireIntuneAppIntegrity
         *            value of {@code securityRequireIntuneAppIntegrity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityRequireIntuneAppIntegrity(Boolean securityRequireIntuneAppIntegrity) {
            this.securityRequireIntuneAppIntegrity = securityRequireIntuneAppIntegrity;
            this.changedFields = changedFields.add("securityRequireIntuneAppIntegrity");
            return this;
        }

        /**
         * <i>“Require the device to pass the SafetyNet basic integrity check.”</i>
         * 
         * @param securityRequireSafetyNetAttestationBasicIntegrity
         *            value of {@code securityRequireSafetyNetAttestationBasicIntegrity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityRequireSafetyNetAttestationBasicIntegrity(Boolean securityRequireSafetyNetAttestationBasicIntegrity) {
            this.securityRequireSafetyNetAttestationBasicIntegrity = securityRequireSafetyNetAttestationBasicIntegrity;
            this.changedFields = changedFields.add("securityRequireSafetyNetAttestationBasicIntegrity");
            return this;
        }

        /**
         * <i>“Require the device to pass the SafetyNet certified device check.”</i>
         * 
         * @param securityRequireSafetyNetAttestationCertifiedDevice
         *            value of {@code securityRequireSafetyNetAttestationCertifiedDevice} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityRequireSafetyNetAttestationCertifiedDevice(Boolean securityRequireSafetyNetAttestationCertifiedDevice) {
            this.securityRequireSafetyNetAttestationCertifiedDevice = securityRequireSafetyNetAttestationCertifiedDevice;
            this.changedFields = changedFields.add("securityRequireSafetyNetAttestationCertifiedDevice");
            return this;
        }

        /**
         * <i>“Require encryption on Android devices.”</i>
         * 
         * @param storageRequireEncryption
         *            value of {@code storageRequireEncryption} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageRequireEncryption(Boolean storageRequireEncryption) {
            this.storageRequireEncryption = storageRequireEncryption;
            this.changedFields = changedFields.add("storageRequireEncryption");
            return this;
        }

        public AndroidDeviceOwnerCompliancePolicy build() {
            AndroidDeviceOwnerCompliancePolicy _x = new AndroidDeviceOwnerCompliancePolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.androidDeviceOwnerCompliancePolicy";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.assignments = assignments;
            _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
            _x.deviceStatuses = deviceStatuses;
            _x.deviceStatusOverview = deviceStatusOverview;
            _x.scheduledActionsForRule = scheduledActionsForRule;
            _x.userStatuses = userStatuses;
            _x.userStatusOverview = userStatusOverview;
            _x.advancedThreatProtectionRequiredSecurityLevel = advancedThreatProtectionRequiredSecurityLevel;
            _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
            _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
            _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
            _x.osMaximumVersion = osMaximumVersion;
            _x.osMinimumVersion = osMinimumVersion;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
            _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
            _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
            _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
            _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
            _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
            _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
            _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
            _x.passwordRequired = passwordRequired;
            _x.passwordRequiredType = passwordRequiredType;
            _x.securityRequireIntuneAppIntegrity = securityRequireIntuneAppIntegrity;
            _x.securityRequireSafetyNetAttestationBasicIntegrity = securityRequireSafetyNetAttestationBasicIntegrity;
            _x.securityRequireSafetyNetAttestationCertifiedDevice = securityRequireSafetyNetAttestationCertifiedDevice;
            _x.storageRequireEncryption = storageRequireEncryption;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    /**
     * <i>“MDATP Require Mobile Threat Protection minimum risk level to report
     * noncompliance.”</i>
     * 
     * @return property advancedThreatProtectionRequiredSecurityLevel
     */
    @Property(name="advancedThreatProtectionRequiredSecurityLevel")
    @JsonIgnore
    public Optional<DeviceThreatProtectionLevel> getAdvancedThreatProtectionRequiredSecurityLevel() {
        return Optional.ofNullable(advancedThreatProtectionRequiredSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * advancedThreatProtectionRequiredSecurityLevel} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“MDATP Require Mobile Threat Protection minimum risk level to report
     * noncompliance.”</i>
     * 
     * @param advancedThreatProtectionRequiredSecurityLevel
     *            new value of {@code advancedThreatProtectionRequiredSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code advancedThreatProtectionRequiredSecurityLevel} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withAdvancedThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel advancedThreatProtectionRequiredSecurityLevel) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("advancedThreatProtectionRequiredSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.advancedThreatProtectionRequiredSecurityLevel = advancedThreatProtectionRequiredSecurityLevel;
        return _x;
    }

    /**
     * <i>“Require that devices have enabled device threat protection.”</i>
     * 
     * @return property deviceThreatProtectionEnabled
     */
    @Property(name="deviceThreatProtectionEnabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceThreatProtectionEnabled() {
        return Optional.ofNullable(deviceThreatProtectionEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require that devices have enabled device threat protection.”</i>
     * 
     * @param deviceThreatProtectionEnabled
     *            new value of {@code deviceThreatProtectionEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionEnabled} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withDeviceThreatProtectionEnabled(Boolean deviceThreatProtectionEnabled) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        return _x;
    }

    /**
     * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @return property deviceThreatProtectionRequiredSecurityLevel
     */
    @Property(name="deviceThreatProtectionRequiredSecurityLevel")
    @JsonIgnore
    public Optional<DeviceThreatProtectionLevel> getDeviceThreatProtectionRequiredSecurityLevel() {
        return Optional.ofNullable(deviceThreatProtectionRequiredSecurityLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceThreatProtectionRequiredSecurityLevel} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Require Mobile Threat Protection minimum risk level to report noncompliance.”</i>
     * 
     * @param deviceThreatProtectionRequiredSecurityLevel
     *            new value of {@code deviceThreatProtectionRequiredSecurityLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceThreatProtectionRequiredSecurityLevel} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withDeviceThreatProtectionRequiredSecurityLevel(DeviceThreatProtectionLevel deviceThreatProtectionRequiredSecurityLevel) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("deviceThreatProtectionRequiredSecurityLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        return _x;
    }

    /**
     * <i>“Minimum Android security patch level.”</i>
     * 
     * @return property minAndroidSecurityPatchLevel
     */
    @Property(name="minAndroidSecurityPatchLevel")
    @JsonIgnore
    public Optional<String> getMinAndroidSecurityPatchLevel() {
        return Optional.ofNullable(minAndroidSecurityPatchLevel);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minAndroidSecurityPatchLevel} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Minimum Android security patch level.”</i>
     * 
     * @param minAndroidSecurityPatchLevel
     *            new value of {@code minAndroidSecurityPatchLevel} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minAndroidSecurityPatchLevel} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withMinAndroidSecurityPatchLevel(String minAndroidSecurityPatchLevel) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("minAndroidSecurityPatchLevel");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
        return _x;
    }

    /**
     * <i>“Maximum Android version.”</i>
     * 
     * @return property osMaximumVersion
     */
    @Property(name="osMaximumVersion")
    @JsonIgnore
    public Optional<String> getOsMaximumVersion() {
        return Optional.ofNullable(osMaximumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMaximumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Maximum Android version.”</i>
     * 
     * @param osMaximumVersion
     *            new value of {@code osMaximumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMaximumVersion} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withOsMaximumVersion(String osMaximumVersion) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMaximumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.osMaximumVersion = osMaximumVersion;
        return _x;
    }

    /**
     * <i>“Minimum Android version.”</i>
     * 
     * @return property osMinimumVersion
     */
    @Property(name="osMinimumVersion")
    @JsonIgnore
    public Optional<String> getOsMinimumVersion() {
        return Optional.ofNullable(osMinimumVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code osMinimumVersion}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Minimum Android version.”</i>
     * 
     * @param osMinimumVersion
     *            new value of {@code osMinimumVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code osMinimumVersion} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withOsMinimumVersion(String osMinimumVersion) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("osMinimumVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.osMinimumVersion = osMinimumVersion;
        return _x;
    }

    /**
     * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Number of days before the password expires. Valid values 1 to 365”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordExpirationDays(Integer passwordExpirationDays) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Minimum password length. Valid values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumLength(Integer passwordMinimumLength) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of letter characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumLetterCharacters
     */
    @Property(name="passwordMinimumLetterCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLetterCharacters() {
        return Optional.ofNullable(passwordMinimumLetterCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLetterCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of letter characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumLetterCharacters
     *            new value of {@code passwordMinimumLetterCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLetterCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumLetterCharacters(Integer passwordMinimumLetterCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLetterCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of lower case characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumLowerCaseCharacters
     */
    @Property(name="passwordMinimumLowerCaseCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLowerCaseCharacters() {
        return Optional.ofNullable(passwordMinimumLowerCaseCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLowerCaseCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of lower case characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumLowerCaseCharacters
     *            new value of {@code passwordMinimumLowerCaseCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLowerCaseCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumLowerCaseCharacters(Integer passwordMinimumLowerCaseCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLowerCaseCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of non-letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumNonLetterCharacters
     */
    @Property(name="passwordMinimumNonLetterCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumNonLetterCharacters() {
        return Optional.ofNullable(passwordMinimumNonLetterCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumNonLetterCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of non-letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumNonLetterCharacters
     *            new value of {@code passwordMinimumNonLetterCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumNonLetterCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumNonLetterCharacters(Integer passwordMinimumNonLetterCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumNonLetterCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of numeric characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumNumericCharacters
     */
    @Property(name="passwordMinimumNumericCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumNumericCharacters() {
        return Optional.ofNullable(passwordMinimumNumericCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumNumericCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of numeric characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumNumericCharacters
     *            new value of {@code passwordMinimumNumericCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumNumericCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumNumericCharacters(Integer passwordMinimumNumericCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumNumericCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of symbol characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumSymbolCharacters
     */
    @Property(name="passwordMinimumSymbolCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumSymbolCharacters() {
        return Optional.ofNullable(passwordMinimumSymbolCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumSymbolCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of symbol characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumSymbolCharacters
     *            new value of {@code passwordMinimumSymbolCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumSymbolCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumSymbolCharacters(Integer passwordMinimumSymbolCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumSymbolCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of upper case letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumUpperCaseCharacters
     */
    @Property(name="passwordMinimumUpperCaseCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumUpperCaseCharacters() {
        return Optional.ofNullable(passwordMinimumUpperCaseCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumUpperCaseCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of upper case letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumUpperCaseCharacters
     *            new value of {@code passwordMinimumUpperCaseCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumUpperCaseCharacters} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinimumUpperCaseCharacters(Integer passwordMinimumUpperCaseCharacters) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumUpperCaseCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
        return _x;
    }

    /**
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeLock
     */
    @Property(name="passwordMinutesOfInactivityBeforeLock")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeLock() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeLock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeLock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Minutes of inactivity before a password is required.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeLock
     *            new value of {@code passwordMinutesOfInactivityBeforeLock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeLock} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordMinutesOfInactivityBeforeLock(Integer passwordMinutesOfInactivityBeforeLock) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeLock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        return _x;
    }

    /**
     * <i>“Number of previous passwords to block. Valid values 1 to 24”</i>
     * 
     * @return property passwordPreviousPasswordCountToBlock
     */
    @Property(name="passwordPreviousPasswordCountToBlock")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordCountToBlock() {
        return Optional.ofNullable(passwordPreviousPasswordCountToBlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordCountToBlock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Number of previous passwords to block. Valid values 1 to 24”</i>
     * 
     * @param passwordPreviousPasswordCountToBlock
     *            new value of {@code passwordPreviousPasswordCountToBlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordCountToBlock} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordPreviousPasswordCountToBlock(Integer passwordPreviousPasswordCountToBlock) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordCountToBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
        return _x;
    }

    /**
     * <i>“Require a password to unlock device.”</i>
     * 
     * @return property passwordRequired
     */
    @Property(name="passwordRequired")
    @JsonIgnore
    public Optional<Boolean> getPasswordRequired() {
        return Optional.ofNullable(passwordRequired);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code passwordRequired}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Require a password to unlock device.”</i>
     * 
     * @param passwordRequired
     *            new value of {@code passwordRequired} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequired} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordRequired(Boolean passwordRequired) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequired");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordRequired = passwordRequired;
        return _x;
    }

    /**
     * <i>“Type of characters in password”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerRequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Type of characters in password”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withPasswordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“If setting is set to true, checks that the Intune app installed on fully managed
     * , dedicated, or corporate-owned work profile Android Enterprise enrolled devices
     * , is the one provided by Microsoft from the Managed Google Playstore. If the
     * check fails, the device will be reported as non-compliant.”</i>
     * 
     * @return property securityRequireIntuneAppIntegrity
     */
    @Property(name="securityRequireIntuneAppIntegrity")
    @JsonIgnore
    public Optional<Boolean> getSecurityRequireIntuneAppIntegrity() {
        return Optional.ofNullable(securityRequireIntuneAppIntegrity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityRequireIntuneAppIntegrity} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“If setting is set to true, checks that the Intune app installed on fully managed
     * , dedicated, or corporate-owned work profile Android Enterprise enrolled devices
     * , is the one provided by Microsoft from the Managed Google Playstore. If the
     * check fails, the device will be reported as non-compliant.”</i>
     * 
     * @param securityRequireIntuneAppIntegrity
     *            new value of {@code securityRequireIntuneAppIntegrity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityRequireIntuneAppIntegrity} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withSecurityRequireIntuneAppIntegrity(Boolean securityRequireIntuneAppIntegrity) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("securityRequireIntuneAppIntegrity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.securityRequireIntuneAppIntegrity = securityRequireIntuneAppIntegrity;
        return _x;
    }

    /**
     * <i>“Require the device to pass the SafetyNet basic integrity check.”</i>
     * 
     * @return property securityRequireSafetyNetAttestationBasicIntegrity
     */
    @Property(name="securityRequireSafetyNetAttestationBasicIntegrity")
    @JsonIgnore
    public Optional<Boolean> getSecurityRequireSafetyNetAttestationBasicIntegrity() {
        return Optional.ofNullable(securityRequireSafetyNetAttestationBasicIntegrity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityRequireSafetyNetAttestationBasicIntegrity} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Require the device to pass the SafetyNet basic integrity check.”</i>
     * 
     * @param securityRequireSafetyNetAttestationBasicIntegrity
     *            new value of {@code securityRequireSafetyNetAttestationBasicIntegrity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityRequireSafetyNetAttestationBasicIntegrity} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withSecurityRequireSafetyNetAttestationBasicIntegrity(Boolean securityRequireSafetyNetAttestationBasicIntegrity) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("securityRequireSafetyNetAttestationBasicIntegrity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.securityRequireSafetyNetAttestationBasicIntegrity = securityRequireSafetyNetAttestationBasicIntegrity;
        return _x;
    }

    /**
     * <i>“Require the device to pass the SafetyNet certified device check.”</i>
     * 
     * @return property securityRequireSafetyNetAttestationCertifiedDevice
     */
    @Property(name="securityRequireSafetyNetAttestationCertifiedDevice")
    @JsonIgnore
    public Optional<Boolean> getSecurityRequireSafetyNetAttestationCertifiedDevice() {
        return Optional.ofNullable(securityRequireSafetyNetAttestationCertifiedDevice);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityRequireSafetyNetAttestationCertifiedDevice} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Require the device to pass the SafetyNet certified device check.”</i>
     * 
     * @param securityRequireSafetyNetAttestationCertifiedDevice
     *            new value of {@code securityRequireSafetyNetAttestationCertifiedDevice} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityRequireSafetyNetAttestationCertifiedDevice} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withSecurityRequireSafetyNetAttestationCertifiedDevice(Boolean securityRequireSafetyNetAttestationCertifiedDevice) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("securityRequireSafetyNetAttestationCertifiedDevice");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.securityRequireSafetyNetAttestationCertifiedDevice = securityRequireSafetyNetAttestationCertifiedDevice;
        return _x;
    }

    /**
     * <i>“Require encryption on Android devices.”</i>
     * 
     * @return property storageRequireEncryption
     */
    @Property(name="storageRequireEncryption")
    @JsonIgnore
    public Optional<Boolean> getStorageRequireEncryption() {
        return Optional.ofNullable(storageRequireEncryption);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageRequireEncryption} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Require encryption on Android devices.”</i>
     * 
     * @param storageRequireEncryption
     *            new value of {@code storageRequireEncryption} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageRequireEncryption} field changed
     */
    public AndroidDeviceOwnerCompliancePolicy withStorageRequireEncryption(Boolean storageRequireEncryption) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = changedFields.add("storageRequireEncryption");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerCompliancePolicy");
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    public AndroidDeviceOwnerCompliancePolicy withUnmappedField(String name, Object value) {
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerCompliancePolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerCompliancePolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerCompliancePolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerCompliancePolicy _copy() {
        AndroidDeviceOwnerCompliancePolicy _x = new AndroidDeviceOwnerCompliancePolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.assignments = assignments;
        _x.deviceSettingStateSummaries = deviceSettingStateSummaries;
        _x.deviceStatuses = deviceStatuses;
        _x.deviceStatusOverview = deviceStatusOverview;
        _x.scheduledActionsForRule = scheduledActionsForRule;
        _x.userStatuses = userStatuses;
        _x.userStatusOverview = userStatusOverview;
        _x.advancedThreatProtectionRequiredSecurityLevel = advancedThreatProtectionRequiredSecurityLevel;
        _x.deviceThreatProtectionEnabled = deviceThreatProtectionEnabled;
        _x.deviceThreatProtectionRequiredSecurityLevel = deviceThreatProtectionRequiredSecurityLevel;
        _x.minAndroidSecurityPatchLevel = minAndroidSecurityPatchLevel;
        _x.osMaximumVersion = osMaximumVersion;
        _x.osMinimumVersion = osMinimumVersion;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
        _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
        _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
        _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
        _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
        _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
        _x.passwordMinutesOfInactivityBeforeLock = passwordMinutesOfInactivityBeforeLock;
        _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
        _x.passwordRequired = passwordRequired;
        _x.passwordRequiredType = passwordRequiredType;
        _x.securityRequireIntuneAppIntegrity = securityRequireIntuneAppIntegrity;
        _x.securityRequireSafetyNetAttestationBasicIntegrity = securityRequireSafetyNetAttestationBasicIntegrity;
        _x.securityRequireSafetyNetAttestationCertifiedDevice = securityRequireSafetyNetAttestationCertifiedDevice;
        _x.storageRequireEncryption = storageRequireEncryption;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerCompliancePolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("assignments=");
        b.append(this.assignments);
        b.append(", ");
        b.append("deviceSettingStateSummaries=");
        b.append(this.deviceSettingStateSummaries);
        b.append(", ");
        b.append("deviceStatuses=");
        b.append(this.deviceStatuses);
        b.append(", ");
        b.append("deviceStatusOverview=");
        b.append(this.deviceStatusOverview);
        b.append(", ");
        b.append("scheduledActionsForRule=");
        b.append(this.scheduledActionsForRule);
        b.append(", ");
        b.append("userStatuses=");
        b.append(this.userStatuses);
        b.append(", ");
        b.append("userStatusOverview=");
        b.append(this.userStatusOverview);
        b.append(", ");
        b.append("advancedThreatProtectionRequiredSecurityLevel=");
        b.append(this.advancedThreatProtectionRequiredSecurityLevel);
        b.append(", ");
        b.append("deviceThreatProtectionEnabled=");
        b.append(this.deviceThreatProtectionEnabled);
        b.append(", ");
        b.append("deviceThreatProtectionRequiredSecurityLevel=");
        b.append(this.deviceThreatProtectionRequiredSecurityLevel);
        b.append(", ");
        b.append("minAndroidSecurityPatchLevel=");
        b.append(this.minAndroidSecurityPatchLevel);
        b.append(", ");
        b.append("osMaximumVersion=");
        b.append(this.osMaximumVersion);
        b.append(", ");
        b.append("osMinimumVersion=");
        b.append(this.osMinimumVersion);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinimumLetterCharacters=");
        b.append(this.passwordMinimumLetterCharacters);
        b.append(", ");
        b.append("passwordMinimumLowerCaseCharacters=");
        b.append(this.passwordMinimumLowerCaseCharacters);
        b.append(", ");
        b.append("passwordMinimumNonLetterCharacters=");
        b.append(this.passwordMinimumNonLetterCharacters);
        b.append(", ");
        b.append("passwordMinimumNumericCharacters=");
        b.append(this.passwordMinimumNumericCharacters);
        b.append(", ");
        b.append("passwordMinimumSymbolCharacters=");
        b.append(this.passwordMinimumSymbolCharacters);
        b.append(", ");
        b.append("passwordMinimumUpperCaseCharacters=");
        b.append(this.passwordMinimumUpperCaseCharacters);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeLock=");
        b.append(this.passwordMinutesOfInactivityBeforeLock);
        b.append(", ");
        b.append("passwordPreviousPasswordCountToBlock=");
        b.append(this.passwordPreviousPasswordCountToBlock);
        b.append(", ");
        b.append("passwordRequired=");
        b.append(this.passwordRequired);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("securityRequireIntuneAppIntegrity=");
        b.append(this.securityRequireIntuneAppIntegrity);
        b.append(", ");
        b.append("securityRequireSafetyNetAttestationBasicIntegrity=");
        b.append(this.securityRequireSafetyNetAttestationBasicIntegrity);
        b.append(", ");
        b.append("securityRequireSafetyNetAttestationCertifiedDevice=");
        b.append(this.securityRequireSafetyNetAttestationCertifiedDevice);
        b.append(", ");
        b.append("storageRequireEncryption=");
        b.append(this.storageRequireEncryption);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
