package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AgreementFileData;

@JsonPropertyOrder({
    "@odata.type", 
    "createdDateTime", 
    "displayName", 
    "fileData", 
    "fileName", 
    "isDefault", 
    "isMajorVersion", 
    "language"})
@JsonInclude(Include.NON_NULL)
public class AgreementFileProperties extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.agreementFileProperties";
    }

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("fileData")
    protected AgreementFileData fileData;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("isMajorVersion")
    protected Boolean isMajorVersion;

    @JsonProperty("language")
    protected String language;

    protected AgreementFileProperties() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAgreementFileProperties() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime createdDateTime;
        private String displayName;
        private AgreementFileData fileData;
        private String fileName;
        private Boolean isDefault;
        private Boolean isMajorVersion;
        private String language;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder fileData(AgreementFileData fileData) {
            this.fileData = fileData;
            this.changedFields = changedFields.add("fileData");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder isMajorVersion(Boolean isMajorVersion) {
            this.isMajorVersion = isMajorVersion;
            this.changedFields = changedFields.add("isMajorVersion");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public AgreementFileProperties build() {
            AgreementFileProperties _x = new AgreementFileProperties();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "microsoft.graph.agreementFileProperties";
            _x.id = id;
            _x.createdDateTime = createdDateTime;
            _x.displayName = displayName;
            _x.fileData = fileData;
            _x.fileName = fileName;
            _x.isDefault = isDefault;
            _x.isMajorVersion = isMajorVersion;
            _x.language = language;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id, String.class));
        }
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AgreementFileProperties withCreatedDateTime(OffsetDateTime createdDateTime) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AgreementFileProperties withDisplayName(String displayName) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="fileData")
    @JsonIgnore
    public Optional<AgreementFileData> getFileData() {
        return Optional.ofNullable(fileData);
    }

    public AgreementFileProperties withFileData(AgreementFileData fileData) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("fileData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.fileData = fileData;
        return _x;
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public AgreementFileProperties withFileName(String fileName) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public AgreementFileProperties withIsDefault(Boolean isDefault) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="isMajorVersion")
    @JsonIgnore
    public Optional<Boolean> getIsMajorVersion() {
        return Optional.ofNullable(isMajorVersion);
    }

    public AgreementFileProperties withIsMajorVersion(Boolean isMajorVersion) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("isMajorVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.isMajorVersion = isMajorVersion;
        return _x;
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    public AgreementFileProperties withLanguage(String language) {
        AgreementFileProperties _x = _copy();
        _x.changedFields = changedFields.add("language");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFileProperties");
        _x.language = language;
        return _x;
    }

    public AgreementFileProperties withUnmappedField(String name, Object value) {
        AgreementFileProperties _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementFileProperties patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AgreementFileProperties _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementFileProperties put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AgreementFileProperties _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AgreementFileProperties _copy() {
        AgreementFileProperties _x = new AgreementFileProperties();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.id = id;
        _x.createdDateTime = createdDateTime;
        _x.displayName = displayName;
        _x.fileData = fileData;
        _x.fileName = fileName;
        _x.isDefault = isDefault;
        _x.isMajorVersion = isMajorVersion;
        _x.language = language;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AgreementFileProperties[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("fileData=");
        b.append(this.fileData);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("isMajorVersion=");
        b.append(this.isMajorVersion);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
